/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlSimple;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Stack;
import java.util.zip.ZipOutputStream;
import org.vishia.charset.CodeCharset;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.StringFunctions;
import org.vishia.zip.ZipUtils;

public class XmlSequWriter {
    public static final String version = "2020-01-01";
    private FileSystem fileSystem;
    private Writer wrFile;
    private OutputStream fwrFile;
    private Appendable twr;
    private StringBuilder wsb = new StringBuilder(2000);
    private static int zWsb = 2000;
    String sEncoding;
    private Charset encodingFile;
    private CodeCharset encodingJava2File;
    boolean bFullEncoding;
    boolean bElementStart;
    int nColumn;
    int nColumnMax = 88;
    ElementInfo elementCurr;
    Stack<ElementInfo> elementsParent = new Stack();
    int indent = 1;
    private String replaceBasics = "&\"'<>\t\r\n";
    private static String[] stdReplacement = new String[]{"&amp;", "&quot;", "&apos;", "&lt;", "&gt;", "&#x09;", "&#x0d;", "&#x0a;"};
    public boolean bTreeComment = false;
    private static String sIndent = "\n                                                                                ";

    public XmlSequWriter() {
        this.replaceNewline(false);
    }

    public void setEncoding(String string) throws IllegalCharsetNameException {
        this.encodingFile = Charset.forName(string);
        this.encodingJava2File = this.encodingFile.name().startsWith("UTF") ? null : CodeCharset.forName(string);
        if (this.encodingFile == null) {
            throw new IllegalCharsetNameException("Illegal encoding id: " + string);
        }
        this.sEncoding = string;
    }

    public String open(File file, String string, Appendable appendable) throws IOException {
        this.twr = appendable;
        if (string != null) {
            this.setEncoding(string);
        } else {
            this.setEncoding("UTF-8");
        }
        try {
            if (this.wrFile != null) {
                this.wrFile.close();
            } else if (this.fwrFile != null) {
                this.fwrFile.close();
            }
            this.wrFile = null;
            this.fwrFile = null;
            if (file != null) {
                if (this.encodingJava2File != null) {
                    this.fwrFile = new FileOutputStream(file);
                    assert (this.wrFile == null);
                } else {
                    this.wrFile = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encodingFile);
                    assert (this.fwrFile == null);
                }
            }
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return "Encoding faulty: " + unsupportedCharsetException.getMessage();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "File not able to create: " + file.getAbsolutePath();
        }
    }

    @Deprecated
    public String XXXopenZip(File file, String string, String string2, Appendable appendable) throws IOException {
        this.twr = appendable;
        if (string2 != null) {
            this.setEncoding(string2);
        } else if (this.sEncoding == null) {
            this.setEncoding("UTF-8");
        }
        try {
            if (this.wrFile != null) {
                this.wrFile.close();
            } else if (this.fwrFile != null) {
                this.fwrFile.close();
            }
            this.wrFile = null;
            this.fwrFile = null;
            if (file != null) {
                this.fileSystem = ZipUtils.openZip(file);
                Path path = this.fileSystem.getPath(string, new String[0]);
                this.wrFile = Files.newBufferedWriter(path, this.encodingFile, new OpenOption[0]);
                assert (this.fwrFile == null);
            }
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return "Encoding faulty: " + unsupportedCharsetException.getMessage();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "File not able to create: " + file.getAbsolutePath();
        }
    }

    public void close() throws IOException {
        while (this.elementCurr != null) {
            this.writeElementEnd();
        }
        this.wrNewline();
        this.fileclose();
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }

    public void XXXflush() throws IOException {
        if (this.wrFile != null) {
            this.wrFile.flush();
        } else if (this.fwrFile != null) {
            this.fwrFile.flush();
        }
    }

    public void fileclose() {
        try {
            this.wrTxtToFile(this.wsb);
            if (this.wrFile != null) {
                this.wrFile.close();
                this.wrFile = null;
                assert (this.fwrFile == null);
            } else if (this.fwrFile != null) {
                if (this.fwrFile instanceof ZipOutputStream) {
                    ZipUtils.closeZipEntry(this.fwrFile);
                } else {
                    this.fwrFile.close();
                }
                this.fwrFile.close();
                this.fwrFile = null;
                assert (this.wrFile == null);
            }
            this.twr = null;
        }
        catch (IOException iOException) {
            String string = ExcUtil.exceptionInfo("XmlSeqWriter problem on close", iOException, 1, 99).toString();
            System.err.println(string);
        }
    }

    public void setDebugTextOut(Appendable appendable) {
        this.twr = appendable;
    }

    public void replaceNewline(boolean bl) {
        this.replaceBasics = bl ? "&\"'<>\t\r\n" : "&\"'<>\t\r";
    }

    private void writeHead() throws IOException {
        this.wrTxtBuffered("<?xml version=\"1.0\" encoding=\"" + this.encodingFile.name() + "\"?>\n");
    }

    public void writeComment() {
    }

    public void writeElement(String string) throws IOException {
        if (this.bElementStart) {
            this.writeElementHeadEnd(true);
        }
        if (this.elementCurr == null) {
            this.writeHead();
        } else {
            this.elementCurr.bIndented = true;
            this.wrNewline();
        }
        this.wrTxtBuffered("<");
        this.wrTxtWithReplacements(string);
        if (this.elementCurr != null) {
            this.elementsParent.push(this.elementCurr);
        }
        this.elementCurr = new ElementInfo(string, this.elementCurr);
        this.bElementStart = true;
        if ((this.indent += 2) > sIndent.length()) {
            this.indent = sIndent.length();
        }
    }

    public void writeElementInline(String string) throws IOException {
        if (this.bElementStart) {
            this.writeElementHeadEnd(true);
        }
        this.wrTxtBuffered("<");
        this.wrTxtWithReplacements(string);
        if (this.elementCurr != null) {
            this.elementsParent.push(this.elementCurr);
        }
        this.elementCurr = new ElementInfo(string, this.elementCurr);
        this.bElementStart = true;
    }

    private void wrNewline() throws IOException {
        this.wrTxtBuffered(sIndent.substring(0, this.indent));
        this.nColumn = this.indent;
    }

    public void writeElementHeadEnd(boolean bl) throws IOException {
        if (!this.bElementStart) {
            throw new IllegalStateException("not in writing head");
        }
        this.bElementStart = false;
        this.wrTxtBuffered(">");
        this.elementCurr.bIndented = bl;
    }

    public void writeElementEnd(String string) throws IOException {
        this.writeElementEnd(string, true);
    }

    private void writeElementEnd(String string, boolean bl) throws IOException {
        while (this.elementCurr != null && !this.elementCurr.sTag.equals(string)) {
            if (this.elementsParent.size() == 0) {
                throw new IllegalStateException("element mismatch, current = " + this.elementCurr.sTag + " != requ = " + string);
            }
            this.writeElementEnd(bl);
        }
        this.writeElementEnd(bl);
    }

    public void writeElementEndInline(String string) throws IOException {
        this.writeElementEnd(string, false);
    }

    public void writeElementEnd() throws IOException {
        this.writeElementEnd(true);
    }

    private void writeElementEnd(boolean bl) throws IOException {
        if ((this.indent -= 2) < 1) {
            this.indent = 1;
        }
        if (this.bElementStart) {
            this.wrTxtBuffered("/");
            this.writeElementHeadEnd(true);
            this.elementCurr.bIndented = true;
            this.bElementStart = false;
        } else {
            if (bl && this.elementCurr.bIndented) {
                this.wrNewline();
            }
            this.wrTxtBuffered("</");
            this.wrTxtWithReplacements(this.elementCurr.sTag);
            this.wrTxtBuffered(">");
            if (this.bTreeComment) {
                this.wrTxtBuffered("<!--");
                for (ElementInfo elementInfo : this.elementsParent) {
                    this.wrTxtBuffered(elementInfo.sTag);
                    this.wrTxtBuffered(" = ");
                }
                this.wrTxtBuffered("-->");
            }
        }
        this.elementCurr = this.elementsParent.size() > 0 ? this.elementsParent.pop() : null;
    }

    public void writeAttribute(String string, String string2) throws IOException {
        if (!this.bElementStart) {
            throw new IllegalStateException("should be written not after content");
        }
        this.wrTxtBuffered(" ");
        this.wrTxtWithReplacements(string);
        this.wrTxtBuffered("=\"");
        this.wrTxtWithReplacements(string2);
        this.wrTxtBuffered("\"");
    }

    public void writeText(CharSequence charSequence, boolean bl) throws IOException {
        String string = charSequence.toString();
        if (bl && string.startsWith(" ") || string.endsWith(" ")) {
            Debugutil.stop();
        }
        if (this.bElementStart) {
            this.writeElementHeadEnd(true);
        }
        this.elementCurr.bIndented = bl;
        if (this.elementCurr.bIndented) {
            this.wrNewline();
        }
        this.wrTxtWithReplacements(charSequence);
    }

    private void wrTxtWithReplacements(CharSequence charSequence) throws IOException {
        int n;
        CharSequence charSequence2 = charSequence == null ? "?null?" : charSequence;
        int n2 = 0;
        int n3 = charSequence2.length();
        int[] nArray = new int[1];
        while ((n = StringFunctions.indexOfAnyChar(charSequence2, n2, n3, this.replaceBasics, nArray)) >= 0) {
            if (n2 < n) {
                this.wrTxtBuffered(charSequence2.subSequence(n2, n));
            }
            this.wrTxtBuffered(stdReplacement[nArray[0]]);
            n2 = n + 1;
        }
        if (n2 < n3) {
            this.wrTxtBuffered(charSequence2.subSequence(n2, n3));
        }
    }

    private void wrTxtBuffered(CharSequence charSequence) throws IOException {
        if (charSequence.length() + this.wsb.length() > zWsb) {
            int n = this.wsb.length();
            if (n > zWsb / 2) {
                n = zWsb / 2;
            }
            this.wrTxtToFile(this.wsb.substring(0, n));
            this.wsb.delete(0, n);
        }
        this.wsb.append(charSequence);
    }

    private void wrTxtToFile(CharSequence charSequence) throws IOException {
        if (this.twr != null) {
            this.twr.append(charSequence);
        }
        if (this.wrFile != null) {
            this.wrFile.write(charSequence.toString());
        } else if (this.fwrFile != null) {
            int n = charSequence.length();
            for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                int n2 = this.encodingJava2File.getCode(c);
                if (n2 != 0) {
                    this.fwrFile.write(n2);
                    if (this.twr == null) continue;
                    this.twr.append(c);
                    continue;
                }
                String string = Integer.toHexString(c).toUpperCase();
                this.wrTxtByteEncoding("&#x");
                if ((string.length() & 1) == 1) {
                    this.wrTxtByteEncoding("0");
                }
                this.wrTxtByteEncoding(string);
                this.wrTxtByteEncoding(";");
            }
        }
    }

    private void wrTxtByteEncoding(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            byte by = (byte)string.charAt(i);
            this.fwrFile.write(by);
        }
    }

    public String elementCurrTag() {
        return this.elementCurr.sTag;
    }

    public String toString() {
        if (this.elementCurr != null) {
            return this.elementCurr.toString();
        }
        return "closed or root";
    }

    private static class ElementInfo {
        final String sTag;
        boolean bIndented;
        final ElementInfo parent;

        public ElementInfo(String string, ElementInfo elementInfo) {
            this.sTag = string;
            this.parent = elementInfo;
        }

        public String toString() {
            return this.sTag;
        }
    }
}

