/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.util.OutTextPreparer;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;

public class XmlCfg {
    public static final String version = "2024-25-12";
    Map<String, String> xmlnsAssign;
    Map<String, XmlCfgNode> subtrees;
    Map<String, List<XmlCfgNode>> subtreeForward;
    XmlCfgNode rootNode = new XmlCfgNode(null, this, "root");
    Map<String, DataAccess.IntegerIx> attribNameVale;
    private static final OutTextPreparer otxCfgHead = new OutTextPreparer("cfgHead", "xmlCfg", "XmlJzReader-Config 2024-05<:if:xmlCfg.xmlnsAssign><:for:ns:xmlCfg.xmlnsAssign><:n>NS: <&ns>=\"<&ns_key>\"<.for><.if>");
    protected boolean readFromText;
    private static final OutTextPreparer otxNode = new OutTextPreparer("node", "whatis, indent, node", "<:n><&indent><&whatis><:<><&node.tag><:>><:if:node.bList> LIST<.if><:if:node.dstClassName> CLASS:<&node.dstClassName><.if><:if:node.attribsForCheck><:n><&indent>  <:for:attr:node.attribsForCheck> @<&attr.name>==\"CHECK\"<.for><:n><.if><:if:node.attribsForCheck><:n><&indent>  <:for:attr:node.attribsArg> @<&attr.name>==\"@<&attr.storeInMap>\"<.for><:n><&indent><.if><:if:node.elementCreatePath><:n><&indent>  NEW:\"<:exec:wrDataAccess(OUT, node.elementCreatePath)>\"<.if><:if:node.elementFinishPath><:n><&indent>  ADD:\"<:exec:wrDataAccess(OUT, node.elementFinishPath)>\"<.if><:if:node.cfgSubtreeName><:n><&indent>  =>SUBTREE:<&node.cfgSubtreeName><:else><:if:node.nameSpaceDef><:n><&indent>  NAMESPACE:\"<&node.nameSpaceDef>\"<.if><:if:node.attribsSet><:for:attr:node.attribs><:n><&indent>  @<&attr.name>=\"<:if:attr.storeInMap>@<&attr.storeInMap><.if><:if:attr.daccess><&attr.daccess.writeAccessString(OUT)><.if>\"<.for><.if><:if:node.contentStorePath><:n><&indent>  TEXT<:if:node.bTextMoreOccurrences>-LIST<.if>:\"<:exec:wrDataAccess(OUT, node.contentStorePath)>\"<.if><:if:node.subnodes><:for:subnode:node.subnodes><:exec:writeSubNode(OUT, indent, subnode)><.for><.if><.if><:n><&indent><:<>/<&node.tag><:>>");
    private static Map<String, OutTextPreparer> idxScript;

    @Deprecated
    public XmlCfg(boolean bl) {
        this.readFromText = bl;
    }

    public XmlCfg() {
    }

    static XmlCfg newCfgCfg() {
        XmlCfg xmlCfg = new XmlCfg();
        try {
            xmlCfg.rootNode = new XmlCfgNode(null, xmlCfg, null);
            XmlCfgNode xmlCfgNode = new XmlCfgNode(null, xmlCfg, "xmlinput:root");
            xmlCfg.rootNode.addSubnode(xmlCfgNode.tag.toString(), xmlCfgNode);
            XmlCfgNode xmlCfgNode2 = new XmlCfgNode(null, xmlCfg, "xmlinput:cfg");
            xmlCfgNode.addSubnode(xmlCfgNode2.tag.toString(), xmlCfgNode2);
            XmlCfgNode xmlCfgNode3 = new XmlCfgNode(null, xmlCfg, null);
            xmlCfgNode2.addSubnode("?", xmlCfgNode3);
            xmlCfgNode3.addSubnode("?", xmlCfgNode3);
            xmlCfgNode3.setNewElementPath("!newElement(tag)");
            xmlCfgNode3.addAttribStorePath("xmlinput:data", "!setNewElementPath(value)");
            xmlCfgNode3.addAttribStorePath("xmlinput:finish", "!setFinishElementPath(value)");
            xmlCfgNode3.addAttribStorePath("xmlinput:class", "!dstClassName");
            xmlCfgNode3.addAttribStorePath("xmlinput:list", "!setList()");
            xmlCfgNode3.setContentStorePath("!setContentStorePath(text)");
            StringPartScan stringPartScan = new StringPartScan("addAttribStorePath(name, value)");
            xmlCfgNode3.attribsUnspec = new DataAccess.DatapathElement(stringPartScan, xmlCfgNode3.allArgNames, null);
            XmlCfgNode xmlCfgNode4 = new XmlCfgNode(null, xmlCfg, "xmlinput:subtree");
            xmlCfgNode.addSubnode(xmlCfgNode4.tag.toString(), xmlCfgNode4);
            xmlCfgNode4.addSubnode("?", xmlCfgNode3);
            xmlCfgNode4.setContentStorePath("!setContentStorePath(text)");
            xmlCfgNode4.addAttribStorePath("xmlinput:name", "!@subtreename");
            xmlCfgNode4.setNewElementPath("!addSubTree(subtreename)");
            xmlCfgNode4.addAttribStorePath("xmlinput:finish", "!setFinishElementPath(value)");
            xmlCfgNode4.addAttribStorePath("xmlinput:class", "!dstClassName");
            xmlCfgNode4.addAttribStorePath("xmlinput:data", "!setNewElementPath(value)");
            xmlCfgNode4.addAttribStorePath("xmlinput:list", "!setList()");
            stringPartScan.assign("addAttribStorePath(name, value)");
            xmlCfgNode4.attribsUnspec = new DataAccess.DatapathElement(stringPartScan, xmlCfgNode3.allArgNames, null);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
        return xmlCfg;
    }

    XmlCfgNode addSubTree(CharSequence charSequence) {
        String string;
        XmlCfgNode xmlCfgNode;
        if (this.subtrees == null) {
            this.subtrees = new TreeMap<String, XmlCfgNode>();
        }
        if ((xmlCfgNode = this.subtrees.get(string = charSequence.toString())) == null) {
            xmlCfgNode = new XmlCfgNode(null, this, charSequence);
            this.subtrees.put(string, xmlCfgNode);
        }
        return xmlCfgNode;
    }

    void transferNamespaceAssignment(Map<String, String> map) {
        if (this.xmlnsAssign == null) {
            this.xmlnsAssign = new TreeMap<String, String>();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            this.xmlnsAssign.put(string2, string);
        }
    }

    void finishReadCfg() {
        if (this.subtrees != null) {
            for (Map.Entry<String, XmlCfgNode> entry : this.subtrees.entrySet()) {
                List<XmlCfgNode> list;
                XmlCfgNode xmlCfgNode = entry.getValue();
                if (xmlCfgNode.dstClassName == null) {
                    xmlCfgNode.dstClassName = xmlCfgNode.tag.toString();
                } else if (xmlCfgNode.dstClassName == xmlCfgNode.tag.toString()) {
                    System.out.println("NOTE: ok dstClassName = " + xmlCfgNode.dstClassName);
                }
                if ((list = this.subtreeForward == null ? null : this.subtreeForward.get(xmlCfgNode.tag.toString())) == null) continue;
                for (XmlCfgNode xmlCfgNode2 : list) {
                    xmlCfgNode2.addFromSubtree(xmlCfgNode);
                }
            }
        }
        this.subtreeForward = null;
    }

    public boolean readCfgFile(File file, LogMessage logMessage) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        StringPartFromFileLines stringPartFromFileLines = new StringPartFromFileLines(file);
        boolean bl = this.readFromText(stringPartFromFileLines, logMessage);
        ((StringPartScan)stringPartFromFileLines).close();
        return bl;
    }

    public boolean readFromJar(Class<?> clazz, String string, LogMessage logMessage) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        StringPartFromFileLines stringPartFromFileLines = new StringPartFromFileLines(clazz, string, 65536, null, Charset.forName("UTF-8"));
        boolean bl = this.readFromText(stringPartFromFileLines, logMessage);
        ((StringPartScan)stringPartFromFileLines).close();
        return bl;
    }

    public boolean readFromText(StringPartScan stringPartScan, LogMessage logMessage) {
        String string;
        Object object;
        this.readFromText = true;
        boolean bl = true;
        this.readFromText = true;
        stringPartScan.setIgnoreWhitespaces(true);
        if (!stringPartScan.scanStart().scan("XmlJzReader-Config 2024-05").scanOk()) {
            logMessage.writeError("ERROR readCfgFromText, faulty head: %s", stringPartScan.getCurrent(30));
            return false;
        }
        this.xmlnsAssign = new TreeMap<String, String>();
        while (stringPartScan.scan("NS:").scanOk()) {
            object = new String[1];
            if (!stringPartScan.scanIdentifier().scan("=").scanQuotion("\"", "\"", (String[])object).scanOk()) {
                logMessage.writeError("ERROR readCfgFromText, faulty NS: %s", stringPartScan.getCurrent(50));
                return false;
            }
            string = stringPartScan.getLastScannedString();
            this.xmlnsAssign.put(object[0], string);
        }
        while (stringPartScan.scan("SUBTREE:").scanToStringEnd(" ").scan("<").scanToStringEnd(">").scanOk()) {
            object = stringPartScan.getLastScannedString();
            string = stringPartScan.getLastScannedString();
            XmlCfgNode xmlCfgNode = new XmlCfgNode(null, this, (CharSequence)object);
            if (this.subtrees == null) {
                this.subtrees = new TreeMap<String, XmlCfgNode>();
            }
            this.subtrees.put(string, xmlCfgNode);
            bl &= this.readFromTextNode(xmlCfgNode, stringPartScan, logMessage);
        }
        if (stringPartScan.scan("<root>").scanOk()) {
            bl &= this.readFromTextNode(this.rootNode, stringPartScan, logMessage);
        } else {
            logMessage.writeError("ERROR readCfgFromText, <root> is missing %s", stringPartScan.getCurrent(50));
            bl = false;
        }
        return bl;
    }

    private boolean readFromTextNode(XmlCfgNode xmlCfgNode, StringPartScan stringPartScan, LogMessage logMessage) {
        Object object;
        String string;
        char c;
        boolean bl = true;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while ((c = stringPartScan.scanSkipSpace().getCurrentChar()) != '<') {
            if (stringPartScan.scan("=>SUBTREE:").scanToAnyChar(" \n\r", '\"', '\"', '\\').scanOk()) {
                xmlCfgNode.cfgSubtreeName = stringPartScan.getLastScannedString();
            }
            if (stringPartScan.scan("LIST").scanOk()) {
                xmlCfgNode.bList = true;
            }
            if (stringPartScan.scan("CLASS:").scanIdentifier().scanOk()) {
                xmlCfgNode.dstClassName = stringPartScan.getLastScannedString();
            }
            if (stringPartScan.scan("@").scanIdentifier(null, "-:").scan("=").scanLiteral("\"\"\\", 9999).scanOk()) {
                string = stringPartScan.getLastScannedString();
                object = stringPartScan.getLastScannedString();
                try {
                    xmlCfgNode.addAttribStorePath((String)object, string);
                }
                catch (ParseException parseException) {
                    logMessage.writeError("ERROR readCfgFromText, Exception ", parseException);
                }
            }
            if (stringPartScan.scan("NEW:").scanLiteral("\"\"\\", 9999).scanOk()) {
                string2 = stringPartScan.getLastScannedString();
                try {
                    xmlCfgNode.setNewElementPath(string2);
                }
                catch (ParseException parseException) {
                    logMessage.writeError("ERROR readCfgFromText, Exception setNewElementStorePath " + string2, parseException);
                }
            }
            if (stringPartScan.scan("ADD:").scanLiteral("\"\"\\", 9999).scanOk()) {
                string3 = stringPartScan.getLastScannedString();
                try {
                    xmlCfgNode.setFinishElementPath(string3);
                }
                catch (ParseException parseException) {
                    logMessage.writeError("ERROR readCfgFromText, Exception setFinishElementStorePath " + string3, parseException);
                }
            }
            if (stringPartScan.scan("NAMESPACE:").scanLiteral("\"\"\\", 9999).scanOk()) {
                string5 = stringPartScan.getLastScannedString();
                try {
                    xmlCfgNode.setNameSpaceStorePath(string5);
                }
                catch (ParseException parseException) {
                    logMessage.writeError("ERROR readCfgFromText, Exception setNameSpaceStorePath " + string5, parseException);
                }
            }
            if (!stringPartScan.scan("TEXT:").scanOk()) continue;
            if (stringPartScan.scan("-LIST:").scanOk()) {
                xmlCfgNode.bTextMoreOccurrences = true;
            }
            if (!stringPartScan.scanLiteral("\"\"\\", 9999).scanOk()) continue;
            string4 = stringPartScan.getLastScannedString();
            try {
                xmlCfgNode.setContentStorePath(string4);
            }
            catch (ParseException parseException) {
                logMessage.writeError("ERROR readCfgFromText, Exception setContentStorePath " + string4, parseException);
            }
        }
        while (bl && stringPartScan.scan("<").scanIdentifier(null, "-:").scan(">").scanOk()) {
            string = stringPartScan.getLastScannedString();
            object = new XmlCfgNode(xmlCfgNode, this, string);
            if (xmlCfgNode.subnodes == null) {
                xmlCfgNode.subnodes = new TreeMap<String, XmlCfgNode>();
            }
            xmlCfgNode.subnodes.put(string, (XmlCfgNode)object);
            bl &= this.readFromTextNode((XmlCfgNode)object, stringPartScan, logMessage);
        }
        if (stringPartScan.scan("</").scanIdentifier(null, "-:").scan(">").scanOk()) {
            string = stringPartScan.getLastScannedString();
            if (!xmlCfgNode.tag.equals(string)) {
                logMessage.writeError("ERROR XmlCfg.readFromTextNode(): faulty </%s> for node %s", string, xmlCfgNode.tag);
            }
        } else {
            logMessage.writeError("ERROR XmlCfg.readFromTextNode(): missing </end:tag>", stringPartScan.getCurrentPart(30));
            bl = false;
        }
        return bl;
    }

    public void writeToText(File file, LogMessage logMessage) {
        StringBuilder stringBuilder = new StringBuilder();
        if (idxScript == null) {
            idxScript = new TreeMap<String, OutTextPreparer>();
            idxScript.put(XmlCfg.otxNode.sIdent, otxNode);
            idxScript.put(XmlCfg.otxCfgHead.sIdent, otxCfgHead);
            try {
                OutTextPreparer.parseTemplates(idxScript, this.getClass(), null, logMessage);
            }
            catch (ParseException parseException) {
                logMessage.writef("\nERROR internal parse exception", parseException);
            }
        }
        try {
            OutTextPreparer.DataTextPreparer dataTextPreparer = otxCfgHead.createArgumentDataObj();
            dataTextPreparer.setArgument("xmlCfg", (Object)this);
            dataTextPreparer.setExecObj(this);
            otxCfgHead.exec(stringBuilder, dataTextPreparer);
            OutTextPreparer.DataTextPreparer dataTextPreparer2 = otxNode.createArgumentDataObj();
            if (this.subtrees != null) {
                for (Map.Entry<String, XmlCfgNode> entry : this.subtrees.entrySet()) {
                    String string = entry.getKey();
                    XmlCfgNode xmlCfgNode = entry.getValue();
                    dataTextPreparer2.setArgument("whatis", (Object)("SUBTREE:" + string + " "));
                    dataTextPreparer2.setArgument("indent", (Object)"");
                    dataTextPreparer2.setArgument("node", (Object)xmlCfgNode);
                    dataTextPreparer2.setExecObj(this);
                    otxNode.exec(stringBuilder, dataTextPreparer2);
                }
            }
            dataTextPreparer2.setArgument("whatis", (Object)"");
            dataTextPreparer2.setArgument("indent", (Object)"");
            dataTextPreparer2.setArgument("node", (Object)this.rootNode);
            dataTextPreparer2.setExecObj(this);
            otxNode.exec(stringBuilder, dataTextPreparer2);
            stringBuilder.append("\n");
            FileFunctions.writeFile(stringBuilder.toString(), file);
        }
        catch (Exception exception) {
            logMessage.writef("\nERROR writing xmlcfg", exception);
        }
    }

    protected void writeSubNode(Appendable appendable, String string, XmlCfgNode xmlCfgNode) throws IOException {
        if (string.length() > 10) {
            return;
        }
        OutTextPreparer.DataTextPreparer dataTextPreparer = otxNode.createArgumentDataObj();
        dataTextPreparer.setArgument("whatis", (Object)"");
        dataTextPreparer.setArgument("indent", (Object)(string + "  "));
        dataTextPreparer.setArgument("node", (Object)xmlCfgNode);
        dataTextPreparer.setExecObj(this);
        otxNode.exec(appendable, dataTextPreparer);
        Debugutil.stop();
    }

    protected static void wrDataAccess(Appendable appendable, DataAccess.DatapathElement datapathElement) throws IOException {
        datapathElement.writeAccessString(appendable);
    }

    public Iterable<Map.Entry<String, String>> iterNamespace() {
        return this.xmlnsAssign.entrySet();
    }

    public void checkCfg(LogMessage logMessage) {
        this.checkCfg(this.rootNode, logMessage, new HashMap<XmlCfgNode, XmlCfgNode>(), 100);
    }

    private void checkCfg(XmlCfgNode xmlCfgNode, LogMessage logMessage, HashMap<XmlCfgNode, XmlCfgNode> hashMap, int n) {
        if (n < 10) {
            Debugutil.stop();
        } else if (n < 0) {
            throw new IllegalArgumentException("too many recurions checkCfg");
        }
        if (xmlCfgNode.subnodes != null) {
            for (XmlCfgNode xmlCfgNode2 : xmlCfgNode.subnodes.values()) {
                if (xmlCfgNode2.cfgSubtreeName != null) {
                    XmlCfgNode xmlCfgNode3 = this.subtrees.get(xmlCfgNode2.cfgSubtreeName);
                    xmlCfgNode2.cmpNode(xmlCfgNode3, logMessage);
                    Debugutil.stop();
                }
                if (hashMap.get(xmlCfgNode) != null) {
                    if (logMessage == null) continue;
                    logMessage.writeError("ERROR CheckCfgSubtree : node recursively %s in parent %s", xmlCfgNode.tag, xmlCfgNode.parent == null ? "??" : xmlCfgNode.parent.tag);
                    continue;
                }
                hashMap.put(xmlCfgNode, xmlCfgNode);
                this.checkCfg(xmlCfgNode2, logMessage, hashMap, n - 1);
                hashMap.remove(xmlCfgNode);
            }
        }
    }

    public static class XmlCfgNode {
        final XmlCfg cfg;
        final XmlCfgNode parent;
        DataAccess.DatapathElement elementCreatePath;
        DataAccess.DatapathElement elementFinishPath;
        boolean bList;
        Map<String, DataAccess.IntegerIx> allArgNames;
        boolean bCheckAttributeNode;
        boolean bStoreAttribsInNewContent;
        Map<String, AttribDstCheck> attribsForCheck;
        Map<String, AttribDstCheck> attribsArg;
        Map<String, AttribDstCheck> attribsSet;
        Map<String, AttribDstCheck> attribs;
        DataAccess.DatapathElement attribsUnspec;
        DataAccess.DatapathElement nameSpaceDef;
        Map<String, XmlCfgNode> subnodes;
        DataAccess.DatapathElement contentStorePath;
        boolean bTextMoreOccurrences;
        final CharSequence tag;
        String dstClassName;
        String cfgSubtreeName;

        XmlCfgNode(XmlCfgNode xmlCfgNode, XmlCfg xmlCfg, CharSequence charSequence) {
            this.parent = xmlCfgNode;
            this.cfg = xmlCfg;
            this.tag = charSequence;
            this.allArgNames = new TreeMap<String, DataAccess.IntegerIx>();
            this.allArgNames.put("name", new DataAccess.IntegerIx(0));
            this.allArgNames.put("value", new DataAccess.IntegerIx(1));
            this.allArgNames.put("tag", new DataAccess.IntegerIx(2));
            this.allArgNames.put("text", new DataAccess.IntegerIx(3));
        }

        public void setNewElementPath(String string) throws ParseException {
            String string2;
            if (this.cfg.readFromText && !string.startsWith("!")) {
                string2 = string;
            } else {
                if (!string.startsWith("!")) {
                    throw new IllegalArgumentException("The store path in xmlInput:data= \"" + string + "\" in config.xml should start with ! because it is a store path.");
                }
                string2 = string.substring(1);
            }
            StringPartScan stringPartScan = new StringPartScan(string2);
            stringPartScan.setIgnoreWhitespaces(true);
            this.elementCreatePath = new DataAccess.DatapathElement(stringPartScan, this.allArgNames, null);
            if (this.allArgNames.size() == 0) {
                this.allArgNames = null;
            }
        }

        public void setFinishElementPath(String string) throws ParseException {
            String string2;
            if (this.cfg.readFromText && !string.startsWith("!")) {
                string2 = string;
            } else {
                if (!string.startsWith("!")) {
                    throw new IllegalArgumentException("The store path in xmlInput:data= \"" + string + "\" in config.xml should start with ! because it is a store path.");
                }
                string2 = string.substring(1);
            }
            StringPartScan stringPartScan = new StringPartScan(string2);
            stringPartScan.setIgnoreWhitespaces(true);
            this.elementFinishPath = new DataAccess.DatapathElement(stringPartScan, this.allArgNames, null);
            if (this.allArgNames.size() == 0) {
                this.allArgNames = null;
            }
        }

        public void setList() {
            this.bList = true;
        }

        public void addAttribStorePath(String string, String string2) throws ParseException {
            AttribDstCheck attribDstCheck;
            if (string.equals("xmlinput:subtree")) {
                this.cfgSubtreeName = string2;
                XmlCfgNode xmlCfgNode = null;
                if (xmlCfgNode == null) {
                    List<XmlCfgNode> list;
                    if (this.cfg.subtreeForward == null) {
                        this.cfg.subtreeForward = new TreeMap<String, List<XmlCfgNode>>();
                    }
                    if ((list = this.cfg.subtreeForward.get(string2)) == null) {
                        list = new LinkedList<XmlCfgNode>();
                        this.cfg.subtreeForward.put(string2, list);
                    }
                    list.add(this);
                } else {
                    this.addFromSubtree(xmlCfgNode);
                }
            } else if (this.attribsForCheck != null && (attribDstCheck = this.attribsForCheck.get(string)) != null && attribDstCheck.bUseForCheck) {
                ((StringBuilder)this.tag).append('@').append(string).append("=\"").append(string2).append("\"");
            } else if (string2.length() > 0) {
                AttribDstCheck attribDstCheck2;
                String string3;
                String string4;
                if (this.attribs == null) {
                    this.attribs = new TreeMap<String, AttribDstCheck>();
                }
                if (this.cfg.readFromText && !string2.startsWith("!")) {
                    string4 = string2;
                } else {
                    if (!string2.startsWith("!")) {
                        throw new IllegalArgumentException("The store path as attrib value \"" + string2 + "\" in config.xml should start with ! because it is a store path.");
                    }
                    string4 = string2.substring(1);
                }
                if (StringFunctions.equals(string4, "CHECK")) {
                    string3 = null;
                    attribDstCheck2 = new AttribDstCheck(string, true);
                    this.attribsForCheck.put(string, attribDstCheck2);
                    this.attribs.put(string, attribDstCheck2);
                    this.bCheckAttributeNode = true;
                } else {
                    attribDstCheck2 = new AttribDstCheck(string, false);
                    this.attribs.put(string, attribDstCheck2);
                    string3 = string4;
                }
                if (string3 != null) {
                    if (string3.startsWith("@")) {
                        attribDstCheck2.storeInMap = string3.substring(1);
                        if (this.attribsArg == null) {
                            this.attribsArg = new TreeMap<String, AttribDstCheck>();
                        }
                        this.attribsArg.put(string, attribDstCheck2);
                    } else {
                        StringPartScan stringPartScan = new StringPartScan(string3);
                        attribDstCheck2.daccess = new DataAccess.DatapathElement(stringPartScan, this.allArgNames, null);
                        if (this.attribsSet == null) {
                            this.attribsSet = new TreeMap<String, AttribDstCheck>();
                        }
                        this.attribsSet.put(string, attribDstCheck2);
                        this.bStoreAttribsInNewContent = true;
                    }
                }
            }
        }

        public void setNameSpaceStorePath(String string) throws ParseException {
            assert (string.startsWith("!"));
            StringPartScan stringPartScan = new StringPartScan(string.substring(1));
            this.nameSpaceDef = new DataAccess.DatapathElement(stringPartScan, this.allArgNames, null);
        }

        void addFromSubtree(XmlCfgNode xmlCfgNode) {
            this.subnodes = xmlCfgNode.subnodes;
            if (xmlCfgNode.attribs != null) {
                for (Map.Entry<String, AttribDstCheck> entry : xmlCfgNode.attribs.entrySet()) {
                    AttribDstCheck attribDstCheck;
                    String string = entry.getKey();
                    AttribDstCheck attribDstCheck2 = entry.getValue();
                    if (this.attribs == null) {
                        this.attribs = new TreeMap<String, AttribDstCheck>();
                    }
                    if ((attribDstCheck = this.attribs.get(string)) == null) {
                        this.attribs.put(string, entry.getValue());
                        continue;
                    }
                    boolean bl = attribDstCheck2.bUseForCheck == attribDstCheck.bUseForCheck;
                    bl &= attribDstCheck2.daccess == null && attribDstCheck.daccess == null || attribDstCheck2.daccess.toString().equals(attribDstCheck.daccess.toString());
                    bl &= attribDstCheck2.name.equals(attribDstCheck.name);
                    if (bl &= attribDstCheck2.storeInMap.equals(attribDstCheck.storeInMap)) continue;
                    System.out.println("NOTE read XmlCfg: Diff. Attribute both in subtree and call found:");
                }
            }
            if (this.dstClassName == null) {
                this.dstClassName = xmlCfgNode.dstClassName;
            }
        }

        void addSubnode(String string, XmlCfgNode xmlCfgNode) {
            if (this.subnodes == null) {
                this.subnodes = new TreeMap<String, XmlCfgNode>();
            }
            if (string.startsWith("Object@")) {
                Debugutil.stop();
            }
            if (string.startsWith("Array@")) {
                Debugutil.stop();
            }
            this.subnodes.put(string, xmlCfgNode);
        }

        XmlCfgNode newElement(CharSequence charSequence) {
            XmlCfgNode xmlCfgNode;
            String string = charSequence.toString();
            XmlCfgNode xmlCfgNode2 = null;
            if (this.subnodes != null && (xmlCfgNode = this.subnodes.get(string)) != null) {
                if (!xmlCfgNode.bCheckAttributeNode) {
                    throw new IllegalArgumentException("XmlReader-cfg: An element has more as one node with the same tag name. This is only admissible if the first node contains a \"!CHECK\" attribute.");
                }
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(xmlCfgNode.tag);
                xmlCfgNode2 = new XmlCfgNode(this, this.cfg, stringBuilder);
                xmlCfgNode2.attribsForCheck = xmlCfgNode.attribs;
            }
            if (xmlCfgNode2 == null) {
                xmlCfgNode2 = new XmlCfgNode(this, this.cfg, string);
                this.addSubnode(string, xmlCfgNode2);
            }
            return xmlCfgNode2;
        }

        void setContentStorePath(String string) throws ParseException {
            String string2;
            if (this.tag instanceof StringBuilder) {
                if (this.tag.toString().startsWith("Object@")) {
                    Debugutil.stop();
                }
                if (this.tag.toString().startsWith("Array@")) {
                    Debugutil.stop();
                }
                this.parent.subnodes.put(this.tag.toString(), this);
            }
            if (this.cfg.readFromText && !string.startsWith("!")) {
                string2 = string;
            } else {
                if (!string.startsWith("!")) {
                    throw new IllegalArgumentException("The store path in xmlInput:data= \"" + string + "\" in config.xml should start with ! because it is a store path.");
                }
                string2 = string.substring(1);
            }
            StringPartScan stringPartScan = new StringPartScan(string2);
            this.contentStorePath = new DataAccess.DatapathElement(stringPartScan, this.allArgNames, null);
            stringPartScan.close();
        }

        public XmlCfgNode addSubTree(CharSequence charSequence) {
            XmlCfgNode xmlCfgNode = this.cfg.addSubTree(charSequence);
            return xmlCfgNode;
        }

        public boolean cmpNode(XmlCfgNode xmlCfgNode, LogMessage logMessage) {
            boolean bl;
            block35: {
                bl = true;
                try {
                    if (xmlCfgNode == null) {
                        bl = false;
                        if (logMessage != null) {
                            logMessage.writeError("ERROR CheckCfgSubtree : node not found in subtree: %s", this.cfgSubtreeName);
                        }
                    } else {
                        Object object;
                        Object object2;
                        if (this.attribs != null) {
                            if (xmlCfgNode.attribs == null) {
                                bl = false;
                                if (logMessage != null) {
                                    logMessage.writeError("ERROR CheckCfgSubtree attribs: %s has no attributes ", this.tag);
                                }
                            } else {
                                for (Map.Entry<String, AttribDstCheck> entry : this.attribs.entrySet()) {
                                    object2 = entry.getValue();
                                    object = xmlCfgNode.attribs.get(entry.getKey());
                                    if (object == null) {
                                        bl = false;
                                        if (logMessage == null) continue;
                                        logMessage.writeError("ERROR CheckCfgSubtree attribs: %s attribs.%s ?? not found ", this.tag, entry.getKey());
                                        continue;
                                    }
                                    if (((AttribDstCheck)object2).daccess != ((AttribDstCheck)object).daccess) {
                                        bl = false;
                                        if (logMessage != null) {
                                            logMessage.writeError("ERROR CheckCfgSubtree attribs: %s attribs.%s daccess %d ?? %d", this.tag, entry.getKey(), ((AttribDstCheck)object2).daccess, ((AttribDstCheck)object).daccess);
                                        }
                                    }
                                    if (!((AttribDstCheck)object2).name.equals(((AttribDstCheck)object).name)) {
                                        bl = false;
                                        if (logMessage != null) {
                                            logMessage.writeError("ERROR CheckCfgSubtree attribs: %s attribs.%s name %d ?? %d", this.tag, entry.getKey(), ((AttribDstCheck)object2).name, ((AttribDstCheck)object).name);
                                        }
                                    }
                                    if (((AttribDstCheck)object2).storeInMap.equals(((AttribDstCheck)object).storeInMap)) continue;
                                    bl = false;
                                    if (logMessage == null) continue;
                                    logMessage.writeError("ERROR CheckCfgSubtree attribs: %s attribs.%s storeInMap %d ?? %d", this.tag, entry.getKey(), ((AttribDstCheck)object2).storeInMap, ((AttribDstCheck)object).storeInMap);
                                }
                            }
                        }
                        if (this.subnodes != null) {
                            if (xmlCfgNode.subnodes == null) {
                                bl = false;
                                if (logMessage != null) {
                                    logMessage.writeError("ERROR CheckCfgSubtree subnodes: %s has no subnodes ", this.tag);
                                }
                            } else if (this.subnodes != xmlCfgNode.subnodes) {
                                for (Map.Entry<String, Object> entry : this.subnodes.entrySet()) {
                                    object2 = (XmlCfgNode)entry.getValue();
                                    object = xmlCfgNode.subnodes.get(entry.getKey());
                                    if (object == null) {
                                        bl = false;
                                        if (logMessage == null) continue;
                                        logMessage.writeError("ERROR CheckCfgSubtree subnodes: %s: %s ?? not found ", this.tag, entry.getKey());
                                        continue;
                                    }
                                    if (object == object2) continue;
                                    bl = false;
                                    if (logMessage == null) continue;
                                    logMessage.writeError("ERROR CheckCfgSubtree subnodes: %s: %s different %s ?? 5s ", this.tag, entry.getKey(), object2, object);
                                }
                            }
                        }
                        if (this.bCheckAttributeNode != xmlCfgNode.bCheckAttributeNode) {
                            bl = false;
                            if (logMessage != null) {
                                logMessage.writeError("ERROR CheckCfgSubtree bCheckAttributeNode: %s:  %b ?? %b", this.tag, this.bList, xmlCfgNode.bList);
                            }
                        }
                        if (this.bCheckAttributeNode != xmlCfgNode.bCheckAttributeNode) {
                            bl = false;
                            if (logMessage != null) {
                                logMessage.writeError("ERROR CheckCfgSubtree bCheckAttributeNode: %s:  %b ?? %b", this.tag, this.bList, xmlCfgNode.bList);
                            }
                        }
                        if (this.bStoreAttribsInNewContent != xmlCfgNode.bStoreAttribsInNewContent) {
                            bl = false;
                            if (logMessage != null) {
                                logMessage.writeError("ERROR CheckCfgSubtree bStoreAttribsInNewContent %s: %b ?? %b", this.tag, this.bStoreAttribsInNewContent, xmlCfgNode.bStoreAttribsInNewContent);
                            }
                        }
                        if (!this.cfgSubtreeName.equals(xmlCfgNode.cfgSubtreeName)) {
                            bl = false;
                            if (logMessage != null) {
                                logMessage.writeError("ERROR CheckCfgSubtree cfgSubtreeName %s: %s ?? %s", this.tag, this.cfgSubtreeName, xmlCfgNode.cfgSubtreeName);
                            }
                        }
                        if (this.dstClassName != null && !this.dstClassName.equals(xmlCfgNode.dstClassName)) {
                            bl = false;
                            if (logMessage != null) {
                                logMessage.writeError("ERROR CheckCfgSubtree dstClassName %s: %s ?? %s", this.tag, this.dstClassName, xmlCfgNode.dstClassName);
                            }
                        }
                        bl &= this.cmpDataAccess(this.tag, "contentStorePath", this.contentStorePath, xmlCfgNode.contentStorePath, logMessage);
                        bl &= this.cmpDataAccess(this.tag, "elementCreatePath", this.elementCreatePath, xmlCfgNode.elementCreatePath, logMessage);
                        bl &= this.cmpDataAccess(this.tag, "elementFinishPath", this.elementFinishPath, xmlCfgNode.elementFinishPath, logMessage);
                        bl &= this.cmpDataAccess(this.tag, "nameSpaceDef", this.nameSpaceDef, xmlCfgNode.nameSpaceDef, logMessage);
                        if (!this.tag.equals(xmlCfgNode.tag)) {
                            bl = false;
                            if (logMessage != null) {
                                logMessage.writeError("ERROR CheckCfgSubtree tag %s: %s ?? %s", this.tag, this.tag, xmlCfgNode.tag);
                            }
                        }
                    }
                    if (!bl) {
                        Debugutil.stop();
                    }
                }
                catch (Exception exception) {
                    if (logMessage == null) break block35;
                    logMessage.writeError("ERROR CheckCfgSubtree unexpected exception", exception);
                }
            }
            return bl;
        }

        private boolean cmpDataAccess(CharSequence charSequence, String string, DataAccess.DatapathElement datapathElement, DataAccess.DatapathElement datapathElement2, LogMessage logMessage) {
            if (datapathElement == null) {
                return true;
            }
            if (datapathElement2 == null) {
                return true;
            }
            if (!datapathElement.toString().equals(datapathElement2.toString())) {
                if (logMessage != null) {
                    logMessage.writeError("ERROR CheckCfgSubtree %s dataAccess.%s: %s ?? %s", charSequence, string, datapathElement, datapathElement2);
                }
                return false;
            }
            return true;
        }

        public String toString() {
            XmlCfgNode xmlCfgNode;
            if (this.subnodes != null && this.subnodes.size() >= 1 && (xmlCfgNode = this.subnodes.get("?")) == this) {
                return this.tag + (this.attribs != null ? " attr:" + this.attribs.toString() : "") + " nodes: ?: own";
            }
            return this.tag + (this.attribs != null ? " attr:" + this.attribs.toString() : "") + (this.subnodes != null ? " nodes...:" : "");
        }
    }

    public static class AttribDstCheck {
        final String name;
        DataAccess.DatapathElement daccess;
        String storeInMap;
        public final boolean bUseForCheck;

        public AttribDstCheck(String string, boolean bl) {
            this.name = string;
            this.bUseForCheck = bl;
        }

        public String toString() {
            return this.name;
        }
    }
}

