/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import org.vishia.util.Debugutil;
import org.vishia.util.PathCheck;
import org.vishia.util.SortedTreeWalkerCallback;

public class TreeWalkerPathCheck
implements SortedTreeWalkerCallback<String, Object> {
    public static final String sVersion = "2015-05-25";
    final PathCheck check;
    private CurrDirChildren curr;

    public TreeWalkerPathCheck(String string) {
        this.check = new PathCheck(string);
    }

    @Override
    public void start(String string, Object object) {
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(String string, Object object, Object object2) {
        PathCheck pathCheck = this.curr != null ? this.curr.pathCheck : this.check;
        PathCheck pathCheck2 = pathCheck.check(string, true);
        if (pathCheck2 == null) {
            return SortedTreeWalkerCallback.Result.skipSubtree;
        }
        this.curr = new CurrDirChildren(string, pathCheck2, this.curr);
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(String string, Object object, Object object2) {
        this.curr = this.curr.parent;
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(String string, Object object) {
        PathCheck pathCheck;
        if (this.curr == null) {
            Debugutil.stop();
        }
        assert (this.curr != null);
        PathCheck pathCheck2 = this.curr.pathCheck;
        PathCheck pathCheck3 = pathCheck = pathCheck2.next != null ? null : pathCheck2.check(string, false);
        if (pathCheck == null) {
            return SortedTreeWalkerCallback.Result.skipSubtree;
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public void finished(String string) {
    }

    @Override
    public boolean shouldAborted() {
        return false;
    }

    private class CurrDirChildren {
        String dir;
        int levelProcessMarked;
        PathCheck pathCheck;
        CurrDirChildren parent;

        CurrDirChildren(String string, PathCheck pathCheck, CurrDirChildren currDirChildren) {
            this.dir = string;
            this.parent = currDirChildren;
            this.pathCheck = pathCheck;
            this.levelProcessMarked = currDirChildren == null ? 0 : currDirChildren.levelProcessMarked - 1;
        }

        public String toString() {
            return this.dir + ": " + this.pathCheck;
        }
    }
}

