/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.IOException;
import java.util.Formatter;
import java.util.Locale;
import org.vishia.util.CheckVs;
import org.vishia.util.StringFunctions;

public class TestOrg {
    public static final String sVersion = "2024-07-15";
    private boolean bOk = true;
    private final String title;
    private boolean bTitleShown = false;
    private final int nTestVerboseLevel;
    private final StringBuilder sbTxt = new StringBuilder(200);
    private final Formatter formatter = new Formatter(this.sbTxt, Locale.ENGLISH);
    private final int nVerboseTitle;
    private Appendable out;
    private final TestOrg parent;

    public TestOrg(String string, int n, String[] stringArray) {
        this(string, n, stringArray, System.out);
    }

    public TestOrg(String string, int n, String[] stringArray, Appendable appendable) {
        this.title = string;
        this.nVerboseTitle = n;
        int n2 = 4;
        for (String string2 : stringArray) {
            if (!string2.startsWith("---TESTverbose:")) continue;
            n2 = string2.charAt(15) - 48;
        }
        this.nTestVerboseLevel = n2;
        this.parent = null;
        this.out = appendable;
    }

    public TestOrg(String string, int n, TestOrg testOrg) {
        this.title = string;
        this.nVerboseTitle = n;
        this.nTestVerboseLevel = testOrg.nTestVerboseLevel;
        this.parent = testOrg;
        this.out = testOrg.out;
    }

    public int expect(CharSequence charSequence, CharSequence charSequence2, int n, String string) {
        String string2;
        int n2 = StringFunctions.comparePos(charSequence, charSequence2);
        if (n2 != 0) {
            int n3;
            n2 = Math.abs(n2);
            int n4 = charSequence.length();
            String string3 = " ";
            if (n4 > n2 + 20) {
                n4 = n2 + 20;
                string3 = "... ";
            }
            string2 = (n3 = StringFunctions.indexOfAnyChar(charSequence, n2, n4, "\n\r")) >= n2 && n3 < n4 ? "@" + n2 + ": " + charSequence.subSequence(n2, n3) + "\\n" + string3 + ": " + string : "@" + n2 + ": " + charSequence.subSequence(n2, n4) + ": " + string3 + string;
        } else {
            string2 = string;
        }
        this.expect_(n2 == 0, n, string2, 3, new Object[0]);
        return n2;
    }

    public void expect(double d, double d2, double d3, int n, String string, Object ... objectArray) {
        boolean bl = Math.abs(d - d2) < d3;
        this.expect(bl, n, string, objectArray);
    }

    public void expect(boolean bl, int n, String string, Object ... objectArray) {
        this.expect_(bl, n, string, 3, objectArray);
    }

    private void expect_(boolean bl, int n, String string, int n2, Object ... objectArray) {
        boolean bl2;
        boolean bl3 = bl2 = this.nTestVerboseLevel >= n;
        if (!bl || bl2 && !this.bTitleShown) {
            this.showParentTitle(null);
        }
        if (bl) {
            if (bl2) {
                this.out("\n  ok: ", new Object[0]);
                this.outln(string, objectArray);
            }
        } else {
            TestOrg testOrg = this;
            while (testOrg != null) {
                testOrg.bOk = false;
                testOrg = testOrg.parent;
            }
            CharSequence charSequence = CheckVs.stackInfo("", n2, 3);
            this.out("\n  ERROR: ", new Object[0]);
            this.out(string, objectArray);
            this.out(" @ ", new Object[0]);
            this.out(charSequence, new Object[0]);
        }
    }

    private void showParentTitle(String string) {
        if (!this.bTitleShown) {
            if (this.parent != null) {
                this.parent.showParentTitle(null);
            } else {
                this.outln("=========================================================================", new Object[0]);
            }
            if (string != null) {
                this.out(string, new Object[0]);
            }
            this.outln(this.title, new Object[0]);
            this.bTitleShown = true;
        }
    }

    public void exception(Exception exception) {
        TestOrg testOrg = this;
        while (testOrg != null) {
            testOrg.bOk = false;
            testOrg = testOrg.parent;
        }
        this.showParentTitle(null);
        CharSequence charSequence = CheckVs.exceptionInfo("  Exception: ", exception, 0, 5);
        this.out(charSequence, new Object[0]);
    }

    public void finish() {
        if (this.bOk && this.nTestVerboseLevel >= this.nVerboseTitle) {
            this.showParentTitle("ok ");
        }
    }

    public boolean isOk() {
        return this.bOk;
    }

    public void out(CharSequence charSequence, Object ... objectArray) {
        try {
            CharSequence charSequence2;
            if (objectArray.length > 0) {
                this.sbTxt.setLength(0);
                this.formatter.format(charSequence.toString(), objectArray);
                charSequence2 = this.sbTxt;
            } else {
                charSequence2 = charSequence;
            }
            this.out.append(charSequence2);
        }
        catch (IOException iOException) {
            System.err.append("Exception on TestOrg.out / ").append(charSequence);
        }
    }

    public void outln(CharSequence charSequence, Object ... objectArray) {
        this.out(charSequence + "\n", objectArray);
    }
}

