/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.FileSystem;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileRemoteCallbackSearch
implements SortedTreeWalkerCallback<FileRemote, FileRemoteCmdEventData> {
    public static final String sVersion = "2016-12-27";
    private final CompareCtrl cmpCtrl = new CompareCtrl();
    private final FileRemote dir1;
    private FileRemote dirCurr;
    private final String basepath1;
    private final int zBasePath1;
    private final EventWithDst<FileRemoteProgressEvData, ?> evBack;
    private final FileRemoteProgressEvData progress;
    private final FileRemoteWalkerCallback callbackUser;
    int mode;
    long minDiffTimestamp = 2000L;
    static final int cmp_onlyTimestamp = 1;
    static final int cmp_content = 2;
    static final int cmp_withoutLineend = 4;
    static final int cmp_withoutEndlineComment = 8;
    static final int cmp_withoutComment = 16;
    final byte[] buffer = new byte[16384];
    final byte[] search;
    boolean aborted = false;

    FileRemoteCallbackSearch(FileRemote fileRemote, byte[] byArray, FileRemoteWalkerCallback fileRemoteWalkerCallback, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        this.evBack = eventWithDst;
        this.progress = eventWithDst.data();
        this.callbackUser = fileRemoteWalkerCallback;
        this.dir1 = fileRemote;
        this.search = byArray;
        this.basepath1 = FileSystem.normalizePath(fileRemote.getAbsolutePath()).toString();
        this.zBasePath1 = this.basepath1.length();
        this.cmpCtrl.ignoreToEol.add(".file");
        this.cmpCtrl.ignoreToEol.add("//");
        this.cmpCtrl.ignoreToEol.add("Compilation time:");
        this.cmpCtrl.ignoreToEol.add("Compiler options:");
        this.cmpCtrl.ignoreCommentline.add("//");
        this.cmpCtrl.ignoreFromTo.add(new String[]{".epcannot:", ".epcannot.end:"});
        this.cmpCtrl.ignoreFromTo.add(new String[]{".static1:", ".static1.end:"});
    }

    @Override
    public void start(FileRemote fileRemote, FileRemoteCmdEventData fileRemoteCmdEventData) {
        if (this.dir1.device == null) {
            this.dir1.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.dir1.getAbsolutePath());
        }
        int n = 0x3D300000;
        this.dir1.resetMarkedRecurs(n, null);
        this.dir1.setMarked(0x100000);
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote, Object object, Object object2) {
        this.dirCurr = fileRemote;
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, Object object, Object object2) {
        return SortedTreeWalkerCallback.Result.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        InputStream inputStream = null;
        int n = 0;
        try {
            inputStream = fileRemote.openInputStream(0L);
            if (inputStream != null) {
                int n2;
                int n3 = 1;
                while (n3 > 0 && (n2 = inputStream.read(this.buffer, n, this.buffer.length - n)) > 0) {
                    byte by = this.search[0];
                    int n4 = 0;
                    do {
                        if (this.buffer[n4] != by || n4 + this.search.length >= this.buffer.length) continue;
                        boolean bl = true;
                        for (int i = 1; i < this.search.length; ++i) {
                            if (this.buffer[n4 + i] == this.search[i]) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        --n3;
                    } while (n3 > 0 && ++n4 < n2);
                }
                if (n3 <= 0) {
                    fileRemote.setMarked(0x20000000);
                    fileRemote.mark.setMarkParent(0x20000000, false);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public boolean shouldAborted() {
        return this.aborted;
    }

    int searchInFile(FileRemote fileRemote) {
        return 0;
    }

    boolean compareFileContent(FileRemote fileRemote, FileRemote fileRemote2) throws IOException {
        String string;
        boolean bl = true;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        bufferedReader = new BufferedReader(new FileReader(fileRemote));
        bufferedReader2 = new BufferedReader(new FileReader(fileRemote2));
        while (bl && (string = this.readIgnoreComment(bufferedReader)) != null) {
            int n;
            String string2 = this.readIgnoreComment(bufferedReader2);
            for (String string3 : this.cmpCtrl.ignoreToEol) {
                n = string.indexOf(string3);
                if (n < 0) continue;
                string = string.substring(0, n);
                int n2 = string2.indexOf(string3);
                if (n2 < 0 || n2 != n) break;
                string2 = string2.substring(0, n2);
                break;
            }
            block2: for (String[] stringArray : this.cmpCtrl.ignoreFromTo) {
                String string4;
                int n3;
                String string5;
                n = string.indexOf(stringArray[0]);
                if (n < 0) continue;
                string = string.substring(0, n);
                while ((string5 = this.readIgnoreComment(bufferedReader)) != null) {
                    n3 = string5.indexOf(stringArray[1]);
                    if (n3 < 0) continue;
                    string = string + string5.substring(n3 + stringArray[1].length());
                    break;
                }
                if ((n3 = string2.indexOf(stringArray[0])) < 0) break;
                string2 = string2.substring(0, n3);
                while ((string4 = this.readIgnoreComment(bufferedReader2)) != null) {
                    int n4 = string4.indexOf(stringArray[1]);
                    if (n4 < 0) continue;
                    string2 = string2 + string4.substring(n4 + stringArray[1].length());
                    break block2;
                }
                break block2;
            }
            if (string2 != null && string.equals(string2)) continue;
            bl = false;
        }
        if (this.readIgnoreComment(bufferedReader2) != null) {
            bl = false;
        }
        bufferedReader.close();
        bufferedReader2.close();
        bufferedReader2 = null;
        bufferedReader = null;
        FileSystem.close(bufferedReader);
        FileSystem.close(bufferedReader2);
        return bl;
    }

    private String readIgnoreComment(BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl;
        block0: do {
            bl = false;
            string = bufferedReader.readLine();
            if (string == null) continue;
            for (String string2 : this.cmpCtrl.ignoreCommentline) {
                if (!string.startsWith(string2)) continue;
                bl = true;
                continue block0;
            }
        } while (bl);
        return string;
    }

    @Override
    public void finished(FileRemote fileRemote) {
    }

    class CompareCtrl {
        final List<String> ignoreToEol = new LinkedList<String>();
        final List<String> ignoreCommentline = new LinkedList<String>();
        final List<String[]> ignoreFromTo = new LinkedList<String[]>();

        CompareCtrl() {
        }
    }
}

