/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.vishia.cmd.CmdExecuter;
import org.vishia.cmd.CmdGetFileArgs_ifc;
import org.vishia.util.FileSystem;

public final class PrepareCmd {
    public static String version = "2016-12-27";
    public static final char executeInShellOpened = '>';
    public static final char executeInShellClose = '$';
    public static final char executeStartProcess = '&';
    public static final char executeLocalPipes = '%';
    public static final char executeJavaMain = '*';
    public static final char executeQuest = '?';
    private final File3Parts part = new File3Parts();
    private List<CmdReplace> listPlaceholderForCmdArgsTemplate;
    private String[] cmdArgsTemplate;
    private final char cKindOfExecutionDefault;
    private final boolean isWindows;
    private char cKindOfExecutionPrepared;
    private String[] cmdSrc;
    private String name;

    PrepareCmd(char c) {
        this.cKindOfExecutionDefault = c;
        this.isWindows = this.checkIsWindows();
    }

    PrepareCmd() {
        this.cKindOfExecutionDefault = (char)37;
        this.isWindows = this.checkIsWindows();
    }

    private final boolean checkIsWindows() {
        String string = System.getenv("OS");
        return string != null && string.toLowerCase().startsWith("windows");
    }

    @Deprecated
    public void prepareListCmdReplace() {
        int n = -1;
        this.cmdArgsTemplate = new String[this.cmdSrc.length];
        this.cKindOfExecutionPrepared = this.cKindOfExecutionDefault;
        this.listPlaceholderForCmdArgsTemplate = new LinkedList<CmdReplace>();
        for (String string : this.cmdSrc) {
            StringBuilder stringBuilder;
            char c = string.charAt(0);
            if (++n == 0 && "%>&$*?".indexOf(c) >= 0) {
                this.cKindOfExecutionPrepared = c;
                stringBuilder = new StringBuilder(string.substring(1));
            } else {
                stringBuilder = new StringBuilder(string);
            }
            int n2 = 0;
            while ((n2 = stringBuilder.indexOf("<*", n2)) >= 0) {
                int n3;
                String string2 = stringBuilder.substring(n2);
                CmdReplace cmdReplace = new CmdReplace();
                cmdReplace.pos = n2;
                cmdReplace.arg = n;
                if (string2.startsWith("<*file")) {
                    cmdReplace.what = 102;
                    n3 = 6;
                } else if (string2.startsWith("<*dir")) {
                    cmdReplace.what = 100;
                    n3 = 5;
                } else if (string2.startsWith("<*nameExt")) {
                    cmdReplace.what = 110;
                    n3 = 9;
                } else if (string2.startsWith("<*name")) {
                    cmdReplace.what = 109;
                    n3 = 6;
                } else if (string2.startsWith("<*ext")) {
                    cmdReplace.what = 101;
                    n3 = 5;
                } else if (string2.startsWith("<*localFile")) {
                    cmdReplace.what = 108;
                    n3 = 11;
                } else if (string2.startsWith("<*absFile")) {
                    cmdReplace.what = 97;
                    n3 = 9;
                } else if (string2.startsWith("<*localDir")) {
                    cmdReplace.what = 99;
                    n3 = 10;
                } else if (string2.startsWith("<*absDir")) {
                    cmdReplace.what = 98;
                    n3 = 8;
                } else if (string2.startsWith("<*wfile")) {
                    cmdReplace.what = 70;
                    n3 = 7;
                } else if (string2.startsWith("<*wdir")) {
                    cmdReplace.what = 68;
                    n3 = 6;
                } else if (string2.startsWith("<*wlocalFile")) {
                    cmdReplace.what = 76;
                    n3 = 12;
                } else if (string2.startsWith("<*wabsFile")) {
                    cmdReplace.what = 65;
                    n3 = 10;
                } else if (string2.startsWith("<*wlocalDir")) {
                    cmdReplace.what = 67;
                    n3 = 11;
                } else if (string2.startsWith("<*wabsDir")) {
                    cmdReplace.what = 66;
                    n3 = 9;
                } else {
                    n3 = 0;
                }
                if (n3 > 0) {
                    char c2 = string2.charAt(n3);
                    switch (c2) {
                        case '1': {
                            cmdReplace.what |= 0x10000;
                            ++n3;
                            break;
                        }
                        case '2': {
                            cmdReplace.what |= 0x20000;
                            ++n3;
                            break;
                        }
                        case '3': {
                            cmdReplace.what |= 0x30000;
                            ++n3;
                            break;
                        }
                        case '>': {
                            break;
                        }
                        default: {
                            n3 = 0;
                        }
                    }
                    if (n3 <= 0 || string2.length() <= n3 || string2.charAt(n3) != '>') continue;
                    this.listPlaceholderForCmdArgsTemplate.add(cmdReplace);
                    stringBuilder.replace(n2, n2 + n3 + 1, "");
                    continue;
                }
                n2 += 2;
            }
            this.cmdArgsTemplate[n] = stringBuilder.toString();
        }
        System.out.println("PrepareCmd - prepareListCmdReplace;" + this.toString());
    }

    public void set_cmd(String string) {
        this.cmdSrc = CmdExecuter.splitArgs(string);
        this.prepareListCmdReplace();
    }

    public void set_name(String string) {
        this.name = string;
    }

    public String[] prepareCmd(CmdGetFileArgs_ifc cmdGetFileArgs_ifc) {
        int n = 0;
        String[] stringArray = new String[this.cmdArgsTemplate.length];
        if (this.listPlaceholderForCmdArgsTemplate == null) {
            this.prepareListCmdReplace();
        }
        cmdGetFileArgs_ifc.prepareFileSelection();
        this.part.clean(cmdGetFileArgs_ifc);
        for (CmdReplace cmdReplace : this.listPlaceholderForCmdArgsTemplate) {
            FileParts fileParts;
            while (n < cmdReplace.arg) {
                stringArray[n] = this.cmdArgsTemplate[n];
                ++n;
            }
            StringBuilder stringBuilder = new StringBuilder(this.cmdArgsTemplate[n]);
            switch (cmdReplace.what & 0xF0000) {
                case 0: {
                    fileParts = this.part.file;
                    break;
                }
                case 65536: {
                    fileParts = this.part.file1;
                    break;
                }
                case 131072: {
                    fileParts = this.part.file2;
                    break;
                }
                case 196608: {
                    fileParts = this.part.file3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("faulty part designation:" + Integer.toHexString(cmdReplace.what));
                }
            }
            String string = null;
            switch (cmdReplace.what & 0xFFFF) {
                case 102: {
                    string = fileParts.getGivenFile();
                    break;
                }
                case 100: {
                    string = fileParts.getGivenDir();
                    break;
                }
                case 109: {
                    string = fileParts.getNameOnly();
                    break;
                }
                case 110: {
                    string = fileParts.getNameExt();
                    break;
                }
                case 101: {
                    string = fileParts.getNameExt();
                    break;
                }
                case 108: {
                    string = fileParts.getLocalFile();
                    break;
                }
                case 97: {
                    string = fileParts.getCanonicalFile();
                    break;
                }
                case 99: {
                    string = fileParts.getLocalDir();
                    break;
                }
                case 98: {
                    string = fileParts.getCanonicalDir();
                }
            }
            if (string == null) {
                string = "??";
            }
            if (this.isWindows) {
                string = string.replace('/', '\\');
            }
            stringBuilder.insert(cmdReplace.pos, string);
            stringArray[n] = stringBuilder.toString();
            ++n;
        }
        while (n < stringArray.length) {
            stringArray[n] = this.cmdArgsTemplate[n];
            ++n;
        }
        return stringArray;
    }

    public Class getJavaClass() {
        return null;
    }

    public boolean usePipes() {
        return this.cKindOfExecutionPrepared == '%';
    }

    public char getKindOfExecution() {
        return this.cKindOfExecutionPrepared;
    }

    public String toString() {
        return this.cKindOfExecutionPrepared + this.cmdSrc[0];
    }

    private static class File3Parts {
        final FileParts file = new FileParts(0);
        final FileParts file1 = new FileParts(1);
        final FileParts file2 = new FileParts(2);
        final FileParts file3 = new FileParts(3);

        private File3Parts() {
        }

        void clean(CmdGetFileArgs_ifc cmdGetFileArgs_ifc) {
            this.file.clean(cmdGetFileArgs_ifc);
            this.file1.clean(cmdGetFileArgs_ifc);
            this.file2.clean(cmdGetFileArgs_ifc);
            this.file3.clean(cmdGetFileArgs_ifc);
        }
    }

    private static class FileParts {
        final int whichFile;
        private CmdGetFileArgs_ifc args;
        File file;
        String sPathFile;
        String sPathLocal;
        String sPathCanonical;
        int posFile;
        int posFileInLocalPath;
        String sName;
        int posExt;

        FileParts(int n) {
            this.whichFile = n;
        }

        void clean(CmdGetFileArgs_ifc cmdGetFileArgs_ifc) {
            this.args = cmdGetFileArgs_ifc;
            this.file = null;
            this.sName = null;
            this.sPathFile = null;
            this.sPathLocal = null;
            this.sPathCanonical = null;
            this.posExt = -2;
            this.posFile = -2;
            this.posFileInLocalPath = -2;
        }

        void getFile() {
            switch (this.whichFile) {
                case 0: {
                    this.file = this.args.getFileSelect();
                    break;
                }
                case 1: {
                    this.file = this.args.getFile1();
                    break;
                }
                case 2: {
                    this.file = this.args.getFile2();
                    break;
                }
                case 3: {
                    this.file = this.args.getFile3();
                }
            }
        }

        String getGivenFile() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sPathFile == null) {
                this.sPathFile = this.file.getPath();
            }
            return this.sPathFile;
        }

        String getNameExt() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sName == null) {
                this.sName = this.file.getName();
            }
            return this.sName;
        }

        String getNameOnly() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sName == null) {
                this.sName = this.file.getName();
            }
            if (this.posExt == -2) {
                this.posExt = this.sName.lastIndexOf(46);
            }
            return this.posExt < 1 ? this.sName : this.sName.substring(0, this.posExt);
        }

        String getExt() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sName == null) {
                this.sName = this.file.getName();
            }
            if (this.posExt == -2) {
                this.posExt = this.sName.lastIndexOf(46);
            }
            return this.posExt < 0 ? "" : this.sName.substring(this.posExt + 1);
        }

        String getLocalFile() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sPathLocal == null) {
                this.sPathLocal = this.file.getPath();
            }
            return this.sPathLocal;
        }

        String getLocalDir() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sPathLocal == null) {
                this.sPathLocal = this.file.getPath();
            }
            if (this.posFileInLocalPath == -2) {
                this.posFileInLocalPath = this.sPathLocal.lastIndexOf(47);
            }
            return this.posFileInLocalPath == -1 ? "." : this.sPathLocal.substring(0, this.posFileInLocalPath);
        }

        String getGivenDir() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sPathFile == null) {
                this.sPathFile = this.file.getPath();
            }
            if (this.posFileInLocalPath == -2) {
                this.posFileInLocalPath = this.sPathFile.lastIndexOf(47);
            }
            return this.posFileInLocalPath == -1 ? "." : this.sPathFile.substring(0, this.posFileInLocalPath);
        }

        String getCanonicalFile() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sPathCanonical == null) {
                this.sPathCanonical = FileSystem.getCanonicalPath(this.file);
            }
            return this.sPathCanonical;
        }

        String getCanonicalDir() {
            if (this.file == null) {
                this.getFile();
            }
            if (this.sPathCanonical == null) {
                this.sPathCanonical = FileSystem.getCanonicalPath(this.file);
            }
            if (this.posFile == -2) {
                this.posFile = this.sPathCanonical.lastIndexOf(47);
            }
            return this.sPathCanonical.substring(0, this.posFile);
        }
    }

    private static class CmdReplace {
        int arg;
        int pos;
        int what;

        private CmdReplace() {
        }
    }
}

