/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.checkDeps_C;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.checkDeps_C.CheckDependencyFile;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.util.Arguments;
import org.vishia.util.FileFunctions;

public class CheckDeps {
    public CheckDependencyFile checkDepfile;

    public CheckDeps() {
        MainCmdLoggingStream mainCmdLoggingStream = new MainCmdLoggingStream(System.out);
        this.checkDepfile = new CheckDependencyFile(mainCmdLoggingStream, true);
    }

    int exec(Args args) throws FileNotFoundException {
        for (String string : args.listRootObjExt) {
            this.checkDepfile.setDirObj(string);
        }
        this.checkDepfile.readCfgData(args.sFileCfg, args.currdir);
        this.checkDepfile.readDependencies(args.sFileDep);
        System.out.println("checkDeps_C: " + args.sFileDep + " read successfully");
        for (String string : args.pathsSrcGen) {
            this.checkDepfile.processSrcfile(string);
        }
        this.checkDepfile.writeDependencies();
        this.checkDepfile.close();
        return 0;
    }

    public static void main(String[] stringArray) {
        int n = CheckDeps.smain(stringArray);
        System.exit(n);
    }

    public static int smain(String[] stringArray) {
        int n;
        Args args = new Args();
        System.out.println(args.aboutInfo());
        try {
            args.parseArgs(stringArray, System.err);
            if (!args.testConsistence(System.err)) {
                return 1;
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR CheckDeps arguments: " + exception.getMessage());
            return Args.exitCodeArgError;
        }
        CheckDeps checkDeps = new CheckDeps();
        try {
            n = checkDeps.exec(args);
        }
        catch (Exception exception) {
            System.err.println("ERROR unexpected in CheckDeps: " + exception.getMessage());
            n = 9;
        }
        return n;
    }

    public static class Args
    extends Arguments {
        public File currdir;
        public String sFileCfg;
        public List<String> pathsSrcGen = new LinkedList<String>();
        public String sPathSrcMirrorRoot;
        public List<String> listRootObjExt = new LinkedList<String>();
        public String sFileDep;
        public boolean cmpAndCpy;
        public boolean evalDeps;
        public String sPathLast;
        public boolean testDummyObj;
        Arguments.SetArgument setCurrdir = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) throws FileNotFoundException {
                currdir = FileFunctions.newFile(string).getAbsoluteFile();
                boolean bl = currdir.exists();
                return bl;
            }
        };
        Arguments.SetArgument setFileCfg = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                sFileCfg = string;
                return true;
            }
        };
        Arguments.SetArgument setPathSrcMirrorRoot = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                sPathSrcMirrorRoot = string;
                return true;
            }
        };
        Arguments.SetArgument setPathsSrcGen = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                pathsSrcGen.add(string);
                return true;
            }
        };
        Arguments.SetArgument setPathObj = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                boolean bl;
                int n = string.indexOf("/*.");
                if (n < 0) {
                    System.err.println("argument -obj should contain a *: Syntay -obj=path/*.ext");
                    bl = false;
                } else {
                    if (listRootObjExt == null) {
                        listRootObjExt = new LinkedList<String>();
                    }
                    listRootObjExt.add(string);
                    bl = true;
                }
                return bl;
            }
        };
        Arguments.SetArgument setFileDep = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                sFileDep = string;
                return true;
            }
        };
        Arguments.SetArgument setCmpAndCpy = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                cmpAndCpy = true;
                return true;
            }
        };
        Arguments.SetArgument setEvalDeps = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                evalDeps = true;
                return true;
            }
        };
        Arguments.SetArgument setPathLast = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                sPathLast = string;
                return true;
            }
        };
        Arguments.SetArgument setDummyObj = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                testDummyObj = true;
                return true;
            }
        };

        Args() {
            this.aboutInfo = "Depedency checker for C/++ files, 2009-10 - 2020-07-23";
            this.helpInfo = "obligate args: -cfg:CFG -depALL:DEP.txt { -obj/PATH/*.OBJ } { -src:SOURCES}";
            this.addArg(new Arguments.Argument("-currdir", ":path/to/currdir For all actions with relative path", this.setCurrdir));
            this.addArg(new Arguments.Argument("-src", ":path/to/src A source file to check, more as one possible", this.setPathsSrcGen));
            this.addArg(new Arguments.Argument("-srcBuild", ":path/to/rootMirror root directory for mirror sources to compare ...", this.setPathSrcMirrorRoot));
            this.addArg(new Arguments.Argument("-srcMirrorRoot", ":path/to/rootMirror       ... whether only comments are changed", this.setPathsSrcGen));
            this.addArg(new Arguments.Argument("-obj", ":path/to/rootObj/*.obj root directory to Objectfiles and extension for Obj", this.setPathObj));
            this.addArg(new Arguments.Argument("-cfg", ":path/to/CheckDeps.cfg Configuration file, write ? for help", this.setFileCfg));
            this.addArg(new Arguments.Argument("-depAll", ":path/to/MyProject.deps - file contains existing, dependencies, will be written or replaced", this.setFileDep));
            this.addArg(new Arguments.Argument("cmpAndCpy", " command to .... TODO", this.setCmpAndCpy));
            this.addArg(new Arguments.Argument("evalDeps", " command to only evaluation dependencies", this.setEvalDeps));
            this.addArg(new Arguments.Argument("-lastPath", ":path/to/TODO", this.setPathLast));
            this.addArg(new Arguments.Argument("-testDummyObj", " option for DummyObject", this.setDummyObj));
        }

        @Override
        public boolean testConsistence(Appendable appendable) throws IOException {
            boolean bl = true;
            if (this.listRootObjExt.size() == 0) {
                appendable.append("-obj:path/to/rootObj/*.o should given at least one time.\n");
                bl = false;
            }
            return bl;
        }
    }
}

