/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData.reflection_Jc;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.vishia.byteData.Class_Jc;
import org.vishia.byteData.Field_Jc;
import org.vishia.byteData.ObjectArray_Jc;

public class Reflection_Jc {
    private TreeMap<Integer, Class> allClassesByMemAddr = new TreeMap();
    private TreeMap<String, Class> allClassesByName = new TreeMap();
    private TreeMap<Integer, FieldAccess> allFieldArraysByMemAddr = new TreeMap();
    private List<Class> allClasses = new LinkedList<Class>();

    public Class getClassFromMemAddr(int n) {
        Class clazz = this.allClassesByMemAddr.get(new Integer(n));
        return clazz;
    }

    public void add(Class_Jc class_Jc) {
        Class clazz = new Class();
        clazz.name = class_Jc.getName();
        clazz.fieldsPodAddr = class_Jc.getFieldsAddr();
        clazz.ownPodAddr = class_Jc.getOwnAdress();
        this.allClassesByMemAddr.put(new Integer(clazz.ownPodAddr), clazz);
        this.allClassesByName.put(clazz.name, clazz);
        this.allClasses.add(clazz);
    }

    public FieldAccess addfields(ObjectArray_Jc objectArray_Jc) {
        int n = objectArray_Jc.getLength_ArrayJc();
        FieldAccess fieldAccess = new FieldAccess();
        fieldAccess.ownPodAddr = objectArray_Jc.getOwnAdress();
        fieldAccess.fields = new Field[n];
        for (int i = 0; i < n; ++i) {
            Field_Jc field_Jc = new Field_Jc();
            objectArray_Jc.addChild(field_Jc);
            Field field = new Field();
            field.name = field_Jc.getName();
            field.position = field_Jc.getPosValue();
            field.typeAddr = field_Jc.getType();
            field.modifier = field_Jc.getModifiers();
            fieldAccess.fields[i] = field;
        }
        this.allFieldArraysByMemAddr.put(new Integer(fieldAccess.ownPodAddr), fieldAccess);
        return fieldAccess;
    }

    public void assignAllElementsToClasses() {
        for (Class clazz : this.allClasses) {
            FieldAccess fieldAccess = this.allFieldArraysByMemAddr.get(clazz.fieldsPodAddr);
            if (fieldAccess == null) continue;
            Class.access$702(clazz, fieldAccess.fields);
        }
    }

    public static class Field {
        private String name;
        private int position;
        private int typeAddr;
        private int modifier;

        public final String getName() {
            return this.name;
        }

        public final int getPosition() {
            return this.position;
        }

        public final int getModifier() {
            return this.modifier;
        }

        public int getNrofBytesPrimitiveType() {
            return this.modifier >> 16 & 0xF;
        }

        public final int isInteger() {
            return this.bytesInteger();
        }

        public final int bytesInteger() {
            switch (this.typeAddr) {
                case 5: {
                    return 4;
                }
                case 7: {
                    return 2;
                }
                case 9: {
                    return 1;
                }
                case 11: {
                    return 4;
                }
                case 4: {
                    return -4;
                }
                case 6: {
                    return -2;
                }
                case 8: {
                    return -1;
                }
                case 10: {
                    return -4;
                }
                case 14: {
                    return -1;
                }
            }
            return 0;
        }

        public final boolean isFloat() {
            return this.typeAddr == 12;
        }

        public final boolean isDouble() {
            return this.typeAddr == 13;
        }

        public final boolean isBoolean() {
            return this.typeAddr == 15 || this.typeAddr == 15;
        }

        public String toString() {
            return this.name + ": typeAddr=" + Integer.toHexString(this.typeAddr);
        }
    }

    public static class FieldAccess {
        public int ownPodAddr;
        public Field[] fields;
    }

    public static class Class {
        private String name;
        private Field[] fields;
        private int ownPodAddr;
        private int fieldsPodAddr;

        public String getName() {
            return this.name;
        }

        public String getFieldNamesColonSeparated() {
            String string = "";
            for (Field field : this.fields) {
                string = string + field.getName() + "; ";
            }
            return string;
        }

        public Field[] getFields() {
            return this.fields;
        }

        static /* synthetic */ Field[] access$702(Class clazz, Field[] fieldArray) {
            clazz.fields = fieldArray;
            return fieldArray;
        }
    }
}

