package org.vishia.util;

/**This is a very simple class to store an Object reference with a name for example in a list
 * to give them a semantic.
 * @author hartmut Schorrig www.vishia.org
 *
 */
public class NameObj {

  /**Version, history and license.
   * Changes:
   * <ul>
   * <li>2025-12-21 {@link #toString()} 
   * <li>2024-05-28 Hartmut: creation as Helper in {@link org.vishia.xmlReader.XmlJzReader}
   * </ul>
   * 
   * 
   * <b>Copyright/Copyleft</b>:
   * For this source the LGPL Lesser General Public License,
   * published by the Free Software Foundation is valid.
   * It means:
   * <ol>
   * <li> You can use this source without any restriction for any desired purpose.
   * <li> You can redistribute copies of this source to everybody.
   * <li> Every user of this source, also the user of redistribute copies
   *    with or without payment, must accept this license for further using.
   * <li> But the LPGL ist not appropriate for a whole software product,
   *    if this source is only a part of them. It means, the user
   *    must publish this part of source,
   *    but don't need to publish the whole source of the own product.
   * <li> You can study and modify (improve) this source
   *    for own using or for redistribution, but you have to license the
   *    modified sources likewise under this LGPL Lesser General Public License.
   *    You mustn't delete this Copyright/Copyleft inscription in this source file.
   * </ol>
   * If you are intent to use this sources without publishing its usage, you can get
   * a second license subscribing a special contract with the author. 
   * 
   * @author Hartmut Schorrig = hartmut.schorrig@vishia.de
   * 
   */
  public final static String version = "2025-12-21";

  
  public final String name;
  public final Object data;
  
  public NameObj(String name, Object data) {
    this.name = name;
    this.data = data;
  }
  
  @Override public String toString() {
    return this.name + ':' + this.data.toString();
  }
}
