/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlSimple;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Stack;
import org.vishia.charset.CodeCharset;
import org.vishia.util.StringFunctions;

public class XmlSequWriter {
    public static final String version = "2020-01-01";
    private Writer wr;
    private OutputStream fwr;
    private Appendable twr;
    private byte[] outBuffer;
    String sEncoding;
    Charset encoding;
    CodeCharset encoding2;
    boolean bFullEncoding;
    boolean bElementStart;
    int nColumn;
    int nColumnMax = 88;
    ElementInfo info;
    Stack<ElementInfo> tags = new Stack();
    int indent = 1;
    public boolean bTreeComment = true;
    private static String sIndent = "\n                                                                                ";
    private static String[] stdReplacement = new String[]{"&amp;", "&quot;", "&apos;", "&lt;", "&gt;", "&#x0a;", "&#x0d;", "&#x09;"};

    public void setEncoding(String string) throws IllegalCharsetNameException {
        if (string.startsWith("UTF-")) {
            this.encoding2 = null;
            this.encoding = Charset.forName(string);
        } else {
            this.encoding = null;
            this.encoding2 = CodeCharset.forName(string);
            if (this.encoding2 == null) {
                throw new IllegalCharsetNameException("Illegal encoding id: " + string);
            }
        }
        this.sEncoding = string;
    }

    public String open(File file, String string, Appendable appendable) throws IOException {
        this.twr = appendable;
        try {
            if (string != null) {
                this.setEncoding(string);
            } else if (this.sEncoding == null) {
                this.setEncoding("UTF-8");
            }
            if (file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.fwr = fileOutputStream;
                this.wr = this.encoding != null ? new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding) : null;
            }
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return "Encoding faulty: " + unsupportedCharsetException.getMessage();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "File not able to create: " + file.getAbsolutePath();
        }
    }

    public void close() throws IOException {
        while (this.info != null) {
            this.writeElementEnd();
        }
        this.wrNewline(0);
        if (this.wr != null) {
            this.wr.close();
            this.wr = null;
            this.fwr = null;
        } else if (this.fwr != null) {
            this.fwr.close();
            this.fwr = null;
            this.wr = null;
        }
        this.twr = null;
    }

    public void flush() throws IOException {
        if (this.wr != null) {
            this.wr.flush();
        } else if (this.fwr != null) {
            this.fwr.flush();
        }
    }

    public void setDebugTextOut(Appendable appendable) {
        this.twr = appendable;
    }

    private void writeHead() throws IOException {
        this.wrTxtAscii("<?xml version=\"1.0\" encoding=\"" + this.sEncoding + "\"?>\n");
    }

    public void writeComment() {
    }

    public void writeElement(String string) throws IOException {
        if (this.bElementStart) {
            this.writeElementHeadEnd(true);
        }
        if (this.info == null) {
            this.writeHead();
        } else {
            this.info.bIndented = true;
            this.wrNewline(1);
        }
        this.wrTxtAscii("<");
        this.wrTxt(string);
        if (this.info != null) {
            this.tags.push(this.info);
        }
        this.info = new ElementInfo(string);
        this.bElementStart = true;
        if ((this.indent += 2) > sIndent.length()) {
            this.indent = sIndent.length();
        }
    }

    private void wrNewline(int n) throws IOException {
        this.wrTxtAscii(sIndent.substring(0, this.indent));
        this.nColumn = this.indent;
    }

    public void writeElementHeadEnd(boolean bl) throws IOException {
        if (!this.bElementStart) {
            throw new IllegalStateException("not in writing head");
        }
        this.bElementStart = false;
        this.wrTxtAscii(">");
        this.info.bIndented = bl;
    }

    public void writeElementEnd() throws IOException {
        if ((this.indent -= 2) < 1) {
            this.indent = 1;
        }
        if (this.bElementStart) {
            this.wrTxtAscii("/");
            this.writeElementHeadEnd(true);
            this.info.bIndented = true;
            this.bElementStart = false;
        } else {
            if (this.info.bIndented) {
                this.wrNewline(-1);
            }
            this.wrTxtAscii("</");
            this.wrTxt(this.info.sTag);
            this.wrTxtAscii(">");
            if (this.bTreeComment) {
                this.wrTxtAscii("<!--");
                for (ElementInfo elementInfo : this.tags) {
                    this.wrTxtAscii(elementInfo.sTag);
                    this.wrTxtAscii(" = ");
                }
                this.wrTxtAscii("-->");
            }
        }
        this.info = this.tags.size() > 0 ? this.tags.pop() : null;
    }

    public void writeAttribute(String string, String string2) throws IOException {
        if (!this.bElementStart) {
            throw new IllegalStateException("should be written not after content");
        }
        this.wrTxtAscii(" ");
        this.wrTxt(string);
        this.wrTxtAscii("=\"");
        this.wrTxt(string2);
        this.wrTxtAscii("\"");
    }

    public void writeText(CharSequence charSequence, boolean bl) throws IOException {
        if (this.bElementStart) {
            this.writeElementHeadEnd(true);
        }
        this.info.bIndented = bl;
        if (this.info.bIndented) {
            this.wrNewline(0);
        }
        this.wrTxt(charSequence);
    }

    private void wrTxt(CharSequence charSequence) throws IOException {
        int n;
        CharSequence charSequence2 = charSequence == null ? "?null?" : charSequence;
        int n2 = 0;
        int n3 = charSequence2.length();
        int[] nArray = new int[1];
        while ((n = StringFunctions.indexOfAnyChar(charSequence2, n2, n3, "&\"'<>\n\r\t", nArray)) >= 0) {
            if (n2 < n) {
                this.wrTxtEncoded(charSequence2.subSequence(n2, n));
            }
            this.wrTxtAscii(stdReplacement[nArray[0]]);
            n2 = n + 1;
        }
        if (n2 < n3) {
            this.wrTxtEncoded(charSequence2.subSequence(n2, n3));
        }
    }

    private void wrTxtEncoded(CharSequence charSequence) throws IOException {
        if (this.wr != null) {
            this.wr.write(charSequence.toString());
            if (this.twr != null) {
                this.twr.append(charSequence);
            }
        } else if (this.fwr != null) {
            assert (this.encoding2 != null);
            int n = charSequence.length();
            for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                int n2 = this.encoding2.getCode(c);
                if (n2 != 0) {
                    this.fwr.write(n2);
                    if (this.twr == null) continue;
                    this.twr.append(c);
                    continue;
                }
                String string = "&#x" + Integer.toHexString(c) + ";";
                this.wrTxtAscii(string);
            }
        } else if (this.twr != null) {
            this.twr.append(charSequence);
        }
    }

    private void wrTxtAscii(String string) throws IOException {
        if (this.twr != null) {
            this.twr.append(string);
        }
        if (this.wr != null) {
            this.wr.write(string);
        } else if (this.fwr != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                this.fwr.write((byte)string.charAt(i));
            }
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(stringArray.length == 0 ? "T:/" : stringArray[0]);
        StringBuilder stringBuilder = new StringBuilder();
        XmlSequWriter xmlSequWriter = new XmlSequWriter();
        xmlSequWriter.setEncoding("UTF-8");
        try {
            xmlSequWriter.testWritetree2(new File(file, "testWritetree2.xml"), stringBuilder);
            xmlSequWriter.testWritetree2t(new File(file, "testWritetree2t.xml"), stringBuilder);
            xmlSequWriter.testWritetree2at(new File(file, "testWritetree2at.xml"), stringBuilder);
            xmlSequWriter.testWriteEncodingFile(new File(file, "testWriteEncodingFile.xml"), stringBuilder);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private void testWritetree2(File file, StringBuilder stringBuilder) throws IOException {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>contentRoot\n  <child1/>\n</root>\n";
        stringBuilder.setLength(0);
        this.open(file, null, stringBuilder);
        this.writeElement("root");
        this.writeText("contentRoot", false);
        this.writeElement("child1");
        this.close();
        if (!string.equals(stringBuilder.toString())) {
            throw new IllegalArgumentException("faulty= testWriteTree");
        }
    }

    private void testWritetree2t(File file, StringBuilder stringBuilder) throws IOException {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n  contentRoot\n  <child1>contentChild</child1>\n</root>\n";
        stringBuilder.setLength(0);
        this.open(file, null, stringBuilder);
        this.writeElement("root");
        this.writeText("contentRoot", true);
        this.writeElement("child1");
        this.writeText("contentChild", false);
        this.close();
        if (!string.equals(stringBuilder.toString())) {
            throw new IllegalArgumentException("faulty= testWriteTree");
        }
    }

    private void testWritetree2at(File file, StringBuilder stringBuilder) throws IOException {
        String string = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?>\n<root>\n  contentRoot\n  <child1 attr=\"value\">\n    contentChild\n  </child1>\n</root>\n";
        stringBuilder.setLength(0);
        this.open(file, "US-ASCII", stringBuilder);
        this.writeElement("root");
        this.writeText("contentRoot", true);
        this.writeElement("child1");
        this.writeAttribute("attr", "value");
        this.writeText("contentChild", true);
        this.close();
        if (!string.equals(stringBuilder.toString())) {
            throw new IllegalArgumentException("faulty= testWriteTree");
        }
    }

    private void testWriteEncodingFile(File file, StringBuilder stringBuilder) throws IOException {
        String string = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?>\n<root>\n  contentRoot\n  <child1 attr=\"value\">contentChild &lt;&#xc4;&#xdc;&#xd6;&gt; special chars</child1>\n  <child2 attr2=\"text &#x20ac; special chars\"/>\n</root>\n";
        stringBuilder.setLength(0);
        this.setEncoding("US-ASCII");
        this.open(file, "US-ASCII", stringBuilder);
        this.writeElement("root");
        this.writeText("contentRoot", true);
        this.writeElement("child1");
        this.writeAttribute("attr", "value");
        this.writeText("contentChild <\ufffd\ufffd\ufffd> special chars", false);
        this.writeElementEnd();
        this.writeElement("child2");
        this.writeAttribute("attr2", "text \ufffd special chars");
        this.close();
        if (!string.equals(stringBuilder.toString())) {
            throw new IllegalArgumentException("faulty= testWriteTree");
        }
    }

    private class ElementInfo {
        String sTag;
        boolean bIndented;

        public ElementInfo(String string) {
            this.sTag = string;
        }
    }
}

