/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.util.Assert;
import org.vishia.util.IterableIterator;
import org.vishia.util.SortedTree;
import org.vishia.util.TreeNodeCallback;
import org.vishia.util.TreeNode_ifc;

public class TreeNodeBase<DerivedNode extends TreeNodeBase<DerivedNode, Data, IfcType>, Data, IfcType extends SortedTree<IfcType>>
implements TreeNode_ifc<DerivedNode, Data>,
SortedTree<IfcType>,
Iterable<DerivedNode> {
    public static final int version = 20131111;
    private static String metaNodeKey = "--metanode-key--";
    protected final String key;
    protected TreeNodeBase<DerivedNode, Data, IfcType> parent;
    protected DerivedNode prev;
    protected DerivedNode next;
    protected DerivedNode firstChild;
    protected DerivedNode lastChild;
    protected Map<String, TreeNodeBase<DerivedNode, Data, IfcType>> idxChildren;
    public List<Data> leafData;
    protected int nrofChildren;
    public final Data data;

    public TreeNodeBase(String string, Data Data2) {
        this.key = string;
        this.parent = null;
        this.data = Data2;
    }

    protected TreeNodeBase(String string, Data Data2, TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase) {
        this.key = string;
        this.parent = treeNodeBase;
        this.data = Data2;
    }

    protected DerivedNode newNode(String string, Data Data2) {
        throw new IllegalArgumentException("This method has to be overridden.");
    }

    @Deprecated
    public void addLeaf(Data Data2) {
        if (this.leafData == null) {
            this.leafData = new ArrayList<Data>();
        }
        this.leafData.add(Data2);
    }

    @Override
    public DerivedNode addNode(String string, Data Data2) {
        DerivedNode DerivedNode = this.newNode(string, Data2);
        this.addNode(DerivedNode);
        return DerivedNode;
    }

    @Override
    public void addNode(DerivedNode DerivedNode) {
        if (((TreeNodeBase)DerivedNode).parent != null || ((TreeNodeBase)DerivedNode).next != null || ((TreeNodeBase)DerivedNode).prev != null) {
            throw new IllegalArgumentException("Node has a parent, it is contained anywhere other, invoke detach!");
        }
        this.addNodeKeyed(DerivedNode, null);
        ++this.nrofChildren;
        if (this.firstChild == null) {
            this.lastChild = DerivedNode;
            this.firstChild = this.lastChild;
        } else {
            ((TreeNodeBase)this.lastChild).next = DerivedNode;
            ((TreeNodeBase)DerivedNode).prev = this.lastChild;
            this.lastChild = DerivedNode;
        }
    }

    @Override
    public void addNodeFirst(DerivedNode DerivedNode) {
        if (((TreeNodeBase)DerivedNode).parent != null) {
            throw new IllegalArgumentException("Node has a parent, it is contained anywhere other, invoke detach!");
        }
        this.addNodeKeyed(DerivedNode, null);
        ++this.nrofChildren;
        ((TreeNodeBase)DerivedNode).next = this.firstChild;
        if (this.firstChild != null) {
            ((TreeNodeBase)this.firstChild).prev = DerivedNode;
        }
        this.firstChild = DerivedNode;
        if (this.lastChild == null) {
            this.lastChild = DerivedNode;
        }
    }

    @Override
    public void addSiblingNext(DerivedNode DerivedNode) {
        if (((TreeNodeBase)DerivedNode).parent != null) {
            throw new IllegalArgumentException("TreeNodeBase.add - new Node has a parent; It is contained anywhere other, invoke detach;" + DerivedNode);
        }
        TreeNodeBase treeNodeBase = this;
        TreeNode_ifc treeNode_ifc = this.parent();
        if (treeNode_ifc == null) {
            throw new IllegalArgumentException("TreeNodeBase.addSiblingNext - this Node has not a parent;" + this.parent);
        }
        super.addNodeKeyed(DerivedNode, null);
        ++((TreeNodeBase)treeNode_ifc).nrofChildren;
        ((TreeNodeBase)DerivedNode).prev = treeNodeBase;
        ((TreeNodeBase)DerivedNode).next = this.next;
        if (this.next != null) {
            ((TreeNodeBase)this.next).prev = DerivedNode;
        }
        this.next = DerivedNode;
        if (this.parent.lastChild == this) {
            this.parent.lastChild = DerivedNode;
        }
    }

    public void addSiblingPrev(DerivedNode DerivedNode) {
        if (((TreeNodeBase)DerivedNode).parent != null) {
            throw new IllegalArgumentException("TreeNodeBase.add - new Node has a parent; It is contained anywhere other, invoke detach;" + DerivedNode);
        }
        TreeNodeBase treeNodeBase = this;
        TreeNode_ifc treeNode_ifc = this.parent();
        if (treeNode_ifc == null) {
            throw new IllegalArgumentException("TreeNodeBase.addSiblingNext - this Node has not a parent;" + this.parent);
        }
        super.addNodeKeyed(DerivedNode, null);
        ++((TreeNodeBase)treeNode_ifc).nrofChildren;
        ((TreeNodeBase)DerivedNode).next = treeNodeBase;
        ((TreeNodeBase)DerivedNode).prev = this.prev;
        if (this.prev != null) {
            ((TreeNodeBase)this.prev).next = DerivedNode;
        }
        this.prev = DerivedNode;
        if (this.parent.firstChild == this) {
            this.parent.firstChild = DerivedNode;
        }
    }

    private void addNodeKeyed(DerivedNode DerivedNode, TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase) {
        TreeNodeBase treeNodeBase2 = this;
        if (((TreeNodeBase)DerivedNode).key == null) {
            ((TreeNodeBase)DerivedNode).parent = treeNodeBase2;
        } else {
            TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase3;
            if (this.idxChildren == null) {
                this.idxChildren = new TreeMap<String, TreeNodeBase<DerivedNode, Data, IfcType>>();
            }
            if ((treeNodeBase3 = this.idxChildren.get(((TreeNodeBase)DerivedNode).key)) == null) {
                ((TreeNodeBase)DerivedNode).parent = treeNodeBase2;
                this.idxChildren.put(((TreeNodeBase)DerivedNode).key, (TreeNodeBase<DerivedNode, Data, IfcType>)DerivedNode);
            } else {
                MetaNode metaNode;
                if (treeNodeBase3.key == metaNodeKey) {
                    metaNode = (MetaNode)treeNodeBase3;
                } else {
                    metaNode = new MetaNode(this);
                    this.idxChildren.put(((TreeNodeBase)DerivedNode).key, metaNode);
                    treeNodeBase3.parent = metaNode;
                    TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase4 = treeNodeBase3;
                    metaNode.children.add(treeNodeBase4);
                }
                metaNode.children.add(DerivedNode);
                ((TreeNodeBase)DerivedNode).parent = metaNode;
            }
        }
    }

    public void swap(DerivedNode DerivedNode) {
    }

    public void movetoSiblingNext(DerivedNode DerivedNode) {
    }

    public void movetoSiblingPrev(DerivedNode DerivedNode) {
    }

    public void movetoFirstChild(DerivedNode DerivedNode) {
    }

    @Override
    public void detach() {
        TreeNode_ifc treeNode_ifc = this.parent();
        if (treeNode_ifc != null) {
            if (((TreeNodeBase)treeNode_ifc).firstChild == this) {
                ((TreeNodeBase)treeNode_ifc).firstChild = this.next;
            }
            if (((TreeNodeBase)treeNode_ifc).lastChild == this) {
                ((TreeNodeBase)treeNode_ifc).lastChild = this.prev;
            }
            if (this.parent.key == metaNodeKey) {
                MetaNode metaNode = (MetaNode)this.parent;
                metaNode.children.remove(this);
                if (metaNode.children.size() == 0) {
                    ((TreeNodeBase)treeNode_ifc).idxChildren.remove(this.key);
                }
            } else if (this.parent.idxChildren != null && this.key != null) {
                this.parent.idxChildren.remove(this.key);
            }
            --((TreeNodeBase)treeNode_ifc).nrofChildren;
            assert (((TreeNodeBase)treeNode_ifc).nrofChildren >= 0);
        }
        if (this.prev != null) {
            ((TreeNodeBase)this.prev).next = this.next;
        }
        if (this.next != null) {
            ((TreeNodeBase)this.next).prev = this.prev;
        }
        this.prev = null;
        this.next = null;
        this.parent = null;
    }

    @Override
    public void removeChildren() {
        while (this.firstChild != null) {
            ((TreeNodeBase)this.firstChild).detach();
        }
        if (this.nrofChildren != 0 || this.lastChild != null) {
            Assert.stop();
        }
        this.nrofChildren = 0;
        this.lastChild = null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Data getParentData() {
        TreeNode_ifc treeNode_ifc = this.parent();
        if (treeNode_ifc == null) {
            return null;
        }
        return ((TreeNodeBase)treeNode_ifc).data;
    }

    @Override
    public DerivedNode getNode(String string, String string2) {
        String[] stringArray = string2 != null ? string.split(string2) : new String[]{string};
        TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase = this;
        for (String string3 : stringArray) {
            if (treeNodeBase.idxChildren == null) {
                treeNodeBase = null;
                break;
            }
            TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase2 = treeNodeBase.idxChildren.get(string3);
            if (treeNodeBase2 == null) {
                treeNodeBase = null;
                break;
            }
            treeNodeBase = treeNodeBase2;
        }
        TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase3 = treeNodeBase;
        return (DerivedNode)treeNodeBase3;
    }

    @Override
    public DerivedNode getOrCreateNode(String string, String string2) {
        String[] stringArray = string.split(string2);
        TreeNodeBase<TreeNodeBase<DerivedNode, Object, IfcType>, Object, IfcType> treeNodeBase = this;
        for (String string3 : stringArray) {
            TreeNodeBase<TreeNodeBase<DerivedNode, Object, IfcType>, Object, IfcType> treeNodeBase2;
            if (treeNodeBase.idxChildren == null) {
                this.idxChildren = new TreeMap<String, TreeNodeBase<DerivedNode, Data, IfcType>>();
                treeNodeBase2 = this.newNode(string3, null);
                treeNodeBase.addNode(treeNodeBase2);
                treeNodeBase = treeNodeBase2;
                continue;
            }
            treeNodeBase2 = treeNodeBase.idxChildren.get(string3);
            if (treeNodeBase2 == null) {
                treeNodeBase2 = this.newNode(string3, null);
                treeNodeBase.addNode(treeNodeBase2);
                treeNodeBase = treeNodeBase2;
                continue;
            }
            treeNodeBase = treeNodeBase2;
        }
        return (DerivedNode)treeNodeBase;
    }

    @Override
    public IfcType getParent() {
        TreeNode_ifc treeNode_ifc = this.parent();
        return (IfcType)treeNode_ifc;
    }

    @Override
    public DerivedNode parent() {
        if (this.parent != null && this.parent.key == metaNodeKey) {
            TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase = this.parent.parent;
            return (DerivedNode)treeNodeBase;
        }
        TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase = this.parent;
        return (DerivedNode)treeNodeBase;
    }

    @Override
    public boolean parentEquals(TreeNode_ifc<DerivedNode, Data> treeNode_ifc) {
        if (this.parent != null && this.parent.key == metaNodeKey) {
            return this.parent.parent == treeNode_ifc;
        }
        return this.parent == treeNode_ifc;
    }

    @Override
    public DerivedNode nextSibling() {
        return this.next;
    }

    @Override
    public DerivedNode prevSibling() {
        DerivedNode DerivedNode = this.prev;
        return DerivedNode;
    }

    public List<DerivedNode> childNodes() {
        ArrayList<TreeNodeBase> arrayList = new ArrayList<TreeNodeBase>(this.nrofChildren);
        Iterator iterator = this.iterator().iterator();
        while (iterator.hasNext()) {
            TreeNodeBase treeNodeBase = (TreeNodeBase)iterator.next();
            arrayList.add(treeNodeBase);
        }
        return arrayList;
    }

    @Override
    public int nrofChildren() {
        return this.nrofChildren;
    }

    @Override
    public DerivedNode firstChild() {
        return this.firstChild;
    }

    @Override
    public boolean hasChildren() {
        return this.firstChild != null;
    }

    @Override
    public DerivedNode lastChild() {
        return this.lastChild;
    }

    @Override
    public IfcType getChild(String string) {
        MetaNode metaNode;
        if (this.idxChildren == null) {
            return null;
        }
        TreeNodeBase treeNodeBase = this.idxChildren.get(string);
        if (treeNodeBase != null && treeNodeBase.key == metaNodeKey) {
            metaNode = treeNodeBase;
            treeNodeBase = metaNode.children.size() >= 1 ? (TreeNodeBase)metaNode.children.get(0) : null;
        }
        metaNode = treeNodeBase;
        return (IfcType)metaNode;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public IterableIterator<DerivedNode> iterator() {
        return new IteratorDerivedNode();
    }

    @Override
    public IterableIterator<DerivedNode> iteratorChildren(String string) {
        TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase;
        if (this.idxChildren != null && (treeNodeBase = this.idxChildren.get(string)) != null) {
            if (treeNodeBase.key == metaNodeKey) {
                MetaNode metaNode = (MetaNode)treeNodeBase;
                return new IteratorMetaNode(metaNode);
            }
            TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase2 = treeNodeBase;
            return new IteratorOneNode(this, treeNodeBase2);
        }
        return null;
    }

    @Override
    public Iterator<IfcType> iterChildren() {
        IteratorImpl iteratorImpl = this.firstChild == null ? null : new IteratorImpl();
        return iteratorImpl;
    }

    @Override
    public IterableIterator<DerivedNode> iteratorChildren() {
        IteratorDerivedImpl iteratorDerivedImpl = this.firstChild == null ? null : new IteratorDerivedImpl();
        return iteratorDerivedImpl;
    }

    @Override
    public Iterator<IfcType> iterChildren(String string) {
        List<IfcType> list = this.listChildren(string);
        return list == null ? null : list.iterator();
    }

    @Override
    public List<IfcType> listChildren() {
        ArrayList<IfcType> arrayList;
        Iterator<IfcType> iterator = this.iterChildren();
        if (iterator != null) {
            arrayList = new ArrayList<IfcType>(this.nrofChildren);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    @Override
    public List<IfcType> listChildren(String string) {
        List<TreeNodeBase<DerivedNode, Data, IfcType>> list;
        if (this.idxChildren == null) {
            return null;
        }
        TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase = this.idxChildren.get(string);
        if (treeNodeBase == null) {
            return null;
        }
        if (treeNodeBase.key != metaNodeKey) {
            list = new ArrayList<TreeNodeBase<DerivedNode, Data, IfcType>>();
            list.add(treeNodeBase);
        } else {
            MetaNode metaNode = (MetaNode)treeNodeBase;
            list = metaNode.children;
        }
        return list;
    }

    public void walkTree(DerivedNode DerivedNode, int n, TreeNodeCallback<DerivedNode> treeNodeCallback) {
        treeNodeCallback.start();
        this.walkSubTree(DerivedNode, n, treeNodeCallback);
        treeNodeCallback.finished();
    }

    private TreeNodeCallback.Result walkSubTree(DerivedNode DerivedNode, int n, TreeNodeCallback<DerivedNode> treeNodeCallback) {
        TreeNodeCallback.Result result = TreeNodeCallback.Result.cont;
        result = treeNodeCallback.offerParent(DerivedNode);
        if (result == TreeNodeCallback.Result.cont) {
            Iterator iterator = this.iterator();
            while (result == TreeNodeCallback.Result.cont && iterator.hasNext()) {
                TreeNodeBase treeNodeBase = (TreeNodeBase)iterator.next();
                if (treeNodeBase.hasChildren()) {
                    if (n > 1) {
                        result = this.walkSubTree(DerivedNode, n - 1, treeNodeCallback);
                        continue;
                    }
                    result = treeNodeCallback.offerLeaf(DerivedNode);
                    continue;
                }
                result = treeNodeCallback.offerLeaf(DerivedNode);
            }
        }
        if (result != TreeNodeCallback.Result.terminate) {
            result = TreeNodeCallback.Result.cont;
        }
        return result;
    }

    public List<DerivedNode> getContainerChildren(String string) {
        if (this.idxChildren == null) {
            return null;
        }
        TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase = this.idxChildren.get(string);
        if (treeNodeBase == null) {
            return null;
        }
        if (treeNodeBase.key != metaNodeKey) {
            return null;
        }
        MetaNode metaNode = (MetaNode)treeNodeBase;
        List list = metaNode.children;
        return list;
    }

    protected List<DerivedNode> childNodes(TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase) {
        return treeNodeBase.childNodes();
    }

    public static final class TreeNode<Data>
    extends TreeNodeBase<TreeNode<Data>, Data, TreeNode<Data>> {
        public TreeNode(String string, Data Data2) {
            super(string, Data2);
        }

        @Override
        protected TreeNode<Data> newNode(String string, Data Data2) {
            return new TreeNode<Data>(string, Data2);
        }
    }

    protected static class IteratorOneNode
    implements IterableIterator<DerivedNode> {
        DerivedNode currentNode;
        boolean bNext = true;
        final /* synthetic */ TreeNodeBase this$0;

        protected IteratorOneNode(DerivedNode DerivedNode) {
            this.this$0 = var1_1;
            this.currentNode = DerivedNode;
        }

        @Override
        public boolean hasNext() {
            return this.bNext;
        }

        @Override
        public DerivedNode next() {
            this.bNext = false;
            return this.currentNode;
        }

        @Override
        public void remove() {
            if (this.currentNode == null) {
                throw new IllegalStateException("");
            }
            ((TreeNodeBase)this.currentNode).detach();
            this.currentNode = null;
        }

        @Override
        public Iterator<DerivedNode> iterator() {
            return this;
        }
    }

    protected class IteratorDerivedNode
    implements IterableIterator<DerivedNode> {
        DerivedNode currentNode = null;
        DerivedNode nextNode;

        protected IteratorDerivedNode() {
            this.nextNode = TreeNodeBase.this.firstChild;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public DerivedNode next() {
            this.currentNode = this.nextNode;
            this.nextNode = ((TreeNodeBase)this.nextNode).next;
            return this.currentNode;
        }

        @Override
        public void remove() {
            if (this.currentNode == null) {
                throw new IllegalStateException("");
            }
            ((TreeNodeBase)this.currentNode).detach();
            this.currentNode = null;
        }

        @Override
        public Iterator<DerivedNode> iterator() {
            return this;
        }
    }

    protected class IteratorDerivedImpl
    implements IterableIterator<DerivedNode> {
        DerivedNode currentNode = null;
        DerivedNode nextNode;

        protected IteratorDerivedImpl() {
            this.nextNode = TreeNodeBase.this.firstChild;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public DerivedNode next() {
            this.currentNode = this.nextNode;
            this.nextNode = ((TreeNodeBase)this.nextNode).next;
            Object DerivedNode = this.currentNode;
            return DerivedNode;
        }

        @Override
        public void remove() {
            if (this.currentNode == null) {
                throw new IllegalStateException("");
            }
            ((TreeNodeBase)this.currentNode).detach();
            this.currentNode = null;
        }

        @Override
        public Iterator<DerivedNode> iterator() {
            return this;
        }
    }

    protected class IteratorImpl
    implements Iterator<IfcType> {
        DerivedNode currentNode = null;
        DerivedNode nextNode;

        protected IteratorImpl() {
            this.nextNode = TreeNodeBase.this.firstChild;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public IfcType next() {
            this.currentNode = this.nextNode;
            this.nextNode = ((TreeNodeBase)this.nextNode).next;
            Object DerivedNode = this.currentNode;
            return DerivedNode;
        }

        @Override
        public void remove() {
            if (this.currentNode == null) {
                throw new IllegalStateException("");
            }
            ((TreeNodeBase)this.currentNode).detach();
            this.currentNode = null;
        }
    }

    protected class IteratorMetaNode
    implements IterableIterator<DerivedNode> {
        MetaNode<DerivedNode, Data, IfcType> metaNode;
        DerivedNode currentNode;
        Iterator<DerivedNode> iter;

        protected IteratorMetaNode(MetaNode<DerivedNode, Data, IfcType> metaNode) {
            this.metaNode = metaNode;
            this.iter = metaNode.children.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public DerivedNode next() {
            this.currentNode = (TreeNodeBase)this.iter.next();
            return this.currentNode;
        }

        @Override
        public void remove() {
            if (this.currentNode == null) {
                throw new IllegalStateException("");
            }
            this.iter.remove();
            ((TreeNodeBase)this.currentNode).detach();
            if (this.metaNode.children.size() == 0) {
                ((TreeNodeBase)this.metaNode.parent()).idxChildren.remove(((TreeNodeBase)this.currentNode).key);
            }
            this.currentNode = null;
        }

        @Override
        public Iterator<DerivedNode> iterator() {
            return this;
        }
    }

    protected static class MetaNode<DerivedNode extends TreeNodeBase<DerivedNode, Data, IfcType>, Data, IfcType extends SortedTree<IfcType>>
    extends TreeNodeBase<DerivedNode, Data, IfcType> {
        protected List<DerivedNode> children = new ArrayList<DerivedNode>();

        public MetaNode(TreeNodeBase<DerivedNode, Data, IfcType> treeNodeBase) {
            super(metaNodeKey, null, treeNodeBase);
        }
    }
}

