/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.IOException;
import org.vishia.util.CheckVs;
import org.vishia.util.StringFunctions;

public class TestOrg {
    private boolean bOk = true;
    private final String title;
    private boolean bTitleShown = false;
    private final int nTestVerboseLevel;
    private final int nVerboseTitle;
    private Appendable out;
    private final TestOrg parent;

    public TestOrg(String string, int n, String[] stringArray) {
        this(string, n, stringArray, System.out);
    }

    public TestOrg(String string, int n, String[] stringArray, Appendable appendable) {
        this.title = string;
        this.nVerboseTitle = n;
        int n2 = 0;
        for (String string2 : stringArray) {
            if (!string2.startsWith("---TESTverbose:")) continue;
            n2 = string2.charAt(15) - 48;
        }
        this.nTestVerboseLevel = n2;
        this.parent = null;
        this.out = appendable;
    }

    public TestOrg(String string, int n, TestOrg testOrg) {
        this.title = string;
        this.nVerboseTitle = n;
        this.nTestVerboseLevel = testOrg.nTestVerboseLevel;
        this.parent = testOrg;
        this.out = testOrg.out;
    }

    public void expect(CharSequence charSequence, CharSequence charSequence2, int n, String string) {
        int n2 = StringFunctions.comparePos(charSequence, charSequence2);
        String string2 = n2 != 0 ? "@ " + Math.abs(n2) + ": " + string : string;
        this.expect_(n2 == 0, n, string2, 3);
    }

    public void expect(boolean bl, int n, String string) {
        this.expect_(bl, n, string, 3);
    }

    private void expect_(boolean bl, int n, String string, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = n <= this.nTestVerboseLevel;
        if (!bl || bl2 && !this.bTitleShown) {
            this.showParentTitle(null);
        }
        if (bl) {
            if (bl2) {
                this.out("  ok: ");
                this.outln(string);
            }
        } else {
            TestOrg testOrg = this;
            while (testOrg != null) {
                testOrg.bOk = false;
                testOrg = testOrg.parent;
            }
            CharSequence charSequence = CheckVs.stackInfo("", n2, 3);
            this.out("  ERROR: ");
            this.out(string);
            this.out(" @ ");
            this.out(charSequence);
        }
    }

    private void showParentTitle(String string) {
        if (!this.bTitleShown) {
            if (this.parent != null) {
                this.parent.showParentTitle(string);
            } else {
                this.outln("=========================================================================");
            }
            if (string != null) {
                this.out(string);
            }
            this.outln(this.title);
            this.bTitleShown = true;
        }
    }

    public void exception(Exception exception) {
        TestOrg testOrg = this;
        while (testOrg != null) {
            testOrg.bOk = false;
            testOrg = testOrg.parent;
        }
        this.showParentTitle(null);
        CharSequence charSequence = CheckVs.exceptionInfo("  Exception: ", exception, 0, 5);
        this.out(charSequence);
    }

    public void finish() {
        if (this.bOk && this.nVerboseTitle <= this.nTestVerboseLevel) {
            this.showParentTitle("ok ");
        }
    }

    public boolean isOk() {
        return this.bOk;
    }

    public void out(CharSequence charSequence) {
        try {
            this.out.append(charSequence);
        }
        catch (IOException iOException) {
            System.err.append(charSequence);
        }
    }

    public void outln(CharSequence charSequence) {
        try {
            this.out.append(charSequence).append('\n');
        }
        catch (IOException iOException) {
            System.err.append("Exception on TestOrg.out / ").append(charSequence);
        }
    }
}

