/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.IOException;
import java.text.ParseException;
import org.vishia.util.Java4C;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;
import org.vishia.util.StringPart;

public class StringPartScan
extends StringPart {
    public static final String sVersion = "2019-06-13";
    protected int beginScan;
    protected int beginScanLast;
    protected final long[] nLastIntegerNumber = new long[5];
    protected final boolean[] nLastIntegerSign = new boolean[5];
    private int ixLastIntegerNumber = -1;
    protected final double[] nLastFloatNumber = new double[5];
    private int ixLastFloatNumber = -1;
    @Java4C.SimpleArray
    protected final StringPart.Part[] sLastString = new StringPart.Part[5];
    private int ixLastString = -1;

    public StringPartScan(CharSequence charSequence, int n, int n2) {
        super(charSequence, n, n2);
        for (int i = 0; i < this.sLastString.length; ++i) {
            this.sLastString[i] = new StringPart.Part(this, 0, 0);
        }
    }

    public StringPartScan(CharSequence charSequence) {
        super(charSequence);
        for (int i = 0; i < this.sLastString.length; ++i) {
            this.sLastString[i] = new StringPart.Part(this, 0, 0);
        }
    }

    public StringPartScan() {
        for (int i = 0; i < this.sLastString.length; ++i) {
            this.sLastString[i] = new StringPart.Part(this, 0, 0);
        }
    }

    public StringPartScan seekScanPos(int n) {
        super.seekPos(n);
        return this;
    }

    public final StringPartScan scanSkipSpace() {
        if (this.scanEntry()) {
            this.seekNoWhitespace();
        }
        return this;
    }

    public final StringPartScan scanSkipComment() {
        if (this.scanEntry()) {
            this.seekNoWhitespaceOrComments();
        }
        return this;
    }

    public final StringPartScan scanStart(boolean bl) {
        this.setIgnoreWhitespaces(bl);
        this.bCurrentOk = true;
        this.scanOk();
        return this;
    }

    public final StringPartScan scanStart() {
        this.bCurrentOk = true;
        this.scanOk();
        return this;
    }

    @Override
    @Java4C.Retinline
    public final StringPartScan scan() {
        return this.scanStart();
    }

    private final boolean scanEntry() {
        if (this.bCurrentOk) {
            this.seekNoWhitespaceOrComments();
            if (this.bStartScan) {
                this.ixLastIntegerNumber = -1;
                this.ixLastFloatNumber = -1;
                this.ixLastString = -1;
                this.bStartScan = false;
            }
            if (this.begin >= this.end) {
                this.bCurrentOk = false;
            }
        }
        return this.bCurrentOk;
    }

    public final boolean scanOk() {
        if (this.bCurrentOk) {
            this.beginScanLast = this.beginScan;
            this.beginScan = this.beginLast = this.begin;
        } else {
            this.begin = this.beginLast = this.beginScan;
        }
        this.bStartScan = true;
        boolean bl = this.bCurrentOk;
        this.bCurrentOk = true;
        return bl;
    }

    public final StringPartScan scanChar(char c) {
        if (this.scanEntry()) {
            if (this.begin + 1 < this.endMax) {
                char c2 = this.content.charAt(this.begin);
                if (c2 == c) {
                    ++this.begin;
                } else {
                    this.bCurrentOk = false;
                }
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    public final StringPartScan scan(CharSequence charSequence) {
        char c;
        if ((charSequence.charAt(0) == '\u0003' || charSequence.length() == 2 && charSequence.charAt(0) == '\\' && ((c = charSequence.charAt(1)) == 'Z' || c == 'z')) && this.begin == this.end) {
            return this;
        }
        if (this.scanEntry()) {
            char c2;
            CharSequence charSequence2;
            boolean bl;
            int n = StringFunctions.indexOf(charSequence, '\u0003', 0);
            int n2 = StringFunctions.indexOf(charSequence, '\u0004', 0);
            boolean bl2 = n2 >= 0;
            boolean bl3 = bl = n >= 0;
            if (bl2) {
                charSequence2 = charSequence.subSequence(0, n2);
                n = n2;
            } else if (bl) {
                charSequence2 = charSequence.subSequence(0, n);
            } else {
                n = charSequence.length();
                charSequence2 = charSequence;
                if (n >= 2 && charSequence.charAt(n - 2) == '\\' && "WZz".indexOf(c = charSequence.charAt(n)) >= 0) {
                    charSequence2 = charSequence2.subSequence(0, n -= 2);
                    bl2 = c == 'W';
                    boolean bl4 = bl = !bl2;
                }
            }
            if (this.begin + n <= this.endMax && StringFunctions.equals(this.content, this.begin, this.begin + n, charSequence2) && (bl ? this.begin + n == this.end : !(bl2 && this.begin + n != this.end && ((c2 = this.content.charAt(this.begin + n)) == '_' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')))) {
                this.begin += n;
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    public final StringPartScan scanQuotion(CharSequence charSequence, String string, String[] stringArray) {
        return this.scanQuotion(charSequence, string, stringArray, Integer.MAX_VALUE);
    }

    public final StringPartScan scanQuotion(CharSequence charSequence, String string, String[] stringArray, int n) {
        if (this.scanEntry()) {
            this.scan(charSequence).lentoNonEscapedString(string, n);
            if (this.bCurrentOk) {
                if (stringArray != null) {
                    stringArray[0] = this.getCurrentPart().toString();
                } else {
                    this.setCurrentPartTo(this.sLastString[++this.ixLastString]);
                }
                this.fromEnd().seekPos(string.length());
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    public StringPartScan scanLiteral(String string, int n) {
        if (this.scanEntry()) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            char c3 = string.length() > 2 ? string.charAt(2) : (char)'\u0000';
            int n2 = this.end - this.begin;
            if (n >= 0 && n2 > n) {
                n2 = n;
            }
            if (this.scanEntry() && this.getCurrentChar() == c) {
                int n3 = this.indexEndOfQuotation(c2, c3, 0, n2);
                if (n3 >= 0) {
                    this.sLastString[++this.ixLastString].setPart(this.begin + 1, this.begin + n3 - 1);
                    this.begin += n3;
                } else {
                    this.bCurrentOk = false;
                }
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final StringPartScan scanDigits(int n, int n2, String string) throws ParseException {
        if (!this.scanEntry()) return this;
        int n3 = this.end - this.begin;
        if (n2 >= 0 && n2 < n3) {
            n3 = n2;
        }
        int[] nArray = new int[1];
        long l = StringFunctions_C.parseUlong(this.content, this.begin, n3, n, nArray, string);
        if (nArray[0] > 0) {
            this.begin += nArray[0];
            if (this.ixLastIntegerNumber >= this.nLastIntegerNumber.length - 2) throw new ParseException("to much scanned integers", 0);
            this.nLastIntegerNumber[++this.ixLastIntegerNumber] = l;
            this.nLastIntegerSign[this.ixLastIntegerNumber] = false;
            return this;
        } else {
            this.bCurrentOk = false;
        }
        return this;
    }

    public final StringPartScan scanPositivInteger() throws ParseException {
        return this.scanDigits(10, Integer.MAX_VALUE, null);
    }

    public final StringPartScan scanInteger() throws ParseException {
        return this.scanInteger(null);
    }

    public final StringPartScan scanInteger(String string) throws ParseException {
        if (this.scanEntry()) {
            boolean bl = false;
            int n = this.begin;
            char c = this.content.charAt(this.begin);
            if (c == '-') {
                bl = true;
                ++this.begin;
            } else if (c == '+') {
                ++this.begin;
            }
            if (this.scanDigits((int)10, (int)Integer.MAX_VALUE, (String)string).bCurrentOk) {
                this.nLastIntegerSign[this.ixLastIntegerNumber] = bl;
                if (bl) {
                    this.nLastIntegerNumber[this.ixLastIntegerNumber] = -this.nLastIntegerNumber[this.ixLastIntegerNumber];
                }
            } else if (bl) {
                this.begin = n;
            }
        }
        return this;
    }

    public final StringPartScan scanFloatNumber(boolean bl) throws ParseException {
        if (bl) {
            this.ixLastFloatNumber = -1;
        }
        this.scanFloatNumber();
        return this;
    }

    public final StringPartScan scanFloatNumber() throws ParseException {
        return this.scanFloatNumber('.', false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final StringPartScan scanFloatNumber(char c, boolean bl, String string) throws ParseException {
        if (!this.scanEntry()) return this;
        int n = this.begin;
        if (this.scanInteger((String)string).bCurrentOk) {
            long l = this.nLastIntegerNumber[this.ixLastIntegerNumber];
            boolean bl2 = this.nLastIntegerSign[this.ixLastIntegerNumber];
            --this.ixLastIntegerNumber;
            this.scanFractionalExponent(c, bl, string, l, bl2);
            if (this.bCurrentOk) return this;
            if (bl) {
                this.begin = n;
                return this;
            } else {
                this.bCurrentOk = true;
                if (this.ixLastFloatNumber >= this.nLastFloatNumber.length - 2) throw new ParseException("to much scanned floats", 0);
                this.nLastFloatNumber[++this.ixLastFloatNumber] = l;
            }
            return this;
        } else {
            this.begin = n;
        }
        return this;
    }

    public final StringPartScan scanFractionalNumber(long l, boolean bl) throws ParseException {
        return this.scanFractionalExponent('.', false, null, l, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final StringPartScan scanFractionalExponent(char c, boolean bl, String string, long l, boolean bl2) throws ParseException {
        int n;
        char c2;
        if (!this.scanEntry()) return this;
        int n2 = this.bitMode;
        this.bitMode &= 0xFFFFFFF8;
        long l2 = 0L;
        int n3 = 1;
        int n4 = 0;
        boolean bl3 = false;
        int n5 = this.begin;
        if (this.begin < this.endMax && this.content.charAt(this.begin) == c) {
            this.seekPos(1);
            while (this.begin < this.endMax && ((c2 = this.getCurrentChar()) == '0' || string != null && string.indexOf(c2) >= 0)) {
                this.seekPos(1);
                if (c2 != '0') continue;
                n3 *= 10;
            }
            if (this.scanDigits((int)10, (int)Integer.MAX_VALUE, (String)string).bCurrentOk) {
                l2 = this.nLastIntegerNumber[this.ixLastIntegerNumber];
                --this.ixLastIntegerNumber;
            } else {
                l2 = 0L;
                this.bCurrentOk = true;
            }
        }
        if ((n = this.begin) < this.endMax && ((c2 = this.content.charAt(this.begin)) == 'e' || c2 == 'E')) {
            this.seekPos(1);
            if (this.scanInteger().bCurrentOk) {
                n4 = (int)this.nLastIntegerNumber[this.ixLastIntegerNumber];
                --this.ixLastIntegerNumber;
            } else {
                this.begin = n;
                n4 = 0;
            }
        }
        if (this.bCurrentOk && this.begin > n5) {
            double d = l;
            if (l2 > 0L) {
                double d2;
                for (d2 = (double)l2; d2 >= 1.0; d2 /= 10.0) {
                }
                d2 /= (double)n3;
                if (d < 0.0 || bl2) {
                    d2 = -d2;
                }
                d += d2;
            }
            if (n4 != 0) {
                if (bl3) {
                    n4 = -n4;
                }
                d *= Math.pow(10.0, n4);
            }
            if (this.ixLastFloatNumber >= this.nLastFloatNumber.length - 2) throw new ParseException("to much scanned floats", 0);
            this.nLastFloatNumber[++this.ixLastFloatNumber] = d;
        } else {
            this.bCurrentOk = false;
            this.begin = n5;
        }
        this.bitMode = n2;
        return this;
    }

    public final StringPartScan scanHex(int n) throws ParseException {
        return this.scanDigits(16, n, null);
    }

    public final StringPartScan scanHexOrDecimal(int n) throws ParseException {
        if (this.scanEntry()) {
            int n2 = this.begin;
            if (StringFunctions.equals(this.content, this.begin, this.begin + 2, "0x")) {
                this.seek(2);
                this.scanDigits(16, n, null);
            } else {
                this.scanDigits(10, n, null);
            }
            if (!this.bCurrentOk) {
                this.begin = n2;
            }
        }
        return this;
    }

    public final StringPartScan scanIdentifier() {
        return this.scanIdentifier(null, null);
    }

    public final StringPartScan scanIdentifier(String string, String string2) {
        if (this.scanEntry()) {
            this.lentoIdentifier(string, string2);
            if (this.bFound) {
                this.setCurrentPartTo(this.sLastString[++this.ixLastString]);
                this.begin = this.end;
            } else {
                this.bCurrentOk = false;
            }
            this.end = this.endLast;
        }
        return this;
    }

    public final boolean getLastScannedIntegerSign() throws ParseException {
        if (this.ixLastIntegerNumber >= 0) {
            return this.nLastIntegerSign[this.ixLastIntegerNumber];
        }
        throw new ParseException("no integer number scanned.", 0);
    }

    public final long getLastScannedIntegerNumber() throws ParseException {
        if (this.ixLastIntegerNumber >= 0) {
            return this.nLastIntegerNumber[this.ixLastIntegerNumber--];
        }
        throw new ParseException("no integer number scanned.", 0);
    }

    public final double getLastScannedFloatNumber() throws ParseException {
        if (this.ixLastFloatNumber >= 0) {
            return this.nLastFloatNumber[this.ixLastFloatNumber--];
        }
        throw new ParseException("no float number scanned.", 0);
    }

    public final String getLastScannedString() {
        return this.sLastString[this.ixLastString--].toString();
    }

    public final StringPart.Part getLastScannedPart(int n) {
        return this.sLastString[this.ixLastString--];
    }

    public final CharSequence getLastScannedPart() {
        int n = this.beginScan - this.beginScanLast;
        if (n <= 0) {
            return "";
        }
        return new StringPart.Part(this, this.beginScanLast, this.beginScan);
    }

    @Java4C.Exclude
    public final CharSequence getCircumScriptionToAnyChar(String string) {
        return this.getCircumScriptionToAnyChar_p(string, false);
    }

    @Java4C.Exclude
    public final CharSequence getCircumScriptionToAnyCharOutsideQuotion(String string) {
        return this.getCircumScriptionToAnyChar_p(string, true);
    }

    @Java4C.Exclude
    private final CharSequence getCircumScriptionToAnyChar_p(String string, boolean bl) {
        char c = bl ? (char)'\"' : '\u0000';
        int n = this.indexOfAnyChar(string, 0, this.end - this.begin, '\\', c, c);
        if (n >= 0) {
            this.lentoPos(n);
            CharSequence charSequence = StringFunctions.convertTransliteration(this.getCurrentPart(), '\\');
            this.fromEnd();
            return charSequence;
        }
        return "";
    }

    @Java4C.Exclude
    public final StringPartScan scanToAnyChar(CharSequence[] charSequenceArray, String string, char c, char c2, char c3) {
        if (this.scanEntry()) {
            int n = this.indexOfAnyChar(string, 0, this.end - this.begin, c, c2, c3);
            if (n >= 0) {
                this.lentoPos(n);
                if (charSequenceArray != null) {
                    charSequenceArray[0] = StringFunctions.convertTransliteration(this.getCurrentPart(), c);
                }
                this.fromEnd();
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    public final StringPartScan scanToAnyChar(String string, char c, char c2, char c3) {
        if (this.scanEntry()) {
            int n = this.indexOfAnyChar(string, 0, this.end - this.begin, c, c2, c3);
            if (n >= 0) {
                this.lentoPos(n);
                this.setCurrentPartTo(this.sLastString[++this.ixLastString]);
                this.fromEnd();
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    public boolean readNextContent(int n) throws IOException {
        return true;
    }

    @Override
    public void close() {
        super.close();
        this.beginScan = 0;
        this.bFound = false;
        this.bCurrentOk = false;
    }
}

