/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.reflect;

import java.lang.reflect.Field;
import org.vishia.bridgeC.MemSegmJc;
import org.vishia.byteData.VariableAccessArray_ifc;
import org.vishia.reflect.ClassJc;
import org.vishia.reflect.FieldJc;

public class FieldJcVariableAccess
implements VariableAccessArray_ifc {
    public static final int version = 20120422;
    final FieldJc theField;
    long timeLastRefreshed;
    long timeRequestRefresh;
    MemSegmJc instance;
    int nrofArrayElements;

    public FieldJcVariableAccess(Object object, Field field) {
        field.setAccessible(true);
        this.theField = new FieldJc(field);
        this.instance = new MemSegmJc(object, 0);
    }

    @Override
    public int getInt(int ... nArray) {
        int n;
        try {
            n = this.theField.getInt(this.instance, nArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return n;
    }

    @Override
    public long getLong(int ... nArray) {
        long l;
        try {
            l = this.theField.getLong(this.instance, nArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return l;
    }

    @Override
    public float getFloat(int ... nArray) {
        float f;
        try {
            f = this.theField.getFloat(this.instance, nArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return f;
    }

    @Override
    public float setFloat(float f, int ... nArray) {
        try {
            f = this.theField.setFloat(this.instance, f, nArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return f;
    }

    @Override
    public double getDouble(int ... nArray) {
        double d;
        try {
            d = this.theField.getDouble(this.instance, nArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return d;
    }

    @Override
    public double setDouble(double d, int ... nArray) {
        return d;
    }

    @Override
    public String getString(int ... nArray) {
        String string;
        ClassJc classJc = this.theField.getType();
        Class<?> clazz = classJc.getClazz();
        try {
            if (clazz.isPrimitive()) {
                String string2 = clazz.getName();
                char c = string2.charAt(0);
                if ("bsi".indexOf(c) >= 0) {
                    int n = this.getInt(nArray);
                    string = Integer.toString(n);
                } else if ("l".indexOf(c) >= 0) {
                    long l = this.getLong(nArray);
                    string = Long.toString(l);
                } else if ("fd".indexOf(c) >= 0) {
                    String string3;
                    double d = this.getDouble(nArray);
                    if (d < 1.0 && d > -1.0) {
                        string3 = "%1.5f";
                    } else if (d < 100.0 && d > -100.0) {
                        string3 = "% 2.3f";
                    } else if (d < 10000.0 && d > -10000.0) {
                        string3 = "% 4.1f";
                    } else if (d < 100000.0 && d > -100000.0) {
                        d /= 1000.0;
                        string3 = "% 2.3f k";
                    } else {
                        string3 = "%3.3g";
                    }
                    string = String.format(string3, d);
                } else {
                    string = "TT";
                }
            } else {
                MemSegmJc memSegmJc = this.theField.get(this.instance, new int[0]);
                string = memSegmJc == null ? "null" : memSegmJc.toString();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return string;
    }

    @Override
    public int setInt(int n, int ... nArray) {
        return 0;
    }

    @Override
    public long setLong(long l, int ... nArray) {
        return 0L;
    }

    @Override
    public String setString(String string, int ... nArray) {
        return null;
    }

    @Override
    public char getType() {
        return this.theField.getTypeChar();
    }

    @Override
    public int getDimension(int n) {
        return 0;
    }

    @Override
    public void requestValue(long l) {
        this.timeRequestRefresh = l;
    }

    @Override
    public void requestValue() {
        this.requestValue(System.currentTimeMillis());
    }

    @Override
    public void requestValue(long l, Runnable runnable) {
        this.timeRequestRefresh = l;
    }

    @Override
    public boolean isRequestedValue(long l, boolean bl) {
        if (this.timeRequestRefresh == 0L) {
            return false;
        }
        long l2 = this.timeRequestRefresh - this.timeLastRefreshed;
        long l3 = this.timeRequestRefresh - l;
        return (this.timeLastRefreshed == 0L || l2 >= 0L) && l3 >= 0L;
    }

    @Override
    public boolean isRefreshed() {
        return this.timeLastRefreshed != 0L && this.timeLastRefreshed - this.timeRequestRefresh >= 0L;
    }

    @Override
    public long getLastRefreshTime() {
        return this.timeLastRefreshed;
    }

    @Override
    public void setRefreshed(long l) {
        this.timeLastRefreshed = l;
    }

    public long getTimeRequestRefresh() {
        return this.timeRequestRefresh;
    }

    @Override
    public double getDouble() {
        return this.getDouble(0);
    }

    @Override
    public float getFloat() {
        return this.getFloat(0);
    }

    @Override
    public int getInt() {
        return this.getInt(0);
    }

    @Override
    public long getLong() {
        return this.getLong(0);
    }

    @Override
    public String getString() {
        return this.getString(0);
    }

    @Override
    public double setDouble(double d) {
        return this.setDouble(d, 0);
    }

    @Override
    public float setFloat(float f) {
        return this.setFloat(f, 0);
    }

    @Override
    public int setInt(int n) {
        return this.setInt(n, 0);
    }

    @Override
    public long setLong(long l) {
        return this.setLong(l, 0);
    }

    @Override
    public String setString(String string) {
        return this.setString(string, 0);
    }
}

