/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.communication.InterProcessComm;
import org.vishia.mainCmd.Report;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.MsgConfig;
import org.vishia.msgDispatch.MsgItems_h;
import org.vishia.util.Assert;

public class MsgReceiver {
    static final int version = 20120822;
    final MsgConfig msgConfig;
    private final Report console;
    private boolean bActivated = false;
    private boolean bListToBottom = false;
    List<MsgItem> msgOfDay = new LinkedList<MsgItem>();
    final InterProcessComm comm;
    private final LogMessage msgDispatcher;
    final MsgItems_h.MsgItems recvData;
    final byte[] recvDataBuffer;
    final int[] nrofBytesReceived = new int[1];
    MsgItems_h.MsgItem msgItem = new MsgItems_h.MsgItem();

    public MsgReceiver(Report report, LogMessage logMessage, MsgConfig msgConfig, InterProcessComm interProcessComm) {
        this.console = report;
        this.msgConfig = msgConfig;
        this.comm = interProcessComm;
        interProcessComm.open(null, false);
        this.recvData = new MsgItems_h.MsgItems();
        this.recvDataBuffer = new byte[596];
        this.recvData.assign(this.recvDataBuffer);
        this.recvData.assignDataToFixChildren();
        this.recvData.clearData();
        this.recvData.setBigEndian(true);
        this.msgDispatcher = logMessage;
    }

    public void start() {
        this.bActivated = true;
    }

    private void storeMsgOfDay(long l, int n, Object ... objectArray) {
        String string = "unknown message";
        while (this.msgOfDay.size() > 200) {
            this.msgOfDay.remove(0);
        }
        this.msgDispatcher.sendMsgTime(n, new OS_TimeStamp(l), string, objectArray);
    }

    void test() {
        Date date = new Date();
        long l = date.getTime();
        this.storeMsgOfDay(l, 1, 3.4, 34);
    }

    public void testAndReceive() {
        if (this.bActivated) {
            this.comm.receiveData(this.nrofBytesReceived, this.recvDataBuffer, null);
            if (this.nrofBytesReceived[0] > 0) {
                if (this.nrofBytesReceived[0] < 596) {
                    this.console.writeError("msgReceiver: to less bytes: " + this.nrofBytesReceived[0]);
                } else {
                    int n = this.recvData.get_nrofMsg();
                    Assert.stop();
                    try {
                        for (int i = 0; i < n; ++i) {
                            int n2 = 36 + i * 28;
                            this.msgItem.assignAt(n2, 28, this.recvData);
                            int n3 = this.msgItem.get_timestamp();
                            short s = this.msgItem.get_timeMillisec();
                            short s2 = this.msgItem.get_mode_typeVal();
                            long l = (long)n3 * 1000L + (long)s;
                            int n4 = this.msgItem.get_ident();
                            int n5 = this.msgItem.get_values(0);
                            int n6 = this.msgItem.get_values(1);
                            int n7 = this.msgItem.get_values(2);
                            int n8 = this.msgItem.get_values(3);
                            Object[] objectArray = new Object[4];
                            short s3 = s2;
                            for (int j = 0; j < objectArray.length; ++j) {
                                int n9 = this.msgItem.get_values(j);
                                switch (s3 & 3) {
                                    case 0: {
                                        objectArray[j] = new Integer(n9);
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        objectArray[j] = new Float(Float.intBitsToFloat(n9));
                                    }
                                }
                                s3 = (short)(s3 >> 2);
                            }
                            this.storeMsgOfDay(l, n4, objectArray);
                            this.bListToBottom = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        CharSequence charSequence = Assert.exceptionInfo("", illegalArgumentException, 0, 10);
                        throw new RuntimeException("MsgReceiver - unexpected;" + charSequence);
                    }
                }
            }
        }
    }

    private class MsgItem {
        String time;
        int ident;
        char state;
        String text;

        private MsgItem() {
        }
    }
}

