/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.mainCmd;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.bridgeC.Va_list;
import org.vishia.cmd.CmdExecuter;
import org.vishia.mainCmd.FileWrite;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.MsgRedirectConsole;
import org.vishia.util.FileSystem;

public abstract class MainCmd
implements MainCmd_ifc {
    public static String sVersion = "2014-06-17";
    protected final List<Argument> argList = new ArrayList<Argument>();
    private static MainCmd singleton;
    public FileWrite fReport;
    public int nLogLevel = 0;
    private String sFileLog = "report.txt";
    public String currdir = System.getProperty("user.dir");
    public int nReportLevelDisplay = 0;
    public int nLevelDisplayToReport = 3;
    public List<String> listHelpInfo = new LinkedList<String>();
    public List<String> listAboutInfo = new LinkedList<String>();
    private int nMaxErrorLevel = 0;
    protected String[] cmdLineArgs;
    private int iArgs;
    protected boolean bHelpIswritten;
    private static final String report_spaces = "                                                                                ";
    private LogMessage redirectLogMessage;
    public final PrintStream outCmdline;
    public final PrintStream errCmdline;
    private Appendable outConsole;
    private Appendable errConsole;
    protected MsgRedirectConsole msgDisp;
    protected SimpleDateFormat dateFormatMsg = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS: ");
    protected static final short kInfo_writeInfoDirectly = 1;
    public static final short kInfoln_writeInfoDirectly = 3;
    protected static final short kWarning_writeInfoDirectly = 6;
    protected static final short kError_writeInfoDirectly = 10;
    public static final short mNewln_writeInfoDirectly = 2;
    protected static final short mWarning_writeInfoDirectly = 4;
    protected static final short mError_writeInfoDirectly = 8;
    protected LogMessage logMessageImplReport = new LogMessage(){

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
            Object[] objectArray = va_list.get();
            return this.sendMsgTime(n, oS_TimeStamp, string, new Object[]{objectArray});
        }

        @Override
        public boolean sendMsg(int n, String string, Object ... objectArray) {
            return this.sendMsgTime(n, OS_TimeStamp.os_getDateTime(), string, objectArray);
        }

        @Override
        public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
            int n2 = n == 0 ? 3 : (n <= 6 ? n : 3);
            String string2 = objectArray.length == 0 ? MainCmd.this.dateFormatMsg.format(oS_TimeStamp) + "; " + n + "; " + string : MainCmd.this.dateFormatMsg.format(oS_TimeStamp) + "; " + n + "; " + String.format(string, objectArray);
            MainCmd.this.reportln(n2, string2);
            return true;
        }

        public String toString() {
            return "MainCmd.logMessageImplReport";
        }
    };
    LogMessageImplConsole logMessageConsole = new LogMessageImplConsole();
    LogMessageImplErrConsole logMessageErrConsole = new LogMessageImplErrConsole();
    LogMessageImplFile logMessageFile = new LogMessageImplFile();

    protected MainCmd() {
        singleton = this;
        this.outCmdline = System.out;
        this.outConsole = this.outCmdline;
        this.errCmdline = System.err;
        this.errConsole = this.errCmdline;
        this.redirectLogMessage = this.logMessageImplReport;
    }

    protected MainCmd(String[] stringArray) {
        this();
        this.cmdLineArgs = stringArray;
    }

    protected MainCmd(Argument[] argumentArray) {
        this();
        for (Argument argument : argumentArray) {
            this.argList.add(argument);
        }
    }

    protected MainCmd(Argument[] argumentArray, String[] stringArray) {
        this(argumentArray);
        this.cmdLineArgs = stringArray;
    }

    public void setLogMessageDestination(LogMessage logMessage) {
        this.redirectLogMessage = logMessage;
    }

    public void addArgument(Argument[] argumentArray) {
        for (Argument argument : argumentArray) {
            this.argList.add(argument);
            this.listHelpInfo.add(argument.arg + argument.help);
        }
    }

    protected void addStandardHelpInfo() {
        this.addHelpInfo("--arg:value    Use = or : as separator between arg and its value. Don't use space!");
        this.addHelpInfo("--about        show the help info");
        this.addHelpInfo("--help[=helpfile]  show the help info");
        this.addHelpInfo("---arg         ignore this argument");
        this.addHelpInfo("--@file        use file for further arguments, one argument per line.");
        this.addHelpInfo("--currdir=PATH Set the currdir variable.");
        this.addHelpInfo("--log=FILE     write the log (report) into the given file, create or clear the file.");
        this.addHelpInfo("-+log=FILE     add to the end of given file or create the log file.");
        this.addHelpInfo("--loglevel=R   set the level of log, R is number from 1 to 6.");
        this.addHelpInfo("--loglevel=DR  also write logs up to level D on display, sample: ..-rlevel:24");
        this.addHelpInfo("--loglevel=WDR write output also in log, W is nr from 1 to 3 (error, warning, info");
    }

    protected void addHelpInfo(String string) {
        this.listHelpInfo.add(string);
    }

    protected void addAboutInfo(String string) {
        this.listAboutInfo.add(string);
    }

    public void writeHelpInfo(File file) {
        boolean bl;
        Closeable closeable = null;
        FileWriter fileWriter = null;
        boolean bl2 = bl = file != null;
        if (file != null) {
            try {
                fileWriter = new FileWriter(file);
                closeable = fileWriter;
            }
            catch (IOException iOException) {
                closeable = System.out;
                bl = false;
                try {
                    closeable.append("MainCmd.writeHelpInfo - ERROR cannot open help output file; " + file.getAbsolutePath());
                }
                catch (IOException iOException2) {
                    System.err.println("MainCmd.writeHelpInfo - ERROR unexpected IOException; ");
                }
            }
        } else {
            closeable = System.out;
        }
        this.writeAboutInfo((Appendable)((Object)closeable));
        Iterator<String> iterator = this.listHelpInfo.iterator();
        try {
            while (iterator.hasNext()) {
                closeable.append(iterator.next()).append('\n');
            }
        }
        catch (IOException iOException) {
            System.err.println("MainCmd.writeAboutInfo - ERROR unexpected IOException; ");
        }
        if (bl) {
            try {
                ((Writer)closeable).close();
            }
            catch (IOException iOException) {
                System.err.println("MainCmd.writeAboutInfo - ERROR unexpected IOException; ");
            }
        }
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bHelpIswritten = true;
    }

    public void writeAboutInfo(Appendable appendable) {
        Iterator<String> iterator = this.listAboutInfo.iterator();
        try {
            while (iterator.hasNext()) {
                appendable.append(iterator.next()).append('\n');
            }
        }
        catch (IOException iOException) {
            System.err.println("MainCmd.writeAboutInfo - ERROR unexpected IOException; ");
        }
    }

    public final boolean parseArguments() throws ParseException {
        return this.parseArguments(this.cmdLineArgs);
    }

    public final boolean parseArguments(String[] stringArray) throws ParseException {
        this.cmdLineArgs = stringArray;
        boolean bl = false;
        MainCmd mainCmd = this;
        if (this.cmdLineArgs.length == 0) {
            this.callWithoutArguments();
        }
        boolean bl2 = false;
        this.iArgs = 0;
        while (this.iArgs < this.cmdLineArgs.length) {
            int n;
            if (this.cmdLineArgs[this.iArgs].startsWith("--@")) {
                String string = this.getArgument(3);
                File file = new File(string);
                LinkedList<String> linkedList = new LinkedList<String>();
                try {
                    String[] stringArray2;
                    int n2 = (int)file.length();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    while (bufferedReader.ready()) {
                        stringArray2 = bufferedReader.readLine().trim();
                        if (stringArray2.startsWith("==Args==")) {
                            linkedList.clear();
                            continue;
                        }
                        if (stringArray2.length() <= 0 || stringArray2.charAt(0) == '#') continue;
                        linkedList.add(this.replaceEnv((String)stringArray2));
                    }
                    bufferedReader.close();
                    stringArray2 = new String[this.cmdLineArgs.length - 1 + linkedList.size()];
                    System.arraycopy(this.cmdLineArgs, 0, stringArray2, 0, this.iArgs);
                    int n3 = this.iArgs - 1;
                    for (String string2 : linkedList) {
                        stringArray2[++n3] = string2;
                    }
                    System.arraycopy(this.cmdLineArgs, this.iArgs + 1, stringArray2, n3 + 1, this.cmdLineArgs.length - this.iArgs - 1);
                    this.cmdLineArgs = stringArray2;
                    --this.iArgs;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new ParseException("argfile not found: " + file.getAbsolutePath(), 0);
                }
                catch (IOException iOException) {
                    throw new ParseException("argfile read error: " + file.getAbsolutePath(), 0);
                }
            }
            if (this.cmdLineArgs[this.iArgs].startsWith("--loglevel")) {
                try {
                    n = Integer.parseInt(this.getArgument(11));
                }
                catch (Exception exception) {
                    throw new ParseException("ERROR on argument --rlevel=" + this.cmdLineArgs[this.iArgs], this.iArgs);
                }
                mainCmd.nLogLevel = n % 10;
                mainCmd.nReportLevelDisplay = n / 10 % 10;
                mainCmd.nLevelDisplayToReport = n / 100 % 10;
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--rlevel")) {
                try {
                    n = Integer.parseInt(this.getArgument(9));
                }
                catch (Exception exception) {
                    throw new ParseException("ERROR on argument --rlevel=" + this.cmdLineArgs[this.iArgs], this.iArgs);
                }
                mainCmd.nLogLevel = n % 10;
                mainCmd.nReportLevelDisplay = n / 10 % 10;
                mainCmd.nLevelDisplayToReport = n / 100 % 10;
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--currdir=")) {
                this.currdir = this.getArgument(10);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--currdir:")) {
                this.currdir = this.getArgument(10);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--log:")) {
                this.sFileLog = this.getArgument(6);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--log=")) {
                this.sFileLog = this.getArgument(6);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("-+log:")) {
                this.sFileLog = this.getArgument(6);
                bl2 = true;
            } else if (this.cmdLineArgs[this.iArgs].startsWith("-+log=")) {
                this.sFileLog = this.getArgument(6);
                bl2 = true;
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--log+=")) {
                this.sFileLog = this.getArgument(7);
                bl2 = true;
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--report+=")) {
                this.sFileLog = this.getArgument(10);
                bl2 = true;
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--report:")) {
                this.sFileLog = this.getArgument(9);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--report=")) {
                this.sFileLog = this.getArgument(9);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--about")) {
                this.writeAboutInfo(null);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--help:")) {
                this.writeHelpInfo(new File(this.getArgument(7)));
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--help=")) {
                this.writeHelpInfo(new File(this.getArgument(7)));
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--help")) {
                this.writeHelpInfo(null);
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--msgcfg:")) {
                this.addMsgConfig(this.cmdLineArgs[this.iArgs].substring(9));
            } else if (this.cmdLineArgs[this.iArgs].startsWith("--msgcfg=")) {
                this.addMsgConfig(this.cmdLineArgs[this.iArgs].substring(9));
            } else if (!this.cmdLineArgs[this.iArgs].startsWith("---")) {
                if (mainCmd.testArgument(this.cmdLineArgs[this.iArgs], this.iArgs)) {
                    bl = true;
                } else {
                    mainCmd.writeError("failed argument: " + this.cmdLineArgs[this.iArgs]);
                    throw new ParseException("failed argument:" + this.cmdLineArgs[this.iArgs], this.iArgs);
                }
            }
            ++this.iArgs;
        }
        if (this.nLogLevel > 0) {
            try {
                this.openReportfile(this.sFileLog, bl2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.writeError("ERROR creating reportfile-path: " + this.sFileLog);
                throw new ParseException("ERROR creating reportfile-path: " + this.sFileLog, 0);
            }
        }
        if (bl && !this.checkArguments()) {
            throw new ParseException("arguments not consistent", 0);
        }
        return bl;
    }

    @Override
    public void openReportfile(String string, boolean bl) throws FileNotFoundException {
        boolean bl2 = false;
        this.sFileLog = string;
        if (this.fReport != null) {
            try {
                this.fReport.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.fReport = new FileWrite(string, bl);
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        if (bl2) {
            FileSystem.mkDirPath(string);
            this.fReport = new FileWrite(string, bl);
        }
    }

    protected abstract boolean checkArguments();

    protected void callWithoutArguments() throws ParseException {
        this.writeHelpInfo(null);
    }

    protected String getArgument(int n) {
        String string;
        if (this.cmdLineArgs[this.iArgs].length() > n) {
            string = this.cmdLineArgs[this.iArgs].substring(n);
        } else {
            ++this.iArgs;
            string = this.iArgs < this.cmdLineArgs.length ? this.cmdLineArgs[this.iArgs] : "";
        }
        return string;
    }

    protected boolean testArgument(String string, int n) {
        if (this.argList != null) {
            int n2;
            Object object;
            Object object2 = null;
            Object object3 = null;
            int n3 = 0;
            int n4 = string.length();
            int n5 = 0;
            int n6 = this.argList.size() - 1;
            Iterator<Argument> iterator = this.argList.iterator();
            while (object3 == null && iterator.hasNext()) {
                object = iterator.next();
                n2 = ((Argument)object).arg.length();
                if (n2 == 0) {
                    object2 = object;
                } else {
                    boolean bl = false;
                    if ((string.startsWith(((Argument)object).arg) && (n4 == n2 || (bl = ":=".indexOf(string.charAt(n2)) >= 0)) || n2 == 0 && (n5 == n || n5 == n6)) && n2 >= n3) {
                        n3 = bl ? n2 + 1 : n2;
                        object3 = object;
                    }
                }
                ++n5;
            }
            if (object3 != null) {
                object = n4 == n3 ? string : string.substring(n3);
                object = this.replaceEnv((String)object);
                n2 = ((Argument)object3).set.setArgument((String)object) ? 1 : 0;
                return n2 != 0;
            }
            if (object2 != null) {
                return ((Argument)object2).set.setArgument(string);
            }
            return false;
        }
        System.err.println("MainCmd- Software design error - MainCmd.setArgumentList(...) should be called or the method testArgument(...) should be overridden.");
        return false;
    }

    public String replaceEnv(String string) {
        int n;
        while ((n = string.indexOf("$$")) >= 0) {
            int n2 = string.indexOf(36, n + 2);
            String string2 = string.substring(n + 2, n2);
            String string3 = System.getenv(string2);
            if (string3 == null) {
                throw new IllegalArgumentException("Environment variable " + string2 + "expected, not found");
            }
            string = string.substring(0, n) + string3 + string.substring(n2 + 1);
        }
        return string;
    }

    @Override
    public String currdir() {
        return this.currdir;
    }

    @Override
    public String setcurrdir(String string) {
        String string2 = this.currdir;
        this.currdir = string;
        return string2;
    }

    @Override
    public void setExitErrorLevel(int n) {
        if (n > this.nMaxErrorLevel) {
            this.nMaxErrorLevel = n;
        }
    }

    @Override
    public int getExitErrorLevel() {
        return this.nMaxErrorLevel;
    }

    @Override
    public void setOutputChannels(Appendable appendable, Appendable appendable2) {
        if (appendable != null) {
            this.outConsole = appendable;
        }
        if (appendable2 != null) {
            this.errConsole = appendable2;
        }
    }

    public void exit() {
        System.exit(this.getExitErrorLevel());
    }

    @Override
    public int executeCmdLine(String string, int n, Appendable appendable, String string2) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        return this.executeCmdLine(stringArray, n, appendable, string2);
    }

    @Override
    @Deprecated
    public int executeCmdLine(String[] stringArray, int n, Appendable appendable, String string) {
        int n2;
        Object object = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            ((StringBuilder)object).append(stringArray[i]);
            ((StringBuilder)object).append(" ");
        }
        ((StringBuilder)object).append(":");
        this.reportln(5, "MainCmd.executeCmdLine():" + object);
        this.writeInfoln("execute>" + ((StringBuilder)object).toString());
        object = null;
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            object = new BufferedReader(new InputStreamReader(inputStream));
            ShowCmdOutput showCmdOutput = new ShowCmdOutput(appendable, n, (BufferedReader)object);
            Thread thread = new Thread((Runnable)showCmdOutput, "cmdline-out");
            thread.start();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
            ShowCmdOutput showCmdOutput2 = new ShowCmdOutput(null, n < 0 ? -1 : 1, bufferedReader);
            Thread thread2 = new Thread((Runnable)showCmdOutput2, "cmdline-error");
            thread2.start();
            this.writeInfoln("process ...");
            process.waitFor();
            n2 = process.exitValue();
        }
        catch (IOException iOException) {
            this.writeInfoln("Problem \n" + iOException);
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException("IOException on commandline");
        }
        catch (InterruptedException interruptedException) {
            this.writeInfoln(interruptedException.toString());
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException("cmdline interrupted");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object != null) {
            try {
                ((BufferedReader)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    @Deprecated
    public int executeCmdLine(String string, ProcessBuilder processBuilder, int n, Appendable appendable, String string2) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        return this.executeCmdLine(stringArray, processBuilder, n, appendable, string2);
    }

    @Deprecated
    public int executeCmdLine(String[] stringArray, ProcessBuilder processBuilder, int n, Appendable appendable, String string) {
        return this.executeCmdLine(processBuilder, stringArray, string, n, appendable, appendable);
    }

    @Override
    public int executeCmdLine(ProcessBuilder processBuilder, String string, String string2, int n, Appendable appendable, Appendable appendable2) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        return this.executeCmdLine(processBuilder, stringArray, string2, n, appendable, appendable2);
    }

    @Override
    public int executeCmdLine(ProcessBuilder processBuilder, String[] stringArray, String string, int n, Appendable appendable, Appendable appendable2) {
        int n2;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        try {
            processBuilder.command(stringArray);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ShowCmdOutput showCmdOutput = new ShowCmdOutput(appendable, n, bufferedReader);
            Thread thread = new Thread((Runnable)showCmdOutput, "cmdline-out");
            thread.start();
            bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            ShowCmdOutput showCmdOutput2 = new ShowCmdOutput(appendable2, n, bufferedReader2);
            Thread thread2 = new Thread((Runnable)showCmdOutput2, "cmdline-error");
            thread2.start();
            this.writeInfoln("process ...");
            process.waitFor();
            n2 = process.exitValue();
        }
        catch (IOException iOException) {
            this.writeInfoln("Problem \n" + iOException);
            n2 = 255;
        }
        catch (InterruptedException interruptedException) {
            this.writeInfoln(interruptedException.toString());
            n2 = 255;
        }
        if (bufferedReader2 != null) {
            try {
                bufferedReader2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public int startCmdLine(ProcessBuilder processBuilder, String string) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        return this.startCmdLine(processBuilder, stringArray);
    }

    @Override
    public int startCmdLine(ProcessBuilder processBuilder, String[] stringArray) {
        int n = 0;
        try {
            processBuilder.command(stringArray);
            Process process = processBuilder.start();
        }
        catch (IOException iOException) {
            this.writeError("", iOException);
            n = 255;
        }
        return n;
    }

    @Override
    public int switchToWindowOrStartCmdline(ProcessBuilder processBuilder, String string, String string2) {
        throw new IllegalArgumentException("only available in graphical-systems.");
    }

    @Override
    public final void writeInfo(String string) {
        this.writeDirectly(string, (short)1);
        if (this.nLevelDisplayToReport >= 3) {
            this.report(11, string);
        }
    }

    @Override
    public final void writeInfoln(String string) {
        this.writeDirectly(string, (short)3);
        if (this.nLevelDisplayToReport >= 3) {
            this.reportln(11, string);
        }
    }

    @Override
    public final void writeWarning(String string) {
        this.writeDirectly(string, (short)6);
        if (this.nLevelDisplayToReport >= 2) {
            this.reportln(10, "WARNING:" + string);
        }
    }

    @Override
    public final void writeError(String string) {
        this.writeDirectly(string, (short)10);
        if (this.nLevelDisplayToReport >= 1) {
            this.reportln(9, "ERROR:" + string);
        }
    }

    @Override
    public final void writeError(String string, Throwable throwable) {
        this.writeErrorDirectly(string, throwable);
        if (this.nLevelDisplayToReport >= 1) {
            this.report(string, throwable, true);
        }
    }

    @Override
    public void writeStackTrace(Exception exception) {
        exception.printStackTrace(new PrintStream(this.fReport, true));
    }

    public void writeDirectly(String string, short s) {
        try {
            if ((s & 4) != 0) {
                this.errConsole.append("\n");
                this.errConsole.append("WARNING: ").append(string).append("\n");
            } else if ((s & 8) != 0) {
                this.errConsole.append("\n");
                this.errConsole.append("ERROR: ").append(string).append("\n");
            } else {
                int n;
                if ((s & 2) != 0) {
                    this.outConsole.append("\n");
                }
                int n2 = 0;
                while (n2 < string.length() && (n = string.indexOf(10, n2)) >= 0) {
                    this.outConsole.append(string.substring(n2, n)).append("|");
                    n2 = n + 1;
                }
                if (n2 < string.length()) {
                    this.outConsole.append(string.substring(n2));
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception while output in MainCmd.writeDirectly(" + string + ")");
        }
    }

    public void writeErrorDirectly(String string, Throwable throwable) {
        System.err.println("");
        System.err.println("EXCEPTION: " + string);
        throwable.printStackTrace(System.err);
    }

    @Override
    public void report(int n, String string) {
        int n2;
        if ((n & 7) <= this.nLogLevel && this.fReport != null && (n2 = 0) < string.length()) {
            this.fReport.write(string.substring(n2));
        }
        if ((n & 7) <= this.nReportLevelDisplay && (n & 8) == 0) {
            this.writeDirectly(string, (short)1);
        }
    }

    @Override
    public void reportln(int n, int n2, String string) {
        if ((n & 7) <= this.nLogLevel && this.fReport != null) {
            this.fReport.writeln("");
            int n3 = n2;
            if (n2 > report_spaces.length() / 2) {
                n3 = report_spaces.length() / 2;
            }
            this.fReport.write("*" + (n & 7) + ":" + report_spaces.substring(0, 2 * n3));
        }
        if ((n & 7) <= this.nReportLevelDisplay && (n & 8) == 0) {
            this.writeDirectly(string, (short)3);
        }
        this.report(n | 8, string);
    }

    @Override
    public void reportln(int n, String string) {
        this.reportln(n, 0, string);
    }

    @Override
    public void report(String string, Throwable throwable) {
        this.report(string, throwable, false);
    }

    private void report(String string, Throwable throwable, boolean bl) {
        if (this.fReport == null) {
            if (!bl) {
                this.writeErrorDirectly(string, throwable);
            }
        } else {
            this.fReport.writeln("\nEXCEPTION: " + string + "  " + throwable.getMessage());
            throwable.printStackTrace(new PrintStream(this.fReport, true));
            if (1 <= this.nReportLevelDisplay && !bl) {
                this.writeErrorDirectly(string, throwable);
            }
        }
    }

    @Override
    public int getReportLevel() {
        return this.nLogLevel;
    }

    public int setReportLevel(int n) {
        int n2 = this.nLogLevel;
        this.nLogLevel = n;
        return n2;
    }

    @Override
    public void flushReport() {
        if (this.fReport != null) {
            try {
                this.fReport.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setReportLevelToIdent(int n, int n2) {
        throw new RuntimeException("report idents are not supported here.");
    }

    @Override
    public int getReportLevelFromIdent(int n) {
        if (n >= 1 && n <= 6) {
            return n;
        }
        throw new RuntimeException("report idents are not supported here.");
    }

    @Override
    public String getReportFileName() {
        return this.sFileLog;
    }

    protected void addMsgConfig(String string) {
        this.msgDisp = new MsgRedirectConsole(this, 0, null);
        if (string.length() > 0) {
            File file = new File(string);
            if (file.exists()) {
                this.msgDisp.readConfig(file);
            } else {
                System.err.println("MainCmd - msgCfg file does not exits; " + file.getAbsolutePath());
            }
        }
        System.out.println("MainCmd - msgConfig installed;");
    }

    @Override
    public boolean sendMsg(int n, String string, Object ... objectArray) {
        return this.redirectLogMessage.sendMsg(n, string, objectArray);
    }

    @Override
    public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
        return this.redirectLogMessage.sendMsgTime(n, oS_TimeStamp, string, objectArray);
    }

    @Override
    public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
        return this.redirectLogMessage.sendMsgVaList(n, oS_TimeStamp, string, va_list);
    }

    @Override
    public void close() {
        this.redirectLogMessage.close();
    }

    @Override
    public void flush() {
        this.redirectLogMessage.flush();
    }

    @Override
    public boolean isOnline() {
        return this.redirectLogMessage.isOnline();
    }

    final void sendMsgTimeToAppendableDst(Appendable appendable, int n, int n2, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
        String string2;
        Object[] objectArray2 = objectArray;
        if (objectArray2.length == 0) {
            string2 = this.dateFormatMsg.format(oS_TimeStamp) + "; " + n + "; " + string;
        } else {
            try {
                if (objectArray2[0] instanceof Object[]) {
                    objectArray2 = (Object[])objectArray2[0];
                }
                string2 = this.dateFormatMsg.format(oS_TimeStamp) + "; " + n + "; " + String.format(string, objectArray2);
            }
            catch (IllegalFormatException illegalFormatException) {
                string2 = this.dateFormatMsg.format(oS_TimeStamp) + "; FORMATEXCEPTION " + n + "; " + string;
            }
        }
        try {
            appendable.append(string2);
            if (!string2.endsWith("\n")) {
                appendable.append("\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.errCmdline);
        }
    }

    @Override
    public LogMessage getLogMessageOutputConsole() {
        return this.logMessageConsole;
    }

    @Override
    public LogMessage getLogMessageErrorConsole() {
        return this.logMessageErrConsole;
    }

    @Override
    public LogMessage getLogMessageOutputFile() {
        return this.logMessageFile;
    }

    public static MainCmdLogging_ifc getLogging_ifc() {
        if (singleton != null) {
            return singleton;
        }
        return new MainCmdLoggingStream(System.out);
    }

    public static void XXXassertion(boolean bl) {
        if (!bl) {
            throw new RuntimeException("assertion");
        }
    }

    private class ShowCmdOutput
    implements Runnable {
        final BufferedReader reader;
        final Appendable uOutput;
        final int nCtrl;

        ShowCmdOutput(Appendable appendable, int n, BufferedReader bufferedReader) {
            this.uOutput = appendable;
            this.nCtrl = n;
            this.reader = bufferedReader;
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                    if (this.uOutput != null) {
                        this.uOutput.append(string + "\n");
                    }
                    if (this.nCtrl == -1) {
                        MainCmd.this.writeError(string);
                        continue;
                    }
                    if (this.nCtrl == -2) {
                        MainCmd.this.writeWarning(string);
                        continue;
                    }
                    if (this.nCtrl == -3) {
                        MainCmd.this.writeInfoln(string);
                        continue;
                    }
                    if (this.nCtrl == 0) continue;
                    MainCmd.this.reportln(this.nCtrl, string);
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
            }
        }
    }

    class LogMessageImplFile
    implements LogMessage {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS: ");

        LogMessageImplFile() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
            String string2 = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(string, va_list.get());
            MainCmd.this.reportln(3, string2);
            return false;
        }

        @Override
        public boolean sendMsg(int n, String string, Object ... objectArray) {
            return this.sendMsgTime(n, OS_TimeStamp.os_getDateTime(), string, objectArray);
        }

        @Override
        public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
            if (MainCmd.this.fReport != null) {
                String string2 = "*" + n + "; " + this.dateFormat.format(oS_TimeStamp) + "; ";
                MainCmd.this.fReport.writeln("");
                MainCmd.this.fReport.write(string2);
                string2 = objectArray.length == 0 ? string : String.format(string, objectArray);
                MainCmd.this.fReport.write(string2);
            }
            return false;
        }

        public String toString() {
            return "MainCmd.LogMessageImplFile";
        }
    }

    class LogMessageImplErrConsole
    implements LogMessage {
        LogMessageImplErrConsole() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
            Object[] objectArray = va_list.get();
            return this.sendMsgTime(n, oS_TimeStamp, string, new Object[]{objectArray});
        }

        @Override
        public boolean sendMsg(int n, String string, Object ... objectArray) {
            return this.sendMsgTime(n, OS_TimeStamp.os_getDateTime(), string, objectArray);
        }

        @Override
        public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
            int n2 = n == 0 ? 3 : (n <= 6 ? n : 3);
            MainCmd.this.sendMsgTimeToAppendableDst(MainCmd.this.errConsole, n, n2, oS_TimeStamp, string, objectArray);
            return true;
        }

        public String toString() {
            return "MainCmd.LogMessageImplErrConsole";
        }
    }

    private class LogMessageImplConsole
    implements LogMessage {
        private LogMessageImplConsole() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
            if (va_list.size() == 0) {
                return this.sendMsgTime(n, oS_TimeStamp, string, new Object[0]);
            }
            Object[] objectArray = va_list.get();
            return this.sendMsgTime(n, oS_TimeStamp, string, new Object[]{objectArray});
        }

        @Override
        public boolean sendMsg(int n, String string, Object ... objectArray) {
            return this.sendMsgTime(n, OS_TimeStamp.os_getDateTime(), string, objectArray);
        }

        @Override
        public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
            int n2 = n == 0 ? 3 : (n <= 6 ? n : 3);
            MainCmd.this.sendMsgTimeToAppendableDst(MainCmd.this.outConsole, n, n2, oS_TimeStamp, string, objectArray);
            return true;
        }

        public String toString() {
            return "MainCmd.LogMessageImplConsole";
        }
    }

    public static class Argument {
        final String arg;
        final String help;
        final SetArgument set;

        public Argument(String string, String string2, SetArgument setArgument) {
            this.arg = string;
            this.help = string2;
            this.set = setArgument;
        }

        public String toString() {
            return this.arg + this.help + '\n';
        }
    }

    public static interface SetArgument {
        public boolean setArgument(String var1);
    }
}

