/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.inspcPC.accTarget;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.communication.Address_InterProcessComm;
import org.vishia.communication.InterProcessComm;
import org.vishia.communication.InterProcessCommFactory;
import org.vishia.inspcPC.accTarget.InspcTargetAccessor;
import org.vishia.util.Assert;

public class InspcCommPort
implements Closeable {
    public static final String version = "2014-11-09";
    private InterProcessComm ipc;
    String sOwnIpAddr;
    Map<String, InspcTargetAccessor> targetAccessors = new TreeMap<String, InspcTargetAccessor>();
    Runnable receiveRun = new Runnable(){

        @Override
        public void run() {
            InspcCommPort.this.receiveFromTarget();
        }
    };
    Thread receiveThread = new Thread(this.receiveRun, "inspcRxThread");
    boolean bRun;
    boolean bFinish;
    boolean bWaitFinish;
    Address_InterProcessComm targetSenderAddr;

    void registerTargetAccessor(InspcTargetAccessor inspcTargetAccessor) {
        String string = inspcTargetAccessor.targetAddr.toString();
        if (this.targetAccessors.get(string) == null) {
            this.targetAccessors.put(string, inspcTargetAccessor);
        }
    }

    public Address_InterProcessComm createTargetAddr(String string) {
        return this.ipc.createAddress(string);
    }

    public boolean open(String string) {
        this.sOwnIpAddr = string;
        InterProcessCommFactory interProcessCommFactory = InterProcessCommFactory.getInstance();
        this.ipc = interProcessCommFactory.create(string);
        this.targetSenderAddr = this.ipc.createAddress();
        int n = this.ipc.open(null, true);
        if (n >= 0) {
            n = this.ipc.checkConnection();
        }
        if (n == 0) {
            // empty if block
        }
        if (n < 0) {
            System.out.println("Problem can't open socket: " + string);
        } else {
            this.receiveThread.start();
        }
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.bRun) {
            this.bRun = false;
            this.ipc.close();
            Runnable runnable = this.receiveRun;
            synchronized (runnable) {
                while (!this.bFinish) {
                    try {
                        this.receiveRun.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    int send(InspcTargetAccessor inspcTargetAccessor, byte[] byArray, int n) {
        return this.ipc.send(byArray, n, inspcTargetAccessor.targetAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFromTarget() {
        Object object;
        this.bRun = true;
        int[] nArray = new int[1];
        while (this.bRun) {
            object = this.ipc.receive(nArray, this.targetSenderAddr);
            if (nArray[0] > 0) {
                String string = this.targetSenderAddr.toString();
                InspcTargetAccessor inspcTargetAccessor = this.targetAccessors.get(string);
                if (inspcTargetAccessor != null) {
                    try {
                        inspcTargetAccessor.evaluateRxTelg((byte[])object, nArray[0]);
                    }
                    catch (Exception exception) {
                        CharSequence charSequence = Assert.exceptionInfo("InspcCommPort - exception while evaluating receice telegram; ", exception, 0, 10);
                        System.err.append(charSequence);
                    }
                    continue;
                }
                System.out.append("InspcCommPort - receive from unknown target; " + string);
                continue;
            }
            System.out.append("InspcCommPort - receive error");
        }
        object = this.receiveRun;
        synchronized (object) {
            this.bFinish = true;
            this.receiveRun.notify();
        }
    }
}

