/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.inspcPC;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Map;
import javax.script.ScriptException;
import org.vishia.cmd.JZtxtcmdExecuter;
import org.vishia.cmd.JZtxtcmdScript;
import org.vishia.communication.InterProcessCommFactorySocket;
import org.vishia.inspcPC.InspcReplAlias;
import org.vishia.inspcPC.mng.InspcMng;
import org.vishia.jztxtcmd.JZtxtcmd;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.util.DataAccess;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.ReplaceAlias_ifc;

public class InspCmd {
    public static final String version = "2017-07-02";
    final MainCmd_ifc console;
    ReplaceAlias_ifc replAlias = new InspcReplAlias();

    public static void main(String[] stringArray) {
        try {
            int n = InspCmd.smain(stringArray);
            System.exit(n);
        }
        catch (Exception exception) {
            System.err.println("InspCmd - script exception; " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(3);
        }
    }

    public static int smain(String[] stringArray) throws ScriptException, IllegalAccessException {
        String string = null;
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(args, stringArray);
        cmdLine.setReportLevel(0);
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            string = "InspcCmd - Argument error ;" + exception.getMessage();
            cmdLine.report(string, exception);
            cmdLine.setExitErrorLevel(5);
        }
        if (args.sFileScript == null) {
            cmdLine.writeHelpInfo(null);
        } else if (string == null) {
            InspCmd inspCmd = new InspCmd(cmdLine);
            FileWriter fileWriter = null;
            File file = args.sFileTextOut == null ? null : new File(args.sFileTextOut);
            try {
                fileWriter = args.sFileTextOut == null ? null : new FileWriter(file);
                inspCmd.execute(args, fileWriter);
            }
            catch (IOException iOException) {
                throw new ScriptException(iOException);
            }
            if (fileWriter != null) {
                try {
                    ((Writer)fileWriter).close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            inspCmd.console.writeInfoln("SUCCESS");
        }
        return cmdLine.getExitErrorLevel();
    }

    public InspCmd(MainCmd_ifc mainCmd_ifc) {
        this.console = mainCmd_ifc;
    }

    void execute(Args args, Writer writer) throws IOException, ScriptException, IllegalAccessException, IllegalArgumentException {
        JZtxtcmdScript jZtxtcmdScript = JZtxtcmd.translateAndSetGenCtrl(new File(args.sFileScript), (MainCmdLogging_ifc)this.console);
        JZtxtcmdExecuter jZtxtcmdExecuter = new JZtxtcmdExecuter(this.console);
        jZtxtcmdExecuter.initialize(jZtxtcmdScript, false, null);
        JZtxtcmdScript.JZcmdClass jZcmdClass = jZtxtcmdScript.getClass("Args");
        if (jZcmdClass == null) {
            throw new IllegalArgumentException("Script class \"Args\" not found in \"" + args.sFileScript + "\"");
        }
        JZtxtcmdExecuter.ExecuteLevel executeLevel = jZtxtcmdExecuter.execute_Scriptclass(jZcmdClass);
        Map<String, DataAccess.Variable<Object>> map = executeLevel.localVariables;
        String string = map.get("ownIp").value().toString();
        Map map2 = (Map)map.get("targets").value();
        IndexMultiTable<String, String> indexMultiTable = new IndexMultiTable<String, String>(IndexMultiTable.providerString);
        for (Map.Entry object2 : map2.entrySet()) {
            indexMultiTable.put(object2.getKey(), ((DataAccess.Variable)object2.getValue()).value().toString());
        }
        new InterProcessCommFactorySocket();
        InspcMng inspcMng = new InspcMng(string, indexMultiTable, args.cycletime, false, null);
        inspcMng.complete_ReplaceAlias_ifc(this.replAlias);
        inspcMng.startupThreads();
        DataAccess.Variable<Object> variable = map.get("telglogfile");
        if (variable != null) {
            inspcMng.sFileLog = variable.value().toString();
        }
        LinkedList<DataAccess.Variable<Object>> linkedList = new LinkedList<DataAccess.Variable<Object>>();
        linkedList.add(new DataAccess.Variable<Object>('O', "inspc", inspcMng));
        jZtxtcmdExecuter.execSub(jZtxtcmdScript, "execute", linkedList, false, (Appendable)writer, null);
        inspcMng.close();
    }

    private static class CmdLine
    extends MainCmd {
        public final Args argData;
        protected final MainCmd.Argument[] argList = new MainCmd.Argument[]{new MainCmd.Argument("", ":pathTo/input.script", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileScript = string;
                return true;
            }
        }), new MainCmd.Argument("-t", ":OUTEXT pathTo text-File for output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileTextOut = string;
                return true;
            }
        })};

        protected CmdLine(Args args, String[] stringArray) {
            super(stringArray);
            this.argData = args;
            super.addAboutInfo("Execution of Inspspector-Commands from a file");
            super.addAboutInfo("made by HSchorrig, Version 1.0, 2016-01-06");
            super.addHelpInfo("args SCRIPTFILE [-t:OUTEXT]");
            super.addArgument(this.argList);
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
        }

        @Override
        protected void callWithoutArguments() {
        }

        @Override
        protected boolean checkArguments() {
            return this.argData.sFileScript != null;
        }
    }

    public static class Args {
        public String sFileScript;
        public String sFileTextOut;
        public String sScriptCheck;
        public File fileTestXml;
        public int cycletime = 100;
    }
}

