/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.header2Reflection.Header2Reflection;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.mainCmd.Report;
import org.vishia.util.FileFunctions;
import org.vishia.util.FileSystem;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParser;

public class C2DataDeps
extends MainCmd {
    public static final int revisionInfo = 20120608;
    final Report console;
    private final List<FileFunctions.FileAndBasePath> listFileIn = new LinkedList<FileFunctions.FileAndBasePath>();
    private ZbnfParser parser;
    private String sFileZbnf;
    private String sOutDir;
    protected List<ZbnfParseResultItem> listParsed = new LinkedList<ZbnfParseResultItem>();
    String sFileIn = null;

    public static void main(String[] stringArray) {
        C2DataDeps c2DataDeps = new C2DataDeps(stringArray);
        boolean bl = true;
        try {
            c2DataDeps.parseArguments(stringArray);
        }
        catch (Exception exception) {
            c2DataDeps.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            try {
                c2DataDeps.execute();
            }
            catch (Exception exception) {
                c2DataDeps.console.report("Uncatched Exception on main level:", exception);
                exception.printStackTrace(System.err);
                c2DataDeps.console.setExitErrorLevel(3);
            }
        }
        c2DataDeps.exit();
    }

    private C2DataDeps(String[] stringArray) {
        super(stringArray);
        this.console = this;
        super.addAboutInfo("Generate Data dependency report from C-files");
        super.addAboutInfo("made by Hartmut Schorrig, 2012-06-07");
        super.addHelpInfo("param: {-i:INPUT} [-o:OUTDIR |-out.c:OUTFILE | -obin[l|b]:BINFILE -offs:OFFSETFILE ] -z:CHeader.zbnf -b:Types.cfg -c_only -ro:FileTypes.out");
        super.addStandardHelpInfo();
        super.addHelpInfo("-i:INPUT    inputfilepath, more as one -i is admissible and typical.");
        super.addHelpInfo("-o:OUTDIR For any INPUT one output file in this directory.");
        super.addHelpInfo("-out.c:OUTFILE The file path and name for OUTFILE.c and OUTFILE.h, this file is written.");
        super.addHelpInfo("-offs:OFFSETFILE An extra file.c for offset-constants for second CPU.");
        super.addHelpInfo("-obinl:BINFILE in little endian, contains all structure informations, only able to use with -offs:.");
        super.addHelpInfo("-obinb:BINFILE Same, but the BINFILE will written in big endian.");
        super.addHelpInfo("-obin[b|l]hex:HEXFILE The BINFILE will written in Intel-hex-Format.");
        super.addHelpInfo("-c_only Don't reagard C++-classes, don't generate C++-code especially static_cast<...> .");
        super.addHelpInfo("-b:Types.cfg Config-file for special handled types.");
        super.addHelpInfo("Syntax of the config-file: ------------------------------------------------------------");
        super.addHelpInfo("$setLinemode. \nReflectionTypes::=\n{ \\n\n| \\<leaderTextOffs  [ = <textFile?leaderTextOffs>  \\> | \\> \\n<lines?leaderTextOffs>]\n| \\<trailerTextOffs [ = <textFile?trailerTextOffs> \\> | \\> \\n<lines?trailerTextOffs>]\n| \\<leaderTextC     [ = <textFile?leaderTextC>     \\> | \\> \\n<lines?leaderTextC>]\n| \\<trailerTextC    [ = <textFile?trailerTextC>    \\> | \\> \\n<lines?trailerTextC>]\n| \\<leaderTextH     [ = <textFile?leaderTextH>     \\> | \\> \\n<lines?leaderTextH>]\n| \\<trailerTextH    [ = <textFile?trailerTextH>    \\> | \\> \\n<lines?trailerTextH>]\n| exprOffsField = <\"\"?exprOffsField> \\n\n| exprOffsBase = <\"\"?exprOffsBase> \\n\n| exprOffsObj = <\"\"?exprOffsObj> \\n\n| exprOffsObjJcpp = <\"\"?exprOffsObjJcpp> \\n\n| exprOffsCppObj = <\"\"?exprOffsCppObj> \\n\n| exprSizeType = <\"\"?exprSizeType> \\n\n| <blockedFile> \\n \n|<?c_only> c_only \\n\n|<?define> #define <$?name> <*\\r\\n?value> \n| <reflectionType> \\n \n| \\n\n} \\e.\nblockedFile::= % <* ,\\r\\n?path>.\nreflectionType::= [<?sign>#|-] <* ,\\r\\n?type> \n| [<?sign>=|@] <* =?type> = [ <$?deftype>| 0x<#x?defvalue>| <#?defvalue>] \n| [<?sign>!|!] <* =?type> = [ <$?deftype>].\nlines::={[? \\<END\\>]<*\\n?line>\\n} \\<END\\> \\n.\ntextFile::= <\"\"?fileName>.\n");
        super.addHelpInfo("---------------------------------------------------------------------------------------");
    }

    public void parseArguments(Header2Reflection header2Reflection, String[] stringArray) throws ParseException {
        super.parseArguments(stringArray);
    }

    @Override
    protected boolean testArgument(String string, int n) {
        boolean bl = true;
        if (string.startsWith("-i:")) {
            String string2 = this.getArgument(3);
            try {
                if (!FileSystem.addFilesWithBasePath(null, string2, this.listFileIn)) {
                    this.writeError("file not found: " + string2);
                    bl = false;
                }
            }
            catch (Exception exception) {
                this.writeError("file not found: " + string2);
                bl = false;
            }
        } else if (string.startsWith("-o:")) {
            bl = this.setOutDir(this.getArgument(3));
        } else if (string.startsWith("-z:")) {
            this.sFileZbnf = this.getArgument(3);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void callWithoutArguments() throws ParseException {
        super.callWithoutArguments();
    }

    @Override
    protected boolean checkArguments() {
        return true;
    }

    boolean setOutDir(String string) {
        boolean bl = true;
        this.sOutDir = string.replace('\\', '/');
        try {
            FileSystem.mkDirPath(this.sOutDir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    boolean init() throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        Object object;
        boolean bl = true;
        if (this.sFileZbnf == null) {
            object = System.getenv("ZBNFJAX_HOME");
            if (object == null) {
                this.console.writeError("No -z:SYNTAX option, and the environment variable ZBNFJAX_HOME is unknown, abort.");
                bl = false;
            } else {
                this.sFileZbnf = (String)object + "/zbnf/Cheader.zbnf";
            }
        }
        if (bl) {
            object = new File(this.sFileZbnf);
            String string = FileSystem.readFile((File)object);
            if (string == null) {
                this.console.writeError("fault SYNTAX file, abort:" + this.sFileZbnf);
                bl = false;
            } else {
                this.parser = new ZbnfParser((MainCmdLogging_ifc)this.console, 10);
                try {
                    this.parser.setSyntax(string);
                }
                catch (ParseException parseException) {
                    this.console.writeError("Headersyntax fault in " + this.sFileZbnf, parseException);
                    this.parser.reportSyntax(this.console, 4);
                    bl = false;
                }
                this.parser.setReportIdents(1, 3, 5, 6);
            }
        }
        return bl;
    }

    void execute() {
        boolean bl = true;
        try {
            this.init();
        }
        catch (Exception exception) {
            System.err.println("C2DataDeps.execute - any exception while init; " + exception.getMessage());
            bl = false;
        }
        if (bl) {
            for (FileFunctions.FileAndBasePath fileAndBasePath : this.listFileIn) {
                this.parseCfile(fileAndBasePath.file);
            }
        }
    }

    boolean parseCfile(File file) {
        Object object;
        boolean bl = true;
        StringPartFromFileLines stringPartFromFileLines = null;
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, -1, null, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("C2DataDeps.parseCfile - Unexpected file not found; " + fileNotFoundException.getMessage());
            bl = false;
        }
        catch (Exception exception) {
            System.err.println("C2DataDeps.parseCfile - Any exception; " + exception.getMessage());
            bl = false;
        }
        bl = this.parser.parse(stringPartFromFileLines);
        if (!bl) {
            object = this.parser.getFoundedInputOnError();
            object = this.parser.getExpectedSyntaxOnError();
            object = this.parser.getSyntaxErrorReport();
            this.console.writeError((String)object);
            this.stop();
        } else {
            this.parser.reportStore(this.console, 4);
            object = this.parser.getFirstParseResult();
            this.listParsed.add((ZbnfParseResultItem)object);
        }
        return bl;
    }

    void stop() {
    }
}

