/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.vishia.event.EventCmdtypeWithBackEvent;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventTimerThread;
import org.vishia.fileLocalAccessor.FileLocalAccessorCopyStateM;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteAccessor;
import org.vishia.fileRemote.FileRemoteCallback;
import org.vishia.fileRemote.FileRemoteProgressTimeOrder;
import org.vishia.util.Assert;
import org.vishia.util.FileSystem;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileAccessorLocalJava6
extends FileRemoteAccessor {
    public static final int version = 20130331;
    private static final boolean useFileChildren = false;
    private static FileRemoteAccessor instance;
    protected final FileLocalAccessorCopyStateM states = new FileLocalAccessorCopyStateM();
    EventSource evSrc = new EventSource("FileLocalAccessor"){

        @Override
        public void notifyDequeued() {
        }

        @Override
        public void notifyConsumed(int n) {
        }

        @Override
        public void notifyRelinquished(int n) {
        }

        @Override
        public void notifyShouldSentButInUse() {
            throw new RuntimeException("event usage error");
        }

        @Override
        public void notifyShouldOccupyButInUse() {
            throw new RuntimeException("event usage error");
        }
    };
    EventTimerThread singleThreadForCommission = new EventTimerThread("FileAccessor-local");
    EventConsumer executerCommission = new EventConsumer(){

        @Override
        public int processEvent(EventObject eventObject) {
            if (eventObject instanceof FileRemote.CmdEvent) {
                FileAccessorLocalJava6.this.execCommission((FileRemote.CmdEvent)eventObject);
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "FileRemoteAccessorLocal - executerCommision";
        }
    };
    private FileRemote workingDir;
    public static FileRemote.FileRemoteAccessorSelector selectLocalFileAlways;

    public static FileRemoteAccessor getInstance() {
        if (instance == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                classLoader.loadClass("java.nio.file.Files");
                Class<?> clazz = classLoader.loadClass("org.vishia.fileLocalAccessor.FileAccessorLocalJava7");
                instance = (FileRemoteAccessor)clazz.newInstance();
            }
            catch (Exception exception) {
                instance = new FileAccessorLocalJava6();
            }
        }
        return instance;
    }

    private File getLocalFile(FileRemote fileRemote) {
        if (fileRemote.oFile() == null) {
            String string = fileRemote.getPath();
            fileRemote.setFileObject(new File(string));
        }
        return (File)fileRemote.oFile();
    }

    @Override
    public void refreshFileProperties(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        RunRefresh runRefresh = new RunRefresh(fileRemote, callbackEvent);
        if (callbackEvent == null) {
            runRefresh.run();
        } else {
            Thread thread = new Thread(runRefresh);
            thread.start();
        }
    }

    @Override
    public void refreshFilePropertiesAndChildren(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        RunRefreshWithChildren runRefreshWithChildren = new RunRefreshWithChildren(fileRemote, callbackEvent);
        if (callbackEvent == null) {
            runRefreshWithChildren.run();
        } else if ((fileRemote.getFlags() & 0x20000000) == 0) {
            fileRemote.internalAccess().setFlagBit(0x20000000);
            Thread thread = new Thread(runRefreshWithChildren);
            runRefreshWithChildren.time = System.currentTimeMillis();
            thread.start();
        } else {
            System.err.println("FileRemoteAccessLocalFile.refreshFilePropertiesAndChildren - double call, ignored;");
            callbackEvent.relinquish();
        }
    }

    @Override
    public List<File> getChildren(FileRemote fileRemote, FileFilter fileFilter) {
        File file = (File)fileRemote.oFile();
        File[] fileArray = file.listFiles(fileFilter);
        LinkedList<File> linkedList = new LinkedList<File>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                linkedList.add(file2);
            }
        }
        return linkedList;
    }

    @Override
    public void walkFileTree(FileRemote fileRemote, boolean bl, boolean bl2, boolean bl3, String string, long l, int n, FileRemoteCallback fileRemoteCallback) {
        fileRemoteCallback.start(fileRemote);
        this.walkSubTree(fileRemote, null, n, fileRemoteCallback);
        fileRemoteCallback.finished(fileRemote, null);
    }

    public SortedTreeWalkerCallback.Result walkSubTree(FileRemote fileRemote, FileFilter fileFilter, int n, FileRemoteCallback fileRemoteCallback) {
        this.refreshFilePropertiesAndChildren(fileRemote, null);
        Map<String, FileRemote> map = fileRemote.children();
        SortedTreeWalkerCallback.Result result = SortedTreeWalkerCallback.Result.cont;
        if (map != null && (result = fileRemoteCallback.offerParentNode(fileRemote)) == SortedTreeWalkerCallback.Result.cont) {
            Iterator<Map.Entry<String, FileRemote>> iterator = map.entrySet().iterator();
            while (result == SortedTreeWalkerCallback.Result.cont && iterator.hasNext()) {
                Map.Entry<String, FileRemote> entry = iterator.next();
                FileRemote fileRemote2 = entry.getValue();
                this.refreshFileProperties(fileRemote2, null);
                if (fileRemote2.isDirectory()) {
                    if (n > 1) {
                        result = this.walkSubTree(fileRemote2, fileFilter, n - 1, fileRemoteCallback);
                        continue;
                    }
                    result = fileRemoteCallback.offerLeafNode(fileRemote2, null);
                    continue;
                }
                result = fileRemoteCallback.offerLeafNode(fileRemote2, null);
            }
        }
        if (result != SortedTreeWalkerCallback.Result.terminate) {
            result = SortedTreeWalkerCallback.Result.cont;
        }
        return result;
    }

    @Override
    public void walkFileTreeCheck(FileRemote fileRemote, boolean bl, boolean bl2, boolean bl3, String string, long l, int n, FileRemoteCallback fileRemoteCallback) {
    }

    @Override
    public boolean setLastModified(FileRemote fileRemote, long l) {
        File file = (File)fileRemote.oFile();
        if (file != null) {
            return file.setLastModified(l);
        }
        return false;
    }

    @Override
    public ReadableByteChannel openRead(FileRemote fileRemote, long l) {
        try {
            FileInputStream fileInputStream = new FileInputStream(fileRemote);
            return fileInputStream.getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public InputStream openInputStream(FileRemote fileRemote, long l) {
        try {
            FileInputStream fileInputStream = new FileInputStream(fileRemote);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public OutputStream openOutputStream(FileRemote fileRemote, long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileRemote);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public WritableByteChannel openWrite(FileRemote fileRemote, long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileRemote);
            return fileOutputStream.getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public boolean createNewFile(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) throws IOException {
        File file;
        if (fileRemote.oFile() == null) {
            file = new File(fileRemote.getAbsolutePath());
            fileRemote.setFileObject(file);
        } else {
            file = (File)fileRemote.oFile();
        }
        return file.createNewFile();
    }

    @Override
    public boolean mkdir(FileRemote fileRemote, boolean bl, FileRemote.CallbackEvent callbackEvent) {
        File file = (File)fileRemote.oFile();
        if (file == null) {
            file = new File(fileRemote.getAbsolutePath());
            fileRemote.setFileObject(file);
        }
        if (callbackEvent == null) {
            if (bl) {
                return file.mkdirs();
            }
            return file.mkdir();
        }
        FileRemote.CmdEvent cmdEvent = this.prepareCmdEvent(500, callbackEvent);
        cmdEvent.filesrc = fileRemote;
        cmdEvent.filedst = null;
        cmdEvent.sendEvent(bl ? FileRemote.Cmd.mkDirs : FileRemote.Cmd.mkDir);
        return true;
    }

    private void mkdir(boolean bl, FileRemote.CmdEvent cmdEvent) {
        boolean bl2 = this.mkdir(cmdEvent.filesrc, bl, null);
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        if (callbackEvent.occupy(this.evSrc, true)) {
            callbackEvent.sendEvent(bl2 ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.nok);
        }
    }

    @Override
    public boolean delete(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
        File file = this.getLocalFile(fileRemote);
        if (callbackEvent == null) {
            return file.delete();
        }
        boolean bl = file.delete();
        callbackEvent.occupy(this.evSrc, true);
        callbackEvent.sendEvent(bl ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.errorDelete);
        return bl;
    }

    @Override
    public void copyChecked(FileRemote fileRemote, String string, String string2, int n, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
        this.states.copyChecked(fileRemote, string, string2, n, fileRemoteCallback, fileRemoteProgressTimeOrder);
    }

    @Override
    public void search(FileRemote fileRemote, byte[] byArray, FileRemoteCallback fileRemoteCallback, FileRemoteProgressTimeOrder fileRemoteProgressTimeOrder) {
    }

    @Override
    public boolean isLocalFileSystem() {
        return true;
    }

    @Override
    public CharSequence getStateInfo() {
        return "";
    }

    @Override
    public FileRemote.CmdEvent prepareCmdEvent(int n, EventCmdtypeWithBackEvent<?, FileRemote.CmdEvent> eventCmdtypeWithBackEvent) {
        FileRemote.CmdEvent cmdEvent;
        if (eventCmdtypeWithBackEvent != null && (cmdEvent = eventCmdtypeWithBackEvent.getOpponent()) != null) {
            if (!cmdEvent.occupy(n, this.evSrc, this.executerCommission, this.singleThreadForCommission)) {
                return null;
            }
        } else {
            cmdEvent = new FileRemote.CmdEvent(this.evSrc, this.executerCommission, this.singleThreadForCommission, (FileRemote.CallbackEvent)eventCmdtypeWithBackEvent);
        }
        return cmdEvent;
    }

    void execCommission(FileRemote.CmdEvent cmdEvent) {
        FileRemote.Cmd cmd = cmdEvent.getCmd();
        switch (cmd) {
            case check: 
            case abortAll: 
            case delChecked: 
            case moveChecked: 
            case chgProps: {
                this.execChgProps(cmdEvent);
                break;
            }
            case chgPropsRecurs: {
                this.execChgPropsRecurs(cmdEvent);
                break;
            }
            case countLength: {
                this.execCountLength(cmdEvent);
                break;
            }
            case delete: {
                this.execDel(cmdEvent);
                break;
            }
            case mkDir: {
                this.mkdir(false, cmdEvent);
                break;
            }
            case mkDirs: {
                this.mkdir(true, cmdEvent);
            }
        }
    }

    private void execChgProps(FileRemote.CmdEvent cmdEvent) {
        FileRemote fileRemote;
        Object object;
        boolean bl;
        boolean bl2 = bl = cmdEvent != null;
        if (cmdEvent.newName() != null && !cmdEvent.newName().equals(cmdEvent.filesrc().getName())) {
            object = new File(cmdEvent.filesrc.getParent(), cmdEvent.newName());
            bl &= cmdEvent.filesrc.renameTo((File)object);
            fileRemote = FileRemote.fromFile(cmdEvent.filesrc.itsCluster, object);
        } else {
            fileRemote = cmdEvent.filesrc;
        }
        bl = this.chgFile(fileRemote, cmdEvent.maskFlags(), cmdEvent.newFlags(), bl);
        object = bl ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.nok;
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        callbackEvent.occupy(this.evSrc, true);
        callbackEvent.sendEvent((FileRemote.CallbackCmd)((Object)object));
    }

    private void execChgPropsRecurs(FileRemote.CmdEvent cmdEvent) {
        FileRemote fileRemote;
        Object object;
        boolean bl;
        boolean bl2 = bl = cmdEvent != null;
        if (cmdEvent.newName() != null && !cmdEvent.newName().equals(cmdEvent.filesrc.getName())) {
            object = cmdEvent.filesrc.getParentFile().child(cmdEvent.newName());
            bl &= cmdEvent.filesrc.renameTo((File)object);
            fileRemote = object;
        } else {
            fileRemote = cmdEvent.filesrc;
        }
        bl &= this.chgPropsRecursive(fileRemote, cmdEvent.maskFlags(), cmdEvent.newFlags(), bl, 0);
        object = bl ? FileRemote.CallbackCmd.done : FileRemote.CallbackCmd.error;
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        callbackEvent.occupy(this.evSrc, true);
        callbackEvent.sendEvent((FileRemote.CallbackCmd)((Object)object));
    }

    private boolean chgPropsRecursive(File file, int n, int n2, boolean bl, int n3) {
        if (n3 > 100) {
            throw new IllegalArgumentException("FileRemoteAccessorLocal.chgProsRecursive: too many recursions ");
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                bl = this.chgPropsRecursive(file2, n, n2, bl, n3 + 1);
            }
        } else {
            bl = this.chgFile(file, n, n2, bl);
        }
        return bl;
    }

    private boolean chgFile(File file, int n, int n2, boolean bl) {
        int n3 = n;
        for (int i = 1; i != 0; i <<= 1) {
            if ((n3 & i) == 0 || this.chgFile1(file, i, n2)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean chgFile1(File file, int n, int n2) {
        boolean bl;
        boolean bl2 = (n2 & n) != 0;
        switch (n) {
            case 4: {
                bl = file.setWritable(bl2);
                break;
            }
            case 32768: {
                bl = file.setWritable(bl2, true);
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl && file instanceof FileRemote) {
            FileRemote fileRemote = (FileRemote)file;
            fileRemote.internalAccess().setOrClrFlagBit(n, bl2);
        }
        return bl;
    }

    private void execCountLength(FileRemote.CmdEvent cmdEvent) {
        FileRemote.CallbackCmd callbackCmd;
        long l = this.countLengthDir(cmdEvent.filesrc, 0L, 0);
        FileRemote.CallbackEvent callbackEvent = cmdEvent.getOpponent();
        callbackEvent.occupy(this.evSrc, true);
        if (l >= 0L) {
            callbackCmd = FileRemote.CallbackCmd.done;
            callbackEvent.nrofBytesAll = l;
        } else {
            callbackCmd = FileRemote.CallbackCmd.nok;
        }
        callbackEvent.sendEvent(callbackCmd);
    }

    private long countLengthDir(File file, long l, int n) {
        if (n > 100) {
            throw new IllegalArgumentException("FileRemoteAccessorLocal.chgProsRecursive: too many recursions ");
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                l = this.countLengthDir(file2, l, n + 1);
            }
        } else {
            l += file.length();
        }
        return l;
    }

    void execDel(FileRemote.CmdEvent cmdEvent) {
        System.err.println("FileRemoteLocal - execDel not implemented yet.");
    }

    @Override
    public void close() throws IOException {
        this.singleThreadForCommission.close();
    }

    static {
        selectLocalFileAlways = new FileRemote.FileRemoteAccessorSelector(){

            @Override
            public FileRemoteAccessor selectFileRemoteAccessor(String string) {
                return FileAccessorLocalJava6.getInstance();
            }
        };
    }

    private class RunRefreshWithChildren
    implements Runnable {
        long time;
        final FileRemote fileRemote;
        final FileRemote.CallbackEvent callback;

        RunRefreshWithChildren(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
            this.fileRemote = fileRemote;
            this.callback = callbackEvent;
        }

        @Override
        public void run() {
            try {
                long l;
                this.time = System.currentTimeMillis();
                FileAccessorLocalJava6.this.refreshFileProperties(this.fileRemote, null);
                File file = FileAccessorLocalJava6.this.getLocalFile(this.fileRemote);
                if (file.exists()) {
                    l = System.currentTimeMillis();
                    System.out.println("FileAccessorLocalJava6.refreshFilePropertiesAndChildren - start listFiles; dt=" + (l - this.time));
                    File[] fileArray = file.listFiles();
                    l = System.currentTimeMillis();
                    System.out.println("FileAccessorLocalJava6.refreshFilePropertiesAndChildren - ok listFiles; dt=" + (l - this.time));
                    if (fileArray != null) {
                        Map<String, FileRemote> map = this.fileRemote.children();
                        this.fileRemote.internalAccess().newChildren();
                        int n = -1;
                        for (File file2 : fileArray) {
                            String string = file2.getName();
                            FileRemote fileRemote = null;
                            if (map != null) {
                                fileRemote = map.remove(string);
                            }
                            if (fileRemote == null) {
                                int n2 = file2.isDirectory() ? 16 : 0;
                                fileRemote = this.fileRemote.internalAccess().newChild(string, 0L, 0L, 0L, 0L, n2, file2);
                            } else if (!fileRemote.isTested(this.time - 1000L)) {
                                // empty if block
                            }
                            this.fileRemote.internalAccess().putNewChild(fileRemote);
                        }
                        System.out.println("FileAccessorLocalJava6.refreshFilePropertiesAndChildren - ok refresh; " + fileArray.length + " files; dt=" + (System.currentTimeMillis() - this.time));
                    }
                }
                this.fileRemote.timeChildren = System.currentTimeMillis();
                if (this.callback != null) {
                    this.callback.occupy(FileAccessorLocalJava6.this.evSrc, true);
                    l = System.currentTimeMillis();
                    System.out.println("FileAccessorLocalJava6.refreshFilePropertiesAndChildren - callback listFiles; dt=" + (l - this.time));
                    this.callback.sendEvent(FileRemote.CallbackCmd.done);
                    l = System.currentTimeMillis();
                    System.out.println("FileAccessorLocalJava6.refreshFilePropertiesAndChildren - finish listFiles; dt=" + (l - this.time));
                }
                this.fileRemote.internalAccess().clrFlagBit(0x20000000);
            }
            catch (Exception exception) {
                System.err.println("FileAccessorLocalJava6.refreshFilePropertiesAndChildren - Thread Excpetion;" + exception.getMessage());
            }
        }
    }

    private class RunRefresh
    implements Runnable {
        final FileRemote fileRemote;
        final FileRemote.CallbackEvent callback;

        RunRefresh(FileRemote fileRemote, FileRemote.CallbackEvent callbackEvent) {
            this.fileRemote = fileRemote;
            this.callback = callbackEvent;
        }

        @Override
        public void run() {
            File file = FileAccessorLocalJava6.this.getLocalFile(this.fileRemote);
            String string = this.fileRemote.getPath();
            if (file.exists()) {
                String string2 = FileSystem.getCanonicalPath(file);
                long l = file.lastModified();
                long l2 = file.length();
                int n = -2147483647;
                if (file.isDirectory()) {
                    n |= 0x10;
                }
                if (file.isHidden()) {
                    n |= 8;
                }
                if (file.canWrite()) {
                    n |= 4;
                }
                if (file.canRead()) {
                    n |= 2;
                }
                if (file.canExecute()) {
                    n |= 0x40;
                }
                if (file.isDirectory()) {
                    n |= 0x10;
                }
                if (file.isDirectory()) {
                    n |= 0x10;
                }
                this.fileRemote._setProperties(l2, l, 0L, 0L, n, file);
                if (file.isAbsolute()) {
                    String string3 = FileSystem.cleanAbsolutePath(string);
                    if (!string2.startsWith(string3)) {
                        this.fileRemote.setSymbolicLinkedPath(string2);
                    } else {
                        this.fileRemote.setCanonicalAbsPath(string2);
                    }
                } else {
                    Assert.stop();
                }
            } else {
                this.fileRemote._setProperties(0L, 0L, 0L, 0L, Integer.MIN_VALUE, file);
            }
            this.fileRemote.timeRefresh = System.currentTimeMillis();
            if (this.callback != null) {
                this.callback.occupy(FileAccessorLocalJava6.this.evSrc, true);
                this.callback.sendEvent(FileRemote.CallbackCmd.done);
            }
        }
    }
}

