/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fblock;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.header2Reflection.CheaderParser;
import org.vishia.util.Debugutil;

public class SmlkSfn {
    public static final String version = "2021-02-20";

    public static List<ZbnfFB> analyseOperations(CheaderParser.ZbnfResultData zbnfResultData) {
        LinkedList<ZbnfFB> linkedList = new LinkedList<ZbnfFB>();
        ZbnfFB zbnfFB = new ZbnfFB();
        int n = 0;
        for (CheaderParser.ZbnfResultFile zbnfResultFile : zbnfResultData.files) {
            for (CheaderParser.ClassC classC : zbnfResultFile.listClassC) {
                for (CheaderParser.HeaderBlockEntry headerBlockEntry : classC.entries) {
                    ZbnfFB zbnfFB2;
                    CheaderParser.HeaderBlockEntry headerBlockEntry2;
                    if (headerBlockEntry instanceof CheaderParser.StructDefinition) {
                        headerBlockEntry2 = (CheaderParser.StructDefinition)headerBlockEntry;
                        zbnfFB = new ZbnfFB();
                        zbnfFB.sBasedOnObject = headerBlockEntry2.sBasedOnObjectJc;
                        continue;
                    }
                    if (!(headerBlockEntry instanceof CheaderParser.MethodDef)) continue;
                    headerBlockEntry2 = (CheaderParser.MethodDef)headerBlockEntry;
                    if (headerBlockEntry.description == null || headerBlockEntry.description.simulinkTag == null) continue;
                    String string = headerBlockEntry.description.simulinkTag;
                    if (string.contains("ctor")) {
                        zbnfFB.dataCtor = new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "!", Whatisit.ctor);
                        zbnfFB.ctor = headerBlockEntry2;
                        zbnfFB.dPorts = null;
                        zbnfFB.tlcParam = null;
                        zbnfFB.init = null;
                        zbnfFB.upd = null;
                        zbnfFB.portSteps.clear();
                        continue;
                    }
                    if (string.contains("dtor")) {
                        zbnfFB.dataDtor = new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "~", Whatisit.dtor);
                        zbnfFB.dtor = headerBlockEntry2;
                        continue;
                    }
                    if (string.contains("init")) {
                        zbnfFB.dataInit = new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "Tinit", Whatisit.init);
                        zbnfFB.init = headerBlockEntry2;
                        zbnfFB.upd = null;
                        zbnfFB.dataUpd = null;
                        zbnfFB.portSteps.clear();
                        continue;
                    }
                    if (string.contains("update")) {
                        zbnfFB.dataUpd = new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "+Tstep", Whatisit.oper);
                        zbnfFB.upd = headerBlockEntry2;
                        continue;
                    }
                    if (string.contains("defTlcParam")) {
                        zbnfFB.dataTlcParam = new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "%", Whatisit.defTcl);
                        zbnfFB.tlcParam = headerBlockEntry2;
                        continue;
                    }
                    if (string.contains("defPortTypes")) {
                        zbnfFB.dataDPorts = new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "@", Whatisit.defPortTypes);
                        zbnfFB.dPorts = headerBlockEntry2;
                        continue;
                    }
                    if (string.contains("portStep") || string.contains("step2")) {
                        zbnfFB.portSteps.add(new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "Tstep" + Integer.toString(++n), Whatisit.oper));
                        continue;
                    }
                    if (string.contains("Operation-FB")) {
                        zbnfFB2 = new ZbnfFB();
                        zbnfFB2.prepareOperationsFB((CheaderParser.MethodDef)headerBlockEntry2);
                        linkedList.add(zbnfFB2);
                        continue;
                    }
                    if (!string.contains("Object-FB")) continue;
                    zbnfFB.dataOp = new ZbnfOpData((CheaderParser.MethodDef)headerBlockEntry2, "Tstep", Whatisit.oper);
                    zbnfFB.op = headerBlockEntry2;
                    zbnfFB.name = ((CheaderParser.MethodDef)headerBlockEntry2).name;
                    if (zbnfFB.name.equals("param_PIDf_Ctrl_emC")) {
                        Debugutil.stop();
                    }
                    zbnfFB.prepareObjectFB();
                    linkedList.add(zbnfFB);
                    zbnfFB2 = new ZbnfFB();
                    zbnfFB2.sBasedOnObject = zbnfFB.sBasedOnObject;
                    zbnfFB2.dataCtor = zbnfFB.dataCtor;
                    zbnfFB2.dataDtor = zbnfFB.dataDtor;
                    zbnfFB2.dataInit = zbnfFB.dataInit;
                    zbnfFB2.dataDPorts = zbnfFB.dataDPorts;
                    zbnfFB2.dataTlcParam = zbnfFB.dataTlcParam;
                    zbnfFB2.ctor = zbnfFB.ctor;
                    zbnfFB2.dtor = zbnfFB.dtor;
                    zbnfFB2.init = zbnfFB.init;
                    zbnfFB2.dPorts = zbnfFB.dPorts;
                    zbnfFB2.tlcParam = zbnfFB.tlcParam;
                    zbnfFB = zbnfFB2;
                }
            }
        }
        return linkedList;
    }

    static enum Whatisit {
        ctor(true, true, false),
        dtor(false, false, false),
        init(true, false, false),
        oper(false, false, true),
        defTcl(false, false, false),
        defPortTypes(false, false, false);

        final boolean bArgIsNonTunableParam;
        final boolean bParamIsTunable;
        final boolean bInit;

        private Whatisit(boolean bl, boolean bl2, boolean bl3) {
            this.bInit = bl;
            this.bArgIsNonTunableParam = bl2;
            this.bParamIsTunable = bl3;
        }
    }

    public static class ZbnfFB {
        public String name;
        public String sBasedOnObject;
        public boolean bObject;
        public boolean bStatic = true;
        public CheaderParser.AttributeOrTypedef thizAttr;
        public boolean isFBstep;
        final List<ZbnfPort> inPorts = new LinkedList<ZbnfPort>();
        final List<ZbnfPort> outPorts = new LinkedList<ZbnfPort>();
        final List<ZbnfPort> paramPorts = new LinkedList<ZbnfPort>();
        final Map<String, ZbnfPort> allArgsIx = new TreeMap<String, ZbnfPort>();
        public boolean busInputCheck;
        public boolean busInputGather;
        public boolean busOutputCheck;
        public boolean busOutputGather;
        public boolean bVarg = false;
        public int ixParamTstep = -1;
        public int ixParamTstep2 = -1;
        public int ixParamStep = 0;
        public int ixParamUpd = 0;
        public int ixParamStep2 = 0;
        public int ixParamInit = 0;
        public int ixParamCtor = 0;
        public int ixInputStep = 0;
        public int ixInputUpd = 0;
        public int ixInputStep2 = 0;
        public int ixInputInit = 0;
        public int ixInputThiz = -1;
        public int ixOutputStep = 0;
        public int ixOutputStep2 = 0;
        public int ixOutputInit = 0;
        public int ixOutputVarg = 0;
        public int ixOutputThizStep = -1;
        public int ixOutputThizInit = -1;
        public int nrofParamsNoTunable = 0;
        public int nrofParamsTunable = 0;
        public int nrofParams = 0;
        public int nrofInputs = 0;
        public int nrofOutputs = 0;
        public int nrofPorts = 0;
        public int nrofPortsMax = 64;
        public StringBuilder paramBitsTunable = new StringBuilder("0");
        public int bitsParamTunable = 0;
        public Map<String, ZbnfPort> paramsNoTunable = new TreeMap<String, ZbnfPort>();
        public int ixDworkThiz = -1;
        public int ixDworkBus = -1;
        public int nrofDwork = 0;
        public int ixPworkFBinfo = -1;
        public int nrofPwork = 0;
        public int ixBusInfo = 0;
        List<String> busTypes;
        ZbnfOpData dataCtor;
        ZbnfOpData dataDtor;
        ZbnfOpData dataInit;
        ZbnfOpData dataTlcParam;
        ZbnfOpData dataDPorts;
        ZbnfOpData dataUpd;
        ZbnfOpData dataOp;
        CheaderParser.MethodDef ctor;
        CheaderParser.MethodDef dtor;
        CheaderParser.MethodDef init;
        CheaderParser.MethodDef tlcParam;
        CheaderParser.MethodDef dPorts;
        CheaderParser.MethodDef upd;
        CheaderParser.MethodDef op;
        final List<ZbnfOpData> portSteps = new LinkedList<ZbnfOpData>();

        public void checkArgs(ZbnfOpData zbnfOpData) {
            if (zbnfOpData == null) {
                return;
            }
            CheaderParser.MethodDef methodDef = zbnfOpData.zbnfOp;
            for (CheaderParser.AttributeOrTypedef attributeOrTypedef : methodDef.args) {
                Object object;
                String string = attributeOrTypedef.name;
                if (attributeOrTypedef.name.endsWith("_bus") || attributeOrTypedef.name.endsWith("_ybus")) {
                    if (this.busTypes == null) {
                        this.busTypes = new LinkedList<String>();
                    }
                    this.busTypes.add(attributeOrTypedef.type.basename);
                }
                if (string.equals("thiz")) {
                    if (this.thizAttr != null) continue;
                    this.thizAttr = attributeOrTypedef;
                    this.bStatic = false;
                    this.sBasedOnObject = attributeOrTypedef.type.typeClass().sBasedOnObjectJc;
                    continue;
                }
                if (string.equals("othiz")) {
                    this.bStatic = false;
                    this.bObject = true;
                    continue;
                }
                if (string.equals("Tstep")) {
                    if (this.allArgsIx.get(string) != null) continue;
                    ZbnfPort zbnfPort = new ZbnfPort(attributeOrTypedef, string, zbnfOpData.steptime, WhatPort.tstepParam, this.nrofParams++);
                    this.paramPorts.add(zbnfPort);
                    this.paramsNoTunable.put(string, zbnfPort);
                    this.allArgsIx.put(string, zbnfPort);
                    this.ixParamTstep = zbnfPort.nr;
                    ++this.nrofParamsNoTunable;
                    continue;
                }
                if (attributeOrTypedef.name.startsWith("vport_")) {
                    this.bVarg = true;
                    if (attributeOrTypedef.arraysize != null && attributeOrTypedef.arraysize.value != 0) {
                        this.nrofPortsMax += attributeOrTypedef.arraysize.value;
                        continue;
                    }
                    ++this.nrofPortsMax;
                    continue;
                }
                if (attributeOrTypedef.name.startsWith("_zVaargs_")) {
                    this.bVarg = true;
                    continue;
                }
                if (attributeOrTypedef.name.equals("_simtime")) continue;
                if (string.endsWith("_y") || string.endsWith("_ybus")) {
                    if (this.allArgsIx.get(string) != null) continue;
                    WhatPort whatPort = zbnfOpData.whatisit.bInit ? WhatPort.outInit : WhatPort.outStep;
                    object = new ZbnfPort(attributeOrTypedef, string, zbnfOpData.steptime, whatPort, this.nrofOutputs++);
                    this.outPorts.add((ZbnfPort)object);
                    this.allArgsIx.put(string, (ZbnfPort)object);
                    continue;
                }
                if (string.endsWith("_param")) {
                    if (this.allArgsIx.get(string) != null) continue;
                    boolean bl = zbnfOpData.whatisit.bParamIsTunable && !attributeOrTypedef.type.name.equals("StringJc");
                    object = bl ? WhatPort.tunableParam : WhatPort.fixParam;
                    ZbnfPort zbnfPort = new ZbnfPort(attributeOrTypedef, string, zbnfOpData.steptime, (WhatPort)((Object)object), this.nrofParams++);
                    this.paramPorts.add(zbnfPort);
                    this.allArgsIx.put(string, zbnfPort);
                    if (bl) {
                        this.bitsParamTunable |= 1 << zbnfPort.nr;
                        ++this.nrofParamsTunable;
                        continue;
                    }
                    ++this.nrofParamsNoTunable;
                    this.paramsNoTunable.put(string, zbnfPort);
                    continue;
                }
                if (attributeOrTypedef.type.basename.equals("DefPortTypes_emC") || attributeOrTypedef.type.basename.equals("EDefPortTypes_emC")) {
                    if (this.ixPworkFBinfo != -1) continue;
                    this.ixPworkFBinfo = this.nrofPwork++;
                    continue;
                }
                if (zbnfOpData.whatisit.bArgIsNonTunableParam) {
                    if (this.allArgsIx.get(string) != null) continue;
                    ZbnfPort zbnfPort = new ZbnfPort(attributeOrTypedef, string, zbnfOpData.steptime, WhatPort.fixParam, this.nrofParams++);
                    this.paramPorts.add(zbnfPort);
                    this.allArgsIx.put(string, zbnfPort);
                    ++this.nrofParamsNoTunable;
                    this.paramsNoTunable.put(string, zbnfPort);
                    continue;
                }
                if (this.allArgsIx.get(string) != null) continue;
                WhatPort whatPort = zbnfOpData.whatisit.bInit ? WhatPort.inpInit : WhatPort.inpStep;
                object = new ZbnfPort(attributeOrTypedef, string, zbnfOpData.steptime, whatPort, this.nrofInputs++);
                this.inPorts.add((ZbnfPort)object);
                this.allArgsIx.put(string, (ZbnfPort)object);
            }
        }

        public void prepareObjectFB() {
            Object object2;
            CheaderParser.AttributeOrTypedef attributeOrTypedef = this.op.args.get(0);
            if (attributeOrTypedef.name.equals("thiz")) {
                this.thizAttr = attributeOrTypedef;
            } else if (this.thizAttr == null && this.ctor.type != null) {
                this.thizAttr = new CheaderParser.AttributeOrTypedef("return");
                this.thizAttr.type = this.ctor.type;
                this.thizAttr.name = "return";
            }
            if (this.op.description.simulinkTag.contains("fnCallTrg")) {
                object2 = "trg";
                ZbnfPort object3 = new ZbnfPort(this.thizAttr, (String)object2, "Tstep", WhatPort.fnCallTrgOut, this.nrofOutputs++);
                this.outPorts.add(object3);
                this.allArgsIx.put((String)object2, object3);
            }
            if (this.op.description.simulinkTag.contains("step-in")) {
                object2 = "step-in";
                ZbnfPort zbnfPort = new ZbnfPort(null, (String)object2, "Tstep", WhatPort.stepIn, this.nrofInputs++);
                this.inPorts.add(zbnfPort);
                this.allArgsIx.put((String)object2, zbnfPort);
            }
            if (this.op.description.simulinkTag.contains("step-out")) {
                object2 = "step-out";
                ZbnfPort zbnfPort = new ZbnfPort(null, (String)object2, "Tstep", WhatPort.stepOut, this.nrofOutputs++);
                this.outPorts.add(zbnfPort);
                this.allArgsIx.put((String)object2, zbnfPort);
            }
            this.ixInputStep = this.nrofInputs;
            this.ixOutputStep = this.nrofOutputs;
            this.ixParamStep = this.nrofParams;
            this.checkArgs(this.dataOp);
            this.ixInputUpd = this.nrofInputs;
            this.ixParamUpd = this.nrofParams;
            this.checkArgs(this.dataUpd);
            this.ixInputStep2 = this.nrofInputs;
            this.ixOutputStep2 = this.nrofOutputs;
            this.ixParamStep2 = this.nrofParams;
            for (ZbnfOpData zbnfOpData : this.portSteps) {
                this.checkArgs(zbnfOpData);
            }
            this.ixInputInit = this.nrofInputs;
            this.ixOutputInit = this.nrofOutputs;
            this.ixParamInit = this.nrofParams;
            if (this.init != null) {
                this.checkArgs(this.dataInit);
            }
            this.ixOutputVarg = this.nrofOutputs;
            this.ixParamCtor = this.nrofParams;
            if (this.ctor != null) {
                this.checkArgs(this.dataCtor);
            }
            this.ixDworkThiz = 0;
            this.nrofDwork = 1;
            if (this.ctor == null && !this.bStatic) {
                object2 = "thiz";
                ZbnfPort zbnfPort = new ZbnfPort(null, (String)object2, "Tstep", WhatPort.thisIn, this.nrofInputs++);
                this.ixInputThiz = zbnfPort.nr;
                this.inPorts.add(zbnfPort);
                this.allArgsIx.put((String)object2, zbnfPort);
            }
            if (this.ctor != null && !this.op.description.simulinkTag.contains("no-thizStep")) {
                object2 = "thizo";
                ZbnfPort zbnfPort = new ZbnfPort(this.thizAttr, (String)object2, "Tstep", WhatPort.thisOutStep, this.nrofOutputs++);
                this.ixOutputThizStep = zbnfPort.nr;
                this.outPorts.add(zbnfPort);
                this.allArgsIx.put((String)object2, zbnfPort);
            }
            if (this.ctor != null && !this.op.description.simulinkTag.contains("no-thizInit")) {
                object2 = "ithizo";
                ZbnfPort zbnfPort = new ZbnfPort(this.thizAttr, (String)object2, "Tinit", WhatPort.thisOutInit, this.nrofOutputs++);
                this.ixOutputThizInit = zbnfPort.nr;
                this.outPorts.add(zbnfPort);
                this.allArgsIx.put((String)object2, zbnfPort);
            }
            this.nrofPorts = this.nrofInputs + this.nrofOutputs;
        }

        void prepareOperationsFB(CheaderParser.MethodDef methodDef) {
            this.name = methodDef.name;
            this.dataOp = new ZbnfOpData(methodDef, "Tstep", Whatisit.oper);
            this.op = methodDef;
            if (this.name.equals("addObj_DataNode_Inspc")) {
                Debugutil.stop();
            }
            this.checkArgs(this.dataOp);
            if (this.thizAttr != null) {
                String string = "thiz";
                ZbnfPort zbnfPort = new ZbnfPort(this.thizAttr, string, "Tstep", WhatPort.thisIn, this.nrofInputs++);
                this.inPorts.add(zbnfPort);
                this.allArgsIx.put(string, zbnfPort);
                this.ixInputThiz = zbnfPort.nr;
            }
            this.ixInputUpd = this.ixInputStep2 = this.nrofInputs;
            this.ixInputInit = this.ixInputStep2;
            this.ixOutputStep2 = this.ixOutputVarg = this.nrofOutputs;
            this.ixOutputInit = this.ixOutputVarg;
            this.ixParamStep2 = this.ixParamCtor = this.nrofParams;
            this.ixParamUpd = this.ixParamCtor;
            this.ixParamInit = this.ixParamCtor;
            this.isFBstep = true;
            this.ixDworkThiz = -1;
            this.nrofDwork = 0;
            this.nrofPorts = this.nrofInputs + this.nrofOutputs;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ZbnfPort {
        final CheaderParser.AttributeOrTypedef zbnfArg;
        final String name;
        final String tstep;
        final String sEnum_SetDefPortTypes;
        final int nr;
        final WhatPort whatis;

        public ZbnfPort(CheaderParser.AttributeOrTypedef attributeOrTypedef, String string, String string2, WhatPort whatPort, int n) {
            this.zbnfArg = attributeOrTypedef;
            this.name = string;
            this.tstep = string2;
            this.whatis = whatPort;
            this.sEnum_SetDefPortTypes = whatPort.sEnum_SetDefPortTypes;
            this.nr = n;
        }

        public String toString() {
            return this.name + " @" + this.nr + this.tstep;
        }
    }

    static enum WhatPort {
        thisIn(false, "mInputStep_Entry_DefPortType_emC"),
        stepIn(false, "mStepIn_Entry_DefPortType_emC"),
        stepOut(false, "mStepOut_Entry_DefPortType_emC"),
        fnCallTrgOut(false, "mOutputFnCall_Entry_DefPortType_emC"),
        thisOutInit(false, "mOutputThizInit_Entry_DefPortType_emC"),
        thisOutStep(false, "mOutputThizStep_Entry_DefPortType_emC"),
        inpInit(false, "mInputInit_Entry_DefPortType_emC"),
        inpStep(false, "mInputStep_Entry_DefPortType_emC"),
        inpStep2(false, "mInputStep2_Entry_DefPortType_emC"),
        outInit(false, "mOutputInit_Entry_DefPortType_emC"),
        outStep(false, "mOutputStep_Entry_DefPortType_emC"),
        outStep2(false, "mOutputStep2_Entry_DefPortType_emC"),
        tunableParam(true, "tunable"),
        fixParam(true, "non-tunable"),
        tstepParam(true, "Tstep, non tunable");

        final String sEnum_SetDefPortTypes;
        final boolean bParam;

        private WhatPort(boolean bl, String string2) {
            this.bParam = bl;
            this.sEnum_SetDefPortTypes = string2;
        }
    }

    public static class ZbnfOpData {
        final CheaderParser.MethodDef zbnfOp;
        final String steptime;
        final Whatisit whatisit;

        public ZbnfOpData(CheaderParser.MethodDef methodDef, String string, Whatisit whatisit) {
            this.zbnfOp = methodDef;
            this.steptime = string;
            this.whatisit = whatisit;
        }
    }
}

