/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.communication;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class TCPexampleSimple {
    byte[] serverAddrBytes = new byte[]{127, 0, 0, 1};
    InetAddress serverAddr;
    ServerSocket serverSo;
    Socket s2;
    boolean bRun = true;

    TCPexampleSimple() {
        try {
            this.serverAddr = InetAddress.getByAddress(this.serverAddrBytes);
            this.serverSo = new ServerSocket(44544, 10, this.serverAddr);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException.toString());
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    void openAndAccept() {
        do {
            try {
                Socket socket = this.serverSo.accept();
                ServiceForClient serviceForClient = new ServiceForClient();
                serviceForClient.soToClient = socket;
                Thread thread = new Thread(serviceForClient);
                thread.start();
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
            }
        } while (this.bRun);
    }

    public static void main(String[] stringArray) {
        TCPexampleSimple tCPexampleSimple = new TCPexampleSimple();
        tCPexampleSimple.openAndAccept();
    }

    static class ServiceForClient
    implements Runnable {
        Socket soToClient;

        ServiceForClient() {
        }

        void setSocket(Socket socket) {
            this.soToClient = socket;
        }

        @Override
        public void run() {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.soToClient.getInputStream());
                OutputStream outputStream = this.soToClient.getOutputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                this.writeOutput(bufferedReader);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            try {
                this.soToClient.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }

        void writeOutput(BufferedReader bufferedReader) throws IOException {
            boolean bl = true;
            do {
                String string;
                if ((string = bufferedReader.readLine()) == null) {
                    bl = false;
                }
                System.out.println(string);
            } while (bl);
            System.out.println("==Client has closed. ==");
        }
    }
}

