/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.communication;

import java.io.IOException;
import java.text.ParseException;
import org.vishia.communication.Address_InterProcessComm;
import org.vishia.communication.InterProcessComm;
import org.vishia.communication.InterProcessCommFactory;
import org.vishia.communication.InterProcessCommFactorySocket;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.mainCmd.Report;
import org.vishia.util.StringFormatter;

public class SocketTester {
    final CmdArgs args;
    final Report report;
    InterProcessComm comm;
    Address_InterProcessComm dstAddress;
    Address_InterProcessComm ownAddress;
    Address_InterProcessComm senderAddress;
    final MainCmd_ifc main;

    SocketTester(CmdArgs cmdArgs, Report report, MainCmd_ifc mainCmd_ifc) {
        this.report = report;
        this.args = cmdArgs;
        this.main = mainCmd_ifc;
    }

    public static void main(String[] stringArray) {
        CmdLine cmdLine = new CmdLine(stringArray);
        boolean bl = true;
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            cmdLine.setExitErrorLevel(5);
            cmdLine.exit();
        }
        SocketTester socketTester = new SocketTester(cmdLine.args, cmdLine, cmdLine);
        new InterProcessCommFactorySocket();
        socketTester.execute();
        cmdLine.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void execute() {
        InterProcessCommFactory interProcessCommFactory = InterProcessCommFactory.getInstance();
        this.comm = interProcessCommFactory.create(this.args.sOwnAddress);
        this.dstAddress = this.comm.createAddress("127.0.0.1", this.args.nDestinationPort);
        this.senderAddress = this.comm.createAddress();
        this.ownAddress = this.comm.createAddress(this.args.sOwnAddress);
        int n = this.comm.open(this.ownAddress, true);
        if (n < 0) {
            this.main.writeError("Problem at open socket" + this.comm.translateErrorMsg(n));
            return;
        }
        UDPdebugReceiver uDPdebugReceiver = new UDPdebugReceiver(this.args.sFileOut);
        UDPdebugTransmitter uDPdebugTransmitter = new UDPdebugTransmitter();
        uDPdebugReceiver.start();
        System.out.println("SocketTester receives from " + this.args.sOwnAddress);
        try {
            boolean bl = false;
            while (true) {
                System.out.print("+");
                SocketTester socketTester = this;
                synchronized (socketTester) {
                    this.wait(10000L);
                }
            }
        }
        catch (Exception exception) {
            this.main.report("Uncatched Exception on main level:", exception);
            this.main.setExitErrorLevel(3);
        }
    }

    private static class CmdLine
    extends MainCmd {
        CmdArgs args = new CmdArgs();

        CmdLine(String[] stringArray) {
            super(stringArray);
            super.addAboutInfo("UDP-debug-receiver");
            super.addAboutInfo("made by HSchorrig, 2006-04-01");
            super.addHelpInfo("param: -aIADR -pPORT -oOUT");
            super.addHelpInfo("-iIADR  The destination internetAdress, default is localhost");
            super.addHelpInfo("-pPORT  The destination port, default is 1002");
            super.addHelpInfo("-rPORT  The own port, default is UDP:127.0.0.1.0xeac0");
            super.addHelpInfo("-oOUT   File to write the received data.");
            super.addStandardHelpInfo();
        }

        void testStringBufferFormat() {
            byte[] byArray = new byte[16];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)i;
            }
            StringFormatter stringFormatter = new StringFormatter(100);
            stringFormatter.addHexLine(byArray, 0, 16, (short)4);
            try {
                stringFormatter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.reportln(3, stringFormatter.toString());
        }

        @Override
        public boolean testArgument(String string, int n) {
            boolean bl = true;
            if (string.startsWith("-i")) {
                this.args.sDestinationInetAddress = this.getArgument(2);
            } else if (string.startsWith("-p")) {
                String string2 = this.getArgument(2);
                try {
                    Integer n2 = Integer.decode(string2);
                    this.args.nDestinationPort = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.writeError("Parameter -p is not a valid integer:" + string2);
                }
            } else if (string.startsWith("-r")) {
                this.args.sOwnAddress = this.getArgument(2);
            } else if (string.startsWith("-o")) {
                this.args.sFileOut = this.getArgument(2);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        protected void callWithoutArguments() throws ParseException {
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }

    class UDPdebugReceiver
    extends Thread {
        boolean bAbort = false;

        UDPdebugReceiver(String string) {
        }

        @Override
        public void run() {
            int[] nArray = new int[1];
            while (!this.bAbort) {
                byte[] byArray = SocketTester.this.comm.receive(nArray, SocketTester.this.senderAddress);
                if (nArray[0] < 0) {
                    SocketTester.this.main.writeError("receive Error socket:" + SocketTester.this.comm.translateErrorMsg(nArray[0]));
                    this.bAbort = true;
                    continue;
                }
                int n = nArray[0];
                int n2 = 0;
                SocketTester.this.main.writeInfoln("received " + n + "bytes from ");
                while (n > 0) {
                    int n3 = n > 64 ? 64 : n;
                    StringFormatter stringFormatter = new StringFormatter(120);
                    stringFormatter.addHexLine(byArray, n2, n3, (short)4);
                    SocketTester.this.main.writeInfoln(stringFormatter.toString());
                    try {
                        stringFormatter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    n -= n3;
                    n2 += n3;
                }
            }
        }
    }

    class UDPdebugTransmitter
    extends Thread {
        byte[] bufferInput = new byte[100];

        UDPdebugTransmitter() {
        }

        @Override
        public void run() {
            int n = 0;
            while (n >= 0) {
                try {
                    n = System.in.read(this.bufferInput);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n <= 0) continue;
                int n2 = SocketTester.this.comm.send(this.bufferInput, n, SocketTester.this.dstAddress);
                SocketTester.this.main.writeInfoln("sent " + n2 + " bytes:");
                int n3 = n;
                int n4 = 0;
                while (n3 > 0) {
                    int n5 = n3 > 16 ? 16 : n3;
                    StringFormatter stringFormatter = new StringFormatter(120);
                    stringFormatter.addHexLine(this.bufferInput, n4, n5, (short)1);
                    SocketTester.this.main.writeInfoln(stringFormatter.toString());
                    try {
                        stringFormatter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    n3 -= n5;
                    n4 += n5;
                }
                if (n2 >= 0) continue;
                SocketTester.this.main.writeError("sent error: " + SocketTester.this.comm.translateErrorMsg(n2));
            }
        }
    }

    static class CmdArgs {
        String sDestinationInetAddress = "localhost";
        int nDestinationPort = 1002;
        int nReceivePort = 1001;
        String sFileOut = null;
        String sOwnAddress = "UDP:127.0.0.1:0xeac0";

        CmdArgs() {
        }
    }
}

