/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.communication;

import org.vishia.byteData.ByteDataAccessBase;
import org.vishia.reflect.ClassJc;
import org.vishia.util.Java4C;
import org.vishia.util.StringFormatter;

public final class InspcDataExchangeAccess {
    public static final String version = "2016-10-19";
    public static final short maxNrOfChars = 200;
    public static final short kLengthAndString = 201;
    public static final short kReferenceAddr64 = 220;
    public static final short kInvalidHandle = 221;
    public static final short kTypeNoValue = 222;
    public static final short kReferenceAddr = 223;
    public static final short kScalarTypes = 224;
    private static final int[] nrofBytesSpecialTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 4};

    public static int nrofBytesForType(short n) {
        int n2 = n < 200 ? n : (n >= 224 ? ClassJc.nrofBytesScalarTypes[n - 224] : nrofBytesSpecialTypes[n - 200]);
        return n2;
    }

    public static float getFloatChild(short s, ByteDataAccessBase byteDataAccessBase) {
        float f;
        switch (s) {
            case 234: {
                f = byteDataAccessBase.getChildInt(-4);
                break;
            }
            case 232: {
                f = byteDataAccessBase.getChildInt(-1);
                break;
            }
            case 230: {
                f = byteDataAccessBase.getChildInt(-2);
                break;
            }
            case 228: {
                f = byteDataAccessBase.getChildInt(-4);
                break;
            }
            case 226: {
                f = byteDataAccessBase.getChildInteger(-8);
                break;
            }
            case 235: {
                f = byteDataAccessBase.getChildInt(4);
                break;
            }
            case 233: {
                f = byteDataAccessBase.getChildInt(1);
                break;
            }
            case 231: {
                f = byteDataAccessBase.getChildInt(2);
                break;
            }
            case 229: {
                f = byteDataAccessBase.getChildInt(4);
                break;
            }
            case 227: {
                f = byteDataAccessBase.getChildInteger(8);
                break;
            }
            case 236: {
                f = byteDataAccessBase.getChildFloat();
                break;
            }
            case 237: {
                f = (float)byteDataAccessBase.getChildDouble();
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    public static int getIntChild(short s, ByteDataAccessBase byteDataAccessBase) {
        int n;
        switch (s) {
            case 234: {
                n = byteDataAccessBase.getChildInt(-4);
                break;
            }
            case 232: {
                n = byteDataAccessBase.getChildInt(-1);
                break;
            }
            case 230: {
                n = byteDataAccessBase.getChildInt(-2);
                break;
            }
            case 228: {
                n = byteDataAccessBase.getChildInt(-4);
                break;
            }
            case 226: {
                n = (int)byteDataAccessBase.getChildInteger(-8);
                break;
            }
            case 235: {
                n = byteDataAccessBase.getChildInt(4);
                break;
            }
            case 233: {
                n = byteDataAccessBase.getChildInt(1);
                break;
            }
            case 231: {
                n = byteDataAccessBase.getChildInt(2);
                break;
            }
            case 229: {
                n = byteDataAccessBase.getChildInt(4);
                break;
            }
            case 227: {
                n = (int)byteDataAccessBase.getChildInteger(8);
                break;
            }
            case 236: {
                n = (int)byteDataAccessBase.getChildFloat();
                break;
            }
            case 237: {
                n = (int)byteDataAccessBase.getChildDouble();
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Java4C.ExtendsOnlyMethods
    public static final class InspcAnswerValueByHandle
    extends Inspcitem {
        public static final int sizeofElement = 12;

        public InspcAnswerValueByHandle() {
            super(12);
            this.setBigEndian(true);
        }

        public InspcAnswerValueByHandle(Inspcitem inspcitem) {
            super(12);
            this.setBigEndian(true);
            this.assignCasted(inspcitem, 0, 0);
        }

        public final int getIxHandleFrom() {
            return this._getInt(8, 2);
        }

        public final int getIxHandleTo() {
            return this._getInt(10, 2);
        }

        public final void setIxHandleFrom(int n) {
            this._setInt(8, 2, n);
        }

        public final void setIxHandleTo(int n) {
            this._setInt(10, 2, n);
        }
    }

    @Java4C.ExtendsOnlyMethods
    public static final class InspcSetValueData
    extends Inspcitem {
        public static final int sizeofElement = 32;

        public InspcSetValueData() {
            super(32);
            this.setBigEndian(true);
        }

        @Java4C.Inline
        public final void setAddress(int n) {
            this._setLong(8, 4, n);
        }

        @Java4C.Inline
        public final void setPosition(int n) {
            this._setLong(12, 4, n);
        }

        public final void setBool(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setBool((byte)n);
            inspcSetValue.detach();
        }

        public final void setShort(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setShort((short)n);
            inspcSetValue.detach();
        }

        public final void setByte(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setByte((byte)n);
            inspcSetValue.detach();
        }

        public final void setInt(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setInt(n);
            inspcSetValue.detach();
        }

        public final void setFloat(float f) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setFloat(f);
            inspcSetValue.detach();
        }

        public final void setFloatIntImage(int n) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setFloatIntImage(n);
            inspcSetValue.detach();
        }

        public final void setDouble(double d) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setDouble(d);
            inspcSetValue.detach();
        }

        public final void setLong(long l) {
            InspcSetValue inspcSetValue = new InspcSetValue();
            this.addChildAt(16, inspcSetValue);
            inspcSetValue.setLong(l);
            inspcSetValue.detach();
        }

        @Java4C.Inline
        public final void setHead(int n) {
            super.setInfoHead(32, 80, n);
        }
    }

    @Java4C.ExtendsOnlyMethods
    public static final class InspcSetValue
    extends ByteDataAccessBase {
        public static final int sizeofElement = 16;
        private static final int kType = 7;

        public InspcSetValue() {
            super(16);
            this.setBigEndian(true);
        }

        @Java4C.Inline
        public final long getPwd() {
            return this._getLong(0, 6);
        }

        @Java4C.Inline
        public final void setPwd(int n) {
            this._setLong(0, 6, n);
        }

        @Java4C.Inline
        public final short getType() {
            return (short)this._getLong(7, 1);
        }

        @Java4C.Inline
        public final byte getByte() {
            return (byte)this._getLong(15, -1);
        }

        @Java4C.Inline
        public final short getShort() {
            return (short)this._getLong(14, -2);
        }

        @Java4C.NoStackTrace
        public final int getInt() {
            switch (this.getType()) {
                case 237: {
                    return (int)this.getDouble(8);
                }
                case 236: {
                    return (int)this.getFloat(12);
                }
            }
            return (int)this._getLong(8, -8);
        }

        @Java4C.NoStackTrace
        public final long getLong() {
            switch (this.getType()) {
                case 237: {
                    return (int)this.getDouble(8);
                }
                case 236: {
                    return (int)this.getFloat(12);
                }
            }
            return this._getLong(8, -8);
        }

        @Java4C.NoStackTrace
        public final float getFloat() {
            switch (this.getType()) {
                case 237: {
                    return (float)this.getDouble(8);
                }
                case 236: {
                    return this.getFloat(12);
                }
            }
            return this._getLong(8, -8);
        }

        @Java4C.Inline
        public final double getDouble() {
            return this.getDouble(8);
        }

        @Java4C.Inline
        public final void setBool(int n) {
            this.clearData();
            this._setLong(7, 1, 246L);
            this._setLong(15, 1, n);
        }

        @Java4C.Inline
        public final void setByte(int n) {
            this.clearData();
            this._setLong(7, 1, 232L);
            this._setLong(15, 1, n);
        }

        @Java4C.Inline
        public final void setShort(int n) {
            this.clearData();
            this._setLong(7, 1, 230L);
            this._setLong(14, 2, n);
        }

        @Java4C.Inline
        public final void setInt(int n) {
            this.clearData();
            this._setLong(7, 1, 228L);
            this._setLong(12, 4, n);
        }

        @Java4C.Inline
        public final void setLong(long l) {
            this.clearData();
            this._setLong(7, 1, 226L);
            this._setLong(8, 8, l);
        }

        @Java4C.Inline
        public final void setFloat(float f) {
            this.clearData();
            this._setLong(7, 1, 236L);
            this.setFloat(12, f);
        }

        @Java4C.Inline
        public final void setFloatIntImage(int n) {
            this.clearData();
            this._setLong(7, 1, 236L);
            this._setLong(12, 4, n);
        }

        @Java4C.Inline
        public final void setDouble(double d) {
            this.clearData();
            this._setLong(7, 1, 237L);
            this.setDouble(8, d);
        }
    }

    public static class Inspcitem
    extends ByteDataAccessBase {
        private static final int kbyteOrder = 4;
        public static final int sizeofHead = 8;
        public static final int kGetFields = 16;
        public static final int kAccessCheck = 17;
        public static final int kAnswerFieldMethod = 20;
        public static final int kRegisterHandle = 35;
        public static final int kAnswerRegisterHandle = 35;
        public static final int kFailedRegisterRepeat = 36;
        public static final int kGetValueByHandle = 37;
        public static final int kAnswerValueByHandle = 37;
        public static final int kAnswerValue = 38;
        public static final int kFailedValue = 39;
        public static final int kFailedHandle = 40;
        public static final int kGetValueByPath = 48;
        public static final int kGetAddressByPath = 50;
        public static final int kSetValueByPath = 53;
        public static final int kSetStringByPath = 54;
        public static final int kGetMsg = 64;
        public static final int kAnswerMsg = 320;
        public static final int kRemoveMsg = 65;
        public static final int kAnswerRemoveMsgOk = 321;
        public static final int kAnswerRemoveMsgNok = 577;
        public static final int kSetvaluedata = 80;
        public static final int kAnswervaluedata = 336;
        public static final int kFailedPath = 254;
        public static final int kNoRessource = 253;
        public static final int kFailedCommand = 255;

        protected Inspcitem(int n) {
            super(n);
        }

        public Inspcitem() {
            super(8);
        }

        public final void setInfoHead(int n, int n2, int n3) {
            this.setInt16(0, n);
            this.setInt16(2, n2);
            this.setInt32(4, n3);
            int n4 = n >= 8 ? n : 8;
            this.setLengthElement(n4);
        }

        @Java4C.Inline
        public final void setLength(int n) {
            this.setInt16(0, n);
            this.setLengthElement(n);
        }

        @Java4C.Inline
        public final void setCmd(int n) {
            this.setInt16(2, n);
        }

        @Java4C.Inline
        public final int getCmd() {
            return this.getInt16(2);
        }

        @Java4C.Inline
        public final int getLenInfo() {
            return this.getInt16(0);
        }

        @Java4C.Inline
        public final int getOrder() {
            return this.getInt32(4);
        }

        @Override
        @Java4C.Exclude
        public void infoFormattedAppend(StringFormatter stringFormatter) {
            String string;
            int n = this.getCmd();
            int n2 = this.getLenInfo();
            int n3 = -1;
            switch (n) {
                case 16: {
                    string = "getFields ";
                    n3 = 8;
                    break;
                }
                case 48: {
                    string = "getValueByPath ";
                    n3 = 8;
                    break;
                }
                case 50: {
                    string = "getAddressByPath ";
                    n3 = 8;
                    break;
                }
                case 53: {
                    string = "setValueByPath ";
                    break;
                }
                case 54: {
                    string = "setStringByPath ";
                    break;
                }
                case 254: {
                    string = "failedPath ";
                    break;
                }
                case 253: {
                    string = "noRessource ";
                    break;
                }
                case 255: {
                    string = "failedCmd ";
                    break;
                }
                case 38: {
                    string = "answerValue ";
                    break;
                }
                case 64: {
                    string = "getMsg ";
                    break;
                }
                default: {
                    string = Integer.toHexString(n);
                }
            }
            String string2 = n3 > 0 ? this.getString(n3, n2 - n3) : "";
            this.infoAppendHead(stringFormatter, 8);
            stringFormatter.add(string).add(string2);
        }
    }

    public static final class InspcDatagram
    extends ByteDataAccessBase {
        private static final int knrofBytes = 0;
        private static final int knEntrant = 2;
        private static final int kencryption = 4;
        private static final int kseqnr = 8;
        private static final int kanswerNr = 12;
        private static final int kspare13 = 13;
        private static final int kspare14 = 14;
        public static final int sizeofHead = 16;

        public InspcDatagram(@Java4C.PtrVal byte[] byArray) {
            super(16);
            this.assign(byArray, -1, 0);
            super.setBigEndian(true);
        }

        public InspcDatagram() {
            super(16);
            this.setBigEndian(true);
        }

        @Java4C.Inline
        public final void assignDatagram(@Java4C.PtrVal byte[] byArray, int n) {
            super.assign(byArray, n, 0);
        }

        @Java4C.Inline
        public final void setLengthDatagram(int n) {
            this.setInt16(0, n);
        }

        @Java4C.Inline
        public final int getLengthDatagram() {
            return this.getInt16(0);
        }

        public final void setHeadRequest(int n, int n2, int n3) {
            this.setInt16(0, 16);
            this.setInt16(2, n);
            this.setInt32(8, n2);
            this.setInt8(12, 0);
            this.setInt8(13, 0);
            this.setInt16(14, 0);
            this.setInt32(4, n3);
        }

        public final void setHeadAnswer(int n, int n2, int n3) {
            this.setInt16(0, 16);
            this.setInt16(2, n);
            this.setInt32(8, n2);
            this.setInt8(12, 0);
            this.setInt8(13, 0);
            this.setInt16(14, 0);
            this.setInt32(4, n3);
        }

        @Java4C.Inline
        public final void setEntrant(int n) {
            this.setInt16(2, n);
        }

        @Java4C.Inline
        public final int getEntrant() {
            return this.getInt16(2);
        }

        @Java4C.Inline
        public final int getEncryption() {
            return this.getInt32(4);
        }

        @Java4C.Inline
        public final void setSeqnr(int n) {
            this.setInt32(8, n);
        }

        @Java4C.Inline
        public final int getSeqnr() {
            return this.getInt32(8);
        }

        public final void markAnswerNrLast() {
            int n = this.getInt8(12);
            this.setInt8(12, n |= 0x80);
        }

        public final void incrAnswerNr() {
            int n = this.getInt8(12);
            n = (n & 0x7F) + 1;
            assert ((n & 0x80) == 0);
            this.setInt8(12, n);
        }

        @Java4C.Inline
        public final int getAnswerNr() {
            return this.getInt8(12) & 0x7F;
        }

        @Java4C.Inline
        public final boolean lastAnswer() {
            return (this.getInt8(12) & 0x80) == 128;
        }
    }
}

