/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.vishia.util.Assert;
import org.vishia.util.FilepathFilter;
import org.vishia.util.StringFunctions;

public class FileSystem {
    public static final String sVersion = "2016-01-17";

    public static boolean addFilesWithBasePath(File file, String string, List<FileAndBasePath> list) {
        File file2;
        int n;
        CharSequence charSequence;
        Object object;
        String string2;
        int n2;
        String string3 = FileSystem.absolutePath(string, file);
        int n3 = string3.indexOf(58, 2);
        if (n3 < 2 && (n3 = string3.lastIndexOf(47, n2 = string3.indexOf(42))) < 0) {
            n3 = string3.lastIndexOf(92, n2);
        }
        if (n3 >= 0) {
            String string4 = (string3.substring(0, n3) + "/").replace('\\', '/');
            string2 = string3.substring(n3 + 1).replace('\\', '/');
            object = file != null ? file.getAbsolutePath() + "/" + string4 : string4;
            charSequence = FileSystem.normalizePath((CharSequence)object);
            n = charSequence.length();
            file2 = new File(charSequence.toString());
        } else {
            object = file.getAbsolutePath();
            charSequence = FileSystem.normalizePath((CharSequence)object);
            file2 = ((String)object).length() != charSequence.length() ? new File(charSequence.toString()) : file;
            string2 = string3.replace('\\', '/');
            n = charSequence.length();
        }
        object = new FilesWithBasePath(charSequence.toString(), n, list);
        return FileSystem.addFileToList(file2, string2, (AddFileToList)object);
    }

    public static String readFile(File file) {
        String string;
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = (int)file.length();
            char[] cArray = new char[n];
            bufferedReader.read(cArray);
            string = new String(cArray);
            bufferedReader.close();
            ((Reader)fileReader).close();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public static String readFile(File file, Appendable appendable, int[] nArray) {
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n2 = (int)file.length();
            if (n2 > 4096) {
                n2 = 4096;
            }
            char[] cArray = new char[n2];
            do {
                if ((n = bufferedReader.read(cArray)) < 0) continue;
                appendable.append(new String(cArray, 0, n));
                if (nArray == null) continue;
                nArray[0] = nArray[0] + n;
            } while (n > 0);
            bufferedReader.close();
            ((Reader)fileReader).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        return null;
    }

    public static CharSequence readInJar(Class clazz, String string, String string2) {
        try {
            int n;
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            int n2 = inputStream.available();
            StringBuilder stringBuilder = new StringBuilder(n2);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            while ((n = inputStreamReader.read()) != -1) {
                stringBuilder.append((char)n);
            }
            inputStreamReader.close();
            return stringBuilder;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean writeFile(String string, String string2) {
        boolean bl = true;
        try {
            FileWriter fileWriter = new FileWriter(string2, false);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public static boolean writeFile(String string, File file) {
        boolean bl = true;
        try {
            FileWriter fileWriter = new FileWriter(file, false);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public static byte[] readBinFile(File file) {
        byte[] byArray;
        int n = (int)file.length();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byArray = new byte[n];
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public static int readBinFile(File file, byte[] byArray) {
        int n;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            n = ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public static int writeBinFile(File file, byte[] byArray) {
        int n;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
            n = byArray.length;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public static int copyFile(File file, File file2) throws IOException {
        return FileSystem.copyFile(file, file2, true, true, true);
    }

    public static int copyFile(File file, File file2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        FileInputStream fileInputStream;
        int n = 0;
        byte[] byArray = new byte[16384];
        if (file2.exists()) {
            if (!bl2) {
                throw new IllegalArgumentException("FileSystem.copyFile - dst exists, " + file2.getAbsolutePath());
            }
            if (!file2.canWrite()) {
                if (!bl3) {
                    throw new IllegalArgumentException("FileSystem.copyFile - dst is read-only, " + file2.getAbsolutePath());
                }
                file2.setWritable(true);
            }
            if (!file2.delete()) {
                throw new IllegalArgumentException("FileSystem.copyFile - dst cannot be deleted, " + file2.getAbsolutePath());
            }
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            n = -1;
            fileInputStream = null;
        }
        if (fileInputStream != null) {
            int n2;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            do {
                if ((n2 = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
                n += n2;
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
            } while (n2 > 0);
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            if (bl) {
                long l = file.lastModified();
                file2.setLastModified(l);
            }
            if (!file.canWrite()) {
                file2.setWritable(false);
            }
        }
        return n;
    }

    public static void mkDirPath(File file) throws FileNotFoundException {
        if (file.exists()) {
            return;
        }
        String string = file.getAbsolutePath();
        if (file.isDirectory()) {
            string = string + "/";
        }
        FileSystem.mkDirPath(string);
    }

    public static File mkDirPath(String string) throws FileNotFoundException {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n > 0) {
            String string2 = string.substring(0, n);
            File file = new File(string2);
            if (!file.exists() && !file.mkdirs()) {
                throw new FileNotFoundException("Directory path mkdirs failed;" + string);
            }
            if (!file.isDirectory()) {
                throw new FileNotFoundException("path is a file, should be a directoy;" + string);
            }
            return file;
        }
        return new File(".");
    }

    public static boolean delete(String string) {
        boolean bl;
        if (string.indexOf(42) < 0) {
            File file = new File(string);
            bl = file.isDirectory() ? FileSystem.rmdir(file) : file.delete();
        } else {
            LinkedList<File> linkedList = new LinkedList<File>();
            bl = FileSystem.addFileToList(string, linkedList);
            if (bl) {
                for (File file : linkedList) {
                    boolean bl2 = file.delete();
                    if (bl2) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static boolean rmdir(File file) {
        boolean bl;
        if (!file.isDirectory()) {
            file = FileSystem.getDir(file);
        }
        bl = (bl = FileSystem.cleandir(file)) && file.delete();
        return bl;
    }

    public static boolean cleandir(File file) {
        File file2 = file;
        boolean bl = true;
        if (!file2.exists()) {
            bl = file2.mkdirs();
        }
        if (bl) {
            File[] fileArray;
            if (!file2.isDirectory()) {
                file2 = FileSystem.getDir(file2);
            }
            for (File file3 : fileArray = file2.listFiles()) {
                if (file3.isDirectory()) {
                    bl = bl && FileSystem.cleandir(file3);
                }
                bl = bl && file3.delete();
            }
        }
        return bl;
    }

    public static boolean cleandirForced(File file) {
        File[] fileArray;
        File file2 = file;
        boolean bl = true;
        if (!file2.exists()) {
            bl = file2.mkdirs();
        }
        if (!file2.isDirectory()) {
            file2 = FileSystem.getDir(file2);
        }
        for (File file3 : fileArray = file2.listFiles()) {
            if (file3.isDirectory()) {
                bl &= FileSystem.cleandirForced(file3);
            }
            bl &= file3.delete();
        }
        return bl;
    }

    public static boolean copyDir(File file, File file2) {
        File[] fileArray;
        boolean bl = true;
        if (!file2.exists()) {
            bl = file2.mkdirs();
        }
        for (File file3 : fileArray = file.listFiles()) {
            if (file3.isDirectory()) {
                File file4 = new File(file, file3.getName());
                File file5 = new File(file2, file3.getName());
                bl &= FileSystem.copyDir(file4, file5);
                continue;
            }
            try {
                bl &= FileSystem.copyFile(file3, new File(file2, file3.getName())) >= 0;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public static File getDirectory(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("not exists:" + file.getName());
        }
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        File file2 = file.getParentFile();
        return file2;
    }

    public static File[] getFiles(File file, CharSequence charSequence) {
        FilepathFilter filepathFilter = new FilepathFilter(charSequence);
        return file.listFiles(filepathFilter);
    }

    public static File getFirstFileWildcard(File file) {
        String string;
        FilepathFilter filepathFilter;
        File file2 = file.getParentFile();
        File[] fileArray = file2.listFiles(filepathFilter = new FilepathFilter(string = file.getName()));
        if (fileArray != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public static File getDir(File file) {
        if (!file.exists()) {
            return null;
        }
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        File file2 = file.getParentFile();
        return file2;
    }

    public static boolean isAbsolutePath(CharSequence charSequence) {
        char c;
        return charSequence.length() >= 3 && charSequence.charAt(1) == ':' && ((c = charSequence.charAt(2)) == '/' || c == '\\') || charSequence.length() >= 1 && ((c = charSequence.charAt(0)) == '/' || c == '\\');
    }

    public static boolean isAbsolutePathOrDrive(CharSequence charSequence) {
        char c;
        return charSequence.length() >= 2 && charSequence.charAt(1) == ':' || charSequence.length() >= 1 && ((c = charSequence.charAt(0)) == '/' || c == '\\');
    }

    public static String getCanonicalPath(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
            string = string.replace('\\', '/');
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    public static String relativatePath(String string, String string2) {
        int n;
        boolean bl;
        int n2 = 0;
        if (string.startsWith("../../../examples_XML")) {
            FileSystem.stop();
        }
        String string3 = string.substring(n2);
        int n3 = -1;
        do {
            int n4;
            if (!(bl = (n4 = string2.indexOf(47, n3 + 1)) >= 0 ? string.length() >= n4 && string2.substring(0, n4).equals(string.substring(0, n4)) : false)) continue;
            n3 = n4;
        } while (bl);
        String string4 = "";
        int n5 = n3 + 1;
        int n6 = 0;
        while ((n = string2.indexOf(47, n5)) >= 0) {
            if (n == n5 + 2 && string2.substring(n5, n).equals("..")) {
                int n7 = string4.length();
                if (n7 >= 3) {
                    string4 = string4.substring(0, n7 - 3);
                } else {
                    --n6;
                }
            } else if (!(n == n5 || n == n5 + 1 && string2.substring(n5, n).equals("."))) {
                if (n6 < 0) {
                    ++n6;
                } else {
                    string4 = string4 + "../";
                }
            }
            n5 = n + 1;
        }
        String string5 = string4 + (n3 + 1 < string3.length() ? string3.substring(n3 + 1) : "");
        return string5;
    }

    public static String absolutePath(String string, File file) {
        String string2;
        if (string.startsWith("~")) {
            String string3 = System.getenv("HOME");
            string2 = string3 + string.substring(1);
        } else if (!(string.startsWith("/") || string.startsWith("\\") || string.length() >= 3 && (string.substring(1, 3).equals(":/") || string.substring(1, 3).equals(":\\")))) {
            String string4 = file == null ? new File(".").getAbsolutePath() : file.getAbsolutePath();
            string2 = string4 + "/" + string;
        } else {
            string2 = string;
        }
        return FileSystem.normalizePath(string2).toString();
    }

    public static CharSequence normalizePath(File file) {
        return FileSystem.normalizePath(file.getAbsolutePath());
    }

    public static CharSequence normalizePath(CharSequence charSequence) {
        int n;
        int n2;
        int n3;
        CharSequence charSequence2 = charSequence;
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : null;
        int n4 = StringFunctions.indexOf(charSequence, '\\', 0);
        if (n4 >= 0) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charSequence);
                charSequence2 = stringBuilder;
            }
            do {
                stringBuilder.setCharAt(n4, '/');
            } while ((n4 = StringFunctions.indexOf(charSequence, '\\', n4 + 1)) >= 0);
        }
        int n5 = 6;
        int n6 = 0;
        while ((n3 = StringFunctions.indexOf(charSequence2, "//", n6)) >= 0) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charSequence);
                charSequence2 = stringBuilder;
            }
            stringBuilder.delete(n3, n3 + 1);
            n6 = n3;
        }
        n6 = 0;
        while ((n3 = StringFunctions.indexOf(charSequence2, "/./", n6)) >= 0) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charSequence);
                charSequence2 = stringBuilder;
            }
            stringBuilder.delete(n3, n3 + 2);
            n6 = n3;
        }
        n6 = 0;
        while (StringFunctions.startsWith(charSequence2, n6, -1, "../")) {
            n6 += 3;
        }
        while ((n3 = StringFunctions.indexOf(charSequence2, "/../", n6)) >= 0) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charSequence);
                charSequence2 = stringBuilder;
            }
            n2 = stringBuilder.lastIndexOf("/", n3 - 1);
            stringBuilder.delete(n2 + 1, n3 + 4);
            n6 = n2;
        }
        n2 = charSequence2.length();
        while (StringFunctions.endsWith(charSequence2, "/..")) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charSequence);
                charSequence2 = stringBuilder;
            }
            if ((n = stringBuilder.lastIndexOf("/", n2 - 4)) < 0) {
                stringBuilder.setLength(1);
                stringBuilder.setCharAt(0, '.');
                continue;
            }
            if (n == 0 || n == 2 && stringBuilder.charAt(1) == ':') {
                ++n;
            }
            stringBuilder.delete(n, n2);
            n2 = n;
        }
        while (StringFunctions.endsWith(charSequence2, "/.")) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charSequence);
                charSequence2 = stringBuilder;
            }
            if ((n = n2 - 2) == 0 || n == 2 && stringBuilder.charAt(1) == ':') {
                ++n;
            }
            stringBuilder.delete(n, n2);
            n2 = n;
        }
        while (StringFunctions.startsWith(charSequence2, "./")) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(charSequence);
                charSequence2 = stringBuilder;
            }
            stringBuilder.delete(0, 2);
        }
        return charSequence2;
    }

    public static String cleanAbsolutePath(String string) {
        return FileSystem.normalizePath(string).toString();
    }

    public static boolean isSymbolicLink(File file) {
        String string;
        String string2 = FileSystem.absolutePath(file.getAbsolutePath(), null);
        if (string2.equals(string = FileSystem.getCanonicalPath(file))) {
            return false;
        }
        if (File.pathSeparatorChar == '\\') {
            return !(string2 = string2.toLowerCase()).equals(string = string.toLowerCase());
        }
        return true;
    }

    public static int checkNewless(File file, File file2, boolean bl) {
        long l;
        if (!file2.exists()) {
            return 1;
        }
        if (!file.exists()) {
            return -1;
        }
        long l2 = file.lastModified();
        if (l2 > (l = file2.lastModified())) {
            if (bl) {
                if (!file2.canWrite()) {
                    file2.setWritable(true);
                }
                if (file2.delete()) {
                    return 3;
                }
                return 4;
            }
            return 2;
        }
        return 0;
    }

    public static boolean close(Closeable closeable) {
        boolean bl;
        if (closeable == null) {
            return true;
        }
        try {
            closeable.close();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public static boolean addFileToList(String string, List<File> list) {
        string = string.replace('\\', '/');
        return FileSystem.addFileToList(null, string, list);
    }

    public static boolean addFileToList(String string, AddFileToList addFileToList) {
        string = string.replace('\\', '/');
        return FileSystem.addFileToList(null, string, addFileToList);
    }

    public static boolean addFileToList(File file, String string, List<File> list) {
        ListWrapper listWrapper = new ListWrapper(list);
        return FileSystem.addFileToList(file, string, listWrapper);
    }

    private static File buildDir(File file, String string, int n) {
        File file2;
        if (n > 0) {
            String string2 = string.substring(0, n);
            file2 = file == null ? new File(string2) : new File(file, string2);
        } else {
            file2 = file == null ? new File(".") : file;
        }
        return file2;
    }

    private static boolean addFileToList(AddFileToList addFileToList, File file, String string, int n, FilenameFilter filenameFilter, FilenameFilter object, int n2) {
        boolean bl = true;
        if (n2 > 1000) {
            throw new RuntimeException("fatal recursion error");
        }
        int n3 = string.lastIndexOf(47, n) + 1;
        File file2 = FileSystem.buildDir(file, string, n3);
        if (file2.exists()) {
            Object object2;
            int n4 = string.indexOf(47, n);
            boolean bl2 = false;
            String string2 = string.substring(n4 + 1);
            if (string.startsWith("xxxZBNF/")) {
                Assert.stop();
            }
            int n5 = string2.indexOf(42);
            if (n4 >= 0 || object != null) {
                Object[] objectArray;
                if (n4 > 0) {
                    objectArray = string.substring(n3, n4);
                    object2 = new FilepathFilter(string);
                    bl2 = objectArray.equals("**");
                    if (((FilepathFilter)object2).bAllTree) {
                        object = object2;
                        object2 = null;
                    }
                } else {
                    object2 = null;
                }
                if (bl2) {
                    bl = FileSystem.addFileToList(addFileToList, file2, string2, n5, filenameFilter, (FilenameFilter)object, n2 + 1);
                } else {
                    objectArray = file2.list();
                    if (objectArray != null) {
                        Object[] objectArray2 = objectArray;
                        int n6 = objectArray2.length;
                        for (int i = 0; i < n6; ++i) {
                            File file3;
                            Object object3 = objectArray2[i];
                            if (!bl2 && (object2 == null || !((FilepathFilter)object2).accept(file2, (String)object3)) && (object == null || !object.accept(file2, (String)object3)) || !(file3 = new File(file2, (String)object3)).isDirectory()) continue;
                            if (((String)object3).equals("ZBNF")) {
                                Assert.stop();
                            }
                            bl = FileSystem.addFileToList(addFileToList, file3, string2, n5, filenameFilter, (FilenameFilter)object, n2 + 1);
                        }
                    }
                }
            }
            if ((n4 < 0 || bl2) && (object2 = file2.listFiles(filenameFilter)) != null) {
                for (Object object4 : object2) {
                    addFileToList.add((File)object4);
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean addFileToList(File file, String string, AddFileToList addFileToList) {
        boolean bl = true;
        int n = (string = string.replace('\\', '/')).indexOf(42);
        if (n < 0) {
            File file2 = file == null ? new File(string) : new File(file, string);
            bl = file2.exists();
            if (bl) {
                addFileToList.add(file2);
            }
        } else {
            int n2 = string.lastIndexOf(47) + 1;
            String string2 = string.substring(n2);
            FilepathFilter filepathFilter = new FilepathFilter(string2);
            bl = FileSystem.addFileToList(addFileToList, file, string, n, filepathFilter, null, 0);
        }
        return bl;
    }

    public static String grep1line(File file, String string) throws IOException {
        String string2;
        String string3 = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        boolean bl = false;
        while (string3 == null && (string2 = bufferedReader.readLine()) != null) {
            if (!string2.contains(string)) continue;
            string3 = string2;
        }
        bufferedReader.close();
        return string3;
    }

    public static String[] searchInFiles(List<File> list, String string, Appendable appendable) {
        LinkedList linkedList = new LinkedList();
        for (File file : list) {
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(file));
                boolean bl = false;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.contains(string)) continue;
                    if (!bl) {
                        appendable.append("<file=").append(file.getPath()).append(">").append("\n");
                        bl = true;
                    }
                    appendable.append("  ").append(string2).append("\n");
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    appendable.append("<file=").append(file.getPath()).append("> - read error.\n");
                }
                catch (IOException iOException2) {}
            }
        }
        try {
            appendable.append("<done: search in files>\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] stringArray = new String[1];
        return stringArray;
    }

    @Deprecated
    public static File searchInParent(File file, String ... stringArray) {
        File file2 = null;
        File file3 = file.isDirectory() ? file : file.getParentFile();
        do {
            File[] fileArray = file3.listFiles();
            for (String string : stringArray) {
                int n = string.indexOf(47);
                String string2 = n > 0 ? string.substring(0, n) : string;
                for (File file4 : fileArray) {
                    String string3 = file4.getName();
                    if (string3.equals(string2)) {
                        if (n > 0) {
                            String string4 = string;
                            File file5 = file4;
                            block3: while (n > 0 && file5 != null && file5.isDirectory()) {
                                String string5 = (n = (string4 = string4.substring(n + 1)).indexOf(47)) > 0 ? string4.substring(n) : string4;
                                File[] fileArray2 = file5.listFiles();
                                file5 = null;
                                file4 = null;
                                for (File file6 : fileArray2) {
                                    if (!file6.getName().equals(string5)) continue;
                                    file5 = file6;
                                    file4 = file6;
                                    continue block3;
                                }
                            }
                            file2 = file4;
                        } else {
                            file2 = file4;
                        }
                    }
                    if (file2 != null) break;
                }
                if (file2 != null) break;
            }
            file3 = file3.getParentFile();
        } while (file2 == null && file3 != null);
        return file2;
    }

    public static File searchFileInParent(File file, String ... stringArray) {
        File file2 = null;
        File file3 = file.isDirectory() ? (file.isAbsolute() ? file : file.getAbsoluteFile()) : (file.isAbsolute() ? file.getParentFile() : file.getAbsoluteFile().getParentFile());
        do {
            for (String string : stringArray) {
                File[] fileArray = FileSystem.getFiles(file3, string);
                if (fileArray.length > 0) {
                    file2 = fileArray[0];
                    continue;
                }
                file3 = file3.getParentFile();
            }
        } while (file2 == null && file3 != null);
        return file2;
    }

    private static void stop() {
    }

    public static boolean exists(File file) {
        return file.exists();
    }

    public static boolean isRoot(File file) {
        String string = FileSystem.absolutePath(file.getPath(), null);
        return FileSystem.isRoot(string);
    }

    public static boolean isRoot(CharSequence charSequence) {
        return charSequence.equals("/") || charSequence.length() == 3 && charSequence.subSequence(1, 3).equals(":/") || charSequence.equals("\\") || charSequence.length() == 3 && charSequence.subSequence(1, 3).equals(":\\");
    }

    private static class WildcardFilter
    implements FilenameFilter {
        private final String sBefore;
        private final String sBehind;
        private final String sContain;
        private final boolean bAllTree;
        private final boolean bAllEntries;

        public WildcardFilter(String string) {
            this.bAllEntries = string.equals("**");
            if (this.bAllEntries) {
                this.bAllTree = true;
                this.sContain = null;
                this.sBehind = null;
                this.sBefore = null;
            } else {
                int n = string.length();
                int n2 = string.indexOf(42);
                this.bAllTree = n2 <= n - 2 && string.charAt(n2 + 1) == '*';
                int n3 = this.bAllTree ? n2 + 1 : n2;
                int n4 = string.lastIndexOf(42);
                this.sBefore = n2 > 0 ? string.substring(0, n2) : null;
                this.sBehind = n4 < n ? string.substring(n4 + 1) : null;
                this.sContain = n4 > n3 ? string.substring(n2 + 1, n4) : null;
            }
        }

        @Override
        public boolean accept(File file, String string) {
            return !(!this.bAllEntries && (this.sBefore != null && !string.startsWith(this.sBefore) || this.sContain != null && !string.contains(this.sContain) || this.sBehind != null && !string.endsWith(this.sBehind)));
        }
    }

    private static class FilesWithBasePath
    implements AddFileToList {
        final String sPathBase;
        final List<FileAndBasePath> list;
        final int posLocalPath;

        FilesWithBasePath(String string, int n, List<FileAndBasePath> list) {
            this.sPathBase = string;
            this.list = list;
            this.posLocalPath = n;
        }

        @Override
        public void add(File file) {
            String string = file.getAbsolutePath();
            String string2 = this.posLocalPath > 0 && string.length() > this.posLocalPath ? string.substring(this.posLocalPath).replace('\\', '/') : string.replace('\\', '/');
            FileAndBasePath fileAndBasePath = new FileAndBasePath(file, this.sPathBase, string2);
            this.list.add(fileAndBasePath);
        }
    }

    public static class FileAndBasePath {
        public final File file;
        public final String basePath;
        public final String localPath;

        FileAndBasePath(File file, String string, String string2) {
            this.file = file;
            assert (string.indexOf(92) < 0);
            assert (string2.indexOf(92) < 0);
            this.basePath = string;
            this.localPath = string2;
        }

        public String localPath() {
            return this.localPath.startsWith("/") ? this.localPath.substring(1) : this.localPath;
        }

        public String toString() {
            return this.basePath + ":" + this.localPath;
        }
    }

    private static class ListWrapper
    implements AddFileToList {
        private final List<File> files;

        public ListWrapper(List<File> list) {
            this.files = list;
        }

        @Override
        public void add(File file) {
            this.files.add(file);
        }
    }

    public static interface AddFileToList {
        public void add(File var1);
    }
}

