/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.vishia.genJavaOutClass.GenJavaOutClass;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Debugutil;
import org.vishia.zbnf.ZbnfParser;
import org.vishia.zbnf.ZbnfSyntaxPrescript;

public class GenZbnfJavaData {
    public static final String sVersion = "2019-12-08";
    protected TreeMap<String, ZbnfSyntaxPrescript> idxSubSyntax;
    private final GenJavaOutClass.CmdArgs cmdArgs;
    private final MainCmdLogging_ifc log;
    private final GenJavaOutClass genClass;

    public GenZbnfJavaData(GenJavaOutClass.CmdArgs cmdArgs, MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.cmdArgs = cmdArgs;
        this.log = mainCmdLogging_ifc;
        this.genClass = new GenJavaOutClass(cmdArgs, mainCmdLogging_ifc);
    }

    public void setAndEvaluateSyntax() {
        ZbnfParser zbnfParser = new ZbnfParser(this.log);
        try {
            zbnfParser.setSyntax(this.cmdArgs.fileInput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.idxSubSyntax = zbnfParser.listSubPrescript;
        ZbnfSyntaxPrescript zbnfSyntaxPrescript = zbnfParser.mainScript();
        this.evaluateSyntax(zbnfSyntaxPrescript);
    }

    private void evaluateSyntax(ZbnfSyntaxPrescript zbnfSyntaxPrescript) {
        this.genClass.setupWriter();
        WrClassZbnf wrClassZbnf = new WrClassZbnf();
        try {
            ZbnfSyntaxPrescript zbnfSyntaxPrescript2 = this.idxSubSyntax.get(zbnfSyntaxPrescript.sDefinitionIdent);
            wrClassZbnf.evaluateChildSyntax(zbnfSyntaxPrescript2.childSyntaxPrescripts, false, 1);
            wrClassZbnf.wrClassJava.writeOperations();
            int n = 0;
            while (this.genClass.listCmpn.size() > n) {
                SubClassZbnf subClassZbnf = (SubClassZbnf)this.genClass.listCmpn.get(n++);
                wrClassZbnf = new WrClassZbnf();
                wrClassZbnf.wrClassJava.wrClassCmpn(subClassZbnf);
                wrClassZbnf.evaluateChildSyntax(subClassZbnf.subSyntax.childSyntaxPrescripts, false, 0);
                wrClassZbnf.wrClassJava.writeOperations();
                this.genClass.finishCmpnWrite();
            }
            this.genClass.finishClassWrite();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        this.genClass.closeWrite();
    }

    public static void main(String[] stringArray) {
        GenZbnfJavaData.smain(stringArray, true);
    }

    public static String smain(String[] stringArray) {
        return GenZbnfJavaData.smain(stringArray, false);
    }

    private static String smain(String[] stringArray, boolean bl) {
        String string;
        GenJavaOutClass.CmdArgs cmdArgs = new GenJavaOutClass.CmdArgs();
        CmdLine cmdLine = new CmdLine(cmdArgs, stringArray);
        try {
            boolean bl2;
            cmdLine.addCmdLineProperties();
            try {
                bl2 = cmdLine.parseArguments();
            }
            catch (Exception exception) {
                cmdLine.report("Argument error:", exception);
                cmdLine.setExitErrorLevel(5);
                bl2 = false;
            }
            if (bl2) {
                GenZbnfJavaData genZbnfJavaData = new GenZbnfJavaData(cmdArgs, cmdLine);
                try {
                    genZbnfJavaData.setAndEvaluateSyntax();
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            string = "";
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        if (bl) {
            cmdLine.exit();
        }
        return string;
    }

    private static class CmdLine
    extends MainCmd {
        public final MainCmd.Argument[] defArguments = new MainCmd.Argument[]{new MainCmd.Argument("-s", "<SYNTAX>    syntax prescript in ZBNF format for parsing", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.fileInput = new File(string);
                return true;
            }
        }), new MainCmd.Argument("-dirJava", ":<dirJava>    directory for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.dirJava = new File(string);
                return true;
            }
        }), new MainCmd.Argument("-pkg", ":<pkg.path>    directory for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sJavaPkg = string;
                return true;
            }
        }), new MainCmd.Argument("-class", ":<class>.java    directory for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sJavaClass = string;
                return true;
            }
        })};
        public final GenJavaOutClass.CmdArgs argData;

        protected CmdLine(GenJavaOutClass.CmdArgs cmdArgs, String[] stringArray) {
            super(stringArray);
            this.argData = cmdArgs;
        }

        void addCmdLineProperties() {
            super.addAboutInfo("Generate Java source code as destination class from ZBNF syntax script");
            super.addAboutInfo("made by HSchorrig, 2019-05-10..2019-08-29");
            super.addArgument(this.defArguments);
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.argData.fileInput == null) {
                bl = false;
                this.writeError("ERROR argument Syntaxfile is obligat.");
            } else if (this.argData.fileInput.length() == 0L) {
                bl = false;
                this.writeError("ERROR argument Syntaxfile without content.");
            }
            return bl;
        }
    }

    private class WrClassZbnf {
        final GenJavaOutClass.WrClassJava wrClassJava;

        WrClassZbnf() {
            this.wrClassJava = GenZbnfJavaData.this.genClass.new GenJavaOutClass.WrClassJava();
        }

        void evaluateChildSyntax(List<ZbnfSyntaxPrescript> list, boolean n, int n2) throws Exception {
            for (ZbnfSyntaxPrescript zbnfSyntaxPrescript : list) {
                Object object;
                int n3;
                String string;
                ZbnfSyntaxPrescript zbnfSyntaxPrescript2 = null;
                String string2 = string = zbnfSyntaxPrescript.sSemantic == null ? "" : zbnfSyntaxPrescript.sSemantic;
                if (string.length() > 0 && string.charAt(0) != '@' && zbnfSyntaxPrescript.childsHasSemantic()) {
                    n3 = string.indexOf(47);
                    object = n3 > 0 ? string.substring(0, n3) : string;
                    this.getRegisterSubclass((String)object, zbnfSyntaxPrescript);
                }
                n3 = n;
                if (zbnfSyntaxPrescript.eType != null) {
                    switch (zbnfSyntaxPrescript.eType) {
                        case kRepetition: 
                        case kRepetitionRepeat: {
                            n3 = 1;
                            object = (ZbnfSyntaxPrescript.RepetitionSyntax)zbnfSyntaxPrescript;
                            zbnfSyntaxPrescript2 = ((ZbnfSyntaxPrescript.RepetitionSyntax)object).backward;
                            if (zbnfSyntaxPrescript.sSemantic == null) break;
                            this.wrVariable("String", string, zbnfSyntaxPrescript, n != 0, false, null);
                            break;
                        }
                        case kOnlySemantic: 
                        case kAlternative: 
                        case kAlternativeOptionCheckEmptyFirst: 
                        case kSimpleOption: 
                        case kAlternativeOption: {
                            if (zbnfSyntaxPrescript.sSemantic == null) break;
                            this.wrVariable("String", string, zbnfSyntaxPrescript, n != 0, false, null);
                            break;
                        }
                        case kExpectedVariant: {
                            break;
                        }
                        case kFloatWithFactor: 
                        case kFloatNumber: {
                            this.wrVariable("float", string, null, n != 0, false, null);
                            break;
                        }
                        case kPositivNumber: 
                        case kIntegerNumber: 
                        case kHexNumber: {
                            this.wrVariable("int", string, null, n != 0, false, null);
                            break;
                        }
                        case kStringUntilEndString: 
                        case kStringUntilEndStringInclusive: 
                        case kStringUntilEndStringTrim: 
                        case kStringUntilEndStringWithIndent: 
                        case kStringUntilEndchar: 
                        case kStringUntilEndcharInclusive: 
                        case kStringUntilEndcharOutsideQuotion: 
                        case kStringUntilEndcharWithIndent: 
                        case kStringUntilRightEndchar: 
                        case kStringUntilRightEndcharInclusive: 
                        case kQuotedString: 
                        case kRegularExpression: 
                        case kIdentifier: {
                            this.wrVariable("String", string, null, n != 0, false, null);
                            break;
                        }
                        case kNegativVariant: 
                        case kNotDefined: {
                            break;
                        }
                        case kSkipSpaces: {
                            break;
                        }
                        case kSyntaxComponent: {
                            this.evaluateSubCmpn(zbnfSyntaxPrescript, n != 0, n2);
                            break;
                        }
                        case kSyntaxDefinition: {
                            break;
                        }
                        case kTerminalSymbol: {
                            break;
                        }
                        case kTerminalSymbolInComment: {
                            break;
                        }
                        case kUnconditionalVariant: {
                            break;
                        }
                        default: {
                            Debugutil.todo();
                        }
                    }
                }
                if (zbnfSyntaxPrescript.childSyntaxPrescripts != null) {
                    this.evaluateChildSyntax(zbnfSyntaxPrescript.childSyntaxPrescripts, n3 != 0, n2 + 1);
                }
                if (zbnfSyntaxPrescript2 == null || zbnfSyntaxPrescript2.childSyntaxPrescripts == null) continue;
                this.evaluateChildSyntax(zbnfSyntaxPrescript2.childSyntaxPrescripts, n3 != 0, n2 + 1);
            }
        }

        private SubClassZbnf getRegisterSubclass(String string, ZbnfSyntaxPrescript zbnfSyntaxPrescript) {
            SubClassZbnf subClassZbnf = (SubClassZbnf)((GenZbnfJavaData)GenZbnfJavaData.this).genClass.idxRegisteredCmpn.get(string);
            if (subClassZbnf == null) {
                subClassZbnf = new SubClassZbnf(string, GenJavaOutClass.firstUppercase(string));
                subClassZbnf.sDbgIdent = zbnfSyntaxPrescript.sDefinitionIdent;
                subClassZbnf.subSyntax = zbnfSyntaxPrescript;
                ((GenZbnfJavaData)GenZbnfJavaData.this).genClass.idxRegisteredCmpn.put(string, subClassZbnf);
                ((GenZbnfJavaData)GenZbnfJavaData.this).genClass.listCmpn.add(subClassZbnf);
            }
            return subClassZbnf;
        }

        private void evaluateSubCmpn(ZbnfSyntaxPrescript zbnfSyntaxPrescript, boolean bl, int n) throws Exception {
            String string;
            ZbnfSyntaxPrescript zbnfSyntaxPrescript2;
            if (zbnfSyntaxPrescript.sDefinitionIdent.startsWith("ST")) {
                Debugutil.stop();
            }
            if ((zbnfSyntaxPrescript2 = GenZbnfJavaData.this.idxSubSyntax.get(zbnfSyntaxPrescript.sDefinitionIdent)) == null) {
                throw new IllegalArgumentException("error in syntax, component not found: " + zbnfSyntaxPrescript.sDefinitionIdent);
            }
            String string2 = zbnfSyntaxPrescript.sSemantic == null ? null : (string = zbnfSyntaxPrescript.sSemantic.equals("@") ? zbnfSyntaxPrescript2.sSemantic : zbnfSyntaxPrescript.sSemantic);
            if (string == null) {
                this.evaluateChildSyntax(zbnfSyntaxPrescript2.childSyntaxPrescripts, bl, n);
            } else {
                if (zbnfSyntaxPrescript.bStoreAsString) {
                    this.wrVariable("String", string, null, bl, false, null);
                }
                if (!zbnfSyntaxPrescript.bDonotStoreData) {
                    Object object;
                    LinkedList<String> linkedList = null;
                    if (zbnfSyntaxPrescript2.childSyntaxPrescripts != null) {
                        object = zbnfSyntaxPrescript2.childSyntaxPrescripts.iterator();
                        while (object.hasNext()) {
                            ZbnfSyntaxPrescript zbnfSyntaxPrescript3 = (ZbnfSyntaxPrescript)object.next();
                            if (zbnfSyntaxPrescript3.sSemantic == null || zbnfSyntaxPrescript3.sSemantic.length() <= 1 || zbnfSyntaxPrescript3.sSemantic.charAt(0) != '@') continue;
                            if (linkedList == null) {
                                linkedList = new LinkedList<String>();
                            }
                            linkedList.add(zbnfSyntaxPrescript3.sSemantic.substring(1));
                        }
                    }
                    if ((object = zbnfSyntaxPrescript2.sSemantic) == null || ((String)object).equals("@")) {
                        object = zbnfSyntaxPrescript.sDefinitionIdent;
                    }
                    if (((String)(object = GenJavaOutClass.firstUppercase((String)object))).equals("Integer")) {
                        Debugutil.stop();
                    } else {
                        this.registerCmpn(zbnfSyntaxPrescript);
                    }
                    this.wrVariable((String)object, string, zbnfSyntaxPrescript, bl, true, linkedList);
                }
            }
        }

        protected void wrVariable(String string, String string2, ZbnfSyntaxPrescript zbnfSyntaxPrescript, boolean bl, boolean bl2, List<String> list) throws Exception {
            if (string2 != null && string2.length() > 0) {
                int n;
                if (string2.startsWith("ST")) {
                    Debugutil.stop();
                }
                if ((n = string2.indexOf(47)) > 0) {
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    LinkedList<String> linkedList = null;
                    if (string4.startsWith("@")) {
                        string4 = string4.substring(1);
                        linkedList = new LinkedList<String>();
                        linkedList.add(string4);
                    }
                    SubClassZbnf subClassZbnf = this.getRegisterSubclass(string3, zbnfSyntaxPrescript);
                    this.wrVariable(string3, string3, zbnfSyntaxPrescript, bl, true, linkedList);
                    GenJavaOutClass.SubClassField subClassField = new GenJavaOutClass.SubClassField(string, GenJavaOutClass.firstLowercase(string4), string4);
                    if (subClassZbnf.fieldsFromSemanticAttr == null) {
                        subClassZbnf.fieldsFromSemanticAttr = new TreeMap();
                    }
                    subClassZbnf.fieldsFromSemanticAttr.put(string4, subClassField);
                } else {
                    String string5;
                    if (string2.equals("secondOperand")) {
                        Debugutil.stop();
                    }
                    if ((string5 = this.wrClassJava.variables.get(string2)) != null) {
                        if (!string5.equals(string)) {
                            throw new IllegalArgumentException("Semantic " + string2 + " with different types");
                        }
                    } else {
                        String string6 = string.equals("Integer") ? "int" : string;
                        if (string2.equals("FBType")) {
                            Debugutil.stop();
                        }
                        if (string2.indexOf("@") >= 0) {
                            Debugutil.stop();
                        }
                        LinkedList<String> linkedList = null;
                        if (list != null) {
                            for (String string7 : list) {
                                if (linkedList == null) {
                                    linkedList = new LinkedList<String>();
                                }
                                linkedList.add(GenJavaOutClass.firstLowercase(string7));
                            }
                        }
                        Object object = string2.replace("@", "");
                        object = ((String)object).replace("/", "_");
                        this.wrClassJava.wrVariable((String)object, string6, !bl2, bl, bl2, linkedList);
                    }
                }
            }
        }

        private void registerCmpn(ZbnfSyntaxPrescript zbnfSyntaxPrescript) {
            ZbnfSyntaxPrescript zbnfSyntaxPrescript2 = GenZbnfJavaData.this.idxSubSyntax.get(zbnfSyntaxPrescript.sDefinitionIdent);
            if (zbnfSyntaxPrescript2 == null) {
                throw new IllegalArgumentException("syntax component not found: " + zbnfSyntaxPrescript.sDefinitionIdent);
            }
            String string = zbnfSyntaxPrescript2.sSemantic;
            if (string == null || string.equals("@")) {
                string = zbnfSyntaxPrescript2.sDefinitionIdent;
            }
            if (((GenZbnfJavaData)GenZbnfJavaData.this).genClass.idxRegisteredCmpn.get(string) == null) {
                SubClassZbnf subClassZbnf = new SubClassZbnf(string, GenJavaOutClass.firstUppercase(string));
                subClassZbnf.sDbgIdent = zbnfSyntaxPrescript2.sDefinitionIdent;
                subClassZbnf.subSyntax = zbnfSyntaxPrescript2;
                ((GenZbnfJavaData)GenZbnfJavaData.this).genClass.idxRegisteredCmpn.put(string, subClassZbnf);
                ((GenZbnfJavaData)GenZbnfJavaData.this).genClass.listCmpn.add(subClassZbnf);
            }
        }
    }

    static class SubClassZbnf
    extends GenJavaOutClass.SubClassJava {
        ZbnfSyntaxPrescript subSyntax;

        SubClassZbnf(String string, String string2) {
            super(string, string2);
        }
    }
}

