/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vishia.util.Assert;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlSimple.XmlSequWriter;

public class XmlJzReader {
    public static final String version = "2020-02-12";
    XmlCfg cfg = new XmlCfg();
    final XmlCfg cfgCfg;
    int sizeBuffer = 20000;
    int debugStopLine = -1;
    Map<String, String> namespaces = new IndexMultiTable<String, String>(IndexMultiTable.providerString);
    private final Map<String, String> replaceChars = new TreeMap<String, String>();
    XmlSequWriter xmlTestWriter;

    public XmlJzReader() {
        this.cfgCfg = XmlCfg.newCfgCfg();
        this.replaceChars.put("&amp;", "&");
        this.replaceChars.put("&lt;", "<");
        this.replaceChars.put("&gt;", ">");
        this.replaceChars.put("&quot;", "\"");
        this.replaceChars.put("&apos;", "'");
        this.replaceChars.put("&nl;", "\n");
        this.replaceChars.put("&cr;", "\r");
        this.replaceChars.put("&#9;", "\t");
        this.replaceChars.put("&#A;", "\n");
        this.replaceChars.put("&#D;", "\r");
        this.replaceChars.put("&#20;", " ");
        this.replaceChars.put("&auml;", "\u00e4");
        this.replaceChars.put("&ouml;", "\u00f6");
        this.replaceChars.put("&uuml;", "\u00fc");
        this.replaceChars.put("&Auml;", "\u00c4");
        this.replaceChars.put("&Ouml;", "\u00d6");
        this.replaceChars.put("&Uuml;", "\u00dc");
    }

    public void setDebugStop(int n) {
        this.debugStopLine = n;
    }

    public void XXXXreadXmlCfg(File file) {
        this.cfg = new XmlCfg();
    }

    public void openXmlTestOut(File file) throws IOException {
        if (this.xmlTestWriter == null) {
            this.xmlTestWriter = new XmlSequWriter();
        }
        this.xmlTestWriter.open(file, "UTF-8", null);
    }

    public String readXml(File file, Object object, XmlCfg xmlCfg) throws IOException {
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string2 = FileSystem.normalizePath(file.getAbsoluteFile()).toString();
            string = this.readXml(fileInputStream, string2, object, xmlCfg);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("XmlJzReader.readXml(...) file not found: " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new IOException("XmlJzReader.readXml(...) any IO exception: " + file.getAbsolutePath());
        }
        return string;
    }

    public String readZipXml(File file, String string, Object object) {
        String string2 = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            String string3 = file.getAbsolutePath() + ":" + string;
            string2 = this.readXml(inputStream, string3, object, this.cfg);
            inputStream.close();
            zipFile.close();
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readXml(InputStream inputStream, String string, Object object, XmlCfg xmlCfg) {
        String string2 = null;
        try (StringPartScan stringPartScan = null;){
            stringPartScan = new StringPartFromFileLines(inputStream, string, this.sizeBuffer, "encoding", null);
            this.readXml(stringPartScan, object, xmlCfg);
        }
        return string2;
    }

    public void readXml(StringPartScan stringPartScan, Object object) throws Exception {
        this.readXml(stringPartScan, object, this.cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readXml(Reader reader, String string, Object object, XmlCfg xmlCfg) {
        String string2 = null;
        try (StringPartScan stringPartScan = null;){
            stringPartScan = new StringPartFromFileLines(reader, string, this.sizeBuffer);
            this.readXml(stringPartScan, object, xmlCfg);
        }
        return string2;
    }

    private void readXml(StringPartScan stringPartScan, Object object, XmlCfg xmlCfg) throws Exception {
        stringPartScan.setIgnoreWhitespaces(true);
        while (stringPartScan.seekEnd("<").found()) {
            stringPartScan.scanStart();
            if (stringPartScan.scan("?").scanOk()) {
                stringPartScan.seekEnd("?>");
                stringPartScan.scanOk();
                continue;
            }
            if (stringPartScan.scan("!").scanOk()) {
                stringPartScan.seekEnd(">");
                stringPartScan.scanOk();
                continue;
            }
            if (stringPartScan.scan().scan("!--").scanOk()) {
                stringPartScan.seekEnd("-->");
                continue;
            }
            stringPartScan.scanOk();
            stringPartScan.readNextContent(this.sizeBuffer * 2 / 3);
            this.parseElement(stringPartScan, object, xmlCfg.rootNode);
        }
        if (this.xmlTestWriter != null) {
            this.xmlTestWriter.close();
            this.xmlTestWriter = null;
        }
        Debugutil.stop();
    }

    private void parseElement(StringPartScan stringPartScan, Object object, XmlCfg.XmlCfgNode xmlCfgNode) throws Exception {
        Object object2;
        XmlCfg.XmlCfgNode xmlCfgNode2;
        int n = -7777;
        if (this.debugStopLine >= 0 && (n = stringPartScan.getLineAndColumn(null)) == this.debugStopLine) {
            Debugutil.stop();
        }
        if (!stringPartScan.scanIdentifier(null, "-:.").scanOk()) {
            throw new IllegalArgumentException("tag name expected");
        }
        String string = stringPartScan.getLastScannedString().toString();
        if (this.xmlTestWriter != null) {
            this.xmlTestWriter.writeElement(string);
        }
        if (string.contains("   ")) {
            Debugutil.stop();
        }
        if (string.equals("Object")) {
            Debugutil.stop();
        }
        Object object3 = null;
        if (xmlCfgNode == null) {
            object3 = null;
            xmlCfgNode2 = null;
        } else {
            if (object == null) {
                Debugutil.stop();
            }
            Assert.check(object != null);
            if (string.toString().contains("   ")) {
                Debugutil.stop();
            }
            if (string.toString().startsWith("Object@")) {
                Debugutil.stop();
            }
            if (xmlCfgNode.subnodes == null) {
                xmlCfgNode2 = null;
            } else {
                xmlCfgNode2 = xmlCfgNode.subnodes.get(string);
                if (xmlCfgNode2 == null) {
                    xmlCfgNode2 = xmlCfgNode.subnodes.get("?");
                }
            }
            if (string.toString().contains("   ")) {
                Debugutil.stop();
            }
        }
        Map[] mapArray = new Map[1];
        if (xmlCfgNode2 != null) {
            mapArray[0] = xmlCfgNode2.allArgNames;
        }
        String[] stringArray = null;
        List[] listArray = new List[1];
        if (mapArray[0] != null) {
            stringArray = new String[xmlCfgNode2.allArgNames.size()];
            object2 = (DataAccess.IntegerIx)mapArray[0].get("tag");
            if (object2 != null) {
                stringArray[((DataAccess.IntegerIx)object2).ix] = string;
            }
        }
        if (n == this.debugStopLine) {
            Debugutil.stop();
        }
        if ((object2 = this.parseAttributes(stringPartScan, string, xmlCfgNode2, listArray, mapArray, stringArray)).length() > string.length()) {
            xmlCfgNode2 = xmlCfgNode.subnodes == null ? null : xmlCfgNode.subnodes.get(object2);
        }
        Object object4 = object3 = xmlCfgNode2 == null ? null : this.getDataForTheElement(object, xmlCfgNode2.elementStorePath, stringArray);
        if (listArray[0] != null) {
            if (object3 == null) {
                System.err.println("Problem storing attribute values, getDataForTheElement \"" + xmlCfgNode2.elementStorePath + "\" returns null");
            } else {
                for (Object object5 : listArray[0]) {
                    this.storeAttrData(object3, ((AttribToStore)object5).daccess, xmlCfgNode2.allArgNames, ((AttribToStore)object5).name, ((AttribToStore)object5).value);
                }
            }
        }
        if (!stringPartScan.scan("/").scan(">").scanOk()) {
            if (stringPartScan.scan(">").scanOk()) {
                if (this.xmlTestWriter != null) {
                    this.xmlTestWriter.writeElementHeadEnd(false);
                }
                Object object6 = null;
                while (!stringPartScan.scan().scan("<").scan("/").scanOk()) {
                    stringPartScan.readNextContent(this.sizeBuffer / 2);
                    if (stringPartScan.scan("<").scanOk()) {
                        if (stringPartScan.scan("!--").scanOk()) {
                            stringPartScan.seekEnd("-->");
                            continue;
                        }
                        this.parseElement(stringPartScan, object3, xmlCfgNode2);
                        continue;
                    }
                    if (object6 == null && object3 != null) {
                        object6 = new StringBuilder(500);
                    }
                    this.parseContent(stringPartScan, (StringBuilder)object6);
                }
                stringPartScan.readNextContent(this.sizeBuffer / 2);
                if (!stringPartScan.scanIdentifier(null, "-:.").scanOk()) {
                    throw new IllegalArgumentException("</tag expected");
                }
                stringPartScan.setLengthMax();
                if (!stringPartScan.scan(">").scanOk()) {
                    throw new IllegalArgumentException("</tag > expected");
                }
                if (object6 != null && object3 != null) {
                    if (object6 != null) {
                        Object object5;
                        assert (mapArray[0] != null);
                        object5 = (DataAccess.IntegerIx)mapArray[0].get("text");
                        if (object5 != null) {
                            stringArray[((DataAccess.IntegerIx)object5).ix] = ((StringBuilder)object6).toString();
                        }
                    }
                    XmlJzReader.storeContent((StringBuilder)object6, xmlCfgNode2, object3, mapArray, stringArray);
                }
            } else {
                throw new IllegalArgumentException("either \">\" or \"/>\" expected");
            }
        }
        stringPartScan.setLengthMax();
        if (this.xmlTestWriter != null) {
            this.xmlTestWriter.writeElementEnd();
        }
    }

    private CharSequence parseAttributes(StringPartScan stringPartScan, CharSequence charSequence, XmlCfg.XmlCfgNode xmlCfgNode, List<AttribToStore>[] listArray, Map<String, DataAccess.IntegerIx>[] mapArray, String[] stringArray) throws Exception {
        CharSequence charSequence2 = charSequence;
        StringBuilder stringBuilder = null;
        while (stringPartScan.scanIdentifier(null, "-:").scan("=").scanOk()) {
            String string = stringPartScan.getLastScannedString();
            if (!stringPartScan.scanQuotion("\"", "\"", null).scanOk()) {
                throw new IllegalArgumentException("attr value expected");
            }
            if (xmlCfgNode != null) {
                Object object;
                Object object2;
                Object object3;
                int n;
                String string2 = this.replaceSpecialCharsInText(stringPartScan.getLastScannedString()).toString();
                if (this.xmlTestWriter != null) {
                    this.xmlTestWriter.writeAttribute(string.toString(), string2);
                }
                if (string.equals("xmlinput:class")) {
                    Debugutil.stop();
                }
                if ((n = StringFunctions.indexOf((CharSequence)string, ':')) >= 0) {
                    String string3;
                    object3 = string.subSequence(0, n);
                    object2 = string.subSequence(n + 1, string.length());
                    if (StringFunctions.equals((CharSequence)object3, "xmlns")) {
                        string3 = string2.toString();
                        this.namespaces.put(object2.toString(), string3);
                        object = null;
                    } else {
                        String string4;
                        string3 = this.namespaces.get(object3);
                        object = string3 == null ? null : (xmlCfgNode.cfg.xmlnsAssign != null ? ((string4 = xmlCfgNode.cfg.xmlnsAssign.get(string3)) == null ? null : string4 + ":" + object2) : string);
                    }
                } else {
                    object = string;
                }
                if (object != null) {
                    object3 = null;
                    if (xmlCfgNode.attribs != null && (object3 = xmlCfgNode.attribs.get(object)) == null) {
                        object3 = xmlCfgNode.attribs.get("?");
                    }
                    if (object3 != null) {
                        if (((XmlCfg.AttribDstCheck)object3).bUseForCheck) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(64);
                                stringBuilder.append(charSequence);
                                charSequence2 = stringBuilder;
                            }
                            stringBuilder.append("@").append((CharSequence)object).append("=\"").append(string2).append("\"");
                        } else if (((XmlCfg.AttribDstCheck)object3).daccess != null) {
                            if (listArray[0] == null) {
                                listArray[0] = new LinkedList<AttribToStore>();
                            }
                            listArray[0].add(new AttribToStore(((XmlCfg.AttribDstCheck)object3).daccess, object.toString(), string2));
                        } else if (((XmlCfg.AttribDstCheck)object3).storeInMap != null) {
                            object2 = mapArray[0].get(((XmlCfg.AttribDstCheck)object3).storeInMap);
                            if (object2 != null) {
                                stringArray[((DataAccess.IntegerIx)object2).ix] = string2;
                            } else {
                                Debugutil.stop();
                            }
                        }
                    } else if (xmlCfgNode.attribsUnspec != null) {
                        if (listArray[0] == null) {
                            listArray[0] = new LinkedList<AttribToStore>();
                        }
                        listArray[0].add(new AttribToStore(xmlCfgNode.attribsUnspec, object.toString(), string2));
                    }
                }
            }
            stringPartScan.readNextContent(this.sizeBuffer / 2);
        }
        return charSequence2;
    }

    Object getDataForTheElement(Object object, DataAccess.DatapathElement datapathElement, String[] stringArray) {
        Object object2;
        if (datapathElement == null) {
            object2 = object;
        } else {
            try {
                object2 = datapathElement.isOperation() ? DataAccess.invokeMethod(datapathElement, null, object, true, stringArray, false) : DataAccess.access(datapathElement, object, true, false, null, (Object[])stringArray, false, null);
            }
            catch (Exception exception) {
                object2 = null;
                CharSequence charSequence = Assert.exceptionInfo("", exception, 1, 30);
                System.err.println("error getDataForTheElement: " + datapathElement);
                System.err.println("help: ");
                System.err.println(charSequence);
            }
        }
        return object2;
    }

    void storeAttrData(Object object, DataAccess.DatapathElement datapathElement, Map<String, DataAccess.IntegerIx> map, CharSequence charSequence, CharSequence charSequence2) {
        try {
            if (datapathElement.isOperation()) {
                Object[] objectArray = null;
                if (map != null) {
                    objectArray = new String[map.size()];
                    for (Map.Entry<String, DataAccess.IntegerIx> entry : map.entrySet()) {
                        String string = entry.getKey();
                        int n = entry.getValue().ix;
                        if (string.equals("name")) {
                            objectArray[n] = charSequence.toString();
                            continue;
                        }
                        if (!string.equals("value")) continue;
                        objectArray[n] = charSequence2.toString();
                    }
                }
                DataAccess.invokeMethod(datapathElement, null, object, true, objectArray, true);
            } else {
                DataAccess.storeValue(datapathElement, object, (Object)charSequence2, true);
            }
        }
        catch (Exception exception) {
            System.err.println("error storeAttrData: " + exception.getMessage());
        }
    }

    private CharSequence parseContent(StringPartScan stringPartScan, StringBuilder stringBuilder) throws IOException, ParseException {
        boolean bl;
        stringPartScan.seekNoWhitespace();
        boolean bl2 = false;
        CharSequence charSequence = null;
        do {
            stringPartScan.lento('<');
            boolean bl3 = bl = !stringPartScan.found();
            if (bl) {
                if (bl2) {
                    throw new IllegalArgumentException("Format error in XML file, missing \"<\", file: " + stringPartScan.getInputfile());
                }
                stringPartScan.setLengthMax();
            } else {
                stringPartScan.lenBacktoNoWhiteSpaces();
            }
            CharSequence charSequence2 = this.replaceSpecialCharsInText(stringPartScan.getCurrentPart());
            if (this.xmlTestWriter != null) {
                this.xmlTestWriter.writeText(charSequence2, false);
            }
            stringPartScan.fromEnd();
            if (stringBuilder != null && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            if (stringBuilder != null) {
                stringBuilder.append(charSequence2);
                charSequence = stringBuilder;
            } else if (charSequence == null) {
                charSequence = charSequence2;
            } else {
                if (!(charSequence instanceof StringBuilder)) {
                    charSequence = new StringBuilder(charSequence);
                }
                ((StringBuilder)charSequence).append(charSequence2);
            }
            bl2 = stringPartScan.readNextContent(this.sizeBuffer / 2);
        } while (bl);
        return charSequence;
    }

    private static void storeContent(StringBuilder stringBuilder, XmlCfg.XmlCfgNode xmlCfgNode, Object object, Map<String, DataAccess.IntegerIx>[] mapArray, String[] stringArray) {
        DataAccess.DatapathElement datapathElement = xmlCfgNode.contentStorePath;
        if (datapathElement != null) {
            try {
                if (datapathElement.isOperation()) {
                    if (xmlCfgNode.allArgNames != null) {
                        for (Map.Entry<String, DataAccess.IntegerIx> entry : xmlCfgNode.allArgNames.entrySet()) {
                            String string = entry.getKey();
                            int n = entry.getValue().ix;
                            if (!string.equals("text") || stringBuilder == null) continue;
                            stringArray[n] = stringBuilder.toString();
                        }
                    }
                    DataAccess.invokeMethod(datapathElement, null, object, true, stringArray, true);
                } else if (stringBuilder != null) {
                    DataAccess.storeValue(datapathElement, object, (Object)stringBuilder, true);
                }
            }
            catch (Exception exception) {
                System.err.println("error storeContent: " + exception.getMessage());
            }
        }
    }

    private CharSequence replaceSpecialCharsInText(CharSequence charSequence) throws ParseException {
        if (StringFunctions.contains(charSequence, "Comment of Network1")) {
            Debugutil.stop();
        }
        if (StringFunctions.indexOf(charSequence, '&') < 0) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        int n = 0;
        while ((n = StringFunctions.indexOf((CharSequence)stringBuilder, '&', n)) >= 0) {
            int n2 = StringFunctions.indexOf((CharSequence)stringBuilder, ';', n);
            if (n2 > 0 && n2 - n < 11) {
                String string = stringBuilder.subSequence(n, n2 + 1).toString();
                String string2 = this.replaceChars.get(string);
                if (string2 == null) {
                    int n3;
                    block11: {
                        if (string.charAt(1) != '#') continue;
                        int n4 = 10;
                        int n5 = 2;
                        if (string.charAt(n5) == 'x') {
                            n4 = 16;
                            ++n5;
                        }
                        try {
                            n3 = Integer.parseUnsignedInt(string.substring(n5, n2 - n), n4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n3 = 63;
                            if ($assertionsDisabled) break block11;
                            throw new AssertionError();
                        }
                    }
                    ++n2;
                    if (n3 == 10) {
                        int n6 = stringBuilder.length();
                        while (n2 < n6 && "\n\r \t".indexOf(stringBuilder.charAt(n2)) >= 0) {
                            ++n2;
                        }
                    }
                    char[] cArray = Character.toChars(n3);
                    stringBuilder.delete(n, n2);
                    stringBuilder.insert(n, cArray);
                    n += cArray.length;
                    continue;
                }
                if (string2 == null) continue;
                if (string2.equals("&")) {
                    Debugutil.stop();
                }
                stringBuilder.replace(n, n2 + 1, string2);
                ++n;
                continue;
            }
            throw new ParseException("faulty Characters on ", n);
        }
        n = 0;
        return stringBuilder;
    }

    public XmlCfg readCfg(File file) throws IOException {
        this.readXml(file, (Object)this.cfg.rootNode, this.cfgCfg);
        this.cfg.finishReadCfg(this.namespaces);
        return this.cfg;
    }

    public XmlCfg readCfgFromJar(Class<?> clazz, String string) throws IOException {
        String string2 = "jar:" + string;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string2);
        }
        this.readXml(inputStream, string2, (Object)this.cfg.rootNode, this.cfgCfg);
        inputStream.close();
        this.cfg.finishReadCfg(this.namespaces);
        return this.cfg;
    }

    public String readXml(File file, Object object) throws IOException {
        return this.readXml(file, object, this.cfg);
    }

    public String readXml(InputStream inputStream, String string, Object object) {
        return this.readXml(inputStream, string, object, this.cfg);
    }

    public String readXml(Reader reader, String string, Object object) {
        return this.readXml(reader, string, object, this.cfg);
    }

    static class AttribToStore {
        final DataAccess.DatapathElement daccess;
        final String name;
        final String value;

        AttribToStore(DataAccess.DatapathElement datapathElement, String string, String string2) {
            this.daccess = datapathElement;
            this.name = string;
            this.value = string2;
        }
    }
}

