/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.vishia.genJavaOutClass.GenJavaOutClass;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.StringFunctions_B;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;

public class GenXmlCfgJavaData {
    private final GenJavaOutClass genJava;
    XmlJzReader xmlReader = new XmlJzReader();
    private final GenJavaOutClass genClass;
    Map<String, XmlCfg.XmlCfgNode> subtrees;

    GenXmlCfgJavaData(GenJavaOutClass.CmdArgs cmdArgs, MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.genJava = new GenJavaOutClass(cmdArgs, mainCmdLogging_ifc);
        this.genClass = new GenJavaOutClass(cmdArgs, mainCmdLogging_ifc);
    }

    public void exec(File file) throws IOException {
        this.xmlReader.readCfg(file);
        XmlCfg xmlCfg = this.xmlReader.cfg;
        this.subtrees = xmlCfg.subtrees;
        Debugutil.stop();
        this.genClass.setupWriter();
        WrClassXml wrClassXml = new WrClassXml();
        try {
            XmlCfg.XmlCfgNode xmlCfgNode = xmlCfg.rootNode;
            wrClassXml.evaluateChildren(xmlCfgNode, false, 1);
            wrClassXml.wrClassJava.writeOperations();
            int n = 0;
            while (this.genClass.listCmpn.size() > n) {
                SubClassXml subClassXml = (SubClassXml)this.genClass.listCmpn.get(n++);
                wrClassXml = new WrClassXml();
                wrClassXml.wrClassJava.wrClassCmpn(subClassXml);
                wrClassXml.evaluateChildren(subClassXml.subItem, false, 0);
                wrClassXml.wrClassJava.writeOperations();
                this.genClass.finishCmpnWrite();
            }
            this.genClass.finishClassWrite();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        this.genClass.closeWrite();
    }

    public static void main(String[] stringArray) {
        GenXmlCfgJavaData.smain(stringArray, true);
    }

    public static String smain(String[] stringArray) {
        return GenXmlCfgJavaData.smain(stringArray, false);
    }

    private static String smain(String[] stringArray, boolean bl) {
        String string;
        if (stringArray.length == 0) {
            System.out.println("java -cp .... org.vishia.xmlReader.GenXmlCfgJavaData -cfg:INFILE -dirJava:PATH -pkg:PKG -class:CLASS\n  -cfg:INFILE: The config.xml file as config file for XmlJzReader\n  -dirJava:path/to/javaSrcRoot to create\n  -pkg:my.pkg.path The package path\n  -class:MyClass without .java, class to create");
            string = "";
        } else {
            GenJavaOutClass.CmdArgs cmdArgs = new GenJavaOutClass.CmdArgs();
            CmdLine cmdLine = new CmdLine(cmdArgs, stringArray);
            try {
                boolean bl2;
                cmdLine.addCmdLineProperties();
                try {
                    bl2 = cmdLine.parseArguments();
                }
                catch (Exception exception) {
                    cmdLine.report("Argument error:", exception);
                    cmdLine.setExitErrorLevel(5);
                    bl2 = false;
                }
                if (bl2) {
                    GenXmlCfgJavaData genXmlCfgJavaData = new GenXmlCfgJavaData(cmdArgs, cmdLine);
                    try {
                        genXmlCfgJavaData.exec(cmdArgs.fileInput);
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                }
                string = "";
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
            if (bl) {
                cmdLine.exit();
            }
        }
        return string;
    }

    private static class CmdLine
    extends MainCmd {
        public final MainCmd.Argument[] defArguments = new MainCmd.Argument[]{new MainCmd.Argument("-cfg", "<fileCfg.xml>    Xml cfg file", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.fileInput = new File(string);
                return true;
            }
        }), new MainCmd.Argument("-dirJava", ":<dirJava>    directory for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.dirJava = new File(string);
                return true;
            }
        }), new MainCmd.Argument("-pkg", ":<pkg.path>    directory for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sJavaPkg = string;
                return true;
            }
        }), new MainCmd.Argument("-class", ":<class>     name and file <class>.java for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sJavaClass = string;
                return true;
            }
        })};
        public final GenJavaOutClass.CmdArgs argData;

        protected CmdLine(GenJavaOutClass.CmdArgs cmdArgs, String[] stringArray) {
            super(stringArray);
            this.argData = cmdArgs;
        }

        void addCmdLineProperties() {
            super.addAboutInfo("Generate Java source code as destination class from XML cfg file");
            super.addAboutInfo("made by HSchorrig, 2019-08-16..2019-08-29");
            super.addArgument(this.defArguments);
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.argData.fileInput == null) {
                bl = false;
                this.writeError("ERROR argument Syntaxfile is obligat.");
            } else if (this.argData.fileInput.length() == 0L) {
                bl = false;
                this.writeError("ERROR argument Syntaxfile without content.");
            }
            return bl;
        }
    }

    private class WrClassXml {
        final GenJavaOutClass.WrClassJava wrClassJava;

        WrClassXml() {
            this.wrClassJava = GenXmlCfgJavaData.this.genClass.new GenJavaOutClass.WrClassJava();
        }

        private SubClassXml getRegisterSubclass(String string, XmlCfg.XmlCfgNode xmlCfgNode) {
            SubClassXml subClassXml = (SubClassXml)((GenXmlCfgJavaData)GenXmlCfgJavaData.this).genClass.idxRegisteredCmpn.get(string);
            if (subClassXml == null) {
                subClassXml = new SubClassXml(string, GenJavaOutClass.firstUppercase(string));
                subClassXml.sDbgIdent = "xxx";
                subClassXml.subItem = xmlCfgNode;
                ((GenXmlCfgJavaData)GenXmlCfgJavaData.this).genClass.idxRegisteredCmpn.put(string, subClassXml);
                ((GenXmlCfgJavaData)GenXmlCfgJavaData.this).genClass.listCmpn.add(subClassXml);
            }
            return subClassXml;
        }

        private void evaluateSubCmpn(XmlCfg.XmlCfgNode xmlCfgNode, boolean bl, int n) throws Exception {
        }

        void evaluateChildren(XmlCfg.XmlCfgNode xmlCfgNode, boolean bl, int n) throws Exception {
            String string;
            Object object;
            System.out.println(xmlCfgNode.tag);
            if (xmlCfgNode.attribs != null) {
                for (Map.Entry<String, Object> entry : xmlCfgNode.attribs.entrySet()) {
                    object = (XmlCfg.AttribDstCheck)entry.getValue();
                    string = StringFunctions_B.replaceNonIdentifierChars(((XmlCfg.AttribDstCheck)object).name, '-').toString();
                    this.wrVariable("String", string, ((XmlCfg.AttribDstCheck)object).daccess, true, false, false);
                }
            }
            if (xmlCfgNode.subnodes != null) {
                for (Map.Entry<String, Object> entry : xmlCfgNode.subnodes.entrySet()) {
                    object = (XmlCfg.XmlCfgNode)entry.getValue();
                    if (((XmlCfg.XmlCfgNode)object).dstClassName != null) {
                        string = GenJavaOutClass.firstUppercase(((XmlCfg.XmlCfgNode)object).dstClassName);
                        if (((GenXmlCfgJavaData)GenXmlCfgJavaData.this).genClass.idxStdTypes.get(string) != null) {
                            string = string + "__";
                        }
                        SubClassXml subClassXml = this.getRegisterSubclass(string, (XmlCfg.XmlCfgNode)object);
                        String string2 = StringFunctions_B.replaceNonIdentifierChars(((XmlCfg.XmlCfgNode)object).tag, '-').toString();
                        this.wrVariable(string, string2, ((XmlCfg.XmlCfgNode)object).elementStorePath, false, ((XmlCfg.XmlCfgNode)object).bList, true);
                        continue;
                    }
                    string = StringFunctions_B.replaceNonIdentifierChars(((XmlCfg.XmlCfgNode)object).tag, '-').toString();
                    this.wrVariable("String", string, ((XmlCfg.XmlCfgNode)object).elementStorePath, true, false, false);
                }
            }
        }

        protected void wrVariable(String string, String string2, DataAccess.DatapathElement datapathElement, boolean bl, boolean bl2, boolean bl3) throws Exception {
            if (string2 != null && string2.length() > 0) {
                String string3;
                if (string2.startsWith("ST")) {
                    Debugutil.stop();
                }
                if (string.equals("Section_A")) {
                    Debugutil.stop();
                }
                if ((string3 = this.wrClassJava.variables.get(string2)) != null) {
                    if (!string3.equals(string)) {
                        throw new IllegalArgumentException("Semantic " + string2 + " with different types");
                    }
                } else {
                    int n;
                    if (string.equals("Integer")) {
                        string = "int";
                    }
                    if (string2.equals("FBType")) {
                        Debugutil.stop();
                    }
                    if (string2.indexOf("@") >= 0) {
                        Debugutil.stop();
                    }
                    LinkedList<String> linkedList = null;
                    if (bl3 && (n = datapathElement.nrArgNames()) > 0) {
                        linkedList = new LinkedList<String>();
                        for (int i = 0; i < n; ++i) {
                            String string4 = datapathElement.argName(i);
                            linkedList.add(GenJavaOutClass.firstLowercase(string4));
                        }
                    }
                    this.wrClassJava.wrVariable(string2, string, bl, bl2, bl3, linkedList);
                }
            }
        }

        private void registerCmpn(String string) {
            if (((GenXmlCfgJavaData)GenXmlCfgJavaData.this).genClass.idxRegisteredCmpn.get(string) == null) {
                XmlCfg.XmlCfgNode xmlCfgNode = GenXmlCfgJavaData.this.subtrees.get(string);
                if (xmlCfgNode == null) {
                    throw new IllegalArgumentException("syntax component not found: " + string);
                }
                SubClassXml subClassXml = new SubClassXml(string, GenJavaOutClass.firstUppercase(xmlCfgNode.tag.toString()));
                subClassXml.sDbgIdent = xmlCfgNode.tag.toString();
                subClassXml.subItem = null;
                ((GenXmlCfgJavaData)GenXmlCfgJavaData.this).genClass.idxRegisteredCmpn.put(string, subClassXml);
                ((GenXmlCfgJavaData)GenXmlCfgJavaData.this).genClass.listCmpn.add(subClassXml);
            }
        }
    }

    static class SubClassXml
    extends GenJavaOutClass.SubClassJava {
        XmlCfg.XmlCfgNode subItem;

        SubClassXml(String string, String string2) {
            super(string, string2);
        }
    }
}

