/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.vishia.mainCmd.MainCmd;
import org.vishia.util.FileSystem;

public class Zip {
    public static final String version = "2020-03-20";
    private final List<Src> listSrc = new LinkedList<Src>();
    private Manifest manifest;
    private boolean bsort;

    public void addSource(String string) {
        this.listSrc.add(new Src(string, null));
    }

    public void addSource(File file, String string) {
        this.listSrc.add(new Src(string, file));
    }

    public void setManifest(File file) throws IOException {
        this.manifest = new Manifest();
        FileInputStream fileInputStream = new FileInputStream(file);
        this.manifest.read(fileInputStream);
        Attributes attributes = this.manifest.getMainAttributes();
        String string = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String exec(File file, int n, String string, long l) throws IOException {
        StringBuilder stringBuilder = null;
        byte[] byArray = new byte[16384];
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            Iterator iterator;
            Object object;
            Cloneable cloneable;
            fileOutputStream = new FileOutputStream(file);
            if (this.manifest != null) {
                if (l != 0L) {
                    zipOutputStream = new JarOutputStream(fileOutputStream);
                    cloneable = new ZipEntry("META-INF/MANIFEST.MF");
                    ((ZipEntry)cloneable).setTime(l);
                    zipOutputStream.putNextEntry((ZipEntry)cloneable);
                    this.manifest.write(new BufferedOutputStream(zipOutputStream));
                    zipOutputStream.closeEntry();
                    System.out.println("jar-file with timestamp ");
                } else {
                    zipOutputStream = new JarOutputStream((OutputStream)fileOutputStream, this.manifest);
                    System.out.println("jar-file with current file time ");
                }
            } else {
                zipOutputStream = new ZipOutputStream(fileOutputStream);
            }
            zipOutputStream.setLevel(n);
            cloneable = new ArrayList();
            for (Src object32 : this.listSrc) {
                void var13_19;
                String string2 = object32.path;
                if (string2.startsWith("/tmp/") && (object = System.getenv("TMP")) != null) {
                    String string3 = (String)object + string2.substring(4);
                }
                System.out.println("  +  : " + (String)var13_19);
                FileSystem.addFilesWithBasePath(object32.dir, (String)var13_19, (List<FileSystem.FileAndBasePath>)((Object)cloneable));
            }
            if (this.bsort) {
                iterator = new TreeMap();
                Iterator iterator2 = cloneable.iterator();
                while (iterator2.hasNext()) {
                    FileSystem.FileAndBasePath fileAndBasePath = (FileSystem.FileAndBasePath)iterator2.next();
                    iterator.put(fileAndBasePath.localPath, fileAndBasePath);
                }
                cloneable.clear();
                for (Map.Entry entry : iterator.entrySet()) {
                    cloneable.add(entry.getValue());
                }
            }
            System.out.println(" files:" + cloneable.size());
            iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                FileSystem.FileAndBasePath fileAndBasePath = (FileSystem.FileAndBasePath)iterator.next();
                if (!fileAndBasePath.file.isFile()) continue;
                Object var13_27 = null;
                object = null;
                String string4 = fileAndBasePath.localPath;
                if (string4.startsWith("/")) {
                    string4 = string4.substring(1);
                }
                try {
                    int n2;
                    void var13_30;
                    if (this.manifest != null) {
                        JarEntry jarEntry = new JarEntry(string4);
                    } else {
                        ZipEntry zipEntry = new ZipEntry(string4);
                    }
                    var13_30.setTime(l == 0L ? fileAndBasePath.file.lastModified() : l);
                    zipOutputStream.putNextEntry((ZipEntry)var13_30);
                    object = new FileInputStream(fileAndBasePath.file);
                    while ((n2 = ((InputStream)object).read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                }
                catch (IOException iOException) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(iOException.getMessage()).append("\n");
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                    if (var13_27 == null) continue;
                    zipOutputStream.closeEntry();
                }
            }
            zipOutputStream.close();
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Archiver.createJar - unexpected IOException");
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Archiver.createJar - unexpected IOException");
            }
        }
        this.listSrc.clear();
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }

    public String exec(Args args) throws IOException {
        if (args.sManifest != null) {
            this.setManifest(new File(args.sManifest));
        }
        this.bsort = args.sortFiles;
        this.listSrc.addAll(args.listSrc);
        long l = 0L;
        if (args.timestamp != null) {
            System.out.println("org.vishia.util.Zip: timestamp = " + args.timestamp + " (" + args.timeFormat + ")");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(args.timeFormat);
            try {
                Date date = simpleDateFormat.parse(args.timestamp);
                l = date.getTime();
            }
            catch (ParseException parseException) {
                System.err.println("org.vishia.util.Zip: faulty format for -time:" + args.timestamp + " - uses the current file time stamp");
            }
        }
        System.out.println("org.vishia.util.Zip: write zip file to " + args.fOut);
        return this.exec(args.fOut, args.compress, args.comment, l);
    }

    public static String zipfiles(File file, File file2, String string, int n, String string2) throws IOException {
        Zip zip = new Zip();
        zip.addSource(string);
        return zip.exec(file, n, string2, 0L);
    }

    public static void main(String[] stringArray) {
        Args args = new Args();
        Cmdline cmdline = new Cmdline(args);
        try {
            cmdline.parseArguments(stringArray);
        }
        catch (ParseException parseException) {
            cmdline.setExitErrorLevel(5);
            cmdline.exit();
        }
        Zip zip = new Zip();
        try {
            zip.exec(args);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    static class Cmdline
    extends MainCmd {
        final Args args;
        MainCmd.SetArgument setCompress = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                char c;
                if (string.length() == 1 && (c = string.charAt(0)) >= '0' && c <= '9') {
                    args.compress = c - 48;
                    return true;
                }
                return false;
            }
        };
        MainCmd.SetArgument setInput = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.listSrc.add(new Src(string, null));
                return true;
            }
        };
        MainCmd.SetArgument setOutput = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.fOut = new File(string);
                return true;
            }
        };
        MainCmd.SetArgument setManifest = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.sManifest = string;
                return true;
            }
        };
        MainCmd.SetArgument setTimestamp = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.timestamp = string;
                return true;
            }
        };
        MainCmd.SetArgument sort = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.sortFiles = true;
                return true;
            }
        };
        MainCmd.Argument[] argList = new MainCmd.Argument[]{new MainCmd.Argument("-compress", ":0..9 set the compression rate 0=non .. 90max", this.setCompress), new MainCmd.Argument("-o", ":ZIP.zip file for zip output", this.setOutput), new MainCmd.Argument("-sort", " sorts entries with path", this.sort), new MainCmd.Argument("-time", ":yyyy-MM-dd+hh:mm sets a timestamp", this.setTimestamp), new MainCmd.Argument("-timeformat", ":yyyy-MM-dd+hh:mm is default, can define other format, see java.text.SimpleDataFormat", this.setTimestamp), new MainCmd.Argument("-manifest", ":<manifestfile> creates a jar file", this.setManifest), new MainCmd.Argument("", "INPUT file possible with wildcards also in path like \"path/** /dir* /name*.ext*\"", this.setInput)};

        @Override
        protected boolean checkArguments() {
            return this.args.fOut != null;
        }

        Cmdline(Args args) {
            this.args = args;
            super.addAboutInfo("Zip routine from Java");
            super.addAboutInfo("made by HSchorrig, 2013-02-09 - 2020-03-20");
            super.addHelpInfo("args: -compress:# -o:ZIP.zip { INPUT}");
            super.addArgument(this.argList);
            super.addStandardHelpInfo();
        }
    }

    public static class Args {
        public final List<Src> listSrc = new ArrayList<Src>();
        public int compress = 5;
        public File fOut;
        public String comment = "";
        public boolean sortFiles;
        public String sManifest;
        public String timestamp;
        public String timeFormat = "yyyy-MM-dd+hh:mm";
    }

    static class Src {
        String path;
        File dir;

        Src(String string, File file) {
            this.path = string;
            this.dir = file;
        }
    }
}

