/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.vishia.util.Java4C;
import org.vishia.util.StringFunctions;

public final class StringFormatter
implements Appendable,
Closeable,
Flushable {
    public static final String version = "2019-04-29";
    private static final byte mNrofBytesInWord = 31;
    private static final byte mBytesInWordBigEndian = 32;
    public static final short k1 = 1;
    public static final short k2right = 2;
    public static final short k2left = 34;
    public static final short k4right = 4;
    public static final short k4left = 36;
    public static final short k6right = 6;
    public static final short k6left = 38;
    public static final short k8right = 8;
    public static final short k8left = 40;
    private static final String spaces = "                                                                                                                                                ";
    protected final StringBuilder buffer;
    protected Appendable lineout;
    private final boolean bShouldLineoutClose;
    private char secondNewline = '\u0000';
    protected int pos_ = 0;
    private boolean bInsert = false;
    private String sNewline = "\n";
    private char cDecimalSeparator = (char)46;
    String sDatePrefixNewer = "";
    SimpleDateFormat dateFormatNewer = new SimpleDateFormat("?yy-MM-dd HH:mm:ss");
    String sDatePrefixToday = "today";
    SimpleDateFormat dateFormatToday = new SimpleDateFormat(" HH:mm:ss");
    String sDatePrefixYear = "";
    SimpleDateFormat dateFormatYear = new SimpleDateFormat("MMM-dd HH:mm:ss");
    String sDatePrefixOlder = "";
    SimpleDateFormat dateFormatOlder = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    private static final long[] n10a = new long[]{1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L};
    static String sNeg = "+-%";

    public StringFormatter() {
        this.buffer = new StringBuilder();
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public StringFormatter(Appendable appendable, boolean bl, String string, int n) {
        this.buffer = new StringBuilder(n);
        this.sNewline = string;
        this.lineout = appendable;
        if (bl) assert (appendable instanceof Closeable);
        this.bShouldLineoutClose = bl;
    }

    public StringFormatter(int n) {
        this.buffer = new StringBuilder(n);
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public StringFormatter(String string) {
        this.buffer = new StringBuilder(string);
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public StringFormatter(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String getContent() {
        return this.buffer.toString();
    }

    public CharSequence getBuffer() {
        return this.buffer;
    }

    public void setDecimalSeparator(char c) {
        this.cDecimalSeparator = c;
    }

    public StringFormatter reset() {
        this.pos_ = 0;
        this.buffer.setLength(this.pos_);
        return this;
    }

    public StringFormatter end() {
        this.pos_ = this.buffer.length();
        return this;
    }

    public StringFormatter pos(int n) {
        return this.pos(n, -1);
    }

    public StringFormatter pos(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative position not supported");
        }
        this.pos_ = n2 >= 0 && this.pos_ + n2 > n ? (this.pos_ += n2) : n;
        for (int i = this.buffer.length(); i < this.pos_; ++i) {
            this.buffer.append(' ');
        }
        return this;
    }

    public int replaceHolder(String string, String string2) {
        return this.replace("<&" + string + ">", 0, string2);
    }

    public int replace(String string, int n, CharSequence charSequence) {
        int n2 = this.buffer.indexOf(string, n);
        if (n2 >= 0) {
            int n3 = charSequence.length();
            int n4 = n3 - string.length();
            if (n4 > 0) {
                this.buffer.insert(n2, spaces.substring(0, n4));
            } else if (n4 < 0) {
                this.buffer.delete(n2, n2 - n4);
            }
            for (int i = 0; i < n3; ++i) {
                this.buffer.setCharAt(n2 + i, charSequence.charAt(i));
            }
            if (this.pos_ > n2 + n3) {
                this.pos_ += n4;
            }
        }
        return n2;
    }

    public int length() {
        return this.buffer.length();
    }

    public int getPos() {
        return this.pos_;
    }

    private void prepareBufferPos(int n) {
        if (this.bInsert && this.pos_ < this.buffer.length()) {
            while (n > 0) {
                if (n >= spaces.length()) {
                    this.buffer.insert(this.pos_, spaces);
                    n -= spaces.length();
                    continue;
                }
                this.buffer.insert(this.pos_, spaces, 0, n);
                n = 0;
            }
        } else {
            int n2 = this.buffer.length() - this.pos_;
            assert (n2 >= 0);
            n -= n2;
            while (n > 0) {
                if (n >= spaces.length()) {
                    this.buffer.append(spaces);
                    n -= spaces.length();
                    continue;
                }
                this.buffer.append(spaces, 0, n);
                n = 0;
            }
        }
    }

    public StringFormatter add(CharSequence charSequence) {
        int n = charSequence.length();
        this.prepareBufferPos(n);
        this.buffer.delete(this.pos_, this.pos_ + n);
        this.buffer.insert(this.pos_, charSequence, 0, n);
        this.pos_ += n;
        return this;
    }

    public StringFormatter add(String string) {
        int n = string.length();
        this.prepareBufferPos(n);
        this.buffer.delete(this.pos_, this.pos_ + n);
        this.buffer.insert(this.pos_, string, 0, n);
        this.pos_ += n;
        return this;
    }

    public StringFormatter addReplaceLinefeed(CharSequence charSequence, CharSequence charSequence2, int n) {
        if (n > charSequence.length()) {
            n = charSequence.length();
        }
        if (charSequence2.length() < 4) {
            throw new IllegalArgumentException("The argument replaceLinefeed should have 4 characters.");
        }
        this.prepareBufferPos(n);
        int n2 = -1;
        while (--n >= 0) {
            char c;
            int n3;
            if ((n3 = "\n\r\f".indexOf(c = charSequence.charAt(++n2))) >= 0) {
                c = charSequence2.charAt(n3);
            }
            if (c <= ' ') {
                c = charSequence2.charAt(3);
            }
            this.buffer.setCharAt(this.pos_++, c);
        }
        return this;
    }

    public StringFormatter add(char c) {
        this.prepareBufferPos(1);
        this.buffer.setCharAt(this.pos_++, c);
        return this;
    }

    public StringFormatter add(char[] cArray) {
        int n;
        for (n = cArray.length; n > 1 && cArray[n - 1] == '\u0000'; --n) {
        }
        this.prepareBufferPos(n);
        for (int i = 0; i < n; ++i) {
            this.buffer.setCharAt(this.pos_, cArray[i]);
            ++this.pos_;
        }
        return this;
    }

    public StringFormatter insert(String string) {
        this.buffer.insert(this.pos_, string);
        this.pos_ += string.length();
        return this;
    }

    public StringFormatter overwrite() {
        this.bInsert = false;
        return this;
    }

    public StringFormatter insert() {
        this.bInsert = true;
        return this;
    }

    public boolean setInsertMode(boolean bl) {
        boolean bl2 = this.bInsert;
        this.bInsert = bl;
        return bl2;
    }

    public StringFormatter addStringLine(byte[] byArray, int n, int n2, String string) {
        String string2;
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        for (int i = 0; i < n2; ++i) {
            if (byArray2[i] >= 32) continue;
            byArray2[i] = 46;
        }
        try {
            string2 = new String(byArray2, 0, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "??encoding error??";
        }
        int n3 = string2.length();
        this.prepareBufferPos(n3);
        this.buffer.replace(this.pos_, this.pos_ + n3, string2);
        this.pos_ += n3;
        return this;
    }

    public StringFormatter addHexLine(byte[] byArray, int n, int n2, short s) {
        int n3 = s & 0x1F;
        int n4 = n2 / n3;
        this.prepareBufferPos(2 * n2 + n4);
        int n5 = n2;
        int n6 = n;
        while (n5 > 0) {
            if (n5 < n3) {
                this.addHexWord_(byArray, n6, (short)((s & 0x20) + n5));
                n5 = 0;
                continue;
            }
            this.addHexWord_(byArray, n6, s);
            this.buffer.setCharAt(this.pos_++, ' ');
            n5 -= n3;
            n6 += n3;
        }
        return this;
    }

    public void addHexBlock(byte[] byArray, int n, int n2, short s, short s2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n3 = n2 <= 0 ? byArray.length + n2 : n2;
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        while (n4 < n3) {
            this.addHex(n4, 6).add(": ");
            this.addHexLine(byArray, n4, s, s2);
            this.newline();
            n4 += s;
        }
    }

    public StringFormatter addHexWord(byte[] byArray, int n, short s) {
        this.prepareBufferPos(2 * (s & 0x1F));
        return this.addHexWord_(byArray, n, s);
    }

    private StringFormatter addHexWord_(byte[] byArray, int n, short s) {
        int n2;
        int n3 = s & 0x1F;
        if ((s & 0x20) != 0) {
            n2 = 1;
        } else {
            n2 = -1;
            n += n3 - 1;
        }
        while (--n3 >= 0 && n < byArray.length) {
            byte by = byArray[n];
            n += n2;
            for (int i = 0; i < 2; ++i) {
                char c = (char)(((by & 0xF0) >> 4) + 48);
                if (c > '9') {
                    c = (char)(c + 97 - 57 - 1);
                }
                this.buffer.setCharAt(this.pos_++, c);
                by = (byte)(by << 4);
            }
        }
        return this;
    }

    public StringFormatter addHex(long l, int n) {
        int n2 = 97;
        if (n < 0) {
            n2 = 65;
            n = -n;
        }
        this.prepareBufferPos(n);
        int n3 = n * 4 - 4;
        for (int i = 0; i < n; ++i) {
            char c = (char)((l >> n3 & 0xFL) + 48L);
            if (c > '9') {
                c = (char)(c + (byte)n2 - 57 - 1);
            }
            this.buffer.setCharAt(this.pos_++, c);
            n3 -= 4;
        }
        return this;
    }

    public StringFormatter addBinary(int n, String string, String string2, String string3) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '1') continue;
            ++n3;
        }
        n2 = 1 << n3 - 1;
        this.prepareBufferPos(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '1') {
                int n4 = n & n2;
                char c2 = n4 != 0 ? string3.charAt(i) : string2.charAt(i);
                this.buffer.setCharAt(this.pos_++, c2);
                n2 = n2 >> 1 & Integer.MAX_VALUE;
                continue;
            }
            this.buffer.setCharAt(this.pos_++, c);
        }
        return this;
    }

    public StringFormatter addHex44(long l) {
        this.addHex(l >> 16 & 0xFFFFL, 4);
        this.buffer.insert(this.pos_++, '\'');
        this.addHex(l & 0xFFFFL, 4);
        return this;
    }

    public StringFormatter addFloat(double d, int n, int n2) {
        int n3 = n + n2 + 2;
        this.prepareBufferPos(n3);
        if (d < 0.0) {
            this.buffer.setCharAt(this.pos_++, '-');
            d = -d;
        } else {
            this.buffer.setCharAt(this.pos_++, ' ');
        }
        String string = Double.toString(d);
        int n4 = string.indexOf(46);
        if (this.cDecimalSeparator != '.') {
            string = string.replace('.', this.cDecimalSeparator);
        }
        int n5 = n - n4;
        int n6 = n2 - (string.length() - n4 - 1);
        if (n6 < 0) {
            n6 = 0;
        }
        int n7 = n - n5 + 1 + n2 - n6;
        while (n5 > 0) {
            this.buffer.setCharAt(this.pos_++, ' ');
            --n5;
        }
        if (n5 < 0) {
            n7 = n7 - -n5 - 2;
            this.buffer.replace(this.pos_, this.pos_ + 2, "##");
            this.pos_ += 2;
        }
        this.buffer.replace(this.pos_, this.pos_ + n7, string.substring(0, n7));
        this.pos_ += n7;
        while (--n6 >= 0) {
            this.buffer.setCharAt(this.pos_++, '0');
        }
        return this;
    }

    public static String addHexLn(byte[] byArray, int n, int n2) {
        int n3 = n2;
        StringFormatter stringFormatter = new StringFormatter();
        String string = "";
        while (n3 < n2 + n) {
            int n4 = n3 + 32;
            if (n4 > n) {
                n4 = n2 + n;
            }
            stringFormatter.addHexLine(byArray, n3, n4 - n3, (short)4);
            stringFormatter.add(" ");
            stringFormatter.addStringLine(byArray, n3, n4 - n3, "ISO-8859-1");
            string = string + stringFormatter.getContent() + "\n";
            stringFormatter.reset();
            n3 = n4;
        }
        try {
            stringFormatter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public StringFormatter addDate(Date date, SimpleDateFormat simpleDateFormat) {
        String string = simpleDateFormat.format(date);
        this.add(string);
        return this;
    }

    public StringFormatter setAt(int n, char c) {
        this.buffer.setCharAt(n, c);
        return this;
    }

    public StringFormatter addint(long l, String string) {
        this.strPicture(l, string, "+-..", '.');
        return this;
    }

    @Deprecated
    public StringFormatter addIntPicture(long l, String string) {
        this.strPicture(l, string, "+-..", '.');
        return this;
    }

    private boolean strPicture(long l, String string, String string2, char n) {
        char c;
        int n2;
        int n3;
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = StringFunctions.indexOfAnyChar(string, 0, Integer.MAX_VALUE, sNeg);
        if (n5 >= 0) {
            boolean bl3;
            if (l < 0L) {
                bl = true;
                l = -l;
                bl3 = true;
            } else if (string.charAt(n5) != '-') {
                bl3 = true;
            } else {
                bl3 = false;
                n4 = 0;
            }
        } else if (l < 0L) {
            throw new IllegalArgumentException("value should be only positive: " + l);
        }
        for (n3 = n10a.length - 1; n3 >= 0 && l >= n10a[n3]; --n3) {
        }
        int n6 = n10a.length - ++n3 + 1;
        int n7 = n2 = string.length();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n7 > 0) {
            if ((c = string.charAt(--n7)) <= '2' && c >= '0') {
                ++n10;
                ++n11;
                if (c == '0') {
                    ++n8;
                    n9 = n10;
                    continue;
                }
                if (c != '1') continue;
                n9 = n10;
                continue;
            }
            if (c > '9' || c < '3') continue;
            ++n11;
        }
        if (n6 > n11) {
            c = '\u0001';
            n10 = n11;
        } else {
            c = '\u0000';
            if (n6 > n10) {
                n10 = n6;
            }
        }
        this.prepareBufferPos(n2 - (n11 - n10) - n4);
        n7 = 0;
        for (n7 = 0; n7 < n2; ++n7) {
            int n12;
            block33: {
                int n13;
                block34: {
                    block32: {
                        n13 = string.charAt(n7);
                        if (n13 < 48 || n13 > 57) break block32;
                        if (--n11 >= n10) {
                            n12 = 0;
                        } else {
                            if (n10 > n6) {
                                n12 = n9 >= n10 ? 48 : 32;
                            } else {
                                n9 = 0;
                                if (c != '\u0000') {
                                    n12 = 35;
                                } else if (l == 0L) {
                                    n12 = n8 >= n6 ? 0 : 48;
                                } else if (n3 >= n10a.length) {
                                    n12 = (char)(l + 48L);
                                } else {
                                    long l2 = n10a[n3];
                                    ++n3;
                                    n12 = 48;
                                    while (l >= l2) {
                                        n12 = (char)(n12 + 1);
                                        l -= l2;
                                    }
                                }
                                --n6;
                            }
                            --n10;
                        }
                        break block33;
                    }
                    int n14 = string2.indexOf(n13);
                    if (n14 < 0) break block34;
                    switch (n14) {
                        case 0: {
                            n12 = string2.charAt(bl ? 1 : 0);
                            break block33;
                        }
                        case 1: {
                            n12 = bl ? n13 : (bl2 ? 0 : 32);
                            break block33;
                        }
                        case 2: {
                            n12 = n;
                            break block33;
                        }
                        case 3: {
                            n12 = n == 46 ? 32 : (int)n;
                            break block33;
                        }
                        default: {
                            throw new RuntimeException("unexpected case");
                        }
                    }
                }
                n12 = n13;
            }
            if (n12 == 0) continue;
            this.buffer.setCharAt(this.pos_++, (char)n12);
        }
        return c == '\u0000';
    }

    public int addFloatPicture(float f, String string) {
        long l;
        boolean bl;
        String string2 = "afpnum.kMGT";
        int n = string2.indexOf(46);
        int n2 = Float.floatToRawIntBits(f);
        byte by = (byte)(n2 >> 24 & 0x7F);
        if (by > 104) {
            f = 9.999999E17f;
        } else if (by < 24) {
            f = 0.0f;
        }
        boolean bl2 = n2 < 0;
        boolean bl3 = bl = (n2 & 0x7F800000) == 0;
        if (bl2) {
            f = -f;
        }
        if (!bl) {
            while (f >= 1000.0f && n < string2.length() - 1) {
                f /= 1000.0f;
                ++n;
            }
            while (f < 1.0f && n > 0) {
                f *= 1000.0f;
                --n;
            }
            if (bl2) {
                f = -f;
            }
            l = (long)f;
        } else {
            l = 0L;
        }
        this.strPicture(l, string, "+-.@", string2.charAt(n));
        return string.length();
    }

    @Java4C.Exclude
    public String convertTimestampToday(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        String string = l3 < -36000000L ? this.sDatePrefixNewer + this.dateFormatNewer.format(l) : (l3 < 64800000L ? this.sDatePrefixToday + this.dateFormatToday.format(l) : (l3 < 27648000000L ? this.sDatePrefixYear + this.dateFormatYear.format(l) : this.sDatePrefixOlder + this.dateFormatOlder.format(l)));
        return string;
    }

    @Override
    public StringFormatter append(CharSequence charSequence) throws IOException {
        this.append(charSequence, 0, charSequence.length());
        return this;
    }

    public void newline() throws IOException {
        this.append('\n');
    }

    @Override
    public StringFormatter append(char c) throws IOException {
        Appendable appendable = this.lineout;
        if (this.lineout != null && (c == '\n' || c == '\r')) {
            if (c != this.secondNewline || this.pos_ > 0) {
                this.flushLine(this.sNewline);
                if (this.sNewline == null) {
                    appendable.append(c);
                }
                this.secondNewline = (char)(c == '\r' ? 10 : 13);
            } else if (this.sNewline == null) {
                appendable.append(c);
            }
        } else {
            this.add(c);
        }
        return this;
    }

    @Override
    public StringFormatter append(CharSequence charSequence, int n, int n2) throws IOException {
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            this.append(c);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.lineout != null) {
            this.lineout.append(this.buffer);
            if (this.lineout instanceof Flushable) {
                ((Flushable)((Object)this.lineout)).flush();
            }
        }
        this.reset();
    }

    public int flushLine(String string) throws IOException {
        Appendable appendable = this.lineout;
        int n = this.pos_;
        if (this.pos_ > 0) {
            appendable.append(this.buffer, 0, this.pos_);
            this.buffer.setLength(0);
            this.pos_ = 0;
        }
        if (string != null) {
            appendable.append(string);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.lineout != null) {
            this.lineout.append(this.buffer);
            this.reset();
            if (this.bShouldLineoutClose && this.lineout instanceof Closeable) {
                ((Closeable)((Object)this.lineout)).close();
                this.lineout = null;
            }
        }
    }
}

