/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.util.Arrays;
import org.vishia.bridgeC.ConcurrentLinkedQueue;
import org.vishia.bridgeC.MemC;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.bridgeC.VaArgBuffer;
import org.vishia.bridgeC.Va_list;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.MsgText_ifc;
import org.vishia.util.Java4C;

public class MsgDispatcherCore
implements LogMessage {
    public static final int version = 20130302;
    public static final int mDispatchInDispatcherThread = Integer.MIN_VALUE;
    public static final int mDispatchInCallingThread = 0x40000000;
    public static final int mDispatchBits = 0x3FFFFFFF;
    protected final int nrofMixedOutputs;
    public final int mDstMixedOutputs;
    public final int mDstOneOutput;
    public static final int mConsole = 1;
    public static final int mConsoleQueued = 2;
    public static final int mAdd = 51933;
    public static final int mSet = 50669;
    public static final int mRemove = 52705;
    long idThreadForDispatching;
    final TestCnt testCnt = new TestCnt();
    final ConcurrentLinkedQueue<Entry> listOrders;
    final ConcurrentLinkedQueue<Entry> freeOrders;
    protected final Entry entryMsgBufferOverflow = new Entry();
    protected int actNrofListIdents;
    protected int[] listIdents;
    protected int[] listBitDst;
    protected Output[] outputs;
    protected MsgText_ifc msgText;
    protected final Runnable runNoEntryMessage;
    int ctLostMessages;

    MsgDispatcherCore(int n, int n2, Runnable runnable) {
        this.runNoEntryMessage = runnable;
        this.nrofMixedOutputs = n2;
        if (n2 < 0 || n2 > 28) {
            throw new IllegalArgumentException("max. nrofMixedOutputs");
        }
        this.mDstMixedOutputs = (1 << n2) - 1;
        this.mDstOneOutput = 0x3FFFFFFF & ~this.mDstMixedOutputs;
        MemC memC = MemC.alloc((n + 2) * Entry._sizeof());
        this.freeOrders = new ConcurrentLinkedQueue(memC);
        this.listOrders = new ConcurrentLinkedQueue<Entry>(this.freeOrders);
    }

    public void setIdThreadForMsgDispatching(long l) {
        this.idThreadForDispatching = l;
    }

    public final void setMsgTextConverter(MsgText_ifc msgText_ifc) {
        this.msgText = msgText_ifc;
    }

    public final int searchDispatchBits(int n) {
        int n2;
        if (n < 0) {
            n = -n;
        }
        if ((n2 = Arrays.binarySearch(this.listIdents, 0, this.actNrofListIdents, n)) < 0) {
            n2 = -n2 - 2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = this.listBitDst[n2];
        return n3;
    }

    @Override
    public final boolean sendMsg(int n, String string, Object ... objectArray) {
        Va_list va_list = new Va_list(objectArray);
        return this.sendMsgVaList(n, OS_TimeStamp.os_getDateTime(), string, va_list);
    }

    @Override
    public final boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, String string, Object ... objectArray) {
        Va_list va_list = new Va_list(objectArray);
        return this.sendMsgVaList(n, oS_TimeStamp, string, va_list);
    }

    @Override
    public final boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
        int n2 = this.searchDispatchBits(n);
        if (n2 != 0) {
            boolean bl = this.idThreadForDispatching != 0L && Thread.currentThread().getId() == this.idThreadForDispatching;
            int n3 = (n2 & 0x40000000) != 0 || bl ? this.dispatchMsg(n2, false, bl, n, oS_TimeStamp, string, va_list) : n2;
            if (n3 != 0) {
                Entry entry = (Entry)this.freeOrders.poll();
                if (entry == null) {
                    if (this.runNoEntryMessage != null) {
                        this.runNoEntryMessage.run();
                    }
                    if (++this.ctLostMessages == 0) {
                        this.ctLostMessages = 1;
                    }
                } else {
                    entry.dst = n3;
                    entry.ident = n;
                    entry.text = string;
                    entry.timestamp.set(oS_TimeStamp);
                    entry.values.copyFrom(string, va_list);
                    this.listOrders.offer(entry);
                }
            }
        }
        return true;
    }

    @Override
    public final boolean isOnline() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public final void tickAndFlushOrClose() {
        this.dispatchQueuedMsg();
        for (int i = 0; i < this.outputs.length; ++i) {
            Output output = this.outputs[i];
            if (!output.dstInDispatcherThread) continue;
            output.outputIfc.flush();
        }
    }

    public final int dispatchQueuedMsg() {
        boolean bl;
        int n = 0;
        int n2 = 100;
        Object var4_3 = null;
        do {
            Entry entry;
            boolean bl2 = bl = (entry = (Entry)this.listOrders.poll()) != null && entry != var4_3;
            if (!bl) continue;
            ++n;
            this.dispatchMsg(entry.dst, true, false, entry.ident, entry.timestamp, entry.text, entry.values.get_va_list());
            entry.values.clean();
            entry.ident = 0;
            this.freeOrders.offer(entry);
        } while (bl && --n2 >= 0);
        if (this.ctLostMessages > 0) {
            this.entryMsgBufferOverflow.values.setArg(0, this.ctLostMessages);
            this.ctLostMessages = 0;
            int n3 = this.searchDispatchBits(this.entryMsgBufferOverflow.ident);
            this.entryMsgBufferOverflow.timestamp.set(OS_TimeStamp.os_getDateTime());
            this.dispatchMsg(n3, true, false, this.entryMsgBufferOverflow.ident, this.entryMsgBufferOverflow.timestamp, this.entryMsgBufferOverflow.text, this.entryMsgBufferOverflow.values.get_va_list());
        }
        if (n2 == 0) {
            ++this.testCnt.tomuchMsgPerThread;
        }
        return n;
    }

    protected final int dispatchMsg(int n, boolean bl, boolean bl2, int n2, OS_TimeStamp oS_TimeStamp, String string, Va_list va_list) {
        n &= 0x3FFFFFFF;
        int n3 = 1;
        int n4 = 0;
        String string2 = string;
        boolean bl3 = false;
        while (n != 0 && n3 < 0x3FFFFFFF) {
            if ((n & n3) != 0 && (bl2 || this.outputs[n4].dstInDispatcherThread && bl || !this.outputs[n4].dstInDispatcherThread && !bl)) {
                Output output = this.outputs[n4];
                LogMessage logMessage = output.outputIfc;
                if (logMessage != null) {
                    boolean bl4;
                    if (!bl3 && this.msgText != null && output.bUseText) {
                        bl3 = true;
                        string2 = this.msgText.getMsgText(n2);
                        if (string2 == null || string2.isEmpty()) {
                            string2 = string;
                        }
                    }
                    if (bl4 = logMessage.sendMsgVaList(n2, oS_TimeStamp, string2, va_list)) {
                        n &= ~n3;
                    }
                } else {
                    n &= ~n3;
                    ++this.testCnt.noOutput;
                }
            }
            n3 <<= 1;
            ++n4;
        }
        return n;
    }

    protected static final class Output {
        String name;
        LogMessage outputIfc;
        boolean dstInDispatcherThread;
        boolean bUseText;

        protected Output() {
        }

        @Java4C.Exclude
        public String toString() {
            return this.name + ":" + this.outputIfc;
        }
    }

    protected static final class TestCnt {
        int noOutput;
        int tomuchMsgPerThread;

        protected TestCnt() {
        }
    }

    public static final class Entry {
        public int ident;
        public int dst;
        public String text;
        public final OS_TimeStamp timestamp = new OS_TimeStamp();
        public final VaArgBuffer values = new VaArgBuffer(11);

        public static int _sizeof() {
            return 1;
        }
    }
}

