/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import org.vishia.bridgeC.ConcurrentLinkedQueue;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.msgDispatch.MsgDispatcherCore;
import org.vishia.util.FileWriter;
import org.vishia.util.StringPartScan;

public class MsgDispatcher
extends MsgDispatcherCore {
    public static final int version = 538051330;
    public final LogMessage outputConsole = LogMessageStream.create(FileDescriptor.out);
    private int maxDst = 0;

    public MsgDispatcher(int n, int n2, int n3, int n4, int n5, Runnable runnable) {
        super(n2, n4, runnable);
        int n6;
        this.entryMsgBufferOverflow.ident = n5;
        this.entryMsgBufferOverflow.text = "Message queue overflow; nrof msg=%d";
        MsgDispatcherCore.Entry[] entryArray = new MsgDispatcherCore.Entry[n2];
        for (n6 = 0; n6 < entryArray.length; ++n6) {
            entryArray[n6] = new MsgDispatcherCore.Entry();
        }
        for (n6 = 0; n6 < n2; ++n6) {
            this.freeOrders.add(entryArray[n6]);
        }
        this.listIdents = new int[n];
        this.listBitDst = new int[n];
        this.listIdents[0] = 0;
        this.listIdents[1] = Integer.MAX_VALUE;
        this.listBitDst[0] = 0;
        this.listBitDst[1] = -1;
        this.actNrofListIdents = 2;
        this.outputs = new MsgDispatcherCore.Output[n3];
        for (int i = 0; i < n3; ++i) {
            this.outputs[i] = new MsgDispatcherCore.Output();
        }
        this.setOutputRoutine(0, "CON", false, true, this.outputConsole);
        this.setOutputRoutine(1, "qCON", true, true, this.outputConsole);
        this.setOutputRange(0, Integer.MAX_VALUE, 1, 50669, 3);
    }

    public final ConcurrentLinkedQueue<MsgDispatcherCore.Entry> getSharedFreeEntries() {
        return this.freeOrders;
    }

    public final void setDefaults(String string) {
        this.setOutputRoutine(0, "CON", false, true, this.outputConsole);
        this.setOutputRoutine(1, "qCON", true, true, this.outputConsole);
        this.setOutputRange(0, Integer.MAX_VALUE, 1, 50669, 3);
    }

    private final int insertIdent(int n, int n2, int n3) {
        int n4;
        int n5 = this.listIdents[n];
        int n6 = this.listIdents[n + 1];
        if (n5 < n2 && n3 + 1 < n6) {
            n4 = n + 1;
            this.actNrofListIdents += 2;
            System.arraycopy(this.listIdents, n + 1, this.listIdents, n + 3, this.actNrofListIdents - (n + 3));
            System.arraycopy(this.listBitDst, n + 1, this.listBitDst, n + 3, this.actNrofListIdents - (n + 3));
            this.listIdents[n4] = n2;
            this.listIdents[n4 + 1] = n3 + 1;
            int n7 = this.listBitDst[n];
            this.listBitDst[n4 + 1] = n7;
            this.listBitDst[n4] = n7;
        } else if (n5 < n2) {
            assert (n3 + 1 == n6);
            n4 = n + 1;
            ++this.actNrofListIdents;
            System.arraycopy(this.listIdents, n + 1, this.listIdents, n + 2, this.actNrofListIdents - (n + 2));
            System.arraycopy(this.listBitDst, n + 1, this.listBitDst, n + 2, this.actNrofListIdents - (n + 2));
            this.listIdents[n4] = n2;
            this.listBitDst[n4] = this.listBitDst[n];
        } else if (n5 == n2 && n3 + 1 < n6) {
            ++this.actNrofListIdents;
            n4 = n;
            System.arraycopy(this.listIdents, n + 1, this.listIdents, n + 2, this.actNrofListIdents - (n + 2));
            System.arraycopy(this.listBitDst, n + 1, this.listBitDst, n + 2, this.actNrofListIdents - (n + 2));
            this.listIdents[n + 1] = n3 + 1;
            this.listBitDst[n + 1] = this.listBitDst[n];
        } else {
            assert (n5 == n2 && n3 + 1 == n6);
            n4 = n;
        }
        return n4;
    }

    public final void setOutputRoutine(int n, String string, boolean bl, boolean bl2, LogMessage logMessage) {
        if (n < 0 || n > this.outputs.length) {
            throw new IllegalArgumentException("dstIdx fault. Hint: an index, not a mask!");
        }
        if (this.maxDst <= n) {
            this.maxDst = n + 1;
        }
        this.outputs[n].outputIfc = logMessage;
        this.outputs[n].dstInDispatcherThread = bl;
        this.outputs[n].bUseText = bl2;
        this.outputs[n].name = string;
    }

    public final int setOutputRange(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.completeDispatchInThreadBits(n3);
        if (n2 == Integer.MAX_VALUE) {
            n2 = 0x7FFFFFFE;
        }
        if ((n10 = Arrays.binarySearch(this.listIdents, 0, this.actNrofListIdents, n)) < 0) {
            n10 = -n10 - 2;
        }
        if (n10 < 0) {
            n10 = 0;
        }
        if (n2 < (n9 = this.listIdents[n10 + 1])) {
            n8 = this.insertIdent(n10, n, n2);
            n7 = n8 + 1;
        } else {
            n6 = this.listIdents[n10 + 1];
            n8 = this.insertIdent(n10, n, n6 - 1);
            int n12 = Arrays.binarySearch(this.listIdents, 0, this.actNrofListIdents, n2 + 1);
            if (n12 < 0) {
                n12 = -n12 - 2;
            }
            int n13 = this.listIdents[n12 + 1];
            int n14 = this.listBitDst[n12];
            n7 = this.insertIdent(n12, n2 + 1, n13 - 1);
        }
        block5: for (n6 = n8; n6 < n7; ++n6) {
            switch (n4) {
                case 50669: {
                    this.listBitDst[n6] = n11;
                    continue block5;
                }
                case 51933: {
                    int n15 = n6;
                    this.listBitDst[n15] = this.listBitDst[n15] | n11;
                    continue block5;
                }
                case 52705: {
                    int n16 = n6;
                    this.listBitDst[n16] = this.listBitDst[n16] & ~(n11 & 0x3FFFFFFF);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("failed mode");
                }
            }
        }
        return 0;
    }

    public final String setOutputFromString(String string, StringBuilder stringBuilder) {
        int n;
        String string2 = null;
        if (stringBuilder != null) {
            stringBuilder.setLength(0);
        }
        StringPartScan stringPartScan = new StringPartScan(string);
        stringPartScan.setIgnoreWhitespaces(true);
        stringPartScan.setIgnoreComment("/*", "*/");
        stringPartScan.setIgnoreEndlineComment("//");
        boolean bl = true;
        try {
            do {
                if (stringPartScan.seekNoWhitespaceOrComments().length() == 0) {
                    bl = false;
                    continue;
                }
                if (stringPartScan.scanInteger().scanOk()) {
                    int n2;
                    n = (int)stringPartScan.getLastScannedIntegerNumber();
                    int n3 = -1;
                    if (stringPartScan.scan("..").scanInteger().scanOk()) {
                        n3 = (int)stringPartScan.getLastScannedIntegerNumber();
                    }
                    if (!stringPartScan.scan(":").scanOk()) {
                        string2 = n3 == -1 ? "\":\"or \"..\" expected" : "\":\" expected";
                        continue;
                    }
                    if (n3 == -1) {
                        n3 = n;
                    }
                    if (stringPartScan.scanHexOrDecimal(8).scanOk()) {
                        n2 = (int)stringPartScan.getLastScannedIntegerNumber();
                        this.setOutputRange(n, n3, n2, 50669, 3);
                        if (stringPartScan.scan(";").scanOk()) continue;
                        string2 = "\";\" expected after number-output.";
                        continue;
                    }
                    n2 = 1;
                    int n4 = 50669;
                    do {
                        String string3 = null;
                        if (stringPartScan.scan("+").scanOk()) {
                            n4 = 51933;
                        } else if (stringPartScan.scan("-").scanOk()) {
                            n4 = 52705;
                        } else if (stringPartScan.scan(";").scanOk()) {
                            n2 = 0;
                        } else if (n4 != 50669) {
                            string2 = "\"+\" or \"-\" or \";\" expected";
                        }
                        if (n2 == 0 || string2 != null) continue;
                        if (stringPartScan.scanIdentifier().scanOk()) {
                            string3 = stringPartScan.getLastScannedString().toString();
                        } else {
                            string2 = "\"DST\" expected, DST should be an identifier.";
                        }
                        if (string2 != null) continue;
                        assert (string3 != null);
                        int n5 = -1;
                        int n6 = 0;
                        while (n6 < this.outputs.length && n5 == -1) {
                            if (this.outputs[n6].name != null && this.outputs[n6].name.equals(string3)) {
                                n5 = 1 << n6;
                                continue;
                            }
                            ++n6;
                        }
                        if (n5 == -1) {
                            if (stringBuilder != null) {
                                stringBuilder.append("Output not found:").append(string3);
                            }
                            string2 = string3;
                            bl = false;
                            continue;
                        }
                        this.setOutputRange(n, n3, n5, n4, 3);
                        n4 = -1;
                    } while (string2 == null && n2 != 0 && bl);
                    continue;
                }
                string2 = "Number for first message to dispatch expected";
                bl = false;
            } while (bl && string2 == null);
        }
        catch (ParseException parseException) {
            string2 = parseException.getMessage();
        }
        if (string2 != null && stringBuilder != null && stringBuilder.length() == 0) {
            n = stringBuilder.capacity() - string2.length() - 5;
            stringBuilder.append(string2).append(" at:").append(stringPartScan.getCurrent(n));
        }
        stringPartScan.close();
        return string2;
    }

    public final boolean reportOutput(FileWriter fileWriter) {
        boolean bl = true;
        try {
            int n;
            fileWriter.write("//Syntax-Example\n");
            fileWriter.write("//  1200..1257: +File +qCON -CON;\n");
            fileWriter.write("//  4567:File;\n");
            fileWriter.write("//Ident number from..to or only one ident number.\n");
            fileWriter.write("//\":\" and \";\" are obligatory. Whitespaces in a line and line end comment are allowed.\n");
            fileWriter.write("//if first DST without \"+\" or \"-\": Redirect first only to this destination, all existing dst are deleted.\n");
            fileWriter.write("//All following dst have to be separated with \"+\" or \"-\":\n");
            fileWriter.write("//\"+\" means: use Dst, \"-\" means, don't use, delete if exists before.\n");
            fileWriter.write("//at exampe switch off file output for a single ident, than write:\n");
            fileWriter.write("//1234:-File;  \n");
            fileWriter.write("\n//All existing dst (destinations):\n");
            StringBuilder stringBuilder = new StringBuilder(200);
            for (n = 0; n < this.maxDst; ++n) {
                stringBuilder.setLength(0);
                MsgDispatcherCore.Output output = this.outputs[n];
                if (output.outputIfc == null) continue;
                stringBuilder.append("//").append(n).append(": ").append(output.name);
                if (output.dstInDispatcherThread) {
                    stringBuilder.append(" - queued");
                }
                stringBuilder.append(";\n");
                fileWriter.write(stringBuilder.toString());
            }
            fileWriter.write("\n//All existing dispatching entries:\n");
            for (n = 0; n < this.actNrofListIdents - 1; ++n) {
                int n2 = this.listIdents[n];
                int n3 = this.listIdents[n + 1] - 1;
                stringBuilder.setLength(0);
                stringBuilder.append(n2);
                if (n3 != n2) {
                    stringBuilder.append("..").append(n3);
                }
                stringBuilder.append(":");
                int n4 = this.listBitDst[n];
                boolean bl2 = true;
                int n5 = 1;
                for (int i = 0; i < this.maxDst; ++i) {
                    if ((n4 & n5) != 0) {
                        MsgDispatcherCore.Output output = this.outputs[i];
                        if (output.outputIfc != null) {
                            if (!bl2) {
                                stringBuilder.append("+");
                            } else {
                                bl2 = false;
                            }
                            stringBuilder.append(output.name);
                        }
                    }
                    if (i < this.nrofMixedOutputs) {
                        n5 <<= 1;
                        continue;
                    }
                    int n6 = ((n4 & this.mDstOneOutput) >> this.nrofMixedOutputs) - 1 + this.nrofMixedOutputs;
                    if (n6 < this.nrofMixedOutputs) continue;
                    MsgDispatcherCore.Output output = this.outputs[i];
                    if (output.outputIfc == null) continue;
                    if (!bl2) {
                        stringBuilder.append("+");
                    } else {
                        bl2 = false;
                    }
                    stringBuilder.append(output.name);
                }
                stringBuilder.append(";\n");
                fileWriter.write(stringBuilder.toString());
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private final int completeDispatchInThreadBits(int n) {
        int n2 = n;
        assert (n >= 0);
        int n3 = 0;
        while (n != 0) {
            if ((n & 1) != 0) {
                n2 = this.outputs[n3].dstInDispatcherThread ? (n2 |= Integer.MIN_VALUE) : (n2 |= 0x40000000);
            }
            n >>= 1;
            ++n3;
        }
        return n2;
    }

    final void stop() {
    }

    @Override
    public final void close() {
        this.dispatchQueuedMsg();
    }

    @Override
    public final void flush() {
        this.dispatchQueuedMsg();
    }

    public class DispatcherThread
    extends Thread {
        private final int cycleMillisec;

        public DispatcherThread(int n) {
            super("MsgDisptch");
            this.cycleMillisec = n;
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.cycleMillisec);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MsgDispatcher.this.tickAndFlushOrClose();
            }
        }
    }
}

