/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.minisys;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class GetWebfile {
    public static void main(String[] stringArray) {
        int n = 0;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        if (stringArray.length < 2) {
            n = 4;
            System.out.println("org.vishia.minisys.GetWebfile <URL> <dst> [-md5:<hash>] [-strict]");
            System.out.println(" reads a file content from <URL> and writes it to <dst>");
            System.out.println(" <URL> is the same like a link in Web Browser to a file for download");
            System.out.println(" <dst> is a absolute or relative path written with / as separator.\n       if it ends with / then it is the directory for the named URL file.");
            System.out.println(" <hash> is the known and expected MD5-hash code of the downloaded file");
            System.out.println(" -strict then the file is not loaded if hash is faulty");
            System.out.println("exitcode 0: all ok, 2: hash faulty 5: parameter error");
            System.out.println(" Note: Use slash instead backslash on windows for file name too!");
            System.out.println(" Made by Hartmut Schorrig, www.vishia.org, 2020-03-15, LPGL-License");
        } else {
            String string = stringArray[0];
            String string2 = stringArray.length >= 3 && stringArray[2].startsWith("-md5:") ? stringArray[2].substring(5) : null;
            String string3 = stringArray[1];
            if (string3.endsWith("/")) {
                string3 = string3 + string.substring(string.lastIndexOf(47) + 1);
            }
            File file = new File(string3);
            boolean bl = false;
            MessageDigest messageDigest = null;
            if (string2 != null) {
                if (string2.length() != 32) {
                    System.err.println("faulty length for -md5:, should be 32, detect: " + string2.length());
                    n = 2;
                } else {
                    try {
                        messageDigest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        noSuchAlgorithmException.printStackTrace();
                    }
                }
                if (stringArray.length >= 4) {
                    if (stringArray[3].equals("-strict")) {
                        bl = true;
                    } else {
                        System.err.println("-strict expected as 4. argument, found: " + stringArray[3]);
                        n = 5;
                    }
                }
            }
            if (n <= 2) {
                int n2;
                Object object;
                Object object2;
                try {
                    int n3;
                    object2 = new URL(string);
                    inputStream = ((URL)object2).openStream();
                    fileOutputStream = new FileOutputStream(file);
                    object = new byte[16384];
                    System.out.print("copy to: " + file.getAbsolutePath() + " : from URL: " + string + " ... ");
                    n2 = 0;
                    do {
                        if ((n3 = inputStream.read((byte[])object)) <= 0) continue;
                        fileOutputStream.write((byte[])object, 0, n3);
                        n2 += n3;
                        if (messageDigest == null) continue;
                        messageDigest.update((byte[])object, 0, n3);
                    } while (n3 > 0);
                    System.out.println(Integer.toString(n2) + " bytes");
                }
                catch (IOException iOException) {
                    if (inputStream == null) {
                        System.err.println("cannot open URL:" + string);
                    } else if (fileOutputStream == null) {
                        System.err.println("cannot create file:" + file.getAbsolutePath());
                    } else {
                        System.err.println("exception: " + iOException.getMessage());
                    }
                    n = 4;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("unexpected exception on close URL");
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("unexpected exception on close file");
                    }
                    if (messageDigest != null) {
                        object2 = messageDigest.digest();
                        object = new StringBuilder();
                        Object object3 = object2;
                        n2 = ((Object)object3).length;
                        for (int i = 0; i < n2; ++i) {
                            Object object4 = object3[i];
                            String string4 = Integer.toHexString((int)object4);
                            if (string4.length() > 2) {
                                string4 = string4.substring(string4.length() - 2);
                            } else if (string4.length() == 1) {
                                ((StringBuilder)object).append('0');
                            }
                            ((StringBuilder)object).append(string4);
                        }
                        if (((StringBuilder)object).length() != 32) {
                            System.err.println("internal MD5 algorithm faulty, not 16 byte");
                            n = 5;
                        } else {
                            for (int i = 0; i < 32; ++i) {
                                if (((StringBuilder)object).charAt(i) == string2.charAt(i)) continue;
                                System.err.println("-md5: faulty at position " + i);
                                n = 2;
                                if (!bl || (n2 = (int)(file.delete() ? 1 : 0)) != 0) break;
                                System.err.println("pay attention: file cannot be deleted: " + file.getAbsolutePath());
                                break;
                            }
                        }
                    }
                }
            }
        }
        System.exit(n);
    }
}

