/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.vishia.cmd.CmdExecuter;
import org.vishia.cmd.JZtxtcmdAccessFileset;
import org.vishia.cmd.JZtxtcmdEngine;
import org.vishia.cmd.JZtxtcmdFilepath;
import org.vishia.cmd.JZtxtcmdFileset;
import org.vishia.cmd.JZtxtcmdScript;
import org.vishia.cmd.JZtxtcmdTester;
import org.vishia.cmd.JZtxtcmdThread;
import org.vishia.cmd.JZtxtcmdThreadData;
import org.vishia.cmd.ZmakeTarget;
import org.vishia.fileRemote.FileRemote;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.Conversion;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FilePath;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFormatter;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartAppend;
import org.vishia.util.StringSeq;
import org.vishia.xmlSimple.SimpleXmlOutputter;

public class JZtxtcmdExecuter {
    public static final String version = "2020-03-14";
    private final JzTcMain acc;
    protected String accessError = null;
    public static final short kBreak = -1;
    public static final short kReturn = -2;
    private static final short kFalse = -3;
    public static final short kException = -5;
    public static final short kSuccess = 0;
    private static CharSequence retException = new String("Exception");
    public static Map<String, DataAccess.Variable<Object>> useScriptLevel = new Map<String, DataAccess.Variable<Object>>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public DataAccess.Variable<Object> get(Object object) {
            return null;
        }

        @Override
        public DataAccess.Variable<Object> put(String string, DataAccess.Variable<Object> variable) {
            return null;
        }

        @Override
        public DataAccess.Variable<Object> remove(Object object) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends DataAccess.Variable<Object>> map) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Collection<DataAccess.Variable<Object>> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, DataAccess.Variable<Object>>> entrySet() {
            return null;
        }
    };

    public JZtxtcmdExecuter(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.acc = new JzTcMain(mainCmdLogging_ifc, this);
    }

    public JZtxtcmdExecuter() {
        MainCmdLogging_ifc mainCmdLogging_ifc = MainCmd.getLogging_ifc();
        if (mainCmdLogging_ifc == null) {
            mainCmdLogging_ifc = new MainCmdLoggingStream(System.out);
        }
        this.acc = new JzTcMain(mainCmdLogging_ifc, this);
    }

    public void initialize(JZtxtcmdScript jZtxtcmdScript, boolean bl, Map<String, DataAccess.Variable<Object>> map, CharSequence charSequence) throws ScriptException {
        this.acc.scriptLevel.localVariables.clear();
        if (map != null) {
            for (Map.Entry<String, DataAccess.Variable<Object>> entry : map.entrySet()) {
                DataAccess.Variable<Object> variable = entry.getValue();
                try {
                    DataAccess.createOrReplaceVariable(this.acc.scriptLevel.localVariables, variable.name(), variable.type(), variable.value(), variable.isConst());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JzScriptException("JZcmdExecuter.genScriptVariable - IllegalAccessException; " + illegalAccessException.getMessage());
                }
            }
        }
        this.initialize_i(jZtxtcmdScript, bl, charSequence);
    }

    public void initialize(JZtxtcmdScript jZtxtcmdScript, boolean bl, List<DataAccess.Variable<Object>> list, CharSequence charSequence) throws ScriptException {
        this.acc.scriptLevel.localVariables.clear();
        if (list != null) {
            for (DataAccess.Variable<Object> variable : list) {
                try {
                    DataAccess.createOrReplaceVariable(this.acc.scriptLevel.localVariables, variable.name(), variable.type(), variable.value(), variable.isConst());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JzScriptException("JZcmdExecuter.genScriptVariable - IllegalAccessException; " + illegalAccessException.getMessage());
                }
            }
        }
        this.initialize_i(jZtxtcmdScript, bl, charSequence);
    }

    public void initialize(JZtxtcmdScript jZtxtcmdScript, boolean bl, CharSequence charSequence) throws ScriptException {
        this.acc.scriptLevel.localVariables.clear();
        this.initialize_i(jZtxtcmdScript, bl, charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize_i(JZtxtcmdScript jZtxtcmdScript, boolean bl, CharSequence charSequence) throws ScriptException {
        this.acc.bAccessPrivate = bl;
        this.acc.jzcmdScript = jZtxtcmdScript;
        ExecuteLevel executeLevel = this.acc.scriptLevel;
        try {
            Object object;
            Object object2;
            File file;
            if (charSequence == null && executeLevel.currdir == null) {
                executeLevel.currdir = new File("").getAbsoluteFile();
                executeLevel.sCurrdir = FileSystem.getCanonicalPath(executeLevel.currdir);
            } else if (charSequence != null) {
                executeLevel.changeCurrDir(charSequence);
            }
            File file2 = file = jZtxtcmdScript == null ? null : jZtxtcmdScript.fileScript;
            if (file != null) {
                object2 = file.getName();
                object = FileSystem.normalizePath(FileSystem.getDir(file));
                DataAccess.createOrReplaceVariable(this.acc.scriptLevel.localVariables, "scriptfile", 'S', object2, true);
                DataAccess.createOrReplaceVariable(this.acc.scriptLevel.localVariables, "scriptdir", 'S', object, true);
            }
            if (executeLevel.localVariables.get("console") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "console", 'O', this.acc.log, true);
            }
            object2 = executeLevel.localVariables.get("text");
            object = null;
            if (object2 != null) {
                Object t = ((DataAccess.Variable)object2).value();
                if (t instanceof StringFormatter) {
                    this.acc.textline = (StringFormatter)t;
                } else {
                    if (!(t instanceof Appendable)) throw new IllegalArgumentException("a given text variable should be either a StringFormatter or a Appendable");
                    object = (Appendable)t;
                }
            } else {
                object = this.acc.outFromCmdlineArg;
                if (object == null) {
                    object = System.out;
                }
            }
            if (object != null) {
                boolean bl2 = object != System.out && object instanceof Closeable;
                this.acc.textline = new StringFormatter((Appendable)object, bl2, "\n", 200);
            }
            DataAccess.createOrReplaceVariable(executeLevel.localVariables, "text", 'A', this.acc.textline, true);
            if (executeLevel.localVariables.get("out") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "out", 'A', System.out, true);
            }
            if (executeLevel.localVariables.get("err") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "err", 'A', System.err, true);
            }
            if (executeLevel.localVariables.get("null") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "null", 'O', null, true);
            }
            if (executeLevel.localVariables.get("true") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "true", 'Q', true, true);
            }
            if (executeLevel.localVariables.get("false") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "false", 'Q', false, true);
            }
            if (executeLevel.localVariables.get("jzcmd") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "jzcmd", 'O', this.acc, true);
            }
            if (executeLevel.localVariables.get("jztc") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "jztc", 'O', this.acc, true);
            }
            if (executeLevel.localVariables.get("test") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "test", 'O', new JZtxtcmdTester(), true);
            }
            if (executeLevel.localVariables.get("conv") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "conv", 'O', new Conversion(), true);
            }
            DataAccess.createOrReplaceVariable(executeLevel.localVariables, "Math", 'C', Class.forName("java.lang.Math"), true);
            DataAccess.createOrReplaceVariable(executeLevel.localVariables, "Num", 'C', Class.forName("org.vishia.util.Num"), true);
            DataAccess.createOrReplaceVariable(executeLevel.localVariables, "System", 'C', Class.forName("java.lang.System"), true);
            DataAccess.createOrReplaceVariable(executeLevel.localVariables, "FileSystem", 'C', Class.forName("org.vishia.util.FileSystem"), true);
            DataAccess.createOrReplaceVariable(executeLevel.localVariables, "StringFunctions", 'C', Class.forName("org.vishia.util.StringFunctions"), true);
            if (executeLevel.localVariables.get("nextNr") == null) {
                DataAccess.createOrReplaceVariable(executeLevel.localVariables, "nextNr", 'O', new NextNr(), true);
            }
            object2 = this.acc.getClass().getMethod("nextNr", new Class[0]);
            object = new DataAccess.ObjMethod((Method)object2, this.acc);
            DataAccess.createOrReplaceVariable(executeLevel.localVariables, "nextnr", 'M', object, true);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JzScriptException("JZcmdExecuter.genScriptVariable - IllegalAccessException; " + illegalAccessException.getMessage());
        }
        catch (Exception exception) {
            throw new JzScriptException("JZcmdExecuter.genScriptVariable - unexpected exception; " + exception.getMessage());
        }
        if (jZtxtcmdScript == null) return;
        this.executeScriptLevel(jZtxtcmdScript, charSequence);
    }

    public void executeScriptLevel(JZtxtcmdScript jZtxtcmdScript, CharSequence charSequence) throws ScriptException {
        short s;
        boolean bl = this.checkInitialize(jZtxtcmdScript, true, charSequence);
        if (!bl && charSequence != null) {
            try {
                this.acc.scriptLevel.changeCurrDir(charSequence);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JzScriptException(illegalAccessException);
            }
        }
        if ((s = this.acc.scriptLevel.execute(jZtxtcmdScript.scriptClass, this.acc.textline, 0, this.acc.scriptLevel.localVariables, -1)) == -5) {
            Throwable throwable = this.acc.scriptThread.exception.getCause();
            String string = throwable == null ? this.acc.scriptThread.exception.toString() : throwable.toString() + " => s" + this.acc.scriptThread.exception.toString();
            throw new JzScriptException(string, this.acc.scriptThread.excSrcfile, this.acc.scriptThread.excLine, this.acc.scriptThread.excColumn);
        }
    }

    public ExecuteLevel execute_Scriptclass(String string) throws ScriptException {
        JZtxtcmdScript.JZcmdClass jZcmdClass = this.acc.jzcmdScript.getClass(string);
        if (jZcmdClass == null) {
            throw new IllegalArgumentException("class in script not found: " + string);
        }
        ExecuteLevel executeLevel = new ExecuteLevel(this.acc, this.acc.jzcmdScript.scriptClass, this.acc.scriptThread, this.acc.scriptLevel, null);
        short s = executeLevel.execute(jZcmdClass, this.acc.textline, 0, executeLevel.localVariables, -1);
        if (s == -5) {
            if (this.acc.scriptThread.exception instanceof ScriptException) {
                throw (ScriptException)this.acc.scriptThread.exception;
            }
            CharSequence charSequence = Assert.exceptionInfo("Exception in the script, ", this.acc.scriptThread.exception, 0, 20);
            throw new JzScriptException(charSequence.toString(), this.acc.scriptThread.excSrcfile, this.acc.scriptThread.excLine, this.acc.scriptThread.excColumn);
        }
        return executeLevel;
    }

    public ExecuteLevel execute_Scriptclass(JZtxtcmdScript.JZcmdClass jZcmdClass) throws ScriptException {
        ExecuteLevel executeLevel = new ExecuteLevel(this.acc, jZcmdClass, this.acc.scriptThread, this.acc.scriptLevel, null);
        short s = executeLevel.execute(jZcmdClass, this.acc.textline, 0, executeLevel.localVariables, -1);
        if (s == -5) {
            if (this.acc.scriptThread.exception instanceof ScriptException) {
                throw (ScriptException)this.acc.scriptThread.exception;
            }
            CharSequence charSequence = Assert.exceptionInfo("Exception in the script, ", this.acc.scriptThread.exception, 0, 20);
            throw new JzScriptException(charSequence.toString(), this.acc.scriptThread.excSrcfile, this.acc.scriptThread.excLine, this.acc.scriptThread.excColumn);
        }
        return executeLevel;
    }

    public Map<String, DataAccess.Variable<Object>> scriptVariables() {
        return this.acc.scriptLevel.localVariables;
    }

    public ExecuteLevel scriptLevel() {
        return this.acc.scriptLevel;
    }

    public void reset() {
        this.acc.scriptLevel.localVariables.clear();
        this.acc.jzcmdScript = null;
    }

    public boolean abortCmdExecution() {
        boolean bl = false;
        for (CmdExecuter cmdExecuter : this.acc.runningCmdExecuter) {
            if (!cmdExecuter.abortCmd()) continue;
            bl = true;
        }
        return bl;
    }

    private boolean checkInitialize(JZtxtcmdScript jZtxtcmdScript, boolean bl, Map<String, DataAccess.Variable<Object>> map, CharSequence charSequence) throws ScriptException {
        boolean bl2;
        boolean bl3 = bl2 = jZtxtcmdScript != null && this.acc.jzcmdScript != jZtxtcmdScript;
        if (bl2) {
            this.initialize(jZtxtcmdScript, bl, map, charSequence);
        }
        return bl2;
    }

    private boolean checkInitialize(JZtxtcmdScript jZtxtcmdScript, boolean bl, List<DataAccess.Variable<Object>> list, CharSequence charSequence) throws ScriptException {
        boolean bl2;
        boolean bl3 = bl2 = jZtxtcmdScript != null && this.acc.jzcmdScript != jZtxtcmdScript;
        if (bl2) {
            this.initialize(jZtxtcmdScript, bl, list, charSequence);
        }
        return bl2;
    }

    private boolean checkInitialize(JZtxtcmdScript jZtxtcmdScript, boolean bl, CharSequence charSequence) throws ScriptException {
        boolean bl2;
        boolean bl3 = bl2 = jZtxtcmdScript != null && this.acc.jzcmdScript != jZtxtcmdScript;
        if (bl2) {
            this.initialize(jZtxtcmdScript, bl, charSequence);
        }
        return bl2;
    }

    private boolean checkInitialize(JZtxtcmdScript jZtxtcmdScript, boolean bl, Map<String, DataAccess.Variable<Object>> map, File file) throws ScriptException {
        String string = file == null ? null : file.getPath();
        return this.checkInitialize(jZtxtcmdScript, bl, map, (CharSequence)string);
    }

    public void execute(JZtxtcmdScript jZtxtcmdScript, boolean bl, boolean bl2, Appendable appendable, Map<String, DataAccess.Variable<Object>> map, String string) throws ScriptException {
        boolean bl3;
        this.acc.outFromCmdlineArg = appendable;
        boolean bl4 = bl3 = this.acc.jzcmdScript != jZtxtcmdScript;
        if (bl3) {
            this.checkInitialize(jZtxtcmdScript, true, map, (CharSequence)string);
        }
        this.execute_i(jZtxtcmdScript, bl, bl2, string, bl3);
    }

    public void execute(JZtxtcmdScript jZtxtcmdScript, boolean bl, boolean bl2, Appendable appendable, List<DataAccess.Variable<Object>> list, String string) throws ScriptException {
        boolean bl3;
        this.acc.outFromCmdlineArg = appendable;
        boolean bl4 = bl3 = this.acc.jzcmdScript != jZtxtcmdScript;
        if (bl3) {
            this.checkInitialize(jZtxtcmdScript, true, list, (CharSequence)string);
        }
        this.execute_i(jZtxtcmdScript, bl, bl2, string, bl3);
    }

    public void execute(JZtxtcmdScript jZtxtcmdScript, boolean bl, boolean bl2, Appendable appendable, String string) throws ScriptException {
        boolean bl3;
        this.acc.outFromCmdlineArg = appendable;
        boolean bl4 = bl3 = this.acc.jzcmdScript != jZtxtcmdScript;
        if (bl3) {
            this.checkInitialize(jZtxtcmdScript, true, string);
        }
        this.execute_i(jZtxtcmdScript, bl, bl2, string, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute_i(JZtxtcmdScript jZtxtcmdScript, boolean bl, boolean bl2, String string, boolean bl3) throws ScriptException {
        short s;
        Object object;
        Object object2;
        Object object3;
        this.acc.bAccessPrivate = bl;
        assert (this.acc.textline != null);
        if (this.acc.textline == null) {
            if (this.acc.outFromCmdlineArg == null) {
                this.acc.outFromCmdlineArg = System.out;
            }
            boolean bl4 = this.acc.outFromCmdlineArg != System.out && this.acc.outFromCmdlineArg instanceof Closeable;
            object3 = new StringFormatter(this.acc.outFromCmdlineArg, bl4, null, 200);
            this.acc.textline = object3;
            try {
                this.acc.setScriptVariable("text", 'A', this.acc.textline, true);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JzScriptException("JZcmd.executer - IllegalAccessException; " + illegalAccessException.getMessage());
            }
        }
        this.acc.outFromCmdlineArg = null;
        if (!bl3 && string != null) {
            try {
                this.acc.scriptLevel.changeCurrDir(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JzScriptException(illegalAccessException);
            }
        }
        ExecuteLevel executeLevel = new ExecuteLevel(this.acc, this.acc.jzcmdScript.scriptClass, this.acc.scriptThread, this.acc.scriptLevel, null);
        if (this.acc.jzcmdScript.checkJZcmdXmlFile != null) {
            try {
                object3 = this.acc.scriptLevel.evalString(this.acc.jzcmdScript.checkJZcmdXmlFile);
            }
            catch (Exception exception) {
                throw new JzScriptException("JZcmd.execute - String eval error on checkJZcmd; ", this.acc.jzcmdScript.checkJZcmdXmlFile.srcFile, this.acc.jzcmdScript.checkJZcmdXmlFile.srcLine, this.acc.jzcmdScript.checkJZcmdXmlFile.srcColumn);
            }
            object2 = new SimpleXmlOutputter();
            try {
                object = new OutputStreamWriter(new FileOutputStream(object3.toString()));
                ((SimpleXmlOutputter)object2).write((OutputStreamWriter)object, this.acc.jzcmdScript.xmlSrc);
                ((OutputStreamWriter)object).close();
                this.acc.jzcmdScript.xmlSrc = null;
            }
            catch (IOException iOException) {
                throw new JzScriptException(iOException);
            }
        }
        if (this.acc.jzcmdScript.checkJZcmdFile != null) {
            try {
                object3 = executeLevel.evalString(this.acc.jzcmdScript.checkJZcmdFile);
            }
            catch (Exception exception) {
                throw new JzScriptException("JZcmd.execute - String eval error on checkJZcmd; ", this.acc.jzcmdScript.checkJZcmdFile.srcFile, this.acc.jzcmdScript.checkJZcmdFile.srcLine, this.acc.jzcmdScript.checkJZcmdFile.srcColumn);
            }
            object2 = new File(object3.toString());
            try {
                object = new FileWriter((File)object2);
                this.acc.jzcmdScript.writeStruct((Appendable)object);
                ((Writer)object).close();
            }
            catch (IOException iOException) {
                throw new JzScriptException("JZcmd.execute - File error on checkJZcmd; " + ((File)object2).getAbsolutePath());
            }
        }
        object3 = this.acc.jzcmdScript.getMain();
        this.acc.startmilli = System.currentTimeMillis();
        this.acc.startnano = System.nanoTime();
        if (object3 != null) {
            s = executeLevel.execute(((JZtxtcmdScript.Subroutine)object3).statementlist, this.acc.textline, 0, executeLevel.localVariables, -1);
        } else {
            System.out.println("JZcmdExecuter - main routine not found.");
            s = 0;
        }
        if (bl2) {
            boolean bl5 = true;
            while (bl5) {
                object = this.acc.threads;
                synchronized (object) {
                    boolean bl6 = bl5 = this.acc.threads.size() != 0;
                    if (bl5) {
                        try {
                            this.acc.threads.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.acc.textline != null) {
            try {
                this.acc.textline.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("unexpected exception on close", iOException);
            }
        }
        if (s == -5) {
            if (this.acc.scriptThread.exception instanceof ScriptException) {
                throw (ScriptException)this.acc.scriptThread.exception;
            }
            CharSequence charSequence = Assert.exceptionInfo("Exception in the script, ", this.acc.scriptThread.exception, 0, 20);
            throw new JzScriptException(charSequence.toString(), this.acc.scriptThread.excSrcfile, this.acc.scriptThread.excLine, this.acc.scriptThread.excColumn);
        }
    }

    public Map<String, DataAccess.Variable<Object>> execSub(JZtxtcmdScript jZtxtcmdScript, String string, Map<String, DataAccess.Variable<Object>> map, boolean bl, Appendable appendable, File file) throws ScriptException {
        this.checkInitialize(jZtxtcmdScript, true, null, file);
        JZtxtcmdScript.Subroutine subroutine = this.acc.jzcmdScript.getSubroutine(string);
        if (subroutine == null) {
            throw new JzScriptException("Subroutine not found: " + string, jZtxtcmdScript.fileScript.getAbsolutePath(), 0, 0);
        }
        return this.execSub(subroutine, map, bl, appendable, file);
    }

    public Map<String, DataAccess.Variable<Object>> execSub(JZtxtcmdScript jZtxtcmdScript, String string, List<DataAccess.Variable<Object>> list, boolean bl, Appendable appendable, File file) throws ScriptException {
        this.checkInitialize(jZtxtcmdScript, true, null, file);
        JZtxtcmdScript.Subroutine subroutine = this.acc.jzcmdScript.getSubroutine(string);
        if (subroutine == null) {
            throw new JzScriptException("Subroutine not found: " + string, jZtxtcmdScript.fileScript.getAbsolutePath(), 0, 0);
        }
        return this.execSub(subroutine, list, bl, appendable, file, null);
    }

    public Map<String, DataAccess.Variable<Object>> execSub(JZtxtcmdScript.Subroutine subroutine, Map<String, DataAccess.Variable<Object>> map, boolean bl, Appendable appendable, File file) throws ScriptException {
        LinkedList<DataAccess.Variable<Object>> linkedList;
        if (map != null) {
            linkedList = new LinkedList<DataAccess.Variable<Object>>();
            for (Map.Entry<String, DataAccess.Variable<Object>> entry : map.entrySet()) {
                linkedList.add(entry.getValue());
            }
        } else {
            linkedList = null;
        }
        return this.execSub(subroutine, linkedList, bl, appendable, file, null);
    }

    public Map<String, DataAccess.Variable<Object>> execSub(JZtxtcmdScript.Subroutine subroutine, List<DataAccess.Variable<Object>> list, boolean bl, Appendable appendable, File file, CmdExecuter cmdExecuter) throws ScriptException {
        short s;
        boolean bl2 = this.checkInitialize(subroutine.theScript, true, null, file);
        ExecuteLevel executeLevel = this.acc.scriptLevel.levelForSubroutine(subroutine);
        if (cmdExecuter != null) {
            executeLevel.setCmdExecuter(cmdExecuter);
            if (file != null) {
                cmdExecuter.setCurrentDir(file);
            }
        }
        if (appendable != null) {
            StringFormatter stringFormatter;
            this.acc.textline = stringFormatter = new StringFormatter(appendable, appendable instanceof Closeable, "\n", 200);
            try {
                this.acc.setScriptVariable("text", 'A', appendable, true);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JzScriptException(illegalAccessException);
            }
        }
        if (!bl2 && file != null) {
            try {
                executeLevel.changeCurrDir(file.getPath());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JzScriptException(illegalAccessException);
            }
        }
        this.acc.startmilli = System.currentTimeMillis();
        this.acc.startnano = System.nanoTime();
        try {
            s = this.acc.scriptLevel.exec_Subroutine(subroutine, executeLevel, null, list, this.acc.textline, 1, 0);
        }
        catch (Exception exception) {
            throw new JzScriptException(exception.getMessage(), this.acc.scriptThread.excSrcfile, this.acc.scriptThread.excLine, this.acc.scriptThread.excColumn);
        }
        if (this.acc.textline != null) {
            try {
                this.acc.textline.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("unexpected exception on close", iOException);
            }
        }
        if (s == -2 || s == -1) {
            s = 0;
        }
        if (s == -5) {
            throw new JzScriptException(this.acc.scriptThread.exception.getMessage(), this.acc.scriptThread.excSrcfile, this.acc.scriptThread.excLine, this.acc.scriptThread.excColumn);
        }
        DataAccess.Variable<Object> variable = executeLevel.localVariables.get("return");
        if (variable != null && variable.value() instanceof Map) {
            Map map = (Map)variable.value();
            return map;
        }
        return null;
    }

    @Deprecated
    public void setScriptVariable(String string, char c, Object object, boolean bl) throws IllegalAccessException {
        DataAccess.createOrReplaceVariable(this.acc.scriptLevel.localVariables, string, c, object, bl);
    }

    public DataAccess.Variable<Object> getScriptVariable(String string) throws NoSuchFieldException {
        return DataAccess.getVariable(this.acc.scriptLevel.localVariables, string, true);
    }

    public DataAccess.Variable<Object> removeScriptVariable(String string) {
        return this.acc.scriptLevel.localVariables.remove(string);
    }

    void stop() {
    }

    protected static class JZcmdBindings
    implements Bindings {
        private final IndexMultiTable<String, DataAccess.Variable<Object>> vars;

        public JZcmdBindings(IndexMultiTable<String, DataAccess.Variable<Object>> indexMultiTable) {
            this.vars = indexMultiTable;
        }

        @Override
        public Object put(String string, Object object) {
            DataAccess.Variable<Object> variable = new DataAccess.Variable<Object>('O', string, object, false);
            return this.vars.put(string, variable);
        }

        @Override
        public boolean containsKey(Object object) {
            return this.vars.containsKey(object);
        }

        @Override
        public Object get(Object object) {
            DataAccess.Variable<Object> variable = this.vars.get(object);
            return variable == null ? null : variable.value();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
        }

        @Override
        public Object remove(Object object) {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<Object> values() {
            return null;
        }
    }

    protected static class JzScriptException
    extends ScriptException {
        JzScriptException(String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
        }

        JzScriptException(Exception exception) {
            super(exception);
        }

        JzScriptException(String string) {
            super(string);
        }

        @Override
        public final String getMessage() {
            String string = super.getMessage();
            string = string + "\n@line:col " + super.getLineNumber() + ':' + super.getColumnNumber() + " in " + super.getFileName();
            return string;
        }
    }

    public static class ExitException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public int exitLevel;

        public ExitException(int n) {
            this.exitLevel = n;
        }
    }

    public static class JZcmdThrow
    extends Exception {
        private static final long serialVersionUID = 1L;

        public JZcmdThrow(String string) {
            super(string);
        }
    }

    public static class CmdErrorLevelException
    extends Exception {
        private static final long serialVersionUID = 7785185972638755384L;
        public int errorLevel;

        public CmdErrorLevelException(int n) {
            super("cmd error level = " + n);
            this.errorLevel = n;
        }
    }

    public static class NextNr {
        private int nr = 0;

        void start() {
            this.nr = 0;
        }

        void set(int n) {
            this.nr = n - 1;
        }

        public String toString() {
            return "" + ++this.nr;
        }
    }

    public static final class ExecuteLevel
    implements ScriptContext,
    FilePath.FilePathEnvAccess {
        final JzTcMain jzcmdMain;
        public final ExecuteLevel parent;
        int ctNesting = 0;
        final JZtxtcmdThreadData threadData;
        final JZtxtcmdScript.JZcmdClass jzClass;
        public File currdir;
        String sCurrdir;
        public boolean bWriteErrorInOutput;
        public final IndexMultiTable<String, DataAccess.Variable<Object>> localVariables;
        public CmdExecuter cmdExecuter;
        private boolean bForHasNext;
        private boolean debug_dataAccessArguments;
        public int cmdErrorlevel = 0;

        protected ExecuteLevel(JzTcMain jzTcMain, JZtxtcmdScript.JZcmdClass jZcmdClass, JZtxtcmdThreadData jZtxtcmdThreadData, ExecuteLevel executeLevel, Map<String, DataAccess.Variable<Object>> map) {
            this.jzcmdMain = jzTcMain;
            this.parent = executeLevel;
            this.ctNesting = executeLevel == null ? 0 : executeLevel.ctNesting + 1;
            this.jzClass = jZcmdClass;
            this.threadData = jZtxtcmdThreadData;
            if (executeLevel != null) {
                this.currdir = executeLevel.currdir;
                this.sCurrdir = executeLevel.sCurrdir;
            }
            this.localVariables = jzTcMain.new_Variables();
            if (map != null) {
                this.localVariables.putAll(map);
            } else if (jzTcMain.scriptLevel != null) {
                for (Map.Entry<String, DataAccess.Variable<Object>> entry : jzTcMain.scriptLevel.localVariables.entrySet()) {
                    Object object;
                    DataAccess.Variable<Object> variable = entry.getValue();
                    String string = entry.getKey();
                    if (string.equals("scriptdir")) {
                        object = jZcmdClass != null ? new File(jZcmdClass.srcFile) : jzTcMain.jzcmdScript.fileScript;
                        CharSequence charSequence = FileSystem.normalizePath(FileSystem.getDir((File)object));
                        DataAccess.Variable<CharSequence> variable2 = new DataAccess.Variable<CharSequence>('S', "scriptdir", charSequence, true);
                        this.localVariables.put("scriptdir", variable2);
                        this.localVariables.put("scriptfile", variable2);
                        continue;
                    }
                    if (string.equals("scriptfile")) continue;
                    if (variable.isConst()) {
                        this.localVariables.put(string, variable);
                        continue;
                    }
                    object = new DataAccess.Variable<Object>(variable);
                    this.localVariables.put(string, (DataAccess.Variable<Object>)object);
                }
            }
            try {
                DataAccess.createOrReplaceVariable(this.localVariables, "jzcmdsub", 'O', this, true);
                DataAccess.createOrReplaceVariable(this.localVariables, "jztcsub", 'O', this, true);
                this.localVariables.put("error", jZtxtcmdThreadData.error);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }

        protected ExecuteLevel(JzTcMain jzTcMain, JZtxtcmdThreadData jZtxtcmdThreadData) {
            this(jzTcMain, null, jZtxtcmdThreadData, null, null);
        }

        public void setCmdExecuter(CmdExecuter cmdExecuter) {
            if (this.cmdExecuter != null) {
                this.cmdExecuter.abortCmd();
                this.cmdExecuter.close();
            }
            this.cmdExecuter = cmdExecuter;
        }

        public JzTcMain executer() {
            return this.jzcmdMain;
        }

        public JZtxtcmdEngine scriptEngine() {
            return this.jzcmdMain.jzcmdScript.getEngine();
        }

        public MainCmdLogging_ifc log() {
            return this.jzcmdMain.log;
        }

        public void setLocalVariable(String string, char c, Object object, boolean bl) throws IllegalAccessException {
            DataAccess.createOrReplaceVariable(this.localVariables, string, c, object, bl);
        }

        public short executeNewlevel(JZtxtcmdScript.JZcmdClass jZcmdClass, JZtxtcmdScript.StatementList statementList, StringFormatter stringFormatter, int n, int n2) throws Exception {
            ExecuteLevel executeLevel = statementList.bContainsVariableDef ? new ExecuteLevel(this.jzcmdMain, jZcmdClass, this.threadData, this, this.localVariables) : this;
            return executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
        }

        short execute(JZtxtcmdScript.StatementList statementList, StringFormatter stringFormatter, int n, Map<String, DataAccess.Variable<Object>> map, int n2) {
            int n3;
            ++this.ctNesting;
            int n4 = n;
            int n5 = -1;
            int n6 = 0;
            int n7 = n3 = statementList != null && statementList.statements != null ? statementList.statements.size() : 0;
            while (n6 == 0 && ++n5 < n3) {
                char c;
                JZtxtcmdScript.JZcmditem jZcmditem = statementList.statements.get(n5);
                int n8 = 0;
                if (jZcmditem.elementType() == 'D') {
                    n8 = this.debug(jZcmditem);
                    if (++n5 < statementList.statements.size()) {
                        jZcmditem = statementList.statements.get(n5);
                    }
                } else {
                    n8 = n2;
                }
                if (n8 >= 0) {
                    Debugutil.stop();
                }
                try {
                    switch (jZcmditem.elementType()) {
                        case 't': {
                            this.exec_Text(jZcmditem, stringFormatter, n4);
                            break;
                        }
                        case '@': {
                            this.exec_SetColumn((JZtxtcmdScript.TextColumn)jZcmditem, stringFormatter);
                            break;
                        }
                        case 'n': {
                            stringFormatter.append(this.jzcmdMain.newline);
                            break;
                        }
                        case '!': {
                            stringFormatter.flush();
                            break;
                        }
                        case '_': {
                            stringFormatter.close();
                            stringFormatter = null;
                            break;
                        }
                        case '\\': {
                            stringFormatter.append(jZcmditem.textArg);
                            break;
                        }
                        case 'T': {
                            n6 = this.exec_TextAppendToVar((JZtxtcmdScript.TextOut)jZcmditem, --n8);
                            break;
                        }
                        case ':': {
                            n6 = this.exec_TextAppendToOut(jZcmditem, stringFormatter, --n8);
                            break;
                        }
                        case 'A': {
                            break;
                        }
                        case 'U': {
                            n6 = this.defineExpr(map, (JZtxtcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'S': {
                            n6 = this.defineExpr(map, (JZtxtcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'P': {
                            StringBuilder stringBuilder = new StringBuilder();
                            this.exec_DefVariable(map, (JZtxtcmdScript.DefVariable)jZcmditem, 'P', stringBuilder, true);
                            break;
                        }
                        case 'L': {
                            n6 = this.exec_DefList((JZtxtcmdScript.DefContainerVariable)jZcmditem, map);
                            break;
                        }
                        case 'M': {
                            n6 = this.exec_DefMapVariable((JZtxtcmdScript.DefVariable)jZcmditem, map);
                            break;
                        }
                        case 'W': {
                            n6 = this.exec_Openfile(map, (JZtxtcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'C': {
                            n6 = this.exec_DefClassVariable((JZtxtcmdScript.DefClassVariable)jZcmditem, map);
                            break;
                        }
                        case 'J': {
                            n6 = this.exec_addClassLoader((JZtxtcmdScript.DefClasspathVariable)jZcmditem, map);
                            break;
                        }
                        case 'O': {
                            Object object = this.evalObject(jZcmditem, false);
                            if (object == retException) {
                                n6 = -5;
                                break;
                            }
                            this.exec_DefVariable(map, (JZtxtcmdScript.DefVariable)jZcmditem, 'O', object, false);
                            break;
                        }
                        case 'K': {
                            CalculatorExpr.Value value = this.evalValue(jZcmditem, false);
                            if (value == retException) {
                                n6 = -5;
                                break;
                            }
                            this.exec_DefVariable(map, (JZtxtcmdScript.DefVariable)jZcmditem, 'K', value, false);
                            break;
                        }
                        case 'Q': {
                            Boolean bl = new Boolean(this.evalCondition(jZcmditem));
                            if (bl == retException) {
                                n6 = -5;
                                break;
                            }
                            this.exec_DefVariable(map, (JZtxtcmdScript.DefVariable)jZcmditem, 'Q', bl, false);
                            break;
                        }
                        case '{': {
                            this.exec_DefCodeblockVariable(map, (JZtxtcmdScript.Subroutine)jZcmditem, true);
                            break;
                        }
                        case 'e': {
                            n6 = this.exec_Datatext((JZtxtcmdScript.DataText)jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case 's': {
                            n6 = this.exec_Call((JZtxtcmdScript.CallStatement)jZcmditem, null, stringFormatter, n4, --n8);
                            break;
                        }
                        case 'x': {
                            n6 = this.exec_Thread(map, (JZtxtcmdScript.ThreadBlock)jZcmditem);
                            break;
                        }
                        case 'm': {
                            this.exec_Move((JZtxtcmdScript.FileOpArg)jZcmditem);
                            break;
                        }
                        case 'y': {
                            this.exec_Copy((JZtxtcmdScript.FileOpArg)jZcmditem);
                            break;
                        }
                        case 'l': {
                            this.exec_Delete((JZtxtcmdScript.FileOpArg)jZcmditem);
                            break;
                        }
                        case 'c': {
                            this.exec_cmdline((JZtxtcmdScript.CmdInvoke)jZcmditem);
                            break;
                        }
                        case 'd': {
                            n6 = this.exec_ChangeCurrDir(jZcmditem);
                            break;
                        }
                        case '9': {
                            n6 = this.exec_MkDir(jZcmditem);
                            break;
                        }
                        case 'f': {
                            n6 = this.exec_forContainer((JZtxtcmdScript.ForStatement)jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case 'B': {
                            n6 = this.exec_NestedLevel(jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case 'i': {
                            n6 = this.exec_IfStatement((JZtxtcmdScript.IfStatement)jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case 'w': {
                            n6 = this.exec_whileStatement((JZtxtcmdScript.CondStatement)jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case 'u': {
                            n6 = this.exec_dowhileStatement((JZtxtcmdScript.CondStatement)jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case 'N': {
                            n6 = this.exec_hasNext(jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case '=': {
                            n6 = this.assignStatement(jZcmditem);
                            break;
                        }
                        case '+': {
                            n6 = this.appendExpr((JZtxtcmdScript.AssignExpr)jZcmditem);
                            break;
                        }
                        case '?': {
                            break;
                        }
                        case 'z': {
                            throw new ExitException(((JZtxtcmdScript.ExitStatement)jZcmditem).exitValue);
                        }
                        case 'r': {
                            this.exec_Throw(jZcmditem);
                            break;
                        }
                        case 'v': {
                            this.exec_Throwonerror((JZtxtcmdScript.Onerror)jZcmditem);
                            break;
                        }
                        case ',': {
                            this.bWriteErrorInOutput = jZcmditem.textArg != null;
                            break;
                        }
                        case 'b': {
                            n6 = -1;
                            break;
                        }
                        case '#': {
                            n6 = this.exec_CmdError((JZtxtcmdScript.Onerror)jZcmditem, stringFormatter, n4);
                            break;
                        }
                        case 'F': {
                            n6 = this.exec_createFilepath(map, (JZtxtcmdScript.DefVariable)jZcmditem);
                            break;
                        }
                        case 'G': {
                            n6 = this.exec_createFileSet(map, (JZtxtcmdScript.UserFileset)jZcmditem);
                            break;
                        }
                        case 'o': {
                            StringFormatter stringFormatter2 = this.exec_OpenTextOut(jZcmditem, stringFormatter, false);
                            if (stringFormatter2 == null && stringFormatter != null) {
                                n6 = -5;
                                break;
                            }
                            n6 = 0;
                            stringFormatter = stringFormatter2;
                            break;
                        }
                        case 'q': {
                            StringFormatter stringFormatter3 = this.exec_OpenTextOut(jZcmditem, stringFormatter, true);
                            if (stringFormatter3 == null && stringFormatter != null) {
                                n6 = -5;
                                break;
                            }
                            n6 = 0;
                            stringFormatter = stringFormatter3;
                            break;
                        }
                        case 'Z': {
                            n6 = this.exec_zmake((JZtxtcmdScript.Zmake)jZcmditem, stringFormatter, n4, --n8);
                            break;
                        }
                        case 'D': {
                            break;
                        }
                        case 'H': {
                            this.exec_DebugOp(jZcmditem);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("JZcmd.execute - unknown statement; ");
                        }
                    }
                }
                catch (Exception exception) {
                    this.threadData.exception = exception instanceof InvocationTargetException ? exception.getCause() : exception;
                    this.threadData.excStatement = jZcmditem;
                    this.threadData.excLine = jZcmditem.srcLine;
                    this.threadData.excColumn = jZcmditem.srcColumn;
                    this.threadData.excSrcfile = jZcmditem.srcFile;
                    StringBuilder stringBuilder = new StringBuilder(1000);
                    stringBuilder.append(this.threadData.exception.toString()).append("; in statement: ");
                    jZcmditem.writeStructLine(stringBuilder);
                    this.threadData.error.setValue(stringBuilder);
                    StringBuilder stringBuilder2 = stringBuilder;
                    if (this.bWriteErrorInOutput) {
                        try {
                            stringFormatter.append("<?? ").append(stringBuilder2).append(" ??>");
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                        this.threadData.error.setValue(null);
                        this.threadData.exception = null;
                        this.threadData.excStatement = null;
                    }
                    n6 = -5;
                }
                if (n6 != -5) continue;
                boolean bl = false;
                int n9 = 0;
                Throwable throwable = this.threadData.exception;
                if (throwable instanceof ExitException) {
                    c = 'e';
                    n9 = ((ExitException)throwable).exitLevel;
                } else {
                    c = throwable instanceof IOException ? (char)'f' : (throwable instanceof CmdErrorLevelException ? (char)'c' : (throwable instanceof NoSuchFieldException || throwable instanceof NoSuchMethodException ? (char)'n' : 'i'));
                }
                JZtxtcmdScript.JZcmditem jZcmditem2 = null;
                while (++n5 < statementList.statements.size() && (jZcmditem2 = statementList.statements.get(n5)).elementType() != '?') {
                }
                if (n5 < statementList.statements.size()) {
                    assert (jZcmditem2 != null);
                    do {
                        JZtxtcmdScript.Onerror onerror = (JZtxtcmdScript.Onerror)jZcmditem2;
                        char c2 = onerror.errorType;
                        if (c2 != c && (c2 != '?' || c == 'e')) continue;
                        boolean bl2 = bl = c != 'e' || n9 >= onerror.errorLevel;
                    } while (!bl && ++n5 < statementList.statements.size() && (jZcmditem = statementList.statements.get(n5)).elementType() == '?');
                }
                if (bl) {
                    assert (jZcmditem2 != null);
                    n6 = this.execute(jZcmditem2.statementlist, stringFormatter, n4, this.localVariables, -1);
                    if (n6 == -5) continue;
                    this.threadData.error.setValue(null);
                    this.threadData.exception = null;
                    this.threadData.excStatement = null;
                    continue;
                }
                n6 = -5;
                assert (this.threadData.exception != null);
            }
            this.endExecution();
            return (short)n6;
        }

        private void endExecution() {
            if (--this.ctNesting <= 0) {
                assert (this.ctNesting == 0);
                if (this.cmdExecuter != null) {
                    this.cmdExecuter.close();
                    this.cmdExecuter = null;
                }
            }
        }

        void exec_Text(JZtxtcmdScript.JZcmditem jZcmditem, Appendable appendable, int n) throws IOException {
            if (jZcmditem.textArg.startsWith("|+")) {
                Debugutil.stop();
            }
            appendable.append(jZcmditem.textArg);
        }

        void exec_SetColumn(JZtxtcmdScript.TextColumn textColumn, StringFormatter stringFormatter) throws Exception {
            CalculatorExpr.Value value;
            int n = -1;
            int n2 = -1;
            if (textColumn.minSpaces != null) {
                value = this.calculateExpression(textColumn.minSpaces);
                n2 = value.intValue();
            }
            if (textColumn.expression != null) {
                value = this.calculateExpression(textColumn.expression);
                n = value.intValue();
            }
            stringFormatter.pos(n, n2);
        }

        void exec_DefVariable(Map<String, DataAccess.Variable<Object>> map, JZtxtcmdScript.DefVariable defVariable, char c, Object object, boolean bl) throws Exception {
            Object object2 = object;
            CalculatorExpr.Value value = object2 instanceof CalculatorExpr.Value ? (CalculatorExpr.Value)object : null;
            switch (defVariable.elementType) {
                case 'K': {
                    if (value != null) {
                        value.toNumValue();
                        break;
                    }
                    if (object2 instanceof Number) break;
                    break;
                }
            }
            if (defVariable.typeVariable != null && !DataAccess.istypeof(object2, defVariable.typeVariable)) {
                throw new IllegalArgumentException("execSubroutine - argument type faulty, " + object2.getClass().getName() + " ");
            }
            if (defVariable.defVariable.datapath().get(0).ident().equals("return") && !map.containsKey("return")) {
                DataAccess.Variable<IndexMultiTable> variable = new DataAccess.Variable<IndexMultiTable>('M', "return", this.jzcmdMain.new_Variables());
                this.localVariables.add("return", variable);
            }
            this.storeValue(defVariable.defVariable, map, object2, this.jzcmdMain.bAccessPrivate);
        }

        void exec_DefCodeblockVariable(Map<String, DataAccess.Variable<Object>> map, JZtxtcmdScript.Subroutine subroutine, boolean bl) throws Exception {
            DataAccess dataAccess = new DataAccess(subroutine.name, 'X');
            this.storeValue(dataAccess, map, subroutine, this.jzcmdMain.bAccessPrivate);
        }

        protected short exec_DefList(JZtxtcmdScript.DefContainerVariable defContainerVariable, Map<String, DataAccess.Variable<Object>> map) throws Exception {
            ArrayList<Object> arrayList;
            short s = 0;
            if (defContainerVariable.statementlist != null) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (JZtxtcmdScript.JZcmditem jZcmditem : defContainerVariable.statementlist.statements) {
                    IndexMultiTable<String, DataAccess.Variable<Object>> indexMultiTable;
                    Object object;
                    char c = jZcmditem.elementType();
                    if (c == '*') {
                        object = new ExecuteLevel(this.jzcmdMain, this.jzClass, this.threadData, this, this.localVariables);
                        indexMultiTable = new IndexMultiTable<String, DataAccess.Variable<Object>>(IndexMultiTable.providerString);
                        s = ((ExecuteLevel)object).execute(jZcmditem.statementlist, null, 0, indexMultiTable, -1);
                        if (s == -5) {
                            return s;
                        }
                        arrayList2.add(indexMultiTable);
                        continue;
                    }
                    if (jZcmditem instanceof JZtxtcmdScript.Subroutine) {
                        object = (JZtxtcmdScript.Subroutine)jZcmditem;
                        indexMultiTable = new DataAccess.Variable<Object>('X', ((JZtxtcmdScript.Subroutine)object).name, object);
                        arrayList2.add(indexMultiTable);
                        continue;
                    }
                    if (jZcmditem instanceof JZtxtcmdScript.DefVariable) {
                        Object object2;
                        object = (JZtxtcmdScript.DefVariable)jZcmditem;
                        indexMultiTable = ((JZtxtcmdScript.DefVariable)object).getVariableIdent();
                        if (((JZtxtcmdScript.JZcmditem)object).elementType() == '{') {
                            assert (false);
                            object2 = ((JZtxtcmdScript.DefVariable)object).statementlist;
                        } else {
                            object2 = this.evalObject(jZcmditem, true);
                        }
                        DataAccess.Variable<Object> variable = new DataAccess.Variable<Object>(c, (String)((Object)indexMultiTable), object2);
                        arrayList2.add(variable);
                        continue;
                    }
                    object = this.evalObject(jZcmditem, true);
                    arrayList2.add(object);
                }
                arrayList = arrayList2;
            } else {
                arrayList = this.evalObject(defContainerVariable, true);
            }
            if (arrayList == retException) {
                s = -5;
            } else {
                if (arrayList != null && !(arrayList instanceof Iterable)) {
                    throw new NoSuchFieldException("JZcmdExecuter - exec variable must be of type Iterable ;" + defContainerVariable.defVariable);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                this.exec_DefVariable(map, defContainerVariable, 'L', arrayList, true);
            }
            return s;
        }

        protected short exec_DefMapVariable(JZtxtcmdScript.DefVariable defVariable, Map<String, DataAccess.Variable<Object>> map) throws Exception {
            short s = 0;
            TreeMap treeMap = this.evalObject(defVariable, false);
            if (treeMap == retException) {
                s = -5;
            } else {
                if (treeMap == null) {
                    treeMap = new TreeMap();
                }
                this.exec_DefVariable(map, defVariable, 'M', treeMap, true);
            }
            return s;
        }

        protected short exec_DefClassVariable(JZtxtcmdScript.DefClassVariable defClassVariable, Map<String, DataAccess.Variable<Object>> map) throws Exception {
            Class<?> clazz;
            short s = 0;
            CharSequence charSequence = this.evalString(defClassVariable);
            if (defClassVariable.loader != null) {
                Object object = this.dataAccess(defClassVariable.loader, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                if (!(object instanceof ClassLoader)) {
                    throw new IllegalArgumentException("JZcmd.exec_DefClassVariable - faulty ClassLoader");
                }
                ClassLoader classLoader = (ClassLoader)object;
                clazz = classLoader.loadClass(charSequence.toString());
            } else {
                clazz = Class.forName(charSequence.toString());
            }
            this.exec_DefVariable(map, defClassVariable, 'C', clazz, false);
            return s;
        }

        protected short exec_addClassLoader(JZtxtcmdScript.DefClasspathVariable defClasspathVariable, Map<String, DataAccess.Variable<Object>> map) throws Exception {
            Object object;
            Object object22;
            Object object3;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (JZtxtcmdScript.AccessFilesetname accessFilesetname : defClasspathVariable.jarpaths) {
                Object object4;
                if (accessFilesetname.filesetVariable != null) {
                    object3 = new JZtxtcmdAccessFileset(accessFilesetname, this);
                    object22 = ((JZtxtcmdAccessFileset)object3).listFilesExpanded();
                    object = object22.iterator();
                    while (object.hasNext()) {
                        object4 = (JZtxtcmdFilepath)object.next();
                        File file = new File(((JZtxtcmdFilepath)object4).absfile().toString());
                        if (!file.exists()) {
                            throw new IllegalArgumentException("JZcmd.addClasspath - file does not exist; " + file.getAbsolutePath());
                        }
                        linkedList.add(file);
                    }
                    continue;
                }
                object22 = this.evalString(accessFilesetname);
                object3 = new FilePath(object22.toString());
                object = new JZtxtcmdFilepath(this, (FilePath)object3);
                object4 = new File(((JZtxtcmdFilepath)object).absfile().toString());
                if (!((File)object4).exists()) {
                    throw new IllegalArgumentException("JZcmd.addClasspath - file does not exist; " + ((File)object4).getAbsolutePath());
                }
                linkedList.add(object4);
            }
            URL[] uRLArray = new URL[linkedList.size()];
            int n = -1;
            for (Object object22 : linkedList) {
                object = ((File)object22).toURI();
                uRLArray[++n] = ((URI)object).toURL();
            }
            object3 = this.getClass().getClassLoader();
            object22 = new URLClassLoader(uRLArray, (ClassLoader)object3);
            this.exec_DefVariable(map, defClasspathVariable, 'J', object22, true);
            return 0;
        }

        short exec_createFilepath(Map<String, DataAccess.Variable<Object>> map, JZtxtcmdScript.DefVariable defVariable) throws Exception {
            CharSequence charSequence = this.evalString(defVariable);
            if (charSequence == retException) {
                return -5;
            }
            JZtxtcmdFilepath jZtxtcmdFilepath = new JZtxtcmdFilepath(this, charSequence.toString());
            this.storeValue(defVariable.defVariable, map, jZtxtcmdFilepath, false);
            return 0;
        }

        short exec_createFileSet(Map<String, DataAccess.Variable<Object>> map, JZtxtcmdScript.UserFileset userFileset) throws Exception {
            JZtxtcmdFileset jZtxtcmdFileset = new JZtxtcmdFileset(this, userFileset);
            this.storeValue(userFileset.defVariable, map, jZtxtcmdFileset, false);
            return 0;
        }

        private short exec_forContainer(JZtxtcmdScript.ForStatement forStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            JZtxtcmdScript.StatementList statementList = forStatement.statementlist();
            ExecuteLevel executeLevel = this;
            DataAccess.Variable<Object> variable = DataAccess.createOrReplaceVariable(executeLevel.localVariables, forStatement.forVariable, 'O', null, false);
            Object object = this.dataAccess(forStatement.forContainer, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
            int n3 = 0;
            boolean bl = this.bForHasNext;
            if (object instanceof String && ((String)object).startsWith("<?")) {
                throw new IllegalArgumentException("JZcmd.execFor - faulty container type;" + (String)object);
            }
            if (object != null && object instanceof Iterable) {
                Iterator iterator = ((Iterable)object).iterator();
                this.bForHasNext = iterator.hasNext();
                while (n3 == 0 && this.bForHasNext) {
                    Object t = iterator.next();
                    variable.setValue(t);
                    this.bForHasNext = iterator.hasNext();
                    if (forStatement.condition != null && !this.evalCondition(forStatement.condition)) {
                        n3 = -1;
                        continue;
                    }
                    if (statementList == null) continue;
                    n3 = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            } else if (object != null && object instanceof Map) {
                Map map = (Map)object;
                Set set = map.entrySet();
                Iterator iterator = set.iterator();
                this.bForHasNext = iterator.hasNext();
                while (n3 == 0 && this.bForHasNext) {
                    Map.Entry entry = iterator.next();
                    Object v = entry.getValue();
                    variable.setValue(v);
                    this.bForHasNext = iterator.hasNext();
                    if (forStatement.condition != null && !this.evalCondition(forStatement.condition)) {
                        n3 = -1;
                        continue;
                    }
                    if (statementList == null) continue;
                    n3 = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            } else if (object != null && object.getClass().isArray()) {
                int n4 = 0;
                Object[] objectArray = (Object[])object;
                int n5 = objectArray.length;
                boolean bl2 = this.bForHasNext = n4 < n5;
                while (n3 == 0 && this.bForHasNext) {
                    Object object2 = objectArray[n4];
                    variable.setValue(object2);
                    boolean bl3 = this.bForHasNext = ++n4 < n5;
                    if (forStatement.condition != null && !this.evalCondition(forStatement.condition)) {
                        n3 = -1;
                        continue;
                    }
                    if (statementList == null) continue;
                    n3 = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            } else if (object instanceof CalculatorExpr.Value) {
                int n6 = (int)((CalculatorExpr.Value)object).longValue();
                for (int i = 0; i < n6; ++i) {
                    variable.setValue(new CalculatorExpr.Value(i));
                    if (forStatement.condition != null && !this.evalCondition(forStatement.condition)) {
                        n3 = -1;
                        continue;
                    }
                    if (statementList == null) continue;
                    n3 = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            } else if (object != null) {
                variable.setValue(object);
                if (forStatement.condition != null && !this.evalCondition(forStatement.condition)) {
                    n3 = -1;
                } else if (statementList != null) {
                    n3 = executeLevel.execute(statementList, stringFormatter, n, executeLevel.localVariables, n2);
                }
            }
            if (n3 == 0 && !this.bForHasNext) {
                variable.setValue(null);
            }
            this.bForHasNext = bl;
            if (n3 == -1) {
                n3 = 0;
            }
            return (short)n3;
        }

        short exec_hasNext(JZtxtcmdScript.JZcmditem jZcmditem, StringFormatter stringFormatter, int n, int n2) throws Exception {
            short s = 0;
            if (this.bForHasNext) {
                JZtxtcmdScript.StatementList statementList = jZcmditem.statementlist();
                if (statementList != null) {
                    s = this.execute(jZcmditem.statementlist(), stringFormatter, n, this.localVariables, n2);
                } else if (jZcmditem.textArg != null) {
                    this.exec_Text(jZcmditem, stringFormatter, n);
                }
            }
            return s;
        }

        short exec_IfStatement(JZtxtcmdScript.IfStatement ifStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            int n3 = -3;
            Iterator<JZtxtcmdScript.JZcmditem> iterator = ifStatement.statementlist.statements.iterator();
            block4: while (iterator.hasNext() && n3 == -3) {
                JZtxtcmdScript.JZcmditem jZcmditem = iterator.next();
                switch (jZcmditem.elementType()) {
                    case 'g': {
                        JZtxtcmdScript.IfCondition ifCondition = (JZtxtcmdScript.IfCondition)jZcmditem;
                        boolean bl = this.evalCondition(ifCondition.condition);
                        if (bl) {
                            if (ifCondition.statementlist == null) continue block4;
                            n3 = this.execute(ifCondition.statementlist, stringFormatter, n, this.localVariables, n2);
                            break;
                        }
                        n3 = -3;
                        break;
                    }
                    case 'E': {
                        if (jZcmditem.statementlist == null) continue block4;
                        n3 = this.execute(jZcmditem.statementlist, stringFormatter, n, this.localVariables, n2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("JZcmd.execIf - unknown statement; " + jZcmditem.elementType());
                    }
                }
            }
            if (n3 == -3) {
                n3 = 0;
            }
            return (short)n3;
        }

        short exec_whileStatement(JZtxtcmdScript.CondStatement condStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            boolean bl;
            short s = 0;
            do {
                if (!(bl = this.evalCondition(condStatement.condition)) || condStatement.statementlist == null) continue;
                s = this.execute(condStatement.statementlist, stringFormatter, n, this.localVariables, n2);
            } while (bl && s == 0);
            if (s == -1) {
                s = 0;
            }
            return s;
        }

        short exec_dowhileStatement(JZtxtcmdScript.CondStatement condStatement, StringFormatter stringFormatter, int n, int n2) throws Exception {
            short s;
            boolean bl;
            do {
                s = this.execute(condStatement.statementlist, stringFormatter, n, this.localVariables, n2);
            } while ((bl = this.evalCondition(condStatement.condition)) && s == 0);
            if (s == -1) {
                s = 0;
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        short exec_TextAppendToOut(JZtxtcmdScript.JZcmditem jZcmditem, StringFormatter stringFormatter, int n) throws Exception {
            short s;
            if (jZcmditem.statementlist != null) {
                StringFormatter stringFormatter2 = stringFormatter;
                synchronized (stringFormatter2) {
                    s = this.execute(jZcmditem.statementlist, stringFormatter, jZcmditem.srcColumn - 1, this.localVariables, n);
                }
            }
            CharSequence charSequence = this.evalString(jZcmditem);
            short s2 = s = charSequence == retException ? (short)-5 : 0;
            if (charSequence != null) {
                StringFormatter stringFormatter3 = stringFormatter;
                synchronized (stringFormatter3) {
                    stringFormatter.append(charSequence);
                }
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        short exec_TextAppendToVar(JZtxtcmdScript.TextOut textOut, int n) throws Exception {
            short s;
            StringFormatter stringFormatter;
            Object object;
            Object object2;
            if (textOut.variable != null) {
                object2 = this.dataAccess(textOut.variable, this.localVariables, this.jzcmdMain.bAccessPrivate, false, true, null);
                if (object2 instanceof DataAccess.Variable) {
                    DataAccess.Variable variable = (DataAccess.Variable)object2;
                    object = variable.value();
                    if (object == null && variable.type() == 'A') {
                        object = new StringPartAppend();
                        variable.setValue(object);
                    }
                } else {
                    object = object2;
                }
                if (object instanceof StringFormatter) {
                    stringFormatter = (StringFormatter)object;
                } else if (object instanceof Appendable) {
                    stringFormatter = new StringFormatter((Appendable)object, object instanceof Closeable, "\n", 200);
                } else {
                    this.throwIllegalDstArgument("variable should be Appendable", textOut.variable, textOut);
                    stringFormatter = new StringFormatter();
                }
            } else {
                stringFormatter = this.jzcmdMain.textline;
            }
            if (textOut.statementlist != null) {
                object = stringFormatter;
                synchronized (object) {
                    s = this.execute(textOut.statementlist, stringFormatter, textOut.srcColumn - 1, this.localVariables, n);
                    if (stringFormatter instanceof Flushable) {
                        stringFormatter.flush();
                    }
                }
            }
            object = this.evalString(textOut);
            short s2 = s = object == retException ? (short)-5 : 0;
            if (object != null) {
                object2 = stringFormatter;
                synchronized (object2) {
                    stringFormatter.append((CharSequence)object);
                }
            }
            return s;
        }

        private short exec_Call(JZtxtcmdScript.CallStatement callStatement, List<DataAccess.Variable<Object>> list, StringFormatter stringFormatter, int n, int n2) throws IllegalArgumentException, Exception {
            Object object;
            DataAccess.Variable<Object> variable;
            CharSequence charSequence;
            Object object2;
            short s = 0;
            JZtxtcmdScript.Subroutine subroutine = null;
            if (callStatement.call_Name.dataAccess != null) {
                object2 = this.dataAccess(callStatement.call_Name.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                if (object2 instanceof JZtxtcmdScript.Subroutine) {
                    subroutine = (JZtxtcmdScript.Subroutine)object2;
                    charSequence = null;
                } else if (object2 instanceof DataAccess.Variable && ((DataAccess.Variable)object2).type() == 'X') {
                    charSequence = null;
                    subroutine = null;
                    variable = (DataAccess.Variable<Object>)object2;
                    object = (JZtxtcmdScript.StatementList)variable.value();
                    s = this.execute((JZtxtcmdScript.StatementList)object, stringFormatter, n, this.localVariables, n2);
                } else {
                    if (object2 == null) {
                        throw new NoSuchElementException("JZcmdExecuter - subroutine variable emtpy; ");
                    }
                    charSequence = object2.toString();
                }
            } else {
                charSequence = this.evalString(callStatement.call_Name);
                if (charSequence == null) {
                    throw new NoSuchElementException("JZcmdExecuter - subroutine name emtpy; ");
                }
            }
            if (subroutine == null && charSequence != null && (subroutine = this.jzClass.subroutines.get(charSequence)) == null) {
                subroutine = this.jzcmdMain.jzcmdScript.getSubroutine(charSequence);
            }
            if (subroutine == null) {
                throw new NoSuchElementException("JZcmdExecuter - subroutine not found; " + charSequence);
            }
            object2 = this.levelForSubroutine(subroutine);
            s = this.exec_Subroutine(subroutine, (ExecuteLevel)object2, callStatement.actualArgs, list, stringFormatter, n, n2);
            if (s == 0 && (callStatement.variable != null || callStatement.assignObjs != null)) {
                variable = ((ExecuteLevel)object2).localVariables.get("return");
                object = variable != null ? variable.value() : null;
                this.assignObj(callStatement, object, false);
            }
            return s;
        }

        public Object evalSubroutine(JZtxtcmdScript.Subroutine subroutine, Map<String, DataAccess.Variable<Object>> map, StringFormatter stringFormatter, int n) throws ScriptException {
            short s;
            try {
                s = this.exec_Subroutine(subroutine, map, null, -1);
            }
            catch (Exception exception) {
                throw new JzScriptException(exception);
            }
            if (s != 0) {
                throw new JzScriptException(this.threadData.exception.getMessage(), this.threadData.excSrcfile, this.threadData.excLine, this.threadData.excColumn);
            }
            return null;
        }

        public short exec_Subroutine(JZtxtcmdScript.Subroutine subroutine, Map<String, DataAccess.Variable<Object>> map, StringFormatter stringFormatter, int n) {
            short s;
            LinkedList<DataAccess.Variable<Object>> linkedList;
            if (map != null) {
                linkedList = new LinkedList<DataAccess.Variable<Object>>();
                for (Map.Entry<String, DataAccess.Variable<Object>> object2 : map.entrySet()) {
                    linkedList.add(object2.getValue());
                }
            } else {
                linkedList = null;
            }
            ExecuteLevel executeLevel = this.levelForSubroutine(subroutine);
            try {
                s = this.exec_Subroutine(subroutine, executeLevel, null, linkedList, stringFormatter, n, -1);
            }
            catch (Exception exception) {
                s = -5;
            }
            return s;
        }

        public final ExecuteLevel levelForSubroutine(JZtxtcmdScript.Subroutine subroutine) {
            JZtxtcmdScript.JZcmdClass jZcmdClass = (JZtxtcmdScript.JZcmdClass)subroutine.parentList;
            ExecuteLevel executeLevel = subroutine.useLocals ? this : new ExecuteLevel(this.jzcmdMain, jZcmdClass, this.threadData, this, null);
            return executeLevel;
        }

        private short exec_Subroutine(JZtxtcmdScript.Subroutine subroutine, ExecuteLevel executeLevel, List<JZtxtcmdScript.Argument> list, List<DataAccess.Variable<Object>> list2, StringFormatter stringFormatter, int n, int n2) throws Exception {
            short s = 0;
            if (subroutine.formalArgs != null) {
                char c;
                Object object;
                Object object2;
                TreeMap<String, JZtxtcmdScript.DefVariable> treeMap = new TreeMap<String, JZtxtcmdScript.DefVariable>();
                for (JZtxtcmdScript.DefVariable object3 : subroutine.formalArgs) {
                    treeMap.put(object3.getVariableIdent(), object3);
                }
                if (list != null) {
                    for (JZtxtcmdScript.Argument argument : list) {
                        object2 = this.evalObject(argument, false);
                        object = (JZtxtcmdScript.DefVariable)treeMap.remove(argument.getIdent());
                        if (object == null) {
                            throw new IllegalArgumentException("\nError: execSubroutine: " + subroutine.name + "( ... " + argument.identArgJbat + "=...) - unexpected argument; ");
                        }
                        if (((JZtxtcmdScript.DefVariable)object).typeVariable != null && !DataAccess.istypeof(object2, ((JZtxtcmdScript.DefVariable)object).typeVariable)) {
                            throw new IllegalArgumentException("execSubroutine - argument type faulty, " + object2.getClass().getName() + " " + argument.identArgJbat);
                        }
                        c = ((JZtxtcmdScript.JZcmditem)object).elementType();
                        switch (c) {
                            case 'F': {
                                object2 = this.convert2FilePath(object2);
                            }
                        }
                        DataAccess.createOrReplaceVariable(executeLevel.localVariables, argument.identArgJbat, c, object2, false);
                    }
                }
                if (list2 != null) {
                    for (DataAccess.Variable variable : list2) {
                        object2 = variable.name();
                        object = (JZtxtcmdScript.DefVariable)treeMap.remove(object2);
                        if (object == null) {
                            throw new IllegalArgumentException("execSubroutine - unexpected additial argument; " + (String)object2);
                        }
                        if (((JZtxtcmdScript.DefVariable)object).typeVariable != null && !DataAccess.istypeof(variable.value(), ((JZtxtcmdScript.DefVariable)object).typeVariable)) {
                            throw new IllegalArgumentException("execSubroutine - argument type faulty, " + variable.getClass().getName() + " " + variable.name());
                        }
                        c = ((JZtxtcmdScript.JZcmditem)object).elementType();
                        Object object3 = variable.value();
                        switch (c) {
                            case 'F': {
                                object3 = this.convert2FilePath(object3);
                                break;
                            }
                            default: {
                                object3 = variable.value();
                            }
                        }
                        DataAccess.createOrReplaceVariable(executeLevel.localVariables, (String)object2, c, object3, false);
                    }
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    object2 = (JZtxtcmdScript.DefVariable)entry.getValue();
                    object = this.jzcmdMain.scriptLevel.evalObject((JZtxtcmdScript.JZcmditem)object2, false);
                    String string = ((JZtxtcmdScript.DefVariable)object2).getVariableIdent();
                    char c2 = ((JZtxtcmdScript.JZcmditem)object2).elementType();
                    if (c2 == 'F' && !(object instanceof JZtxtcmdFilepath)) {
                        object = new JZtxtcmdFilepath(this, object.toString());
                    }
                    DataAccess.createOrReplaceVariable(executeLevel.localVariables, string, c2, object, false);
                }
            } else if (list != null) {
                throw new IllegalArgumentException("execSubroutine -  not expected arguments");
            }
            s = executeLevel.execute(subroutine.statementlist, stringFormatter, n, executeLevel.localVariables, n2);
            return s;
        }

        private short exec_zmake(JZtxtcmdScript.Zmake zmake, StringFormatter stringFormatter, int n, int n2) throws IllegalArgumentException, Exception {
            ZmakeTarget zmakeTarget = new ZmakeTarget(this, zmake.name);
            Object object2 = this.evalObject(zmake.jzoutput, false);
            zmakeTarget.output = this.convert2FilePath(object2);
            for (JZtxtcmdScript.AccessFilesetname object3 : zmake.input) {
                JZtxtcmdAccessFileset jZtxtcmdAccessFileset = new JZtxtcmdAccessFileset(object3, this);
                if (zmakeTarget.inputs == null) {
                    zmakeTarget.inputs = new ArrayList<JZtxtcmdAccessFileset>();
                }
                zmakeTarget.inputs.add(jZtxtcmdAccessFileset);
            }
            LinkedList linkedList = new LinkedList();
            DataAccess.Variable<ZmakeTarget> variable = new DataAccess.Variable<ZmakeTarget>('O', "target", zmakeTarget, true);
            linkedList.add(variable);
            return this.exec_Call(zmake, linkedList, stringFormatter, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short exec_Thread(Map<String, DataAccess.Variable<Object>> map, JZtxtcmdScript.ThreadBlock threadBlock) throws Exception {
            String string;
            JZtxtcmdThread jZtxtcmdThread;
            if (threadBlock.threadVariable != null) {
                try {
                    jZtxtcmdThread = new JZtxtcmdThread();
                    string = threadBlock.threadVariable.idents().toString();
                    this.storeValue(threadBlock.threadVariable, map, jZtxtcmdThread, this.jzcmdMain.bAccessPrivate);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("JZcmd - thread assign failure; path=" + threadBlock.threadVariable.toString());
                }
            } else {
                jZtxtcmdThread = new JZtxtcmdThread();
                string = "JZcmd";
            }
            ExecuteLevel executeLevel = new ExecuteLevel(this.jzcmdMain, this.jzClass, jZtxtcmdThread, this, this.localVariables);
            Queue<JZtxtcmdThreadData> queue = this.jzcmdMain.threads;
            synchronized (queue) {
                this.jzcmdMain.threads.add(jZtxtcmdThread);
            }
            jZtxtcmdThread.startThread(string, executeLevel, threadBlock);
            return 0;
        }

        private short exec_NestedLevel(JZtxtcmdScript.JZcmditem jZcmditem, StringFormatter stringFormatter, int n, int n2) throws Exception {
            ExecuteLevel executeLevel = this;
            short s = executeLevel.execute(jZcmditem.statementlist, stringFormatter, n, executeLevel.localVariables, n2);
            if (s == -1) {
                s = 0;
            }
            return s;
        }

        private void exec_cmdline(JZtxtcmdScript.CmdInvoke cmdInvoke) throws IllegalArgumentException, Exception {
            Object object;
            String string;
            Object object2;
            Object object3;
            CharSequence charSequence = cmdInvoke.textArg == null ? this.evalString(cmdInvoke) : cmdInvoke.textArg;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(charSequence.toString());
            if (cmdInvoke.cmdArgs != null) {
                for (JZtxtcmdScript.JZcmditem object42 : cmdInvoke.cmdArgs) {
                    if (object42.elementType == 'L') {
                        object3 = this.dataAccess(object42.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                        if (!(object3 instanceof List)) continue;
                        Object object4 = (List)object3;
                        object2 = object4.iterator();
                        while (object2.hasNext()) {
                            string = object2.next();
                            arrayList.add(string.toString());
                        }
                        continue;
                    }
                    object3 = this.evalString(object42).toString();
                    arrayList.add((String)object3);
                }
            }
            if (cmdInvoke.bCmdCheck) {
                this.setLocalVariable("argsCheck", 'L', arrayList, true);
            }
            if (cmdInvoke.variable != null) {
                object = new LinkedList();
                Object object5 = this.dataAccess(cmdInvoke.variable, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                if (object5 instanceof Appendable) {
                    object.add((Appendable)object5);
                } else {
                    this.throwIllegalDstArgument("variable should be Appendable", cmdInvoke.variable, cmdInvoke);
                }
                if (cmdInvoke.assignObjs != null) {
                    for (Object object4 : cmdInvoke.assignObjs) {
                        Object object6 = this.dataAccess((JZtxtcmdScript.JZcmdDataAccess)object4, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                        if (object6 instanceof Appendable) {
                            object.add((Appendable)object6);
                            continue;
                        }
                        this.throwIllegalDstArgument("variable should be Appendable", cmdInvoke.variable, cmdInvoke);
                    }
                }
            } else {
                object = null;
            }
            if (this.cmdExecuter == null) {
                this.cmdExecuter = new CmdExecuter();
                Map<String, String> map = this.cmdExecuter.environment();
                object3 = this.localVariables.iterator("$");
                boolean bl = true;
                while (bl && object3.hasNext()) {
                    object2 = (DataAccess.Variable)object3.next();
                    string = ((DataAccess.Variable)object2).name();
                    Object t = ((DataAccess.Variable)object2).value();
                    if (string.startsWith("$") && t != null) {
                        String string2 = t.toString();
                        map.put(string.substring(1), string2);
                        continue;
                    }
                    bl = false;
                }
                this.cmdExecuter.setCurrentDir(this.currdir);
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            this.jzcmdMain.runningCmdExecuter.offer(this.cmdExecuter);
            this.cmdErrorlevel = this.cmdExecuter.execute(stringArray, cmdInvoke.bShouldNotWait, null, (List<Appendable>)object, null, null);
            this.jzcmdMain.runningCmdExecuter.remove(this.cmdExecuter);
        }

        short exec_CmdError(JZtxtcmdScript.Onerror onerror, StringFormatter stringFormatter, int n) throws Exception {
            short s = 0;
            if (this.cmdErrorlevel >= onerror.errorLevel) {
                s = this.execute(onerror.statementlist, stringFormatter, n, this.localVariables, -1);
            }
            return s;
        }

        short exec_DebugOp(JZtxtcmdScript.JZcmditem jZcmditem) throws Exception {
            short s = 0;
            Object object = this.evalObject(jZcmditem, false);
            if (object instanceof String) {
                DataAccess.debugMethod((String)object);
            }
            return s;
        }

        short exec_ChangeCurrDir(JZtxtcmdScript.JZcmditem jZcmditem) throws Exception {
            CharSequence charSequence = this.evalString(jZcmditem);
            if (charSequence == retException) {
                return -5;
            }
            this.changeCurrDir(charSequence);
            return 0;
        }

        short exec_MkDir(JZtxtcmdScript.JZcmditem jZcmditem) throws Exception {
            CharSequence charSequence = this.evalString(jZcmditem);
            if (charSequence == retException) {
                return -5;
            }
            if (!FileSystem.isAbsolutePath(charSequence)) {
                charSequence = this.currdir() + "/" + charSequence;
            }
            String string = StringFunctions.endsWith(charSequence, "'") ? charSequence.toString().substring(0, charSequence.length() - 1) : (!StringFunctions.endsWith(charSequence, "/") ? charSequence + "/" : charSequence.toString());
            FileSystem.mkDirPath(string);
            return 0;
        }

        StringFormatter exec_OpenTextOut(JZtxtcmdScript.JZcmditem jZcmditem, StringFormatter stringFormatter, boolean bl) throws Exception {
            if (this.jzcmdMain.outFromCmdlineArg != null && this.jzcmdMain.outFromCmdlineArg != System.out) {
                System.out.println("Info: exec_OpenTextOut skipped because outFromCmdLine is given.");
                return stringFormatter;
            }
            Object object = this.evalObject(jZcmditem, false);
            Appendable appendable = null;
            if (object == retException) {
                return null;
            }
            if (object instanceof Appendable) {
                appendable = (Appendable)object;
            } else if (object instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)object;
                if (!FileSystem.isAbsolutePath(charSequence)) {
                    charSequence = this.currdir() + "/" + charSequence;
                }
                appendable = new FileWriter(charSequence.toString(), bl);
            } else {
                throw new IllegalArgumentException("assignment to text should either an Appendable or a text which is the filename.");
            }
            if (appendable != null) {
                if (this.jzcmdMain.textline != null) {
                    this.jzcmdMain.textline.close();
                }
                this.jzcmdMain.textline = new StringFormatter(appendable, true, null, 200);
                this.jzcmdMain.setScriptVariable("text", 'A', this.jzcmdMain.textline, true);
            }
            return this.jzcmdMain.textline;
        }

        protected void changeCurrDir(CharSequence charSequence) throws IllegalAccessException {
            CharSequence charSequence2;
            boolean bl = FileSystem.isAbsolutePathOrDrive(charSequence);
            if (bl) {
                charSequence2 = FileSystem.normalizePath(charSequence);
            } else {
                if (this.currdir == null) {
                    this.currdir = new File("").getAbsoluteFile();
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.currdir.getPath()).append('/').append(charSequence);
                charSequence2 = FileSystem.normalizePath(stringBuilder);
            }
            this.sCurrdir = charSequence2.toString();
            this.currdir = new File(this.sCurrdir);
            if (!this.currdir.exists() || !this.currdir.isDirectory()) {
                throw new IllegalArgumentException("JZcmdExecuter - cd, dir not exists; " + charSequence);
            }
            this.setLocalVariable("currdir", 'O', this.currdir, true);
        }

        private short exec_Datatext(JZtxtcmdScript.DataText dataText, StringFormatter stringFormatter, int n, int n2) throws IllegalArgumentException, Exception {
            int n3 = 0;
            CharSequence charSequence = null;
            Object object = null;
            try {
                object = this.dataAccess(dataText.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
            }
            catch (Exception exception) {
                if (dataText.errorText != null) {
                    charSequence = dataText.errorText;
                }
                throw exception;
            }
            if (charSequence == null) {
                if (object == retException) {
                    n3 = -5;
                } else {
                    if (dataText.format != null) {
                        if (object instanceof CalculatorExpr.Value) {
                            object = ((CalculatorExpr.Value)object).objValue();
                        }
                        charSequence = String.format(this.jzcmdMain.locale, dataText.format, object);
                    } else if (object == null) {
                        charSequence = null;
                    } else if (object instanceof CharSequence) {
                        charSequence = (CharSequence)object;
                    } else if (object instanceof DataAccess.Variable) {
                        DataAccess.Variable variable = (DataAccess.Variable)object;
                        if (variable.type() == 'X') {
                            DataAccess.Variable variable2 = (DataAccess.Variable)object;
                            JZtxtcmdScript.Subroutine subroutine = (JZtxtcmdScript.Subroutine)variable2.value();
                            if (!subroutine.useLocals) {
                                throw new IllegalArgumentException("Subroutine as <&dataText> can only used without arguments.");
                            }
                            ExecuteLevel executeLevel = this.levelForSubroutine(subroutine);
                            try {
                                n3 = this.exec_Subroutine(subroutine, executeLevel, null, null, stringFormatter, n, -1);
                            }
                            catch (Exception exception) {
                                n3 = -5;
                            }
                            charSequence = null;
                        } else {
                            charSequence = variable.value().toString();
                        }
                    } else {
                        charSequence = object instanceof CalculatorExpr.Value ? ((CalculatorExpr.Value)object).stringValue() : object.toString();
                    }
                    if (charSequence == null) {
                        Debugutil.stop();
                    }
                    n3 = 0;
                }
            }
            if (charSequence != null) {
                stringFormatter.append(charSequence);
            }
            return (short)n3;
        }

        void exec_Move(JZtxtcmdScript.FileOpArg fileOpArg) throws IllegalArgumentException, Exception {
            File file;
            CharSequence charSequence = this.evalString(fileOpArg.src);
            CharSequence charSequence2 = this.evalString(fileOpArg.dst);
            File file2 = FileSystem.isAbsolutePath(charSequence) ? new File(charSequence.toString()) : new File(this.currdir, charSequence.toString());
            boolean bl = file2.renameTo(file = FileSystem.isAbsolutePath(charSequence2) ? new File(charSequence2.toString()) : new File(this.currdir, charSequence2.toString()));
            if (!bl) {
                throw new IOException("JZcmd - move not successfully; " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
            }
        }

        void exec_Copy(JZtxtcmdScript.FileOpArg fileOpArg) throws Exception {
            Object object = this.evalObject(fileOpArg.src, false);
            String string = object instanceof JZtxtcmdFilepath ? ((JZtxtcmdFilepath)object).absfile().toString() : object.toString();
            Object object2 = this.evalObject(fileOpArg.dst, false);
            String string2 = object2 instanceof JZtxtcmdFilepath ? ((JZtxtcmdFilepath)object2).absfile().toString() : object2.toString();
            int n = string.indexOf(42);
            if (n >= 0) {
                int n2 = string.lastIndexOf(47, n);
                String string3 = string.substring(0, n2);
                if (!FileSystem.isAbsolutePath(string3)) {
                    string3 = this.sCurrdir + '/' + string3;
                }
                if (!FileSystem.isAbsolutePath(string2)) {
                    string2 = this.sCurrdir + '/' + string2;
                }
                String string4 = string.substring(n2 + 1);
                FileRemote fileRemote = FileRemote.getDir(string3);
                FileRemote fileRemote2 = FileRemote.getDir(string2);
                fileRemote.copyDirTreeTo(fileRemote2, 0, string4, 0, null, null);
            } else {
                File file;
                File file2 = FileSystem.isAbsolutePath(string) ? new File(string.toString()) : new File(this.currdir, string.toString());
                int n3 = FileSystem.copyFile(file2, file = FileSystem.isAbsolutePath(string2) ? new File(string2.toString()) : new File(this.currdir, string2.toString()), fileOpArg.bNewTimestamp, fileOpArg.bOverwrite, fileOpArg.bOverwriteReadonly);
                if (n3 < 0) {
                    throw new FileNotFoundException("JbatchExecuter - copy src not found; " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
                }
            }
        }

        void exec_Delete(JZtxtcmdScript.FileOpArg fileOpArg) throws Exception {
            CharSequence charSequence = this.evalString(fileOpArg.src);
            String string = FileSystem.isAbsolutePath(charSequence) ? charSequence.toString() : this.currdir() + "/" + charSequence;
            boolean bl = FileSystem.delete(string);
            if (!bl) {
                throw new FileNotFoundException("JbatchExecuter - del not possible; " + charSequence);
            }
        }

        short exec_Openfile(Map<String, DataAccess.Variable<Object>> map, JZtxtcmdScript.DefVariable defVariable) throws IllegalArgumentException, Exception {
            FileWriter fileWriter;
            CharSequence charSequence = this.evalString(defVariable);
            if (charSequence == retException) {
                return -5;
            }
            String string = charSequence.toString();
            if (!FileSystem.isAbsolutePath(string)) {
                File file = new File(this.currdir, string);
                fileWriter = new FileWriter(file);
            } else {
                fileWriter = new FileWriter(string);
            }
            this.storeValue(defVariable.defVariable, map, fileWriter, this.jzcmdMain.bAccessPrivate);
            return 0;
        }

        private short assignStatement(JZtxtcmdScript.JZcmditem jZcmditem) throws IllegalArgumentException, Exception {
            return this.assignObj((JZtxtcmdScript.AssignExpr)jZcmditem, null, true);
        }

        private short assignObj(JZtxtcmdScript.AssignExpr assignExpr, Object object, boolean bl) throws IllegalArgumentException, Exception {
            Object object2;
            CalculatorExpr.Value value = null;
            Object object3 = object;
            int n = 0;
            Boolean bl2 = null;
            JZtxtcmdScript.JZcmdDataAccess jZcmdDataAccess = assignExpr.variable;
            if (jZcmdDataAccess == null) {
                object2 = this.evalObject(assignExpr, false);
                n = object2 == retException ? -5 : 0;
            }
            Object object4 = object2 = assignExpr.assignObjs == null ? null : assignExpr.assignObjs.iterator();
            while (jZcmdDataAccess != null) {
                DataAccess.Dst dst = new DataAccess.Dst();
                Object object5 = this.dataAccess(jZcmdDataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, true, dst);
                if (object5 instanceof DataAccess.Variable) {
                    DataAccess.Variable variable = (DataAccess.Variable)object5;
                    char c = variable.type();
                    switch (c) {
                        case 'K': {
                            if (value != null) break;
                            value = this.evalValue(assignExpr, false);
                            break;
                        }
                        case 'Q': {
                            if (bl2 != null) break;
                            bl2 = new Boolean(this.evalCondition(assignExpr));
                            break;
                        }
                        default: {
                            if (object3 != null) break;
                            object3 = this.evalObject(assignExpr, false);
                        }
                    }
                    switch (variable.type()) {
                        case 'A': {
                            this.throwIllegalDstArgument("assign to appendable faulty", jZcmdDataAccess, assignExpr);
                            break;
                        }
                        case 'U': {
                            Object object6;
                            object5 = variable.value();
                            assert (object5 instanceof StringPartAppend);
                            StringPartAppend stringPartAppend = (StringPartAppend)object5;
                            stringPartAppend.clear();
                            Object object7 = object6 = object3 == null ? "--null--" : object3;
                            if (!(object6 instanceof CharSequence)) {
                                object6 = object6.toString();
                            }
                            stringPartAppend.append((CharSequence)object6);
                            break;
                        }
                        case 'S': {
                            if (object3 == null || object instanceof String || object instanceof StringSeq && ((StringSeq)object).isUnmated()) {
                                variable.setValue(object3);
                                break;
                            }
                            variable.setValue(object3.toString());
                            break;
                        }
                        case 'K': {
                            variable.setValue(value);
                            break;
                        }
                        case 'Q': {
                            variable.setValue(bl2);
                            break;
                        }
                        default: {
                            variable.setValue(object3);
                            break;
                        }
                    }
                } else {
                    if (object3 == null && (object3 = this.evalObject(assignExpr, false)) == retException) {
                        n = -5;
                    }
                    dst.set(object3);
                }
                if (object2 != null && object2.hasNext()) {
                    jZcmdDataAccess = (JZtxtcmdScript.JZcmdDataAccess)object2.next();
                    continue;
                }
                jZcmdDataAccess = null;
            }
            return (short)n;
        }

        short defineExpr(Map<String, DataAccess.Variable<Object>> map, JZtxtcmdScript.DefVariable defVariable) throws IllegalArgumentException, Exception {
            Object object;
            Object object2;
            Object object3;
            Object object4 = this.evalObject(defVariable, false);
            if (object4 == retException) {
                return -5;
            }
            switch (defVariable.elementType()) {
                case 'U': {
                    if (object4 == null) {
                        object3 = new StringPartAppend();
                        break;
                    }
                    object2 = object4 instanceof CharSequence ? (CharSequence)object4 : object4.toString();
                    object = new StringPartAppend();
                    ((StringPartAppend)object).append((CharSequence)object2);
                    object3 = object;
                    break;
                }
                case 'S': {
                    if (object4 == null || object4 instanceof String) {
                        object3 = object4;
                        break;
                    }
                    object3 = object4.toString();
                    break;
                }
                default: {
                    object3 = object4;
                }
            }
            object2 = defVariable.defVariable.datapath();
            if (object2.get(0).ident().equals("return") && !this.localVariables.containsKey("return")) {
                object = new DataAccess.Variable<IndexMultiTable>('M', "return", this.jzcmdMain.new_Variables());
                this.localVariables.add("return", (DataAccess.Variable<Object>)object);
            }
            this.storeValue(defVariable.defVariable, map, object3, this.jzcmdMain.bAccessPrivate);
            if (this.cmdExecuter != null && ((String)(object = defVariable.defVariable.datapath().get(0).ident())).startsWith("$")) {
                this.cmdExecuter.environment().put((String)object, object3.toString());
            }
            return 0;
        }

        short appendExpr(JZtxtcmdScript.AssignExpr assignExpr) throws IllegalArgumentException, Exception {
            Iterator<JZtxtcmdScript.JZcmdDataAccess> iterator;
            Object object = this.evalObject(assignExpr, false);
            short s = object == retException ? (short)-5 : 0;
            JZtxtcmdScript.JZcmdDataAccess jZcmdDataAccess = assignExpr.variable;
            Iterator<JZtxtcmdScript.JZcmdDataAccess> iterator2 = iterator = assignExpr.assignObjs == null ? null : assignExpr.assignObjs.iterator();
            while (jZcmdDataAccess != null) {
                Object object2 = this.dataAccess(jZcmdDataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                if (object2 instanceof Appendable) {
                    if (!(object instanceof CharSequence)) {
                        object = object.toString();
                    }
                    ((Appendable)object2).append((CharSequence)object);
                } else if (object2 instanceof List) {
                    List list = (List)object2;
                    if (object instanceof List) {
                        List list2 = (List)object;
                        for (Object e : list2) {
                            list.add(e);
                        }
                    } else {
                        list.add(object);
                    }
                } else {
                    this.throwIllegalDstArgument("dst should be Appendable", jZcmdDataAccess, assignExpr);
                }
                if (iterator != null && iterator.hasNext()) {
                    jZcmdDataAccess = iterator.next();
                    continue;
                }
                jZcmdDataAccess = null;
            }
            return s;
        }

        void exec_Throw(JZtxtcmdScript.JZcmditem jZcmditem) throws Exception {
            CharSequence charSequence = this.evalString(jZcmditem);
            throw new JZcmdThrow(charSequence.toString());
        }

        void exec_Throwonerror(JZtxtcmdScript.Onerror onerror) throws CmdErrorLevelException {
            if (this.cmdErrorlevel >= onerror.errorLevel) {
                throw new CmdErrorLevelException(this.cmdErrorlevel);
            }
        }

        public Object evalDatapathOrExpr(JZtxtcmdScript.Argument argument) throws Exception {
            if (argument.dataAccess != null) {
                Object object = this.dataAccess(argument.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                if (object == null) {
                    return "null";
                }
                return object;
            }
            if (argument.expression != null) {
                CalculatorExpr.Value value = this.calculateExpression(argument.expression);
                if (value.isObjValue()) {
                    return value.objValue();
                }
                return value;
            }
            throw new IllegalArgumentException("JZcmd - unexpected, faulty syntax");
        }

        public CharSequence evalString(JZtxtcmdScript.JZcmditem jZcmditem) throws Exception {
            if (jZcmditem.textArg != null) {
                return jZcmditem.textArg;
            }
            if (jZcmditem.dataAccess != null) {
                Object object = this.dataAccess(jZcmditem.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                if (object == null) {
                    return "null";
                }
                if (object instanceof CharSequence) {
                    return (CharSequence)object;
                }
                return object.toString();
            }
            if (jZcmditem.statementlist != null) {
                StringFormatter stringFormatter = new StringFormatter();
                short s = this.executeNewlevel(this.jzClass, jZcmditem.statementlist, stringFormatter, 0, -1);
                if (s == -5) {
                    return retException;
                }
                return stringFormatter.getBuffer();
            }
            if (jZcmditem.expression != null) {
                CalculatorExpr.Value value = this.calculateExpression(jZcmditem.expression);
                return value.stringValue();
            }
            return null;
        }

        Object dataAccess(JZtxtcmdScript.JZcmdDataAccess jZcmdDataAccess, Map<String, DataAccess.Variable<Object>> map, boolean bl, boolean bl2, boolean bl3, DataAccess.Dst dst) throws Exception {
            this.calculateArguments(jZcmdDataAccess);
            return DataAccess.access(jZcmdDataAccess.datapath(), map, bl, bl2, null, null, bl3, dst);
        }

        void storeValue(DataAccess dataAccess, Map<String, DataAccess.Variable<Object>> map, Object object, boolean bl) throws Exception {
            this.calculateArguments(dataAccess);
            dataAccess.storeValue(map, object, bl);
        }

        private CalculatorExpr.Value calculateExpression(CalculatorExpr calculatorExpr) throws Exception {
            for (CalculatorExpr.Operation operation : calculatorExpr.listOperations()) {
                DataAccess dataAccess = operation.datapath();
                if (dataAccess == null) continue;
                this.calculateArguments(dataAccess);
            }
            return calculatorExpr.calcDataAccess(this.localVariables, new Object[0]);
        }

        private void calculateArguments(DataAccess dataAccess) throws Exception {
            if (this.debug_dataAccessArguments) {
                this.debug();
                this.debug_dataAccessArguments = false;
            }
            for (DataAccess.DatapathElement datapathElement : dataAccess.datapath()) {
                Object object;
                DataAccess.DatapathElement datapathElement2;
                List<JZtxtcmdScript.JZcmditem> list = null;
                if (datapathElement instanceof JZtxtcmdScript.JZcmdDatapathElementClass) {
                    datapathElement2 = (JZtxtcmdScript.JZcmdDatapathElementClass)datapathElement;
                    if (((JZtxtcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathLoader != null) {
                        object = this.dataAccess(((JZtxtcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathLoader, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                        assert (object instanceof ClassLoader);
                        ((DataAccess.DatapathElementClass)datapathElement2).set_loader((ClassLoader)object);
                    }
                    if (((JZtxtcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathClass != null) {
                        object = this.dataAccess(((JZtxtcmdScript.JZcmdDatapathElementClass)datapathElement2).dpathClass, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                        assert (object instanceof Class);
                        ((DataAccess.DatapathElementClass)datapathElement2).set_Class((Class)object);
                    }
                    list = ((JZtxtcmdScript.JZcmdDatapathElementClass)datapathElement2).fnArgsExpr;
                }
                if (datapathElement instanceof JZtxtcmdScript.JZcmdDatapathElement) {
                    datapathElement2 = (JZtxtcmdScript.JZcmdDatapathElement)datapathElement;
                    if (((JZtxtcmdScript.JZcmdDatapathElement)datapathElement2).indirectDatapath != null) {
                        object = this.dataAccess(((JZtxtcmdScript.JZcmdDatapathElement)datapathElement2).indirectDatapath, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                        datapathElement.setIdent(object.toString());
                    }
                    list = ((JZtxtcmdScript.JZcmdDatapathElement)datapathElement2).fnArgsExpr;
                }
                if (list == null) continue;
                int n = list.size();
                object = new Object[n];
                int n2 = -1;
                for (JZtxtcmdScript.JZcmditem jZcmditem : list) {
                    Object object2 = this.evalObject(jZcmditem, false);
                    object[++n2] = object2;
                }
                datapathElement.setActualArgumentArray((Object[])object);
            }
        }

        public Object evalObject(JZtxtcmdScript.JZcmditem jZcmditem, boolean bl) throws Exception {
            Object object;
            Object object2;
            int n = 0;
            if (jZcmditem.textArg != null) {
                object2 = jZcmditem.textArg;
            } else if (jZcmditem.dataAccess != null) {
                object2 = this.dataAccess(jZcmditem.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
            } else if (jZcmditem.statementlist != null) {
                IndexMultiTable<String, DataAccess.Variable<Object>> indexMultiTable;
                object2 = jZcmditem.elementType == 'M' ? ((n = (int)((ExecuteLevel)(object = new ExecuteLevel(this.jzcmdMain, this.jzClass, this.threadData, this, this.localVariables))).execute(jZcmditem.statementlist, null, 0, indexMultiTable = new IndexMultiTable<String, DataAccess.Variable<Object>>(IndexMultiTable.providerString), -1)) == -5 ? retException : indexMultiTable) : ((n = (int)this.executeNewlevel(this.jzClass, jZcmditem.statementlist, (StringFormatter)(object = new StringFormatter()), 0, -1)) == -5 ? retException : ((StringFormatter)object).toString());
            } else if (jZcmditem.expression != null) {
                object = this.calculateExpression(jZcmditem.expression);
                object2 = ((CalculatorExpr.Value)object).objValue();
            } else {
                object2 = null;
            }
            if (object2 != null && n != -5 && jZcmditem.conversion != '\u0000') {
                switch (jZcmditem.conversion) {
                    case '~': {
                        if (FileSystem.isAbsolutePath(object2.toString())) break;
                        object2 = this.currdir() + "/" + object2;
                        break;
                    }
                    case 'E': {
                        object = object2.toString();
                        if (FileSystem.isAbsolutePath((CharSequence)object)) {
                            object2 = new File((String)object);
                            break;
                        }
                        object2 = new File(this.currdir, (String)object);
                        break;
                    }
                    case 'F': {
                        object = object2.toString();
                        object2 = new JZtxtcmdFilepath(this, (String)object);
                        break;
                    }
                    case 'G': {
                        assert (jZcmditem.subitem instanceof JZtxtcmdScript.AccessFilesetname);
                        object = (JZtxtcmdScript.AccessFilesetname)jZcmditem.subitem;
                        object2 = new JZtxtcmdAccessFileset((JZtxtcmdScript.AccessFilesetname)object, this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            return object2;
        }

        public CalculatorExpr.Value evalValue(JZtxtcmdScript.JZcmditem jZcmditem, boolean bl) throws Exception {
            if (jZcmditem.textArg != null) {
                return null;
            }
            if (jZcmditem.dataAccess != null) {
                Object object = this.dataAccess(jZcmditem.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                CalculatorExpr.Value value = object instanceof Float ? new CalculatorExpr.Value(((Float)object).floatValue()) : (object instanceof Double ? new CalculatorExpr.Value((Double)object) : (object instanceof Long ? new CalculatorExpr.Value((Long)object) : (object instanceof Integer ? new CalculatorExpr.Value((Integer)object) : (object instanceof Short ? new CalculatorExpr.Value(((Short)object).shortValue()) : (object instanceof Byte ? new CalculatorExpr.Value(((Byte)object).byteValue()) : (object instanceof Boolean ? new CalculatorExpr.Value((Boolean)object) : (object instanceof CalculatorExpr.Value ? (CalculatorExpr.Value)object : new CalculatorExpr.Value(object))))))));
                return value;
            }
            if (jZcmditem.expression != null) {
                return this.calculateExpression(jZcmditem.expression);
            }
            return null;
        }

        public boolean evalCondition(JZtxtcmdScript.JZcmditem jZcmditem) throws Exception {
            boolean bl;
            block12: {
                if (jZcmditem.textArg != null) {
                    return true;
                }
                if (jZcmditem.dataAccess != null) {
                    try {
                        Object object = this.dataAccess(jZcmditem.dataAccess, this.localVariables, this.jzcmdMain.bAccessPrivate, false, false, null);
                        if (object instanceof Boolean) {
                            bl = (Boolean)object;
                            break block12;
                        }
                        if (object instanceof Integer) {
                            bl = (Integer)object != 0;
                            break block12;
                        }
                        bl = object != null;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        bl = false;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        bl = false;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        bl = false;
                    }
                } else {
                    if (jZcmditem.statementlist != null) {
                        throw new IllegalArgumentException("JZcmdExecuter - unexpected, faulty syntax");
                    }
                    if (jZcmditem.expression != null) {
                        CalculatorExpr.Value value = this.calculateExpression(jZcmditem.expression);
                        bl = value.booleanValue();
                    } else {
                        throw new IllegalArgumentException("JZcmdExecuter - unexpected, faulty syntax");
                    }
                }
            }
            return bl;
        }

        JZtxtcmdFilepath convert2FilePath(Object object) {
            JZtxtcmdFilepath jZtxtcmdFilepath;
            if (object == null) {
                jZtxtcmdFilepath = null;
            } else if (object instanceof JZtxtcmdFilepath) {
                jZtxtcmdFilepath = (JZtxtcmdFilepath)object;
            } else {
                String string = object.toString();
                jZtxtcmdFilepath = new JZtxtcmdFilepath(this, new FilePath(string));
            }
            return jZtxtcmdFilepath;
        }

        protected void runThread(ExecuteLevel executeLevel, JZtxtcmdScript.ThreadBlock threadBlock, JZtxtcmdThreadData jZtxtcmdThreadData) {
            try {
                executeLevel.execute(threadBlock.statementlist, this.jzcmdMain.textline, 0, executeLevel.localVariables, -1);
            }
            catch (Exception exception) {
                jZtxtcmdThreadData.exception = exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finishThread(JZtxtcmdThreadData jZtxtcmdThreadData) {
            Object object = jZtxtcmdThreadData;
            synchronized (object) {
                jZtxtcmdThreadData.notifyAll();
            }
            object = this.jzcmdMain.threads;
            synchronized (object) {
                boolean bl = this.jzcmdMain.threads.remove(jZtxtcmdThreadData);
                assert (bl);
                if (this.jzcmdMain.threads.size() == 0) {
                    this.jzcmdMain.threads.notify();
                }
            }
        }

        public String currdir() {
            return this.currdir.getPath().replace('\\', '/');
        }

        int debug(JZtxtcmdScript.JZcmditem jZcmditem) {
            try {
                CharSequence charSequence = this.evalString(jZcmditem);
                if (charSequence != null) {
                    System.out.println(charSequence.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.stop();
            return 1;
        }

        public void debug_dataAccessArguments() {
            this.debug_dataAccessArguments = true;
        }

        void debug() {
            Assert.stop();
        }

        public CharSequence excStacktraceinfo() {
            CharSequence charSequence = Assert.exceptionInfo("JZcmd.execute - exception at;" + this.threadData.excStatement.toString() + ";", this.threadData.exception, 0, 20);
            return charSequence;
        }

        void throwIllegalDstArgument(CharSequence charSequence, DataAccess dataAccess, JZtxtcmdScript.JZcmditem jZcmditem) throws IllegalArgumentException {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("JZcmd - ").append(charSequence).append(";").append(dataAccess);
            stringBuilder.append("; in file ").append(jZcmditem.parentList.srcFile);
            stringBuilder.append(", line ").append(jZcmditem.srcLine).append(" col ").append(jZcmditem.srcColumn);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        @Override
        public Object getAttribute(String string) {
            DataAccess.Variable<Object> variable = this.localVariables.get(string);
            if (variable == null) {
                return null;
            }
            return variable.value();
        }

        @Override
        public Object getAttribute(String string, int n) {
            switch (n) {
                case 100: {
                    return this.getAttribute(string);
                }
                case 200: {
                    return this.jzcmdMain.scriptLevel.getAttribute(string);
                }
            }
            throw new IllegalArgumentException("JZcmdExecuter.getAttribute - failed scope;" + n);
        }

        @Override
        public int getAttributesScope(String string) {
            return 100;
        }

        @Override
        public Bindings getBindings(int n) {
            switch (n) {
                case 100: {
                    return new JZcmdBindings(this.localVariables);
                }
                case 200: {
                    return new JZcmdBindings(this.jzcmdMain.scriptLevel.localVariables);
                }
            }
            throw new IllegalArgumentException("JZcmdExecuter.getBindings - failed scope;" + n);
        }

        @Override
        public Writer getErrorWriter() {
            return null;
        }

        @Override
        public Reader getReader() {
            return null;
        }

        @Override
        public List<Integer> getScopes() {
            return null;
        }

        @Override
        public Writer getWriter() {
            return null;
        }

        @Override
        public Object removeAttribute(String string, int n) {
            return null;
        }

        @Override
        public void setAttribute(String string, Object object, int n) {
        }

        @Override
        public void setBindings(Bindings bindings, int n) {
        }

        @Override
        public void setErrorWriter(Writer writer) {
        }

        @Override
        public void setReader(Reader reader) {
        }

        @Override
        public void setWriter(Writer writer) {
        }

        @Override
        public CharSequence getCurrentDir() {
            return this.currdir();
        }

        @Override
        public Object getValue(String string) throws NoSuchFieldException {
            Object object;
            DataAccess.Variable<Object> variable = this.localVariables.get(string);
            if (variable == null) {
                object = string.startsWith("$") ? System.getenv(string.substring(1)).replace('\\', '/') : null;
                if (object == null) {
                    throw new NoSuchFieldException("JZcmdFilepath.getValue() - variable not found; " + string);
                }
            } else {
                object = variable.value();
                if (object instanceof JZtxtcmdFilepath) {
                    object = ((JZtxtcmdFilepath)object).data;
                }
            }
            return object;
        }
    }

    public static class JzTcMain {
        final JZtxtcmdExecuter jzCmdExecuter;
        public final MainCmdLogging_ifc log;
        public String newline = "\r\n";
        public int tabsize = 4;
        protected Locale locale = Locale.ENGLISH;
        Appendable outFromCmdlineArg;
        StringFormatter textline;
        public long startmilli;
        public long startnano;
        private int nextNr_ = 0;
        public boolean bAccessPrivate;
        JZtxtcmdScript jzcmdScript;
        Queue<CmdExecuter> runningCmdExecuter = new ConcurrentLinkedQueue<CmdExecuter>();
        public final Queue<JZtxtcmdThreadData> threads = new ConcurrentLinkedQueue<JZtxtcmdThreadData>();
        public final JZtxtcmdThreadData scriptThread;
        public final ExecuteLevel scriptLevel;

        JzTcMain(MainCmdLogging_ifc mainCmdLogging_ifc, JZtxtcmdExecuter jZtxtcmdExecuter) {
            this.log = mainCmdLogging_ifc;
            this.jzCmdExecuter = jZtxtcmdExecuter;
            this.scriptThread = new JZtxtcmdThreadData();
            this.scriptLevel = new ExecuteLevel(this, this.scriptThread);
        }

        public Map<String, DataAccess.Variable<Object>> scriptVariables() {
            return this.scriptLevel.localVariables;
        }

        public MainCmdLogging_ifc log() {
            return this.log;
        }

        public String getstdin() {
            String string = null;
            try {
                byte[] byArray = new byte[100];
                int n = System.in.read(byArray);
                string = new String(byArray, 0, n);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return string;
        }

        public boolean sleep(int n) {
            boolean bl = false;
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            return !bl;
        }

        public void setScriptVariable(String string, char c, Object object, boolean bl) throws IllegalAccessException {
            DataAccess.createOrReplaceVariable(this.scriptLevel.localVariables, string, c, object, bl);
        }

        public DataAccess.Variable<Object> getScriptVariable(String string) throws NoSuchFieldException {
            return DataAccess.getVariable(this.scriptLevel.localVariables, string, true);
        }

        public JZtxtcmdScript.Subroutine sub(CharSequence charSequence) {
            return this.jzcmdScript.getSubroutine(charSequence);
        }

        public String nextNr() {
            return Integer.toString(++this.nextNr_);
        }

        public DataAccess.Variable<Object> removeScriptVariable(String string) {
            return this.scriptLevel.localVariables.remove(string);
        }

        public CharSequence currdir() {
            return this.scriptLevel.currdir();
        }

        public long calctime() {
            return System.currentTimeMillis() - this.startmilli;
        }

        private IndexMultiTable<String, DataAccess.Variable<Object>> new_Variables() {
            return new IndexMultiTable<String, DataAccess.Variable<Object>>(IndexMultiTable.providerString);
        }
    }
}

