package org.vishia.xml;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.jdom.Element;
import org.jdom.Namespace;
import org.vishia.xmlSimple.XmlException;
import org.vishia.xmlSimple.XmlNode;

/**This class wraps a JDOM Element with a implementation of {@link org.vishia.xmlSimple.XmlNode}.
 * So some algorithm using XmlNode can execute with a given JDOM XML Tree. 
 * <br>
 * This class is used in 
 * {@link org.vishia.xml.CorrectHref}. There a JDOM tree is used, 
 * and {@link org.vishia.xmlSimple.WikistyleTextToSimpleXml} is called there. The last class 
 * WikistyleTextToSimpleXml don't know JDOM, but it works correct.  
 * 
 * @author Hartmut Schorrig
 *
 */
public class XmlNodeJdom implements XmlNode
{

  final Element jdomNode;

  List<XmlNode> listChildren;
  
  public XmlNodeJdom(Element jdomNode)
  { this.jdomNode =jdomNode;
  }
  
  
  public XmlNode addContent(String text)
  {
    jdomNode.addContent(text);
    return this;
  }

  public XmlNode addContent(XmlNode node) throws XmlException
  { if(node instanceof XmlNodeJdom)
    {
      jdomNode.addContent(((XmlNodeJdom)node).jdomNode);
    }
    else
    { Element newNode = new Element(node.getName());
      jdomNode.addContent(newNode);
    }
    return this;
  }

  public void addNamespaceDeclaration(String name, String value)
  {
    // TODO Auto-generated method stub
    
  }

  public XmlNode addNewNode(String name, String namespaceKey) throws XmlException
  {
    XmlNode node = createNode(name,namespaceKey);
    addContent(node);
    return node;
  }

  public XmlNode createNode(String name, String namespaceKey) throws XmlException
  { org.jdom.Element jdomNodeNew;
    if(namespaceKey != null && namespaceKey.length()>0)
    { Namespace ns = jdomNode.getNamespace(namespaceKey);
      if(ns == null) throw new XmlException("unknown namespace: " + namespaceKey);
      jdomNodeNew = new Element(name, ns);
    }
    else
    { jdomNodeNew = new Element(name);
    }
    XmlNodeJdom node = new XmlNodeJdom(jdomNodeNew);  //the wrapper of the jdom node.
    return node;
  }

  public String getAttribute(String name)
  {
    org.jdom.Attribute attrib = jdomNode.getAttribute(name);
    if(attrib != null){ return attrib.getValue(); }
    else return null;
  }

  public Map<String, String> getAttributes()
  {
    // TODO Auto-generated method stub
    return null;
  }

  public XmlNode getChild(String key)
  {
    org.jdom.Element jdomChild = jdomNode.getChild(key);
    return new XmlNodeJdom(jdomChild);
  }

  public String getName()
  {
    return jdomNode.getName();
  }

  public String getNamespaceKey()
  {
    return jdomNode.getNamespace().getPrefix();
  }

  public Map<String, String> getNamespaces()
  {
    return null;
  }

  public XmlNode getParent()
  {
    return new XmlNodeJdom(jdomNode.getParentElement());
  }

  public String text()
  {
    // TODO Auto-generated method stub
    return jdomNode.getTextTrim();
  }

  public boolean isTextNode()
  {
    
    return false;
  }

  public String removeAttribute(String name)
  {
    jdomNode.removeAttribute(name);
    return null;
  }

  public void removeChildren()
  {
    jdomNode.removeContent();    
  }

  public void setAttribute(String name, String value)
  {
    jdomNode.setAttribute(new org.jdom.Attribute(name, value));
    
  }

  public void setParent(XmlNode parent)
  {
    // TODO Auto-generated method stub
    
  }

  public Iterator<XmlNode> iterChildren()
  {
    listChildren();
    return listChildren.iterator();
  }

  public Iterator<XmlNode> iterChildren(String key)
  {
    return listChildren(key).iterator();
  }

  @SuppressWarnings("unchecked")
  public List<XmlNode> listChildren()
  {
    if(listChildren == null)
    { listChildren = new LinkedList<XmlNode>();
      List<Element> jdomChildren = jdomNode.getChildren();
      for(Element jdomChild : jdomChildren)
      { listChildren.add(new XmlNodeJdom(jdomChild));
      }
    }
    // TODO Auto-generated method stub
    return listChildren;
  }

  @SuppressWarnings("unchecked")
  public List<XmlNode> listChildren(String key)
  {
    List<XmlNode> listChildrenKey = new LinkedList<XmlNode>();
    List<Element> jdomChildren = jdomNode.getChildren(key);
    for(Element jdomChild : jdomChildren)
    { listChildrenKey.add(new XmlNodeJdom(jdomChild));
    }
    // TODO Auto-generated method stub
    return listChildrenKey;
  }

  
  @Override
  public String toString()
  { return jdomNode.getName();
  }
  
  
}
