package org.vishia.inspcReflBridge;

import java.io.File;

import org.vishia.util.FileSystem;

/**This class loads reflection info for C/C++ (embedded) applications which are given as data image in a file.
 * The reflection access uses this information to prepare access to the embedded target.
 * The target itself have only less informations with a simple interface, which can be used with socket, serial
 * or dual port ram communication. See 
 * 
 * @author hartmut
 *
 */
public class ReflectionLoadExt
{
  byte[] extReflectionBuffer;
  
  public String load(String fileName, int headerOffset )
  {
    String sError = null;
    File file = new File(fileName);
    if(file.exists()) {
      int zFile = (int)file.length();
      byte[] buffer = extReflectionBuffer = new byte[zFile];
      int zBytesRead = FileSystem.readBinFile(file, buffer);
      if(zBytesRead < zFile) {
        sError = "reflection bin file read error";
      } else {
        
      }
    } else {
      sError = "reflection-bin-file not found";
    }
    return sError;
  }
}
