/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zcmd;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.vishia.cmd.JZcmdEngine;
import org.vishia.cmd.JZcmdExecuter;
import org.vishia.cmd.JZcmdScript;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLoggingStream;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.DataAccess;
import org.vishia.util.FileSystem;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.xmlSimple.SimpleXmlOutputter;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zbnf.ZbnfParser;

public class JZcmd
implements JZcmdEngine,
Compilable {
    public static final String sVersion = "2014-06-10";
    final ZbnfParser parserGenCtrl;
    final MainCmdLogging_ifc log;

    public static void main(String[] stringArray) {
        try {
            int n = JZcmd.smain(stringArray);
            System.exit(n);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable == null) {
                throwable = exception;
            }
            String string = null;
            int n = 0;
            int n2 = 0;
            if (string != null) {
                String string2 = "JZcmd.main() - uncaught ERROR in ;" + string + "; line,col: " + n + ", " + n2 + "; " + throwable.getMessage();
                System.err.println(string2);
            } else {
                System.err.println("JZcmd.main() - uncaught ERROR; ");
            }
            throwable.printStackTrace(System.err);
            System.exit(3);
        }
    }

    public static int smain(String[] stringArray) throws ScriptException {
        String string = null;
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(args, stringArray);
        cmdLine.setReportLevel(0);
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            string = "JZcmd - Argument error ;" + exception.getMessage();
            cmdLine.report(string, exception);
            cmdLine.setExitErrorLevel(5);
        }
        if (args.sFileScript == null) {
            cmdLine.writeHelpInfo(null);
        } else if (string == null) {
            File file;
            OutputStreamWriter outputStreamWriter = null;
            Closeable closeable = null;
            if (args.sFileTextOut != null) {
                try {
                    file = new File(args.sFileTextOut);
                    outputStreamWriter = new FileWriter(file);
                    closeable = outputStreamWriter;
                }
                catch (IOException iOException) {
                    string = "JZcmd - cannot create output text file;";
                }
            } else {
                closeable = System.out;
            }
            if (string == null) {
                file = new File(args.sFileScript);
                int n = 1;
                JZcmdExecuter jZcmdExecuter = new JZcmdExecuter(cmdLine);
                try {
                    for (String string2 : args.userArgs) {
                        jZcmdExecuter.setScriptVariable("$" + n, 'S', string2, true);
                        ++n;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ScriptException("JZcmd.smain - cannot set user argument; " + n);
                }
                String string3 = cmdLine.currdir();
                JZcmd.execute(jZcmdExecuter, file, closeable, string3, true, args.fileTestXml, cmdLine);
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            if (string != null) {
                cmdLine.writeError(string);
            }
        }
        return cmdLine.getExitErrorLevel();
    }

    public JZcmd() throws ScriptException {
        this(null);
    }

    public JZcmd(MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        this.log = mainCmdLogging_ifc == null ? new MainCmdLoggingStream(System.out) : mainCmdLogging_ifc;
        this.parserGenCtrl = new ZbnfParser(this.log);
        try {
            this.parserGenCtrl.setSyntax(" $comment=(?...?).\n $endlineComment=\\#\\#.  ##The ## is the start chars for an endline-comment or commented line in the generator script.\n $keywords= new | cmd | cmd_check | start \n   | debug | java \n   | stdout | stdin | stderr \n   | subtext | sub | main | call | cd | CD | REM | Rem | rem \n   | Pipe | StringBuffer | Stringjar | String | List | Openfile | Fileset | Obj | Set | set | include | zbatch \n   | break | XXXreturn | exit | onerror | instanceof | for | while | do | if | elsif | else | throw . \n \n JZcmd::= \n [<*|==ZGen==?>==ZGen== ]\n [<*|==JZcmd==?>==JZcmd== ]\n [{ ! checkJZcmd = <textValue?checkJZcmdFile> ; \n  | ! checkXml = <textValue?checkXmlFile> ; \n }]\n [{ [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n  | include <include> ; \n  | currdir = <textDatapath?cd> ;\n }] \n { [//] ==endJZcmd==<*\\e?> \n | [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*\\n\\r?> ##line comment in C style\n | /*<*|*/?>*/ ##block commment in C style\n | <DefVariable?> ; \n | <statement?>\n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n | main ( ) \\{ <statementBlock?mainRoutine> \\} \n } \\e.\n \n \n include::= [$<$?envVar>[/|\\\\]][ <\"\"?path> | <*;\\ ?path>].\n \n \n subClass::= <$?name> \\{ \n { subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n } \\}. \n \n \n subroutine::= <$?name> ( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , }|] ) \\{ [<statementBlock>] \\}. \n \n subtext::= <$?name> ( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , }|] ) \\<:\\><textExpr>\\<\\.\\>.\n \n \n statementBlock::= { <statement?> }.\n \n statement::=\n   \\{ [<statementBlock>] \\} \n | REM <*\\n\\r?> ##Remark like in batch files\n | ::{:}                ##Skip over :::\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*|\\n|\\r|\\<+?>     ##line commment in C style but only till <+\n | /*<*|*/?>*/          ##block commment in C style\n | currdir = <textDatapath?cd> ;   ##set current directory\n | [cd|CD] [<textValue?cd> | <*\\ ;?cd> ; ]  ##change current directory \n | <DefVariable?> ; \n | for <forCtrl> \n | if <ifCtrl> \n | while <whileCtrl> \n | do <dowhileCtrl> \n | start <cmdLine?cmdStart> \n | zmake <zmake> \n | move <srcdst?move> ; \n | copy <srcdst?copy> ; \n | [rm|del] <oneArg?del> ; \n | break <?breakBlock> ; \n | return <?return> ; \n | exit <#?exitScript> ;\n | throw on errorlevel <#?throwonerror> \n | throw <textDatapath?throw> \n | onerror <onerror> \n | errortoOutput off <?errorToOutput=0> \n | errortoOutput <?errorToOutput=1> \n | if errorlevel <iferrorlevel> \n | debug [<textValue?debug>| <?debug>] ; \n | <callSubroutine?call> \n | <threadBlock> \n | \\<+<textOut> \n | \\<:\\><textExpr>\\<\\.\\> [;] \n | <cmdLineWait?cmdWait> \n | <assignExpr> \n | ; \n .\n \n \n srcdst::= [src=] <textValue?actualArgument> [dst=] <textValue?actualArgument> .\n oneArg::= <textValue?actualArgument> .\n \n \n DefVariable::=\n   String\\  <DefStringVar?textVariable> \n | Stringjar\\  <DefSpecVar?Stringjar> \n | Num\\  <DefNumVar> \n | Bool\\  <DefBoolVar> \n | Pipe\\  <DefSpecVar?Pipe> \n | List\\  <DefSpecVar?List> \n | Map\\  <DefMapVar> \n | Obj\\  <DefObjVar> \n | Class\\  <DefClassVar> \n | Classpath\\  <DefClasspath> \n | Openfile\\  <Openfile> \n | Fileset\\  <DefFileset> \n | Filepath\\ <DefFilepath> \n | Set\\  <DefStringVar?setEnvVar> \n | set\\  <DefStringVar?setEnvVar> \n | SET\\  <DefStringVar?setEnvVar> \n .\n \n DefNumVar::= [const <?const>] <definePath?defVariable>  [ = <numExpr>].\n \n DefBoolVar::= [const <?const>] <definePath?defVariable>  [ = <boolExpr>].\n \n DefSpecVar::= [const <?const>] <definePath?defVariable>  [ = <objExpr?>].\n \n DefObjVar::= [const <?const>] <definePath?defVariable> [ : <$\\.?type>]  [ = <objExpr?>].\n \n DefClassVar::= [const] <definePath?defVariable>  = \n   [: <dataAccess?loader> : ]  ## a datapath to a ClassLoader instance, a Classpath variable. \n   <textValue?>.               ## The package path maybe contained in any expression\n \n DefClasspath::= [const] <definePath?defVariable>  = [ : <$?parentClasspath> : ] { <filesetAccess> ? , }.\n \n DefStringVar::= [const <?const>] <definePath?defVariable> [ = <textDatapath?>].\n \n DefMapVar::= [const <?const>] <definePath?defVariable> [ = \\{ <dataStruct> \\}  ].\n \n Openfile::= [const <?const>] <definePath?defVariable> = <textDatapath?> .\n \n \n definePath::= <$-?startVariable>[ [?\\. \\>] \\.{ <defineSubelement?datapathElement> ? [?\\. \\>] \\.}].\n \n defineSubelement::= <$-?ident> [( [{ <objExpr?argument> ? ,}])<?whatisit=(>].\n \n \n DefFileset::= <definePath?defVariable> [ =  ( \n [ commonpath = [<\"\"?commonPath>|<*;,)(\\ \\r\\n?commonPath>] , ] \n { [{ //JZcmd | //<*\\n\\r?>}] [<\"\"?filePath>|<*;,)(\\ \\r\\n?filePath>] [{ //JZcmd | //<*\\n\\r?>}] ? , } \n ) ] .\n \n DefFilepath::= <definePath?defVariable> [ = <textValue?> ]. \n \n \n XXXFilepath::=<\"\"?!prepFilePath>|<*;\\ \\r\\n,)?!prepFilePath>. \n \n prepFilePath::=<$NoWhiteSpaces><! *?>\n [ &$<$?@envVariable> [\\\\|/|]      ##path can start with a environment variable's content\n | &<$?@scriptVariable> [\\\\|/|]    ##path can start with a scriptvariable's content\n | [<!.?@drive>:]                  ## only 1 char with followed : is the drive letter\n   [ [/|\\\\]<?@absPath>]            ## starting with / maybe after d: is absolute path\n |]\n [ <*:?@pathbase>[?:=]:]           ## all until : is pathbase, but not till a :=\n [ <toLastChar:/\\\\?@path>[\\\\|/|]] ## all until last \\ or / is path\n [ <toLastChar:.?@name>              ## all until exclusive dot is the name\n   <*\\e?@ext>                       ## from dot to end is the extension\n | <*\\e?@name>                      ## No dot is found, all is the name.\n ] . \n \n \n \n \n \n textDatapath::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | [& [?(] ] <dataAccess> .\n \n textValue::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | & <dataAccess> | <*;,)(\\ \\r\\n\\>?text> .\n \n \n objExpr::= \n   File : <textValue?File>         ## A textValue which builds a java.lang.File in the currdir \n | Filepath : <textValue?Filepath> ## A textValue which builds a Filepath in the currdir \n | Fileset: <filesetAccess>  \n | \\{ <dataStruct> \\}              ## It is a Map of Variables. \n | <\"\"?text>                       ## It is a constant text. \n | \\<:\\><textExpr>\\<\\.\\>           ## It is a text assembled in runtime. \n | <numExpr>.                      ## special detection of a simple dataAccess.\n \n dataStruct::= { <DefVariable?> ; }.\n \n \n \n \n dataAccess::= \n [ $<$?envVariable> \n | [<?startVariable> $<#?>| $<$?>]    ## $1 .. $999 are the arguments of JZcmd, $name for environment \n | [java\\ ] new\\  <staticJavaAccess?newJavaClass> \n | [%|java\\ ] <staticJavaAccess?staticJavaMethod> \n | <dataPath?> \n ].\n \n \n ## Access to a Java class constructor or static method or field\n staticJavaAccess::=\n   [ & <dataAccess?Class_Var> : [<$\\.$?javapath>]       ## access via Class variable .element\n   | [: <dataAccess?Classpath_Var> : ] <$\\.$?javapath>  ## [Classpath] package.path.Class.element\n   ] [( [ { <objExpr?argument> ? , } ])].               ## arguments\n \n dataPath::= <startDatapath>[ [?\\. \\>] \\.{ <datapathElement> ? [?\\. \\>] \\.}].\n \n ## A datapath cannot start with an JZcmd keyword! \n startDatapath::= [ & ( <dataPath> ) | <$-?ident> ] <?whatisit=@> [( [{ <objExpr?argument> ? ,}])<?whatisit=+>].\n ## Use regex for the second datapath element, it can be a JZcmd keyword too! \n datapathElement::= [ & ( <dataPath> ) |[<?ident>[@]<![\\\\w-]+?>]] [( [{ <objExpr?argument> ? ,}])<?whatisit=(>].\n \n \n \n \n condition::=<andExpr?> [{\\|\\| <?boolCheckOrOperation> <andExpr?boolOrOperation>}].\n \n andExpr::= <boolExpr?> [{ && <?boolCheckAndOperation> <boolExpr?boolAndOperation>}].\n \n boolExpr::= [<?boolNot> ! | not| NOT|]\n [ ( <condition?parenthesisCondition> ) \n | <numExpr?> [<cmpOperation>]\n ].\n \n cmpOperation::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == | \\>= | \\> | \\<= | \\< ]] <numExpr?>.\n \n instanceof::=<objExpr> instanceof <staticJavaAccess>.\n \n conditionInText::=<andExprInText?> [{\\|\\| <?boolCheckOrOperation> <andExprInText?boolOrOperation>}].\n \n andExprInText::= <boolExprInText?> [{ && <?boolCheckAndOperation> <boolExprInText?boolAndOperation>}].\n \n boolExprInText::= [<?boolNot> ! | not|]\n [ ( <conditionInText?parenthesisCondition> ) \n | <numExpr?> [<cmpOperationInText?cmpOperation>]\n ].\n \n cmpOperationInText::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne] |  [<?cmpOperator> != | == ]] <numExpr?>.\n \n \n numExpr::=  bool ( <boolExpr?> ) \n             | <multExpr?> [{ + <multExpr?addOperation> | - <multExpr?subOperation>}].\n \n \n multExpr::= <value?> [{ * <value?multOperation> | / <value?divOperation> }].\n \n value::= 0x<#x?intValue> | <#?intValue>[?\\.] | <#f?doubleValue> |    ##unary - associated to value.\n [{[<?unaryOperator> ! | ~ | - | + ]}]        ##additional unary operators.\n [ 0x<#x?intValue> | <#?intValue>  ##ones of kind of value:\n | '<!.?charValue>' | <\"\"?textValue> \n | ( <numExpr?parenthesisExpr> ) \n | [& [?(] ] <dataAccess>   ## & is optional, don't confuse with &(variable) \n ].\n \n \n textExpr::=<$NoWhiteSpaces>\n { [?\\<\\.\\>]                             ##abort on <.> \n [ \\<&-<*\\>?>\\>                          ##<&- it is comment> \n | \\<:-<*\\>?>\\><textExpr?>\\<\\.-<*\\>?>\\> ##<:-comment> comment <.- > \n | \\#\\#<*\\r\\n?>   ##comment to eol in a text Expression\n | \\<:for:<forInText?forCtrl>\n | \\<:if: <ifInText?ifCtrl>\n | \\<:hasNext\\> <textExpr?hasNext> \\<\\.hasNext\\>\n | \\<:subtext : <callSubtext?call>\n | \\<:scriptdir<?scriptdir>\\>\n | \\<:debug[:<textDatapath?debug>| <?debug>]\\>\n | \\<&<dataText>\n | \\<: [<?transliteration>n|r|t|[\\<|#|\\\"]<*\\>?>] \\>\n | \\<:lf\\><?newline>\n | \\<:\\ \\><!\\\\s*?> [ \\#\\#<*\\r\\n?> <!\\\\s*?> ]\n | \\<:@<setColumn>\\>  \n | \\<:\\><textExpr?>\\<\\.\\>\n | <*|\\<:|\\<=|\\<&|\\#\\#|\\<\\.?plainText>\n ]\n }.\n \n \n dataText::=<dataAccess>[ \\: [<\"\"?formatText>|<*\\>?formatText>]] \\>.     ##<*expr: format>\n \n textOut::= [<dataPath?assign>] [:n<?newline>] \\> <textExpr>[ \\<\\.+\\> \n   | \\<\\.n+\\><?newline> | \\<\\.+n\\><?newline> \n   | \\<\\.+n+flush\\><?newline><?flush> | \\<\\.+flush\\><?flush>\n   | \\<\\.+n+close\\><?close> | \\<\\.+close\\><?close>].\n \n setColumn::=<numExpr> [ : <numExpr?minSpaces>] | : <numExpr?minSpaces>.\n \n \n \n forCtrl::= ( <$?forVariable> : <dataAccess?forContainer> [ && <condition> ])  \\{ <statementBlock> \\} .\n \n forInText::= <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] \\> <textExpr> \\<\\.for[ : <$?@checkForVariable> ]\\>. \n ##name is the name of the container element data reference\n \n ifCtrl::= <ifBlock> [{ elsif <ifBlock>  }][ else \\{ [<statementBlock?elseBlock>] \\} ].\n \n ifBlock::= ( <condition> ) \\{ <statementBlock> \\} .\n \n ifInText::= <ifBlockInText?ifBlock> [{ \\<:elsif : <ifBlockInText?ifBlock>  }][ \\<:else\\> <textExpr?elseBlock> ] \\<\\.if\\>.\n \n ifBlockInText::= <conditionInText?condition> \\> <textExpr>.\n \n whileCtrl::= ( <condition> ) \\{ [<statementBlock>] \\} .\n \n dowhileCtrl::=  \\{ [<statementBlock>] \\} while ( <condition> ) ; .\n \n \n onerror::= [ <#?errorLevel> \n            | [<?errortype> notfound | cmd | file | internal | exit ]\n            |]\n            \\{ [<statementBlock>] \\}.\n \n \n callSubroutine::= [{ <dataPath?assign> [ = | += <?append>] }] call <textValue?callName> ( [{ <namedArgument?actualArgument> ? , }] ) ; .\n \n callSubtext::=<textValue?callName> [ : { <namedArgument?actualArgument> ? , }] \\>.\n \n namedArgument::= <$?name> = <objExpr?>.\n \n \n zmake::= [ : <$-?name> :[?=] ] <textValue?zmakeOutput> := <textValue?callName> ( { <namedArgument?actualArgument> | <filesetAccess> ? ,} ).\n \n \n \n ## An accessPath is a Filepath, see prepFilepath::=, but analyzed on Java level. \n filesetAccess::= [ \n                    <\"\"?accessPath> | \\<:\\><textExpr>\\<\\.\\> \n                  | [<?accessPathOrFilesetVariable> [&]<*\\ \\r\\n,)&;?>] \n                  ] [ & <$?zmakeFilesetVariable>] . \n \n \n cmdLineWait::=[{ <dataPath?assign> += }] cmd\\  <cmdLine?>.\n \n cmdLine::= [\\!argsCheck!<?argsCheck>] <textValue?> [{[?;[\\ |\\n|\\r]] [ \\<\\:arg\\><textExpr?actualArgument>\\<\\.arg\\> | \\<\\:args:<dataAccess?argList>\\> |<textValue?actualArgument>] }] \n   [ \\<:stdout:[ pipe<?pipe>| [$]<$?stdoutVariable>] \\>] ;.\n \n iferrorlevel::= <#?errorLevel> \\{ [<statementBlock>] \\}.\n \n \n \n assignExpr::= [{ <dataPath?assign> [ = | += <?append>] }] <objExpr?> ;.\n \n \n threadBlock::= Thread <dataPath?defThreadVar> = [thread] \\{ <statementBlock> \\} \n              | thread \\{ <statementBlock> \\}.\n \n");
        }
        catch (ParseException parseException) {
            throw new ScriptException("JZcmd.ctor - internal syntax error; " + parseException.getMessage());
        }
    }

    public static CharSequence execute(File file, JZcmdExecuter.ExecuteLevel executeLevel) throws IllegalAccessException {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        MainCmdLogging_ifc mainCmdLogging_ifc = executeLevel.log();
        JZcmdExecuter jZcmdExecuter = new JZcmdExecuter(mainCmdLogging_ifc);
        try {
            JZcmdScript jZcmdScript = JZcmd.translateAndSetGenCtrl(file, null, mainCmdLogging_ifc);
            jZcmdExecuter.initialize(jZcmdScript, true, executeLevel.localVariables, executeLevel.currdir());
            jZcmdExecuter.execute(jZcmdScript, true, bl, stringBuilder, null);
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            System.err.println(string);
        }
        return stringBuilder.toString();
    }

    public static CharSequence execSub(File file, String string, Map<String, DataAccess.Variable<Object>> map, JZcmdExecuter.ExecuteLevel executeLevel) {
        MainCmdLogging_ifc mainCmdLogging_ifc = executeLevel.log();
        try {
            JZcmdScript jZcmdScript = JZcmd.translateAndSetGenCtrl(file, null, mainCmdLogging_ifc);
            JZcmdScript.Subroutine subroutine = jZcmdScript.getSubroutine(string);
            executeLevel.execSubroutine(subroutine, map, null, -1);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            System.err.println(string2);
        }
        return "";
    }

    @Override
    public Object evalSub(File file, String string, Map<String, DataAccess.Variable<Object>> map, JZcmdExecuter.ExecuteLevel executeLevel) throws ScriptException {
        JZcmdScript jZcmdScript = this.compile(file, null);
        JZcmdScript.Subroutine subroutine = jZcmdScript.getSubroutine(string);
        return executeLevel.evalSubroutine(subroutine, map, null, -1);
    }

    public static void execute(String string) throws ScriptException {
        StringPartScan stringPartScan = new StringPartScan(string);
        MainCmdLoggingStream mainCmdLoggingStream = new MainCmdLoggingStream(System.out);
        JZcmdExecuter jZcmdExecuter = new JZcmdExecuter(mainCmdLoggingStream);
        JZcmd.execute(jZcmdExecuter, null, stringPartScan, null, null, true, null, mainCmdLoggingStream);
    }

    public static void execute(File file, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        JZcmd.execute(null, file, null, null, true, null, mainCmdLogging_ifc);
    }

    public static void execute(JZcmdExecuter jZcmdExecuter, File file, Appendable appendable, String string, boolean bl, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        int n = (int)file.length();
        StringPartFromFileLines stringPartFromFileLines = null;
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            throw new ScriptException("JZcmd - Error script file not found; " + file.getAbsolutePath() + "; " + string2);
        }
        if (stringPartFromFileLines != null) {
            JZcmd.execute(jZcmdExecuter, file, stringPartFromFileLines, appendable, string, bl, file2, mainCmdLogging_ifc);
        }
    }

    public static void execute(JZcmdExecuter jZcmdExecuter, File file, StringPartScan stringPartScan, Appendable appendable, String string, boolean bl, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        JZcmdScript jZcmdScript = null;
        jZcmdScript = JZcmd.translateAndSetGenCtrl(stringPartScan, mainCmdLogging_ifc, file2, file);
        JZcmdExecuter jZcmdExecuter2 = jZcmdExecuter == null ? new JZcmdExecuter(mainCmdLogging_ifc) : jZcmdExecuter;
        jZcmdExecuter2.execute(jZcmdScript, bl, true, appendable, string);
    }

    public static JZcmdScript translateAndSetGenCtrl(File file, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        return JZcmd.translateAndSetGenCtrl(file, null, mainCmdLogging_ifc);
    }

    public static JZcmdScript translateAndSetGenCtrl(File file, File file2, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        StringPartFromFileLines stringPartFromFileLines;
        int n = (int)file.length();
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScriptException("JZcmd.translate - file not found; ", file.getAbsolutePath(), -1);
        }
        catch (IOException iOException) {
            throw new ScriptException("JZcmd.translate - any file error; ", file.getAbsolutePath(), -1);
        }
        return JZcmd.translateAndSetGenCtrl(stringPartFromFileLines, mainCmdLogging_ifc, file2, file);
    }

    public JZcmdScript compile(File file, File file2) throws ScriptException {
        StringPartFromFileLines stringPartFromFileLines;
        int n = (int)file.length();
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new ScriptException("JZcmd.translate - illegal CharSet in file; ", file.getAbsolutePath(), -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScriptException("JZcmd.translate - file not found; ", file.getAbsolutePath(), -1);
        }
        catch (IOException iOException) {
            throw new ScriptException("JZcmd.translate - any file error; ", file.getAbsolutePath(), -1);
        }
        return this.compile(stringPartFromFileLines, file2, file);
    }

    public static JZcmdScript translateAndSetGenCtrl(String string, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        return JZcmd.translateAndSetGenCtrl(new StringPartScan(string), mainCmdLogging_ifc, null, null);
    }

    public static JZcmdScript translateAndSetGenCtrl(StringPartScan stringPartScan, MainCmdLogging_ifc mainCmdLogging_ifc) throws ScriptException {
        return JZcmd.translateAndSetGenCtrl(stringPartScan, mainCmdLogging_ifc, null, null);
    }

    private static JZcmdScript translateAndSetGenCtrl(StringPartScan stringPartScan, MainCmdLogging_ifc mainCmdLogging_ifc, File file, File file2) throws ScriptException {
        JZcmd jZcmd = new JZcmd(mainCmdLogging_ifc);
        JZcmdScript jZcmdScript = new JZcmdScript(mainCmdLogging_ifc, file2, jZcmd);
        File file3 = FileSystem.getDir(file2);
        JZcmdScript.ZbnfJZcmdScript zbnfJZcmdScript = new JZcmdScript.ZbnfJZcmdScript(jZcmdScript);
        jZcmd.translateAndSetGenCtrl(stringPartScan, zbnfJZcmdScript, file3, file);
        return jZcmdScript;
    }

    private JZcmdScript compile(StringPartScan stringPartScan, File file, File file2) throws ScriptException {
        JZcmdScript jZcmdScript = new JZcmdScript(this.log, file2, this);
        File file3 = FileSystem.getDir(file2);
        JZcmdScript.ZbnfJZcmdScript zbnfJZcmdScript = new JZcmdScript.ZbnfJZcmdScript(jZcmdScript);
        this.translateAndSetGenCtrl(stringPartScan, zbnfJZcmdScript, file3, file);
        return jZcmdScript;
    }

    private void translateAndSetGenCtrl(StringPartScan stringPartScan, JZcmdScript.ZbnfJZcmdScript zbnfJZcmdScript, File file, File file2) throws ScriptException {
        Object object;
        Object object2;
        boolean bl = this.parserGenCtrl.parse(stringPartScan);
        if (!bl) {
            String string = this.parserGenCtrl.getSyntaxErrorReport();
            throw new ScriptException("\n" + string, stringPartScan.getInputfile(), -1, -1);
        }
        if (file2 != null) {
            object2 = this.parserGenCtrl.getResultTree();
            object = new SimpleXmlOutputter();
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file2));
                ((SimpleXmlOutputter)object).write(outputStreamWriter, (XmlNode)object2);
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                throw new ScriptException(iOException);
            }
        }
        object2 = new ZbnfJavaOutput(this.log);
        zbnfJZcmdScript.scriptfile = new JZcmdScript.Scriptfile();
        try {
            ((ZbnfJavaOutput)object2).setContent(JZcmdScript.ZbnfJZcmdScript.class, zbnfJZcmdScript, this.parserGenCtrl.getFirstParseResult());
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        if (zbnfJZcmdScript.isXmlSrcNecessary()) {
            zbnfJZcmdScript.setXmlSrc(this.parserGenCtrl.getResultTree());
        }
        object = zbnfJZcmdScript.scriptfile.getMainRoutine();
        if (zbnfJZcmdScript.scriptfile.includes != null) {
            for (JZcmdScript.JZcmdInclude jZcmdInclude : zbnfJZcmdScript.scriptfile.includes) {
                StringPartFromFileLines stringPartFromFileLines;
                String string;
                Object object3;
                if (jZcmdInclude.envVar != null) {
                    object3 = System.getenv(jZcmdInclude.envVar);
                    if (object3 == null) {
                        throw jZcmdInclude.scriptException("JZcmd.include - cannot find environment variable;" + jZcmdInclude.envVar);
                    }
                    string = (String)object3 + '/' + jZcmdInclude.path;
                } else {
                    string = jZcmdInclude.path;
                }
                object3 = FileSystem.isAbsolutePath(string) ? new File(string) : new File(file, string);
                if (!((File)object3).exists()) {
                    System.err.printf("TextGenScript - translateAndSetGenCtrl, included file not found; %s\n", ((File)object3).getAbsolutePath());
                    throw new ScriptException("JZcmd.compile - included file not found: ", ((File)object3).getAbsolutePath(), -1, -1);
                }
                File file3 = FileSystem.getDir((File)object3);
                int n = (int)((File)object3).length();
                try {
                    stringPartFromFileLines = new StringPartFromFileLines((File)object3, n, "encoding", null);
                }
                catch (Exception exception) {
                    throw new ScriptException(exception);
                }
                this.translateAndSetGenCtrl(stringPartFromFileLines, zbnfJZcmdScript, file3, file2);
            }
        }
        if (object != null) {
            zbnfJZcmdScript.setMainRoutine((JZcmdScript.Subroutine)object);
        }
    }

    @Override
    public CompiledScript compile(String string) throws ScriptException {
        StringPartScan stringPartScan = new StringPartScan(string);
        JZcmdScript jZcmdScript = new JZcmdScript(this.log, null, this);
        JZcmdScript.ZbnfJZcmdScript zbnfJZcmdScript = new JZcmdScript.ZbnfJZcmdScript(jZcmdScript);
        try {
            this.translateAndSetGenCtrl(stringPartScan, zbnfJZcmdScript, null, null);
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        return jZcmdScript;
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        char[] cArray;
        int n;
        int n2 = 8192;
        try {
            while ((n = reader.read(cArray = new char[n2 = 2 * n2])) == n2 && n2 < 5000000) {
            }
            if (n == n2) {
                throw new ScriptException("script to long; " + n);
            }
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        String string = new String(cArray, 0, n);
        return this.compile(string);
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public Object eval(String string) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(String string, Bindings bindings) throws ScriptException {
        return null;
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return null;
    }

    @Override
    public Object get(String string) {
        return null;
    }

    @Override
    public Bindings getBindings(int n) {
        return null;
    }

    @Override
    public ScriptContext getContext() {
        JZcmdExecuter jZcmdExecuter = new JZcmdExecuter();
        return jZcmdExecuter.scriptLevel();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return null;
    }

    @Override
    public void put(String string, Object object) {
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
    }

    private static class CmdLine
    extends MainCmd {
        public final Args argData;
        protected final MainCmd.Argument[] argList = new MainCmd.Argument[]{new MainCmd.Argument("", "INPUT    pathTo JZcmd-File to execute", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                if (CmdLine.this.argData.sFileScript == null) {
                    CmdLine.this.argData.sFileScript = string;
                } else {
                    CmdLine.this.argData.userArgs.add(string);
                }
                return true;
            }
        }), new MainCmd.Argument("-t", ":OUTEXT pathTo text-File for output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdLine.this.argData.sFileTextOut = string;
                return true;
            }
        }), new MainCmd.Argument("-debug", ":INPUT.xml pathTo XML output of parsed script", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdLine.this.argData.fileTestXml = new File(string);
                try {
                    FileSystem.mkDirPath(CmdLine.this.argData.fileTestXml);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("JZcmd.main - faulty path for -debug;" + string);
                    return false;
                }
                return true;
            }
        }), new MainCmd.Argument("-u", ":userArgs", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdLine.this.argData.userArgs.add(string);
                return true;
            }
        })};

        protected CmdLine(Args args, String[] stringArray) {
            super(stringArray);
            this.argData = args;
            super.addAboutInfo("Compilation and Execution of JZcmd-Files");
            super.addAboutInfo("made by HSchorrig, Version 1.0, 2013-07-11..2014-06-09");
            super.addHelpInfo("args JZcmd_SCRIPTFILE [-t:OUTEXT] [-debug:SCRIPTFILE.xml]");
            super.addArgument(this.argList);
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
            super.addHelpInfo("==Syntax of a JZcmd script==");
            super.addHelpInfo(" $comment=(?...?).\n $endlineComment=\\#\\#.  ##The ## is the start chars for an endline-comment or commented line in the generator script.\n $keywords= new | cmd | cmd_check | start \n   | debug | java \n   | stdout | stdin | stderr \n   | subtext | sub | main | call | cd | CD | REM | Rem | rem \n   | Pipe | StringBuffer | Stringjar | String | List | Openfile | Fileset | Obj | Set | set | include | zbatch \n   | break | XXXreturn | exit | onerror | instanceof | for | while | do | if | elsif | else | throw . \n \n JZcmd::= \n [<*|==ZGen==?>==ZGen== ]\n [<*|==JZcmd==?>==JZcmd== ]\n [{ ! checkJZcmd = <textValue?checkJZcmdFile> ; \n  | ! checkXml = <textValue?checkXmlFile> ; \n }]\n [{ [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n  | include <include> ; \n  | currdir = <textDatapath?cd> ;\n }] \n { [//] ==endJZcmd==<*\\e?> \n | [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*\\n\\r?> ##line comment in C style\n | /*<*|*/?>*/ ##block commment in C style\n | <DefVariable?> ; \n | <statement?>\n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n | main ( ) \\{ <statementBlock?mainRoutine> \\} \n } \\e.\n \n \n include::= [$<$?envVar>[/|\\\\]][ <\"\"?path> | <*;\\ ?path>].\n \n \n subClass::= <$?name> \\{ \n { subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n } \\}. \n \n \n subroutine::= <$?name> ( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , }|] ) \\{ [<statementBlock>] \\}. \n \n subtext::= <$?name> ( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , }|] ) \\<:\\><textExpr>\\<\\.\\>.\n \n \n statementBlock::= { <statement?> }.\n \n statement::=\n   \\{ [<statementBlock>] \\} \n | REM <*\\n\\r?> ##Remark like in batch files\n | ::{:}                ##Skip over :::\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*|\\n|\\r|\\<+?>     ##line commment in C style but only till <+\n | /*<*|*/?>*/          ##block commment in C style\n | currdir = <textDatapath?cd> ;   ##set current directory\n | [cd|CD] [<textValue?cd> | <*\\ ;?cd> ; ]  ##change current directory \n | <DefVariable?> ; \n | for <forCtrl> \n | if <ifCtrl> \n | while <whileCtrl> \n | do <dowhileCtrl> \n | start <cmdLine?cmdStart> \n | zmake <zmake> \n | move <srcdst?move> ; \n | copy <srcdst?copy> ; \n | [rm|del] <oneArg?del> ; \n | break <?breakBlock> ; \n | return <?return> ; \n | exit <#?exitScript> ;\n | throw on errorlevel <#?throwonerror> \n | throw <textDatapath?throw> \n | onerror <onerror> \n | errortoOutput off <?errorToOutput=0> \n | errortoOutput <?errorToOutput=1> \n | if errorlevel <iferrorlevel> \n | debug [<textValue?debug>| <?debug>] ; \n | <callSubroutine?call> \n | <threadBlock> \n | \\<+<textOut> \n | \\<:\\><textExpr>\\<\\.\\> [;] \n | <cmdLineWait?cmdWait> \n | <assignExpr> \n | ; \n .\n \n \n srcdst::= [src=] <textValue?actualArgument> [dst=] <textValue?actualArgument> .\n oneArg::= <textValue?actualArgument> .\n \n \n DefVariable::=\n   String\\  <DefStringVar?textVariable> \n | Stringjar\\  <DefSpecVar?Stringjar> \n | Num\\  <DefNumVar> \n | Bool\\  <DefBoolVar> \n | Pipe\\  <DefSpecVar?Pipe> \n | List\\  <DefSpecVar?List> \n | Map\\  <DefMapVar> \n | Obj\\  <DefObjVar> \n | Class\\  <DefClassVar> \n | Classpath\\  <DefClasspath> \n | Openfile\\  <Openfile> \n | Fileset\\  <DefFileset> \n | Filepath\\ <DefFilepath> \n | Set\\  <DefStringVar?setEnvVar> \n | set\\  <DefStringVar?setEnvVar> \n | SET\\  <DefStringVar?setEnvVar> \n .\n \n DefNumVar::= [const <?const>] <definePath?defVariable>  [ = <numExpr>].\n \n DefBoolVar::= [const <?const>] <definePath?defVariable>  [ = <boolExpr>].\n \n DefSpecVar::= [const <?const>] <definePath?defVariable>  [ = <objExpr?>].\n \n DefObjVar::= [const <?const>] <definePath?defVariable> [ : <$\\.?type>]  [ = <objExpr?>].\n \n DefClassVar::= [const] <definePath?defVariable>  = \n   [: <dataAccess?loader> : ]  ## a datapath to a ClassLoader instance, a Classpath variable. \n   <textValue?>.               ## The package path maybe contained in any expression\n \n DefClasspath::= [const] <definePath?defVariable>  = [ : <$?parentClasspath> : ] { <filesetAccess> ? , }.\n \n DefStringVar::= [const <?const>] <definePath?defVariable> [ = <textDatapath?>].\n \n DefMapVar::= [const <?const>] <definePath?defVariable> [ = \\{ <dataStruct> \\}  ].\n \n Openfile::= [const <?const>] <definePath?defVariable> = <textDatapath?> .\n \n \n definePath::= <$-?startVariable>[ [?\\. \\>] \\.{ <defineSubelement?datapathElement> ? [?\\. \\>] \\.}].\n \n defineSubelement::= <$-?ident> [( [{ <objExpr?argument> ? ,}])<?whatisit=(>].\n \n \n DefFileset::= <definePath?defVariable> [ =  ( \n [ commonpath = [<\"\"?commonPath>|<*;,)(\\ \\r\\n?commonPath>] , ] \n { [{ //JZcmd | //<*\\n\\r?>}] [<\"\"?filePath>|<*;,)(\\ \\r\\n?filePath>] [{ //JZcmd | //<*\\n\\r?>}] ? , } \n ) ] .\n \n DefFilepath::= <definePath?defVariable> [ = <textValue?> ]. \n \n \n XXXFilepath::=<\"\"?!prepFilePath>|<*;\\ \\r\\n,)?!prepFilePath>. \n \n prepFilePath::=<$NoWhiteSpaces><! *?>\n [ &$<$?@envVariable> [\\\\|/|]      ##path can start with a environment variable's content\n | &<$?@scriptVariable> [\\\\|/|]    ##path can start with a scriptvariable's content\n | [<!.?@drive>:]                  ## only 1 char with followed : is the drive letter\n   [ [/|\\\\]<?@absPath>]            ## starting with / maybe after d: is absolute path\n |]\n [ <*:?@pathbase>[?:=]:]           ## all until : is pathbase, but not till a :=\n [ <toLastChar:/\\\\?@path>[\\\\|/|]] ## all until last \\ or / is path\n [ <toLastChar:.?@name>              ## all until exclusive dot is the name\n   <*\\e?@ext>                       ## from dot to end is the extension\n | <*\\e?@name>                      ## No dot is found, all is the name.\n ] . \n \n \n \n \n \n textDatapath::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | [& [?(] ] <dataAccess> .\n \n textValue::=  <\"\"?text> | \\<:\\><textExpr>\\<\\.\\> | & <dataAccess> | <*;,)(\\ \\r\\n\\>?text> .\n \n \n objExpr::= \n   File : <textValue?File>         ## A textValue which builds a java.lang.File in the currdir \n | Filepath : <textValue?Filepath> ## A textValue which builds a Filepath in the currdir \n | Fileset: <filesetAccess>  \n | \\{ <dataStruct> \\}              ## It is a Map of Variables. \n | <\"\"?text>                       ## It is a constant text. \n | \\<:\\><textExpr>\\<\\.\\>           ## It is a text assembled in runtime. \n | <numExpr>.                      ## special detection of a simple dataAccess.\n \n dataStruct::= { <DefVariable?> ; }.\n \n \n \n \n dataAccess::= \n [ $<$?envVariable> \n | [<?startVariable> $<#?>| $<$?>]    ## $1 .. $999 are the arguments of JZcmd, $name for environment \n | [java\\ ] new\\  <staticJavaAccess?newJavaClass> \n | [%|java\\ ] <staticJavaAccess?staticJavaMethod> \n | <dataPath?> \n ].\n \n \n ## Access to a Java class constructor or static method or field\n staticJavaAccess::=\n   [ & <dataAccess?Class_Var> : [<$\\.$?javapath>]       ## access via Class variable .element\n   | [: <dataAccess?Classpath_Var> : ] <$\\.$?javapath>  ## [Classpath] package.path.Class.element\n   ] [( [ { <objExpr?argument> ? , } ])].               ## arguments\n \n dataPath::= <startDatapath>[ [?\\. \\>] \\.{ <datapathElement> ? [?\\. \\>] \\.}].\n \n ## A datapath cannot start with an JZcmd keyword! \n startDatapath::= [ & ( <dataPath> ) | <$-?ident> ] <?whatisit=@> [( [{ <objExpr?argument> ? ,}])<?whatisit=+>].\n ## Use regex for the second datapath element, it can be a JZcmd keyword too! \n datapathElement::= [ & ( <dataPath> ) |[<?ident>[@]<![\\\\w-]+?>]] [( [{ <objExpr?argument> ? ,}])<?whatisit=(>].\n \n \n \n \n condition::=<andExpr?> [{\\|\\| <?boolCheckOrOperation> <andExpr?boolOrOperation>}].\n \n andExpr::= <boolExpr?> [{ && <?boolCheckAndOperation> <boolExpr?boolAndOperation>}].\n \n boolExpr::= [<?boolNot> ! | not| NOT|]\n [ ( <condition?parenthesisCondition> ) \n | <numExpr?> [<cmpOperation>]\n ].\n \n cmpOperation::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == | \\>= | \\> | \\<= | \\< ]] <numExpr?>.\n \n instanceof::=<objExpr> instanceof <staticJavaAccess>.\n \n conditionInText::=<andExprInText?> [{\\|\\| <?boolCheckOrOperation> <andExprInText?boolOrOperation>}].\n \n andExprInText::= <boolExprInText?> [{ && <?boolCheckAndOperation> <boolExprInText?boolAndOperation>}].\n \n boolExprInText::= [<?boolNot> ! | not|]\n [ ( <conditionInText?parenthesisCondition> ) \n | <numExpr?> [<cmpOperationInText?cmpOperation>]\n ].\n \n cmpOperationInText::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne] |  [<?cmpOperator> != | == ]] <numExpr?>.\n \n \n numExpr::=  bool ( <boolExpr?> ) \n             | <multExpr?> [{ + <multExpr?addOperation> | - <multExpr?subOperation>}].\n \n \n multExpr::= <value?> [{ * <value?multOperation> | / <value?divOperation> }].\n \n value::= 0x<#x?intValue> | <#?intValue>[?\\.] | <#f?doubleValue> |    ##unary - associated to value.\n [{[<?unaryOperator> ! | ~ | - | + ]}]        ##additional unary operators.\n [ 0x<#x?intValue> | <#?intValue>  ##ones of kind of value:\n | '<!.?charValue>' | <\"\"?textValue> \n | ( <numExpr?parenthesisExpr> ) \n | [& [?(] ] <dataAccess>   ## & is optional, don't confuse with &(variable) \n ].\n \n \n textExpr::=<$NoWhiteSpaces>\n { [?\\<\\.\\>]                             ##abort on <.> \n [ \\<&-<*\\>?>\\>                          ##<&- it is comment> \n | \\<:-<*\\>?>\\><textExpr?>\\<\\.-<*\\>?>\\> ##<:-comment> comment <.- > \n | \\#\\#<*\\r\\n?>   ##comment to eol in a text Expression\n | \\<:for:<forInText?forCtrl>\n | \\<:if: <ifInText?ifCtrl>\n | \\<:hasNext\\> <textExpr?hasNext> \\<\\.hasNext\\>\n | \\<:subtext : <callSubtext?call>\n | \\<:scriptdir<?scriptdir>\\>\n | \\<:debug[:<textDatapath?debug>| <?debug>]\\>\n | \\<&<dataText>\n | \\<: [<?transliteration>n|r|t|[\\<|#|\\\"]<*\\>?>] \\>\n | \\<:lf\\><?newline>\n | \\<:\\ \\><!\\\\s*?> [ \\#\\#<*\\r\\n?> <!\\\\s*?> ]\n | \\<:@<setColumn>\\>  \n | \\<:\\><textExpr?>\\<\\.\\>\n | <*|\\<:|\\<=|\\<&|\\#\\#|\\<\\.?plainText>\n ]\n }.\n \n \n dataText::=<dataAccess>[ \\: [<\"\"?formatText>|<*\\>?formatText>]] \\>.     ##<*expr: format>\n \n textOut::= [<dataPath?assign>] [:n<?newline>] \\> <textExpr>[ \\<\\.+\\> \n   | \\<\\.n+\\><?newline> | \\<\\.+n\\><?newline> \n   | \\<\\.+n+flush\\><?newline><?flush> | \\<\\.+flush\\><?flush>\n   | \\<\\.+n+close\\><?close> | \\<\\.+close\\><?close>].\n \n setColumn::=<numExpr> [ : <numExpr?minSpaces>] | : <numExpr?minSpaces>.\n \n \n \n forCtrl::= ( <$?forVariable> : <dataAccess?forContainer> [ && <condition> ])  \\{ <statementBlock> \\} .\n \n forInText::= <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] \\> <textExpr> \\<\\.for[ : <$?@checkForVariable> ]\\>. \n ##name is the name of the container element data reference\n \n ifCtrl::= <ifBlock> [{ elsif <ifBlock>  }][ else \\{ [<statementBlock?elseBlock>] \\} ].\n \n ifBlock::= ( <condition> ) \\{ <statementBlock> \\} .\n \n ifInText::= <ifBlockInText?ifBlock> [{ \\<:elsif : <ifBlockInText?ifBlock>  }][ \\<:else\\> <textExpr?elseBlock> ] \\<\\.if\\>.\n \n ifBlockInText::= <conditionInText?condition> \\> <textExpr>.\n \n whileCtrl::= ( <condition> ) \\{ [<statementBlock>] \\} .\n \n dowhileCtrl::=  \\{ [<statementBlock>] \\} while ( <condition> ) ; .\n \n \n onerror::= [ <#?errorLevel> \n            | [<?errortype> notfound | cmd | file | internal | exit ]\n            |]\n            \\{ [<statementBlock>] \\}.\n \n \n callSubroutine::= [{ <dataPath?assign> [ = | += <?append>] }] call <textValue?callName> ( [{ <namedArgument?actualArgument> ? , }] ) ; .\n \n callSubtext::=<textValue?callName> [ : { <namedArgument?actualArgument> ? , }] \\>.\n \n namedArgument::= <$?name> = <objExpr?>.\n \n \n zmake::= [ : <$-?name> :[?=] ] <textValue?zmakeOutput> := <textValue?callName> ( { <namedArgument?actualArgument> | <filesetAccess> ? ,} ).\n \n \n \n ## An accessPath is a Filepath, see prepFilepath::=, but analyzed on Java level. \n filesetAccess::= [ \n                    <\"\"?accessPath> | \\<:\\><textExpr>\\<\\.\\> \n                  | [<?accessPathOrFilesetVariable> [&]<*\\ \\r\\n,)&;?>] \n                  ] [ & <$?zmakeFilesetVariable>] . \n \n \n cmdLineWait::=[{ <dataPath?assign> += }] cmd\\  <cmdLine?>.\n \n cmdLine::= [\\!argsCheck!<?argsCheck>] <textValue?> [{[?;[\\ |\\n|\\r]] [ \\<\\:arg\\><textExpr?actualArgument>\\<\\.arg\\> | \\<\\:args:<dataAccess?argList>\\> |<textValue?actualArgument>] }] \n   [ \\<:stdout:[ pipe<?pipe>| [$]<$?stdoutVariable>] \\>] ;.\n \n iferrorlevel::= <#?errorLevel> \\{ [<statementBlock>] \\}.\n \n \n \n assignExpr::= [{ <dataPath?assign> [ = | += <?append>] }] <objExpr?> ;.\n \n \n threadBlock::= Thread <dataPath?defThreadVar> = [thread] \\{ <statementBlock> \\} \n              | thread \\{ <statementBlock> \\}.\n \n");
        }

        @Override
        protected void callWithoutArguments() {
        }

        @Override
        protected boolean checkArguments() {
            return this.argData.sFileScript != null;
        }
    }

    private static class Args {
        String sFileScript;
        String sFileTextOut;
        File fileTestXml;
        List<String> userArgs = new ArrayList<String>();

        private Args() {
        }
    }
}

