/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zcmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartFromFile;
import org.vishia.xmlSimple.SimpleXmlOutputter;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.zbnf.ZbnfParser;

public class Csv2Data {
    public static final String sVersion = "2014-06-10";
    final MainCmdLogging_ifc log;
    Map<String, Map<String, String>> dataMap = new IndexMultiTable<String, Map<String, String>>(IndexMultiTable.providerString);
    List<Map<String, String>> lines = new LinkedList<Map<String, String>>();
    List<String> columns = new ArrayList<String>();
    int colident;

    public Csv2Data(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.log = mainCmdLogging_ifc;
    }

    public Csv2Data() {
        this.log = null;
    }

    public static void main(String[] stringArray) {
        String string = null;
        Args args = new Args();
        CmdHandler cmdHandler = new CmdHandler(args, stringArray);
        try {
            cmdHandler.parseArguments();
        }
        catch (Exception exception) {
            cmdHandler.report("Argument error:", exception);
            cmdHandler.setExitErrorLevel(5);
            cmdHandler.writeHelpInfo(null);
            string = "Csv2Data - cmd line error";
        }
        if (string == null) {
            Csv2Data csv2Data = new Csv2Data(cmdHandler);
            csv2Data.parseCsv(args.sInputCsv);
        }
        if (string != null) {
            cmdHandler.writeError(string);
        }
    }

    public String parseCsv(String string) {
        String string2 = null;
        File file = new File(string);
        BufferedReader bufferedReader = null;
        this.dataMap.clear();
        this.lines.clear();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            string2 = "Csv2Data - can't open file; " + file.getAbsolutePath();
            bufferedReader = null;
        }
        if (bufferedReader != null) {
            try {
                String string3 = bufferedReader.readLine();
                this.createColumns(string3);
                while (string2 == null && (string3 = bufferedReader.readLine()) != null) {
                    this.parseLine(string3, bufferedReader);
                }
            }
            catch (IOException iOException) {
                string2 = "Csv2Data - readline failed in; " + file.getAbsolutePath();
            }
        }
        return string2;
    }

    public void createColumns(String string) {
        this.columns.clear();
        String[] stringArray = string.split(";");
        int n = 0;
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            this.columns.add(string3);
            if (string3.equals("Identifier")) {
                this.colident = n;
            }
            ++n;
        }
    }

    public String XXXparseLine(String string) {
        boolean bl = false;
        String[] stringArray = string.split(";");
        String string2 = null;
        StringPart stringPart = new StringPart(string);
        boolean bl2 = false;
        do {
            stringPart.lentoAnyCharOutsideQuotion(";", Integer.MAX_VALUE);
            if (!stringPart.found()) {
                stringPart.len0end();
                boolean bl3 = bl2 = stringPart.length() == 0;
            }
            if (bl2) continue;
            String string3 = stringPart.getCurrentPart().toString();
            stringPart.fromEnd().seek(1);
        } while (stringPart.found());
        return string2;
    }

    public void parseLine(String string, BufferedReader bufferedReader) {
        boolean bl = false;
        IndexMultiTable indexMultiTable = new IndexMultiTable(IndexMultiTable.providerString);
        int n = 0;
        boolean bl2 = true;
        int n2 = 0;
        String string2 = null;
        while (bl2) {
            String string3;
            int n3 = string.indexOf(34, n);
            int n4 = string.indexOf(59, n);
            if (n4 < 0) {
                n4 = string.length();
                bl2 = false;
            }
            if (n3 >= 0 && n3 < n4) {
                int n5 = string.indexOf(34, n3 + 1);
                if (n5 < 0) {
                    string3 = string.substring(n3 + 1);
                    do {
                        try {
                            string = bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            string = null;
                        }
                        n = 0;
                        n5 = string.indexOf(34);
                        string3 = n5 >= 0 ? string3 + '\n' + string.substring(0, n5) : string3 + '\n' + string;
                    } while (n5 < 0);
                } else {
                    string3 = string.substring(n3 + 1, n5);
                }
                n4 = string.indexOf(59, n5);
                if (n4 < 0) {
                    bl2 = false;
                }
            } else {
                string3 = string.substring(n, n4).trim();
            }
            String string4 = n2 >= 0 && n2 < this.columns.size() ? this.columns.get(n2) : "column_" + n2;
            indexMultiTable.put(string4, string3);
            n = n4 + 1;
            if (n2 == this.colident) {
                string2 = string3;
            }
            ++n2;
        }
        if (string2 != null && !string2.isEmpty()) {
            n2 = 0;
            this.dataMap.put(string2, indexMultiTable);
            this.lines.add(indexMultiTable);
        }
    }

    public float floatVal(String string) {
        try {
            if (string.indexOf(44) < 0) {
                Assert.stop();
            }
            float f = StringFunctions.parseFloat(string, 0, Integer.MAX_VALUE, ',', null);
            return f;
        }
        catch (Exception exception) {
            return 777777.7f;
        }
    }

    public String parseCsvZbnf(String string) {
        String string2 = null;
        ZbnfParser zbnfParser = new ZbnfParser(this.log);
        String string3 = FileSystem.readFile(new File("zbnf/csvSyntax.zbnf"));
        try {
            zbnfParser.setSyntax(string3);
        }
        catch (ParseException parseException) {
            string2 = "Csv2Data - zbnf syntax fails";
            this.log.writeError(string2, parseException);
        }
        if (string2 == null) {
            Object object;
            boolean bl;
            File file = new File(string);
            StringPartFromFile stringPartFromFile = null;
            try {
                stringPartFromFile = new StringPartFromFile(file);
            }
            catch (IOException iOException) {
                string2 = "Csv2Data - input file read fails";
                this.log.writeError(string2, iOException);
            }
            if (string2 == null && !(bl = zbnfParser.parse(stringPartFromFile))) {
                string2 = "Csv2Data - input file syntax";
                object = zbnfParser.getSyntaxErrorReport();
                this.log.writeError((String)object);
            }
            if (string2 == null) {
                XmlNode xmlNode = zbnfParser.getResultTree();
                object = new SimpleXmlOutputter();
                try {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream("csvinput.xml"));
                    ((SimpleXmlOutputter)object).write(outputStreamWriter, xmlNode);
                }
                catch (IOException iOException) {
                    this.log.writeError("Csv2Data - xmlOut fails", iOException);
                }
            }
        }
        return string2;
    }

    static class CmdHandler
    extends MainCmd {
        protected final Args args;
        private final MainCmd.Argument[] arguments = new MainCmd.Argument[]{new MainCmd.Argument("-i", "=<CSV> Input csv file", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                CmdHandler.this.args.sInputCsv = string;
                return true;
            }
        })};

        CmdHandler(Args args, String[] stringArray) {
            super(stringArray);
            super.addArgument(this.arguments);
            this.args = args;
        }

        @Override
        protected boolean checkArguments() {
            return this.args.sInputCsv != null;
        }
    }

    static class Args {
        String sInputCsv;

        Args() {
        }
    }
}

