/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.StringFormatter;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParserStore;
import org.vishia.zbnf.ZbnfSyntaxPrescript;

public class ZbnfParser {
    public static final String sVersion = "2014-06-17";
    private static final String sEmpty = "                                                                                                                                                                                                                                                                                                                          ";
    static final int mXmlSrcline_xmlWrmode = 1;
    static final int mXmlSrctext_xmlWrmode = 2;
    protected final MainCmdLogging_ifc report;
    protected int nReportLevel;
    protected int nLevelReportParsing;
    protected int nLevelReportComponentParsing;
    protected int nLevelReportInfo;
    protected int nLevelReportError;
    protected int nLevelReportBranchParsing = 5;
    protected int idReportParsing = 6;
    protected int idReportComponentParsing = 5;
    protected int idReportBranchParsing = 5;
    protected int idReportInfo = 3;
    protected int idReportError = 1;
    protected final TreeMap<String, ZbnfSyntaxPrescript> listSubPrescript;
    TreeMap<String, String> listKeywords = new TreeMap();
    TreeMap<String, String> xmlnsList = null;
    protected boolean bConstantSyntaxAsParseResult = false;
    private ZbnfSyntaxPrescript mainScript;
    protected PrescriptParser prescriptParserTopLevel;
    protected CharSequence sRightestError = "--noError--";
    protected String sExpectedSyntax = "--noError--";
    protected String xxxsFoundedSyntax = "--noError--";
    private int maxParseResultEntriesOnError = 0;
    private final LogParsing log;
    ArrayList<ZbnfParseResultItem> listParseResultOnError = null;
    protected long posRightestError = 0L;
    protected int lineError;
    protected int columnError;
    protected String sFileError;
    String sCommentStringStart = "/*";
    String sCommentStringEnd = "*/";
    boolean bStoreComment = false;
    String sEndlineCommentStringStart = "//";
    protected String sInputEncodingKeyword;
    protected String sInputEncoding;
    boolean bStoreEndlineComment = false;
    String sWhiteSpaces = " \t\r\f\n";
    boolean bStoreNewline = false;
    boolean bStoreOneSpaceOnWhitespaces = false;
    boolean bStoreWhiteSpaces = false;
    private Charset charsetInput;
    protected Map<String, String> idxMissingPrescripts;
    private ZbnfParserStore parserStoreTopLevel;
    private final ZbnfParserStore.BuilderTreeNodeXml builderTreeNodeXml = new ZbnfParserStore.BuilderTreeNodeXml();
    private final int[] column = new int[1];
    final TreeMap<String, ParseResultlet> alreadyParsedCmpn = new TreeMap();

    public ZbnfParser(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this(mainCmdLogging_ifc, 10);
    }

    public ZbnfParser(MainCmdLogging_ifc mainCmdLogging_ifc, int n) {
        this.report = mainCmdLogging_ifc;
        this.listSubPrescript = new TreeMap();
        this.log = new LogParsing(mainCmdLogging_ifc);
        this.maxParseResultEntriesOnError = n;
        this.listParseResultOnError = n > 0 ? new ArrayList(n) : null;
    }

    public void setSyntax(String string) throws ParseException {
        this.setSyntax(new StringPartScan(string));
    }

    public void setSyntaxString(String string) throws ParseException {
        this.setSyntax(new StringPartScan(string));
    }

    public void setSyntaxFile(File file) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException, ParseException {
        this.setSyntax(file);
    }

    public void setSyntax(File file) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException, ParseException {
        StringPartFromFileLines stringPartFromFileLines = null;
        int n = (int)file.length();
        stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        String string = file.getParent();
        this.setSyntax(stringPartFromFileLines, string);
    }

    public void setSyntax(StringPartScan stringPartScan) throws ParseException {
        try {
            this.setSyntax(stringPartScan, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("import in ZBNF-script is not supported here.", 0);
        }
        catch (IOException iOException) {
            throw new ParseException("import in ZBNF-script is not supported here.", 0);
        }
    }

    public void setSyntax(StringPartScan stringPartScan, String string) throws ParseException, IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        LinkedList linkedList = null;
        boolean bl = false;
        if (stringPartScan.startsWith("<?SBNF") || stringPartScan.startsWith("<?ZBNF")) {
            stringPartScan.seek("?>", 1);
        }
        while (stringPartScan.seekNoWhitespace().length() > 0) {
            String string2;
            CharSequence charSequence = stringPartScan.getCurrent(30);
            stringPartScan.scanStart();
            if (StringFunctions.startsWith(charSequence, "$keywords")) {
                char c;
                stringPartScan.seek(9);
                if (stringPartScan.startsWith("::=")) {
                    stringPartScan.seek(3);
                } else if (stringPartScan.startsWith("=")) {
                    stringPartScan.seek(1);
                } else {
                    throw new ParseException("expected \"=\" behind \"$keywords\"", stringPartScan.getLineAndColumn(this.column));
                }
                do {
                    stringPartScan.seekNoWhitespace().lentoIdentifier();
                    if (stringPartScan.length() > 0) {
                        string2 = stringPartScan.getCurrentPart().toString();
                        this.listKeywords.put(string2, string2);
                    }
                    c = stringPartScan.fromEnd().seekNoWhitespace().getCurrentChar();
                    stringPartScan.seek(1);
                } while (c == '|');
                if (c == '.') continue;
                throw new ParseException("expected \".\" on end of \"$keywords\"", stringPartScan.getLineAndColumn(this.column));
            }
            if (StringFunctions.startsWith(charSequence, "$Whitespaces=")) {
                stringPartScan.seek(12);
                String string3 = stringPartScan.getCircumScriptionToAnyChar(".").toString();
                if (string3.length() == 0 || string3.indexOf(10) >= 0) {
                    throw new ParseException("expected \".\" on end of \"$Whitespaces=\"", stringPartScan.getLineAndColumn(this.column));
                }
                stringPartScan.seek(1);
                this.setWhiteSpaces(this.sWhiteSpaces);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$setLinemode")) {
                stringPartScan.seek(12);
                if (stringPartScan.getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    this.setLinemode(true);
                    continue;
                }
                throw new ParseException("expected \".\" on end of \"$setLinemode\"", stringPartScan.getLineAndColumn(this.column));
            }
            if (StringFunctions.startsWith(charSequence, "$setXmlSrcline")) {
                stringPartScan.seek(16);
                if (stringPartScan.getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    this.setXmlSrcline(true);
                    continue;
                }
                throw new ParseException("expected \".\" on end of \"$setXmlSrcline\"", stringPartScan.getLineAndColumn(this.column));
            }
            if (StringFunctions.startsWith(charSequence, "$setXmlSrctext")) {
                stringPartScan.seek(16);
                if (stringPartScan.getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    this.setXmlSrctext(true);
                    continue;
                }
                throw new ParseException("expected \".\" on end of \"$setXmlSrctext\"", stringPartScan.getLineAndColumn(this.column));
            }
            if (StringFunctions.startsWith(charSequence, "$endlineComment=")) {
                stringPartScan.seek(16);
                stringPartScan.seekNoWhitespace();
                this.sEndlineCommentStringStart = stringPartScan.getCircumScriptionToAnyChar(".").toString().trim();
                if (this.sEndlineCommentStringStart.length() == 0) {
                    this.sEndlineCommentStringStart = null;
                } else if (this.sEndlineCommentStringStart.length() > 5) {
                    throw new ParseException("more as 5 chars as $endlineComment unexpected", stringPartScan.getLineAndColumn(this.column));
                }
                stringPartScan.seek(1);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$comment=")) {
                stringPartScan.seek(9);
                stringPartScan.seekNoWhitespace();
                this.sCommentStringStart = stringPartScan.getCircumScriptionToAnyChar(".").toString().trim();
                if (this.sCommentStringStart.length() == 0) {
                    this.sCommentStringStart = null;
                    continue;
                }
                if (this.sCommentStringStart.length() > 5) {
                    throw new ParseException("more as 5 chars as $endlineComment unexpected", stringPartScan.getLineAndColumn(this.column));
                }
                if (!stringPartScan.startsWith("...")) {
                    throw new ParseException("$comment, must have ... betwenn comment strings.", stringPartScan.getLineAndColumn(this.column));
                }
                stringPartScan.seek(3);
                stringPartScan.seekNoWhitespace();
                this.sCommentStringEnd = stringPartScan.getCircumScriptionToAnyChar(".").toString().trim();
                if (this.sCommentStringEnd.length() == 0) {
                    throw new ParseException("$comment: no endchars found.", stringPartScan.getLineAndColumn(this.column));
                }
                if (this.sCommentStringEnd.length() > 5) {
                    throw new ParseException("SyntaxPrescript: more as 5 chars as $endlineComment-end unexpected", stringPartScan.getLineAndColumn(this.column));
                }
                stringPartScan.seek(1);
                continue;
            }
            if (stringPartScan.scan("$inputEncodingKeyword=").scanOk()) {
                String[] stringArray = new String[1];
                if (stringPartScan.scanQuotion("\"", "\"", stringArray).scan(".").scanOk()) {
                    this.sInputEncodingKeyword = stringArray[0];
                    continue;
                }
                throw new ParseException("$inputEncodingKeyword=", 0);
            }
            if (stringPartScan.scan("$inputEncoding=").scanOk()) {
                String[] stringArray = new String[1];
                if (stringPartScan.scanQuotion("\"", "\"", stringArray).scan(".").scanOk()) {
                    this.sInputEncoding = stringArray[0];
                    this.charsetInput = Charset.forName(stringArray[0]);
                    continue;
                }
                throw new ParseException("$inputEncodingKeyword=", 0);
            }
            if (StringFunctions.startsWith(charSequence, "##")) {
                stringPartScan.seek('\n', 1);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$main=")) {
                stringPartScan.seek(6);
                this.mainScript = ZbnfSyntaxPrescript.createWithSyntax(stringPartScan, this.report);
                this.listSubPrescript.put(this.mainScript.getDefinitionIdent(), this.mainScript);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$xmlns:")) {
                stringPartScan.seek(7);
                String string4 = stringPartScan.lento("=").getCurrentPart().toString();
                string2 = stringPartScan.fromEnd().seek(1).lentoQuotionEnd('\"', Integer.MAX_VALUE).getCurrentPart().toString();
                if (string4.length() > 0 && string2.length() > 2) {
                    if (this.xmlnsList == null) {
                        this.xmlnsList = new TreeMap();
                    }
                } else {
                    throw new ParseException("SyntaxPrescript: $xmlns:ns:\"string\". :failed syntax.", stringPartScan.getLineAndColumn(this.column));
                }
                this.xmlnsList.put(string4, string2.substring(1, string2.length() - 1));
                if (stringPartScan.fromEnd().getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    continue;
                }
                throw new ParseException("SyntaxPrescript: $xmlns:ns:\"string\". :no dot on end.", stringPartScan.getLineAndColumn(this.column));
            }
            if (stringPartScan.scan("$import").scanOk()) {
                String[] stringArray = new String[1];
                if (stringPartScan.seekNoWhitespace().scan().scanQuotion("\"", "\"", stringArray).scan(".").scanOk()) {
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    this.importScript(stringArray[0], string);
                    continue;
                }
                throw new ParseException("$import \"importfile\".", 0);
            }
            ZbnfSyntaxPrescript zbnfSyntaxPrescript = ZbnfSyntaxPrescript.createWithSyntax(stringPartScan, this.report);
            if (!bl) {
                bl = true;
                this.mainScript = zbnfSyntaxPrescript;
            }
            if ((string2 = zbnfSyntaxPrescript.getDefinitionIdent()) == null) continue;
            this.listSubPrescript.put(string2, zbnfSyntaxPrescript);
        }
        if (linkedList != null) {
            for (String string5 : linkedList) {
                this.importScript(string5, string);
            }
        }
    }

    private void importScript(String string, String string2) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException, ParseException {
        String string3 = string2 + "/" + string;
        File file = new File(string3);
        this.setSyntax(file);
    }

    public void setSkippingComment(String string, String string2, boolean bl) {
        this.sCommentStringStart = string;
        this.sCommentStringEnd = string2;
        this.bStoreComment = bl;
    }

    public void setSkippingEndlineComment(String string, boolean bl) {
        this.sEndlineCommentStringStart = string;
        this.bStoreComment = bl;
    }

    public void setWhiteSpaces(String string) {
        this.sWhiteSpaces = string;
    }

    public void setLinemode(boolean bl) {
        int n = this.sWhiteSpaces.indexOf(10);
        if (bl && n >= 0) {
            this.sWhiteSpaces = this.sWhiteSpaces.substring(0, n) + this.sWhiteSpaces.substring(n + 1);
        } else if (!bl && n < 0) {
            this.sWhiteSpaces = this.sWhiteSpaces + '\n';
        }
    }

    public void setXmlSrcline(boolean bl) {
        this.builderTreeNodeXml.bXmlSrcline = bl;
    }

    public void setXmlSrctext(boolean bl) {
        this.builderTreeNodeXml.bXmlSrctext = bl;
    }

    public void setReportIdents(int n, int n2, int n3, int n4) {
        this.idReportParsing = n4;
        this.idReportComponentParsing = n3;
        this.idReportInfo = n2;
        this.idReportError = n;
    }

    public boolean parseFile(File file, int n, String string, Charset charset) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        StringPartFromFileLines stringPartFromFileLines = new StringPartFromFileLines(file, n, string, charset);
        return this.parse(stringPartFromFileLines);
    }

    public boolean parseFile(File file) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        int n = 0;
        StringPartFromFileLines stringPartFromFileLines = new StringPartFromFileLines(file, n, null, null);
        return this.parse(stringPartFromFileLines);
    }

    public boolean parse(String string) {
        StringPartScan stringPartScan = new StringPartScan(string);
        return this.parse(stringPartScan);
    }

    public boolean parse(StringPartScan stringPartScan) {
        return this.parse(stringPartScan, null);
    }

    public boolean parse(StringPartScan stringPartScan, List<String> list) {
        Object object;
        ZbnfParserStore zbnfParserStore;
        this.nLevelReportParsing = this.report.getReportLevelFromIdent(this.idReportParsing);
        this.nLevelReportComponentParsing = this.report.getReportLevelFromIdent(this.idReportComponentParsing);
        this.nLevelReportInfo = this.report.getReportLevelFromIdent(this.idReportInfo);
        this.nLevelReportError = this.report.getReportLevelFromIdent(this.idReportError);
        this.nReportLevel = this.report.getReportLevel();
        this.parserStoreTopLevel = new ZbnfParserStore();
        this.posRightestError = 0L;
        this.lineError = 0;
        this.columnError = 0;
        this.sFileError = null;
        this.sExpectedSyntax = null;
        this.alreadyParsedCmpn.clear();
        this.sRightestError = stringPartScan.getCurrentPart(80);
        this.prescriptParserTopLevel = new PrescriptParser(null, this.mainScript, "topLevelSyntax", stringPartScan, 0);
        if (list != null) {
            zbnfParserStore = new ZbnfParserStore();
            object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = object.hasNext() ? (String)object.next() : "";
                zbnfParserStore.addString(string2, string, stringPartScan, null);
            }
        } else {
            zbnfParserStore = null;
        }
        object = this.mainScript.getDefinitionIdent();
        try {
            boolean bl = this.prescriptParserTopLevel.parsePrescript1((String)object, null, this.parserStoreTopLevel, zbnfParserStore, false, 0);
            return bl;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    protected ZbnfSyntaxPrescript searchSyntaxPrescript(String string) {
        ZbnfSyntaxPrescript zbnfSyntaxPrescript = this.listSubPrescript.get(string);
        if (zbnfSyntaxPrescript == null) {
            if (this.idxMissingPrescripts == null) {
                this.idxMissingPrescripts = new TreeMap<String, String>();
            }
            this.idxMissingPrescripts.put(string, string);
        }
        return zbnfSyntaxPrescript;
    }

    public void reportSyntax(MainCmdLogging_ifc mainCmdLogging_ifc, int n) {
        this.mainScript.reportContent(mainCmdLogging_ifc, n);
        for (String string : this.listSubPrescript.keySet()) {
            ZbnfSyntaxPrescript zbnfSyntaxPrescript = this.listSubPrescript.get(string);
            mainCmdLogging_ifc.reportln(n, 0, "");
            zbnfSyntaxPrescript.reportContent(mainCmdLogging_ifc, n);
        }
    }

    public void reportStore(MainCmdLogging_ifc mainCmdLogging_ifc, int n, String string) {
        if (mainCmdLogging_ifc.getReportLevel() >= n) {
            mainCmdLogging_ifc.reportln(n, 0, "== MainCmdLogging_ifc ParserStore " + string + " ==");
            this.reportStoreComponent(this.getFirstParseResult(), mainCmdLogging_ifc, 1, null, n);
            mainCmdLogging_ifc.flushReport();
        }
    }

    public void reportStore(MainCmdLogging_ifc mainCmdLogging_ifc, int n) {
        this.reportStore(mainCmdLogging_ifc, n, "");
    }

    public void reportStore(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.reportStore(mainCmdLogging_ifc, 4);
    }

    private int reportStoreComponent(ZbnfParseResultItem zbnfParseResultItem, MainCmdLogging_ifc mainCmdLogging_ifc, int n, ZbnfParseResultItem zbnfParseResultItem2, int n2) {
        int n3 = 0;
        while (zbnfParseResultItem != null) {
            ++n3;
            mainCmdLogging_ifc.reportln(n2, 0, "parseResult: " + sEmpty.substring(0, n) + zbnfParseResultItem.getDescription());
            if (zbnfParseResultItem.isComponent()) {
                this.reportStoreComponent(zbnfParseResultItem.nextSkipIntoComponent(zbnfParseResultItem), mainCmdLogging_ifc, n + 1, zbnfParseResultItem, n2);
            }
            zbnfParseResultItem = zbnfParseResultItem.next(zbnfParseResultItem2);
        }
        return n3;
    }

    public String getInputEncodingKeyword() {
        return this.sInputEncodingKeyword;
    }

    public Charset getInputEncoding() {
        return this.charsetInput;
    }

    public String getExpectedSyntaxOnError() {
        return this.sExpectedSyntax;
    }

    public String getLastFoundedResultOnError() {
        String string = null;
        if (this.listParseResultOnError != null) {
            string = "";
            for (ZbnfParseResultItem zbnfParseResultItem : this.listParseResultOnError) {
                string = string + "\n" + zbnfParseResultItem.getDescription();
            }
        }
        return string;
    }

    public StringBuilder buildFoundedInputOnError() {
        StringBuilder stringBuilder = new StringBuilder(120);
        int n = this.getInputColumnOnError();
        int n2 = this.getInputLineOnError();
        String string = this.getInputFileOnError();
        stringBuilder.append("ZbnfParser ERROR ");
        if (string != null) {
            stringBuilder.append(" in file ").append((CharSequence)string);
        }
        if (n2 == 0 && n == 0) {
            stringBuilder.append(" @char position: ");
            stringBuilder.append(this.getInputPositionOnError());
            stringBuilder.append("=0x" + Long.toString(this.getInputPositionOnError(), 16) + " ");
        } else {
            stringBuilder.append(" @line, col: ").append(n2).append(", ").append(n);
        }
        stringBuilder.append(" >>>>>").append(this.sRightestError);
        if (stringBuilder.length() < 80) {
            stringBuilder.append("<<<<end of file");
        }
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c != '\n' && c != '\r') continue;
            stringBuilder.setCharAt(i, '|');
        }
        return stringBuilder;
    }

    public String getFoundedInputOnError() {
        return this.buildFoundedInputOnError().toString();
    }

    public long getInputPositionOnError() {
        return this.posRightestError;
    }

    public int getInputLineOnError() {
        return this.lineError;
    }

    public int getInputColumnOnError() {
        return this.columnError;
    }

    public String getInputFileOnError() {
        return this.sFileError;
    }

    protected void throwSyntaxErrorException(String string) throws ParseException {
        throw new ParseException(string + this.getSyntaxErrorReport(), (int)this.getInputPositionOnError());
    }

    public String getSyntaxErrorReport() {
        String string = this.getLastFoundedResultOnError();
        StringBuilder stringBuilder = this.buildFoundedInputOnError();
        stringBuilder.append("\nexpected: ----------------------------------------------");
        stringBuilder.append(this.getExpectedSyntaxOnError());
        stringBuilder.append("\nfounded before: ----------------------------------------------");
        stringBuilder.append(string == null ? "-nothing-" : string);
        stringBuilder.append("\n");
        if (this.idxMissingPrescripts != null) {
            for (Map.Entry<String, String> entry : this.idxMissingPrescripts.entrySet()) {
                stringBuilder.append("missing prescript: ").append(entry.getValue()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public ZbnfParseResultItem getFirstParseResult() {
        if (this.parserStoreTopLevel.items.size() > 0) {
            return this.parserStoreTopLevel.items.get(0);
        }
        return null;
    }

    public XmlNode getResultTree() {
        if (this.parserStoreTopLevel.items.size() > 0) {
            ZbnfParserStore.ParseResultItemImplement parseResultItemImplement = this.parserStoreTopLevel.items.get(0);
            return parseResultItemImplement.treeNodeXml;
        }
        return null;
    }

    public TreeMap<String, String> getXmlnsFromSyntaxPrescript() {
        return this.xmlnsList;
    }

    public boolean setStoringConstantSyntax(boolean bl) {
        boolean bl2 = this.bConstantSyntaxAsParseResult;
        this.bConstantSyntaxAsParseResult = bl;
        return bl2;
    }

    private void stop() {
    }

    static CharSequence inputCurrent(StringPartScan stringPartScan) {
        StringBuilder stringBuilder = new StringBuilder(stringPartScan.getCurrent(40));
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '\n') {
                stringBuilder.replace(i, i + 1, "|");
            }
            if (c != '\r') continue;
            stringBuilder.replace(i, i + 1, "-");
        }
        return stringBuilder;
    }

    static class ParseResultlet {
        final ZbnfSyntaxPrescript syntaxPrescript;
        final long startPosText;
        long endPosText;
        XmlNode xmlResult;

        ParseResultlet(ZbnfSyntaxPrescript zbnfSyntaxPrescript, long l) {
            this.syntaxPrescript = zbnfSyntaxPrescript;
            this.startPosText = l;
        }

        public final String toString() {
            return this.syntaxPrescript.sDefinitionIdent;
        }
    }

    static class LogParsing {
        final StringFormatter line = new StringFormatter(250);
        final MainCmdLogging_ifc logOut;

        LogParsing(MainCmdLogging_ifc mainCmdLogging_ifc) {
            this.logOut = mainCmdLogging_ifc;
        }

        void reportParsing(String string, int n, ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string2, StringPartScan stringPartScan, int n2, int n3, boolean bl) {
            int n4 = (int)(stringPartScan.getCurrentPosition() - (long)n2);
            this.line.reset().add(string).pos(10).addint(n2, "22221").add('+').addint(n4, "221").add(": ").addReplaceLinefeed(stringPartScan.getPart(n2, 30), "|-||", 30).pos(50).add(bl ? "  ok    " : "  error ").add(zbnfSyntaxPrescript.toString()).pos(70).add(" in ").add(string2);
            this.logOut.reportln(n, this.line.getContent());
        }
    }

    class PrescriptParser {
        final ParseResultlet resultlet;
        protected final StringPartScan input;
        protected final int posInputbase;
        final PrescriptParser parentPrescriptParser;
        ZbnfParserStore parserStoreInPrescript;
        ZbnfParserStore parseResultToOtherComponent = null;
        int[] idxWholeParserStoreForInsertionsFromOuterToInnerLevels = new int[100];
        ZbnfParseResultItem[] parentInWholeParserStoreForInsertionsFromOuterToInnerLevels = new ZbnfParseResultItem[100];
        final String sSemanticIdent;
        final String sReportParentComponents;

        protected PrescriptParser(PrescriptParser prescriptParser, ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string, StringPartScan stringPartScan, int n) {
            this.resultlet = new ParseResultlet(zbnfSyntaxPrescript, stringPartScan.getCurrentPosition());
            this.parentPrescriptParser = prescriptParser;
            this.input = stringPartScan;
            this.posInputbase = n;
            this.sSemanticIdent = string;
            this.sReportParentComponents = string + "+" + (prescriptParser != null ? prescriptParser.sReportParentComponents : "");
        }

        public boolean parsePrescript1(String string, ZbnfParseResultItem zbnfParseResultItem, ZbnfParserStore zbnfParserStore, ZbnfParserStore zbnfParserStore2, boolean bl, int n) throws ParseException {
            this.parserStoreInPrescript = zbnfParserStore;
            int n2 = this.parserStoreInPrescript.items.size();
            int n3 = -1;
            SubParser subParser = new SubParser(this.resultlet.syntaxPrescript, null, zbnfParseResultItem, n);
            boolean bl2 = subParser.parseSub(this.input, "::=", -32766, string, bl, zbnfParserStore2);
            if (!bl2 && n3 >= 0) {
                this.parserStoreInPrescript.setCurrentPosition(n3);
            }
            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportComponentParsing) {
                ZbnfParser.this.log.reportParsing("parseComp ", ZbnfParser.this.idReportComponentParsing, this.resultlet.syntaxPrescript, this.sReportParentComponents, this.input, (int)this.input.getCurrentPosition(), n, bl2);
            }
            if (bl2) {
                Object object;
                if (n2 < this.parserStoreInPrescript.items.size()) {
                    object = this.parserStoreInPrescript.items.get(n2);
                    this.resultlet.xmlResult = ZbnfParser.this.builderTreeNodeXml.buildTreeNodeRepresentationXml(null, (ZbnfParserStore.ParseResultItemImplement)object, true);
                } else {
                    this.resultlet.xmlResult = null;
                }
                this.resultlet.endPosText = this.input.getCurrentPosition();
                object = String.format("%9d", this.resultlet.startPosText) + this.resultlet.syntaxPrescript.sDefinitionIdent;
                ZbnfParser.this.alreadyParsedCmpn.put((String)object, this.resultlet);
            }
            return bl2;
        }

        class SubParser {
            final ZbnfSyntaxPrescript syntaxPrescript;
            private int idxPrescript;
            private final int nRecursion;
            int xxxidxAlternative;
            List<ZbnfSyntaxPrescript> listPrescripts;
            String sSemanticForError;
            final SubParser parentParser;
            final ZbnfParseResultItem parentOfParentResultItem;
            ZbnfParseResultItem parentResultItem;

            protected SubParser(ZbnfSyntaxPrescript zbnfSyntaxPrescript, SubParser subParser, ZbnfParseResultItem zbnfParseResultItem, int n) {
                this.syntaxPrescript = zbnfSyntaxPrescript;
                this.parentParser = subParser;
                this.parentOfParentResultItem = zbnfParseResultItem;
                this.nRecursion = n;
            }

            private void init() {
                if (PrescriptParser.this.parseResultToOtherComponent != null) {
                    PrescriptParser.this.parseResultToOtherComponent = null;
                }
            }

            public boolean parseSub(StringPartScan stringPartScan, String string, int n, String string2, boolean bl, ZbnfParserStore zbnfParserStore) throws ParseException {
                Object object;
                int n2;
                int n3;
                ZbnfParserStore.ParseResultItemImplement parseResultItemImplement;
                boolean bl2 = false;
                this.sSemanticForError = string;
                String string3 = PrescriptParser.this.sSemanticIdent;
                if (n == -32763) {
                    ZbnfParser.this.stop();
                }
                if (string2 != null && string2.equals("@")) {
                    string2 = this.syntaxPrescript.getSemantic();
                }
                if (this.syntaxPrescript.getSemantic() != null) {
                    this.sSemanticForError = string = this.syntaxPrescript.getSemantic();
                }
                if (string2 != null && string2.equals("description")) {
                    Assert.stop();
                }
                long l = stringPartScan.getCurrentPosition();
                if (bl && n == -32763 && string2 != null) {
                    this.parseWhiteSpaceAndComment();
                }
                long l2 = stringPartScan.getCurrentPosition();
                int n4 = -1;
                if (string2 != null && string2.equals("@")) {
                    assert (false);
                    parseResultItemImplement = null;
                    n3 = -1;
                } else if (string2 != null && string2.length() > 0) {
                    parseResultItemImplement = PrescriptParser.this.parserStoreInPrescript.addAlternative(string2, n, this.parentOfParentResultItem, stringPartScan);
                    n4 = n3 = PrescriptParser.this.parserStoreInPrescript.items.size() - 1;
                    this.parentResultItem = parseResultItemImplement;
                } else {
                    n3 = -1;
                    parseResultItemImplement = null;
                    this.parentResultItem = this.parentOfParentResultItem;
                }
                if (zbnfParserStore != null) {
                    n2 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                    PrescriptParser.this.parserStoreInPrescript.insert(zbnfParserStore, n2, this.parentResultItem);
                    if (n4 == -1) {
                        n4 = n2;
                    }
                }
                ZbnfParser.this.report.reportln(ZbnfParser.this.nLevelReportParsing, "parseSub                " + stringPartScan.getCurrentPosition() + " " + stringPartScan.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " semantic=" + string2 + " errormsg=" + this.sSemanticForError);
                n2 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                int n5 = 0;
                this.listPrescripts = this.syntaxPrescript.getListPrescripts();
                boolean bl3 = false;
                if (this.syntaxPrescript.isAlternative()) {
                    object = this.listPrescripts.iterator();
                    while (!bl3 && object.hasNext()) {
                        ZbnfSyntaxPrescript zbnfSyntaxPrescript = object.next();
                        SubParser subParser = new SubParser(zbnfSyntaxPrescript, this, this.parentResultItem, this.nRecursion + 1);
                        bl3 = subParser.parseSub(stringPartScan, "..|..|..", -32763, "@", bl, null);
                    }
                } else {
                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parse subPrescript;     " + stringPartScan.getCurrentPosition() + " " + stringPartScan.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") alternative=" + n5);
                    }
                    if (this.listPrescripts == null) {
                        ZbnfParser.this.stop();
                    }
                    bl3 = true;
                    this.idxPrescript = 0;
                    while (bl3 && this.idxPrescript < this.listPrescripts.size()) {
                        if (this.testSkipSpaceAndComment()) {
                            bl = true;
                        }
                        if (this.idxPrescript < this.listPrescripts.size()) {
                            if (stringPartScan.getCurrentPosition() == 31L) {
                                Assert.stop();
                            }
                            bl3 = this.parseItem(bl);
                            bl = false;
                        }
                        if (!bl3) continue;
                        ++this.idxPrescript;
                    }
                    if (bl) {
                        // empty if block
                    }
                }
                if (bl3) {
                    bl2 = true;
                } else {
                    stringPartScan.setCurrentPosition(l);
                    PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n2);
                    ++n5;
                    if (ZbnfParser.this.nReportLevel >= 6) {
                        ZbnfParser.this.report.reportln(6, "parse Error, reset to:  " + stringPartScan.getCurrent(30) + "...... idxResult = " + n2 + " idxAlternative = " + n5);
                    }
                }
                if (!bl2) {
                    PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n4);
                    object = null;
                } else {
                    object = stringPartScan.getPart((int)l2, (int)(stringPartScan.getCurrentPosition() - l2));
                    if (parseResultItemImplement != null) {
                        parseResultItemImplement.sInput = ((StringPart.Part)object).toString();
                    }
                }
                if (!bl2 && this.syntaxPrescript.isPossibleEmptyOption()) {
                    bl2 = true;
                    n5 = -1;
                } else if (bl2 && n3 >= 0) {
                    n5 = n5 == 0 && !this.syntaxPrescript.hasAlternatives() ? -1 : ++n5;
                    PrescriptParser.this.parserStoreInPrescript.setAlternativeAndOffsetToEnd(n3, n5);
                    if (n == -32763) {
                        assert (parseResultItemImplement != null);
                        parseResultItemImplement.parsedString = ((StringPart.Part)object).trim().toString();
                    }
                }
                if (this.syntaxPrescript.sSubSyntax != null) {
                    bl2 = this.addResultOrSubsyntax((CharSequence)object, l2, string2, this.syntaxPrescript.sSubSyntax, stringPartScan);
                }
                if (!bl2 && n4 >= 0) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseSub not found;     " + stringPartScan.getCurrentPosition() + " " + stringPartScan.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " error parsing, remove items from result buffer, before=" + PrescriptParser.this.parserStoreInPrescript.items.size());
                    ZbnfParser.this.report.report(ZbnfParser.this.idReportParsing, " after=" + PrescriptParser.this.parserStoreInPrescript.items.size());
                }
                return bl2;
            }

            boolean testSkipSpaceAndComment() {
                boolean bl = false;
                while (this.idxPrescript < this.listPrescripts.size() && this.listPrescripts.get(this.idxPrescript).getType() == 3) {
                    ++this.idxPrescript;
                    bl = true;
                }
                return bl;
            }

            private boolean parseItem(boolean bl) throws ParseException {
                boolean bl2;
                int n;
                ZbnfSyntaxPrescript zbnfSyntaxPrescript = this.listPrescripts.get(this.idxPrescript);
                String string = zbnfSyntaxPrescript.getConstantSyntax();
                String string2 = zbnfSyntaxPrescript.getDefinitionIdent();
                String string3 = zbnfSyntaxPrescript.getSemantic();
                CharSequence charSequence = PrescriptParser.this.input.getCurrent(80);
                if (string3 != null && string3.length() == 0) {
                    string3 = null;
                }
                if (string3 != null) {
                    this.sSemanticForError = string3;
                    if (string3.equals("semantic")) {
                        ZbnfParser.this.stop();
                    }
                }
                if ((n = zbnfSyntaxPrescript.getMaxNrofCharsFromComplexItem()) < -1) {
                    ZbnfParser.this.stop();
                }
                int n2 = zbnfSyntaxPrescript.getType();
                if (PrescriptParser.this.input.getCurrentPosition() == 704L) {
                    ZbnfParser.this.stop();
                }
                if (PrescriptParser.this.input.startsWith("\r\n#include")) {
                    ZbnfParser.this.stop();
                }
                switch (n2) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        bl2 = this.parseOptions(bl);
                        break;
                    }
                    case 8: {
                        bl2 = this.parseNegativVariant(zbnfSyntaxPrescript, bl);
                        break;
                    }
                    case 62: {
                        bl2 = this.parseUnconditionalVariant(zbnfSyntaxPrescript, bl);
                        break;
                    }
                    case 33: {
                        bl2 = this.parseExpectedVariant(zbnfSyntaxPrescript, bl);
                        break;
                    }
                    case 9: {
                        bl2 = this.parseRepetition(zbnfSyntaxPrescript, zbnfSyntaxPrescript.getRepetitionBackwardPrescript(), bl, PrescriptParser.this.parserStoreInPrescript);
                        break;
                    }
                    case 11: {
                        bl2 = true;
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem only Semantic;" + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseSemantic(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                        }
                        PrescriptParser.this.parserStoreInPrescript.addSemantic(string3, PrescriptParser.this.input, this.parentResultItem);
                        break;
                    }
                    case 12: {
                        bl2 = this.parseComponent(PrescriptParser.this.input, PrescriptParser.this.posInputbase, string2, string3, bl, zbnfSyntaxPrescript.isResultToAssignIntoNextComponent(), zbnfSyntaxPrescript.isToAddOuterResults());
                        break;
                    }
                    default: {
                        boolean bl3;
                        CharSequence charSequence2;
                        int n3 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                        long l = PrescriptParser.this.input.getCurrentPosition();
                        String string4 = null;
                        if (bl) {
                            if (n2 == 2) {
                                charSequence2 = zbnfSyntaxPrescript.getConstantSyntax();
                                string4 = ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportBranchParsing ? "" : "parsSpace " + PrescriptParser.this.input.getCurrentPosition() + " " + ZbnfParser.inputCurrent(PrescriptParser.this.input);
                            } else {
                                charSequence2 = null;
                            }
                            bl2 = bl3 = this.parseWhiteSpaceAndCommentOrTerminalSymbol((String)charSequence2, PrescriptParser.this.parserStoreInPrescript);
                        } else {
                            bl3 = false;
                            bl2 = false;
                        }
                        if (!bl3) {
                            assert (!bl2);
                            charSequence2 = null;
                            string4 = ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportBranchParsing ? "" : "item " + PrescriptParser.this.input.getCurrentPosition() + " " + ZbnfParser.inputCurrent(PrescriptParser.this.input);
                            switch (n2) {
                                case 2: {
                                    bl2 = this.parseTerminalSymbol(zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 20: {
                                    bl2 = this.parseIdentifier(string, string3, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 16: {
                                    bl2 = this.parsePositiveInteger(string3, n, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 18: {
                                    bl2 = this.parseHexNumber(string3, n, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 17: {
                                    bl2 = this.parseInteger(string3, n, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 15: 
                                case 19: {
                                    bl2 = this.parseFloatNumber(string3, n, PrescriptParser.this.parserStoreInPrescript, zbnfSyntaxPrescript);
                                    break;
                                }
                                case 22: {
                                    if (string3 != null && string3.equals("TESTrest")) {
                                        ZbnfParser.this.stop();
                                    }
                                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem StrTilEndchar;" + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*" + string + "?" + this.sSemanticForError + ">");
                                    }
                                    if (string.length() > 0) {
                                        bl2 = PrescriptParser.this.input.lentoAnyChar(string, n).found();
                                    } else {
                                        int n4 = PrescriptParser.this.input.length();
                                        if (n < n4) {
                                            PrescriptParser.this.input.lento(n);
                                        }
                                        bl2 = true;
                                    }
                                    if (bl2) {
                                        charSequence2 = PrescriptParser.this.input.getCurrentPart();
                                        break;
                                    }
                                    PrescriptParser.this.input.setLengthMax();
                                    this.saveError("ones of terminate chars \"" + string + "\" not found <?" + this.sSemanticForError + ">");
                                    break;
                                }
                                case 27: {
                                    bl2 = this.parseStringUntilRightEndchar(string, false, n, string3, zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 59: {
                                    bl2 = this.parseStringUntilRightEndchar(string, true, n, string3, zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 21: {
                                    bl2 = this.parseStringUntilTerminateString(string, false, false, n, string3, zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 37: {
                                    bl2 = this.parseStringUntilTerminateString(string, false, true, n, string3, zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 53: {
                                    bl2 = this.parseStringUntilTerminateString(string, true, false, n, string3, zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 25: {
                                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem-StrTilEndInde;" + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*" + string + "?" + this.sSemanticForError + ">");
                                    }
                                    StringBuilder stringBuilder = new StringBuilder();
                                    PrescriptParser.this.input.setLengthMax().lentoAnyStringWithIndent(zbnfSyntaxPrescript.getListStrings().toArray(new String[1]), zbnfSyntaxPrescript.getIndentChars(), n, stringBuilder);
                                    if (PrescriptParser.this.input.found()) {
                                        charSequence2 = stringBuilder;
                                        break;
                                    }
                                    PrescriptParser.this.input.setLengthMax();
                                    this.saveError("ones of terminate strings not found <?" + this.sSemanticForError + ">");
                                    break;
                                }
                                case 23: {
                                    bl2 = this.parseNoOrSomeCharsOutsideQuotion(string, n, string3, zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 26: {
                                    bl2 = this.parseSimpleStringLiteral(string, n, string3, zbnfSyntaxPrescript, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                case 28: {
                                    bl2 = this.parseRegularExpression(zbnfSyntaxPrescript, string3, bl, PrescriptParser.this.parserStoreInPrescript);
                                    break;
                                }
                                default: {
                                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem-default;      " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseSemantic(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                                    }
                                    bl2 = false;
                                }
                            }
                            if (charSequence2 != null) {
                                if (StringFunctions.startsWith(charSequence2, "First line")) {
                                    ZbnfParser.this.stop();
                                }
                                long l2 = PrescriptParser.this.input.getCurrentPosition();
                                bl2 = this.addResultOrSubsyntax(charSequence2, l2, string3, zbnfSyntaxPrescript.getSubSyntax(), PrescriptParser.this.input);
                                PrescriptParser.this.input.fromEnd();
                            }
                        }
                        if (!bl2) {
                            PrescriptParser.this.input.setCurrentPosition(l);
                            PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n3);
                        }
                        if (ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportBranchParsing) break;
                        ZbnfParser.this.log.reportParsing(string4, ZbnfParser.this.idReportBranchParsing, zbnfSyntaxPrescript, PrescriptParser.this.sReportParentComponents, PrescriptParser.this.input, (int)l, this.nRecursion, bl2);
                    }
                }
                return bl2;
            }

            boolean XXXparseSubSyntax(String string, int n, String string2) throws ParseException {
                StringPartScan stringPartScan = new StringPartScan(string);
                return this.parseComponent(stringPartScan, n, string2, null, false, false, false);
            }

            private boolean parseTerminalSymbol(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore zbnfParserStore) {
                boolean bl;
                long l = PrescriptParser.this.input.getCurrentPosition();
                int n = PrescriptParser.this.input.getLineAndColumn(ZbnfParser.this.column);
                String string = PrescriptParser.this.input.getInputfile();
                String string2 = zbnfSyntaxPrescript.getConstantSyntax();
                if (PrescriptParser.this.input.scan(string2).scanOk()) {
                    bl = true;
                    if (ZbnfParser.this.bConstantSyntaxAsParseResult) {
                        zbnfParserStore.addConstantSyntax(string2, l, PrescriptParser.this.input.getCurrentPosition(), n, 0, string, this.parentResultItem);
                    }
                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseTerminalSymbol;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse Ok Terminal:" + string2);
                    }
                } else {
                    bl = false;
                    this.saveError("\"" + string2 + "\"");
                }
                return bl;
            }

            private boolean parseRegularExpression(ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string, boolean bl, ZbnfParserStore zbnfParserStore) throws ParseException {
                Pattern pattern = zbnfSyntaxPrescript.getRegexPatternFromComplexItem();
                String string2 = pattern.pattern();
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRegex;             " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseRegex(" + this.nRecursion + ") <!" + string2 + "?" + this.sSemanticForError + ">");
                }
                StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                Matcher matcher = pattern.matcher(part);
                boolean bl2 = true;
                matcher.lookingAt();
                int n = -1;
                try {
                    n = matcher.end();
                }
                catch (IllegalStateException illegalStateException) {
                    bl2 = false;
                    String string3 = illegalStateException.getMessage();
                    this.saveError("regex: <!" + string2 + "?" + this.sSemanticForError + "> illegalStateException:" + string3);
                }
                if (bl2) {
                    PrescriptParser.this.input.lento(n);
                    StringPart.Part part2 = PrescriptParser.this.input.getCurrentPart();
                    long l = PrescriptParser.this.input.getCurrentPosition();
                    bl2 = this.addResultOrSubsyntax(part2, l, string, zbnfSyntaxPrescript.getSubSyntax(), PrescriptParser.this.input);
                    if (bl2) {
                        PrescriptParser.this.input.fromEnd();
                    }
                }
                return bl2;
            }

            private boolean parseIdentifier(String string, String string2, ZbnfParserStore zbnfParserStore) {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseIdentifier;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseIdentifier(" + this.nRecursion + ") <$" + "" + "?" + this.sSemanticForError + ">");
                }
                PrescriptParser.this.input.lentoIdentifier(null, string);
                if (PrescriptParser.this.input.length() > 0) {
                    String string3 = PrescriptParser.this.input.getCurrentPart().toString();
                    if (string3.equals("way1Sensor") && PrescriptParser.this.parentPrescriptParser.parseResultToOtherComponent != null) {
                        ZbnfParser.this.stop();
                    }
                    if (ZbnfParser.this.listKeywords.get(string3) != null) {
                        bl = false;
                        PrescriptParser.this.input.setLengthMax();
                    } else {
                        bl = true;
                        if (string2 != null) {
                            zbnfParserStore.addIdentifier(string2, string3, this.parentResultItem);
                        }
                        PrescriptParser.this.input.fromEnd();
                    }
                } else {
                    bl = false;
                    PrescriptParser.this.input.fromEnd();
                    this.saveError("identifier <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parsePositiveInteger(String string, int n, ZbnfParserStore zbnfParserStore) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parsePositivIntg;       " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parsePosNumber(" + this.nRecursion + ") <#?" + this.sSemanticForError + ">");
                }
                if (PrescriptParser.this.input.scanPositivInteger().scanOk()) {
                    bl = true;
                    if (string != null) {
                        zbnfParserStore.addIntegerNumber(string, PrescriptParser.this.input.getLastScannedIntegerNumber(), this.parentResultItem);
                    }
                } else {
                    bl = false;
                    this.saveError("positiv number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseHexNumber(String string, int n, ZbnfParserStore zbnfParserStore) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseHexNumber;         " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseHex(" + this.nRecursion + ") <#x?" + this.sSemanticForError + ">");
                }
                if (PrescriptParser.this.input.scanHex(n).scanOk()) {
                    bl = true;
                    if (string != null) {
                        zbnfParserStore.addIntegerNumber(string, PrescriptParser.this.input.getLastScannedIntegerNumber(), this.parentResultItem);
                    }
                } else {
                    bl = false;
                    this.saveError("hex number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseInteger(String string, int n, ZbnfParserStore zbnfParserStore) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseInteger;           " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseInt(" + this.nRecursion + ") <#-?" + this.sSemanticForError + ">");
                }
                if (PrescriptParser.this.input.scanInteger().scanOk()) {
                    bl = true;
                    if (string != null) {
                        zbnfParserStore.addIntegerNumber(string, PrescriptParser.this.input.getLastScannedIntegerNumber(), this.parentResultItem);
                    }
                } else {
                    bl = false;
                    this.saveError("integer number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseFloatNumber(String string, int n, ZbnfParserStore zbnfParserStore, ZbnfSyntaxPrescript zbnfSyntaxPrescript) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseFloat;             " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseFloat(" + this.nRecursion + ") <#f?" + this.sSemanticForError + ">");
                }
                if (PrescriptParser.this.input.scanFloatNumber(true).scanOk()) {
                    bl = true;
                    if (string != null) {
                        double d = PrescriptParser.this.input.getLastScannedFloatNumber();
                        if (zbnfSyntaxPrescript.getType() == 15) {
                            d *= zbnfSyntaxPrescript.getFloatFactor();
                        }
                        zbnfParserStore.addFloatNumber(string, d, this.parentResultItem);
                    }
                } else {
                    bl = false;
                    this.saveError("float number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseNoOrSomeCharsOutsideQuotion(String string, int n, String string2, ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore zbnfParserStore) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseCharsOutsideQuot;  " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*\"\"" + string + "?" + this.sSemanticForError + ">");
                }
                int n2 = PrescriptParser.this.input.indexOfAnyCharOutsideQuotion(string, 0, n);
                boolean bl = PrescriptParser.this.input.found();
                if (bl) {
                    if (n2 >= 0) {
                        PrescriptParser.this.input.lento(n2);
                        StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                        long l = PrescriptParser.this.input.getCurrentPosition();
                        bl = this.addResultOrSubsyntax(part, l, string2, zbnfSyntaxPrescript.getSubSyntax(), PrescriptParser.this.input);
                        if (bl) {
                            PrescriptParser.this.input.fromEnd();
                        }
                    }
                } else {
                    this.saveError("ones of terminate chars \"" + string + "\" not found <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseStringUntilRightEndchar(String string, boolean bl, int n, String string2, ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore zbnfParserStore) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseStrTilRightChar;   " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <stringtolastinclChar?" + this.sSemanticForError + ">");
                }
                PrescriptParser.this.input.lentoAnyChar(string, n, 48);
                boolean bl2 = PrescriptParser.this.input.found();
                if (bl2) {
                    if (bl) {
                        PrescriptParser.this.input.lento(PrescriptParser.this.input.length() + 1);
                    }
                    if (PrescriptParser.this.input.length() > 0) {
                        StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                        long l = PrescriptParser.this.input.getCurrentPosition();
                        bl2 = this.addResultOrSubsyntax(part, l, string2, zbnfSyntaxPrescript.getSubSyntax(), PrescriptParser.this.input);
                    }
                    PrescriptParser.this.input.fromEnd();
                } else {
                    PrescriptParser.this.input.setLengthMax();
                    this.saveError("ones of terminate chars \"" + string + "\" not found <?" + this.sSemanticForError + ">");
                }
                return bl2;
            }

            private boolean parseStringUntilTerminateString(String string, boolean bl, boolean bl2, int n, String string2, ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore zbnfParserStore) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseStrTilTermString;  " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*" + string + "?" + this.sSemanticForError + ">");
                }
                int n2 = bl ? 1 : 0;
                PrescriptParser.this.input.setLengthMax().lentoAnyString(zbnfSyntaxPrescript.getListStrings().toArray(new String[1]), n, n2);
                boolean bl3 = PrescriptParser.this.input.found();
                if (bl3) {
                    long l;
                    if (bl) {
                        PrescriptParser.this.input.lento(PrescriptParser.this.input.length() + 1);
                    }
                    StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                    if (bl2) {
                        part = part.trim();
                    }
                    if (bl3 = this.addResultOrSubsyntax(part, l = PrescriptParser.this.input.getCurrentPosition(), string2, zbnfSyntaxPrescript.getSubSyntax(), PrescriptParser.this.input)) {
                        PrescriptParser.this.input.fromEnd();
                    }
                } else {
                    PrescriptParser.this.input.setLengthMax();
                    String string3 = "";
                    Iterator<String> iterator = zbnfSyntaxPrescript.getListStrings().iterator();
                    while (iterator.hasNext()) {
                        string3 = string3 + "|" + iterator.next();
                    }
                    this.saveError("ones of terminate strings:" + string3 + " not found" + " <?" + this.sSemanticForError + ">");
                }
                return bl3;
            }

            private boolean parseComponent(StringPartScan stringPartScan, int n, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws ParseException {
                boolean bl4;
                ZbnfSyntaxPrescript zbnfSyntaxPrescript;
                String string3 = String.format("%9d", PrescriptParser.this.input.getCurrentPosition()) + string;
                ParseResultlet parseResultlet = ZbnfParser.this.alreadyParsedCmpn.get(string3);
                if (parseResultlet != null) {
                    Assert.stop();
                }
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseComponent;         " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseComponent(" + this.nRecursion + ") <" + string + "?" + this.sSemanticForError + ">");
                }
                if (string.equals("description")) {
                    ZbnfParser.this.stop();
                }
                if ((zbnfSyntaxPrescript = ZbnfParser.this.searchSyntaxPrescript(string)) != null) {
                    ZbnfParseResultItem zbnfParseResultItem;
                    ZbnfParserStore zbnfParserStore;
                    if (string.equals("variableDefinition")) {
                        ZbnfParser.this.stop();
                    }
                    if (bl2) {
                        if (PrescriptParser.this.parseResultToOtherComponent == null) {
                            PrescriptParser.this.parseResultToOtherComponent = new ZbnfParserStore();
                        }
                        zbnfParserStore = PrescriptParser.this.parseResultToOtherComponent;
                        zbnfParseResultItem = null;
                    } else {
                        zbnfParserStore = PrescriptParser.this.parserStoreInPrescript;
                        zbnfParseResultItem = this.parentResultItem;
                    }
                    PrescriptParser prescriptParser = new PrescriptParser(PrescriptParser.this, zbnfSyntaxPrescript, string, stringPartScan, n);
                    bl4 = prescriptParser.parsePrescript1(string2, zbnfParseResultItem, zbnfParserStore, bl3 ? PrescriptParser.this.parseResultToOtherComponent : null, bl, this.nRecursion + 2);
                    ZbnfParser.this.stop();
                    if (bl4) {
                        if (string2 != null && string2.equals("assign")) {
                            Assert.stop();
                        }
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseCompOk;            " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseComponent-ok(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                        }
                    } else if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseCompError;         " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseComponent-error(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                    }
                } else {
                    bl4 = false;
                    ZbnfParser.this.report.reportln(1, "parse - Syntaxprescript not found:" + string);
                    String string4 = "prescript for : <" + string + (!this.sSemanticForError.equals("@") && !this.sSemanticForError.equals("?") ? "?" + this.sSemanticForError : "") + "> not found.";
                    this.saveError(string4);
                }
                return bl4;
            }

            private boolean addResultOrSubsyntax(CharSequence charSequence, long l, String string, String string2, StringPart stringPart) throws ParseException {
                boolean bl;
                if (string2 != null) {
                    if (string != null) {
                        ZbnfParser.this.stop();
                    }
                    StringPartScan stringPartScan = new StringPartScan(charSequence);
                    bl = this.parseComponent(stringPartScan, (int)l, string2, string, false, false, false);
                } else if (string != null) {
                    PrescriptParser.this.parserStoreInPrescript.addString(charSequence, string, stringPart, this.parentResultItem);
                    bl = true;
                } else {
                    bl = true;
                }
                return bl;
            }

            private boolean parseSimpleStringLiteral(String string, int n, String string2, ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore zbnfParserStore) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseSimpleStringLit;   " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <\"\"\"?" + this.sSemanticForError + ">");
                }
                if (PrescriptParser.this.input.getCurrentChar() == string.charAt(0)) {
                    int n2 = PrescriptParser.this.input.indexEndOfQuotion(string.charAt(1), 0, n);
                    if (n2 >= 2) {
                        bl = true;
                        PrescriptParser.this.input.seek(1);
                        PrescriptParser.this.input.lento(n2 - 2);
                        StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                        long l = PrescriptParser.this.input.getCurrentPosition();
                        bl = this.addResultOrSubsyntax(part, l, string2, zbnfSyntaxPrescript.getSubSyntax(), PrescriptParser.this.input);
                        if (bl) {
                            PrescriptParser.this.input.fromEnd().seek(1);
                        }
                    } else {
                        bl = false;
                        this.saveError("right quotion mark <" + string + "?" + this.sSemanticForError + ">");
                    }
                } else {
                    bl = false;
                    this.saveError("" + string.charAt(0) + "StingLiteral" + string.charAt(1) + " <" + string + "?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseWhiteSpaceAndCommentOrTerminalSymbol(String string, ZbnfParserStore zbnfParserStore) {
                boolean bl;
                boolean bl2;
                long l = PrescriptParser.this.input.getCurrentPosition();
                long l2 = PrescriptParser.this.input.getCurrentPosition();
                do {
                    long l3;
                    bl2 = false;
                    if (string != null && string.charAt(0) == '\u0003' && PrescriptParser.this.input.length() == 0) {
                        bl = true;
                        bl2 = false;
                        if (ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportParsing) continue;
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseWhiteSpace;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse Ok EndOfText:");
                        continue;
                    }
                    if (string != null && PrescriptParser.this.input.startsWith(string)) {
                        bl = true;
                        bl2 = false;
                        l3 = PrescriptParser.this.input.getCurrentPosition();
                        int n = PrescriptParser.this.input.getLineAndColumn(ZbnfParser.this.column);
                        PrescriptParser.this.input.seek(string.length());
                        if (ZbnfParser.this.bConstantSyntaxAsParseResult) {
                            String string2 = PrescriptParser.this.input.getInputfile();
                            zbnfParserStore.addConstantSyntax(string, l3, PrescriptParser.this.input.getCurrentPosition(), n, 0, string2, this.parentResultItem);
                        }
                        if (ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportParsing) continue;
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseConstInComment;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse Ok Terminal:" + string);
                        continue;
                    }
                    bl = false;
                    PrescriptParser.this.input.seekNoChar(ZbnfParser.this.sWhiteSpaces);
                    l3 = PrescriptParser.this.input.getCurrentPosition();
                    if (l3 > l2) {
                        bl2 = true;
                        l2 = l3;
                    }
                    if (!bl2 && ZbnfParser.this.sCommentStringStart != null && PrescriptParser.this.input.startsWith(ZbnfParser.this.sCommentStringStart)) {
                        PrescriptParser.this.input.lento(ZbnfParser.this.sCommentStringEnd, 1);
                        if (PrescriptParser.this.input.length() > 0) {
                            bl2 = true;
                            PrescriptParser.this.input.fromEnd();
                            l2 = PrescriptParser.this.input.getCurrentPosition();
                        }
                    }
                    if (bl2 || ZbnfParser.this.sEndlineCommentStringStart == null || !PrescriptParser.this.input.startsWith(ZbnfParser.this.sEndlineCommentStringStart)) continue;
                    PrescriptParser.this.input.lento("\n");
                    if (PrescriptParser.this.input.length() <= 0) continue;
                    bl2 = true;
                    PrescriptParser.this.input.fromEnd();
                    l2 = PrescriptParser.this.input.getCurrentPosition();
                } while (bl2);
                if (string != null && !bl) {
                    this.saveError("\"" + string + "\"");
                    PrescriptParser.this.input.setCurrentPosition(l);
                    int n = zbnfParserStore.getNextPosition();
                    zbnfParserStore.setCurrentPosition(n);
                }
                return bl;
            }

            private boolean parseOptions(boolean bl) throws ParseException {
                ZbnfSyntaxPrescript zbnfSyntaxPrescript;
                int n;
                boolean bl2;
                boolean bl3 = true;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseOptions;           " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse option:" + this.sSemanticForError);
                }
                boolean bl4 = bl2 = (n = (zbnfSyntaxPrescript = this.listPrescripts.get(this.idxPrescript)).getType()) == 6;
                if (bl2) {
                    int n2 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                    long l = PrescriptParser.this.input.getCurrentPosition();
                    int n3 = this.idxPrescript++;
                    while (bl3 && this.idxPrescript < this.listPrescripts.size()) {
                        if (this.testSkipSpaceAndComment()) {
                            bl = true;
                        }
                        if (this.idxPrescript < this.listPrescripts.size()) {
                            bl3 = this.parseItem(bl);
                            bl = false;
                        }
                        if (!bl3) continue;
                        ++this.idxPrescript;
                    }
                    if (bl3) {
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseOptionOk;          " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse FirstAfterOption -ok:");
                        }
                    } else {
                        PrescriptParser.this.input.setCurrentPosition(l);
                        PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n2);
                        this.idxPrescript = n3;
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseOptionError;       " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse FirstAfterOption -error:");
                        }
                    }
                }
                if (!bl2 || !bl3) {
                    SubParser subParser;
                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseOptionFirstAfter;  " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " try options:");
                    }
                    if (!(bl3 = (subParser = new SubParser(zbnfSyntaxPrescript, this, this.parentResultItem, this.nRecursion + 1)).parseSub(PrescriptParser.this.input, "[...]", -32763, "@", bl, null))) {
                        this.saveError(" [...]<?" + this.sSemanticForError + ">");
                    }
                }
                return bl3;
            }

            private boolean parseNegativVariant(ZbnfSyntaxPrescript zbnfSyntaxPrescript, boolean bl) throws ParseException {
                boolean bl2 = true;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseNegativVariante;   " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " [?" + this.sSemanticForError);
                }
                SubParser subParser = new SubParser(zbnfSyntaxPrescript, this, this.parentResultItem, this.nRecursion + 1);
                int n = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                long l = PrescriptParser.this.input.getCurrentPosition();
                bl2 = subParser.parseSub(PrescriptParser.this.input, "[?..]", -32763, "@", bl, null);
                PrescriptParser.this.input.setCurrentPosition(l);
                PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n);
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportBranchParsing) {
                    ZbnfParser.this.log.reportParsing("parseNegV ", ZbnfParser.this.idReportBranchParsing, zbnfSyntaxPrescript, PrescriptParser.this.sReportParentComponents, PrescriptParser.this.input, (int)PrescriptParser.this.input.getCurrentPosition(), this.nRecursion, bl2);
                }
                return !bl2;
            }

            private boolean parseExpectedVariant(ZbnfSyntaxPrescript zbnfSyntaxPrescript, boolean bl) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseExpectVariante;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " [!" + this.sSemanticForError);
                }
                SubParser subParser = new SubParser(zbnfSyntaxPrescript, this, this.parentResultItem, this.nRecursion + 1);
                int n = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                long l = PrescriptParser.this.input.getCurrentPosition();
                boolean bl2 = subParser.parseSub(PrescriptParser.this.input, "[!..]", -32763, "@", bl, null);
                if (bl2) {
                    PrescriptParser.this.input.setCurrentPosition(l);
                    PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n);
                }
                return bl2;
            }

            private boolean parseUnconditionalVariant(ZbnfSyntaxPrescript zbnfSyntaxPrescript, boolean bl) throws ParseException {
                SubParser subParser;
                boolean bl2 = true;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseUncondVariante;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " [>" + this.sSemanticForError);
                }
                if (!(bl2 = (subParser = new SubParser(zbnfSyntaxPrescript, this, this.parentResultItem, this.nRecursion + 1)).parseSub(PrescriptParser.this.input, "[>..]", -32763, "@", bl, null))) {
                    throw new ParseException("unconditional Syntax failes", 0);
                }
                return bl2;
            }

            private boolean parseRepetition(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfSyntaxPrescript zbnfSyntaxPrescript2, boolean bl, ZbnfParserStore zbnfParserStore) throws ParseException {
                boolean bl2;
                boolean bl3 = true;
                boolean bl4 = true;
                int n = 0;
                String string = zbnfSyntaxPrescript.getSemantic();
                if (string != null) {
                    this.sSemanticForError = string;
                }
                if (string != null) {
                    this.sSemanticForError = string;
                }
                SubParser subParser = new SubParser(zbnfSyntaxPrescript, this, this.parentResultItem, this.nRecursion + 1);
                SubParser subParser2 = new SubParser(zbnfSyntaxPrescript2, this, this.parentResultItem, this.nRecursion + 1);
                long l = -1L;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRepetition;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse repetition:");
                }
                do {
                    boolean bl5;
                    ++n;
                    long l2 = PrescriptParser.this.input.getCurrentPosition();
                    if (l2 == 594L) {
                        ZbnfParser.this.stop();
                    }
                    if (l2 == l) {
                        bl5 = false;
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-nonRepeat;     " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + "   parse no repetition because no progress on input");
                        }
                    } else {
                        l = l2;
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-repeat;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " { parse repetition nr:" + n);
                        }
                        bl5 = subParser.parseSub(PrescriptParser.this.input, "{...}", n, string, bl, null);
                    }
                    if (!bl5 && bl4) {
                        bl3 = false;
                        this.saveError("repetition required because backward-continue is matched.");
                    }
                    if (PrescriptParser.this.input.getCurrentPosition() == 1688L) {
                        ZbnfParser.this.stop();
                    }
                    if (bl5) {
                        if (subParser2.syntaxPrescript != null) {
                            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-backCheck;     " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse test repetition back:");
                            }
                            bl4 = bl2 = subParser2.parseSub(PrescriptParser.this.input, "{?...}", -n, "@", bl, null);
                        } else {
                            bl4 = false;
                            bl2 = true;
                            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-backUncond;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse repetition test repeat:");
                            }
                        }
                    } else {
                        bl2 = false;
                    }
                    switch (this.nRecursion) {
                        case 0: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 1: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 2: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 3: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 4: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 5: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        default: {
                            ZbnfParser.this.stop();
                        }
                    }
                } while (bl2);
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-finish;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " } parse repetition finished, nr:" + n);
                }
                return bl3;
            }

            private boolean parseWhiteSpaceAndComment() {
                return this.parseWhiteSpaceAndCommentOrTerminalSymbol(null, null);
            }

            private void saveError(String string) {
                int n;
                if (PrescriptParser.this.input.length() < PrescriptParser.this.input.lengthMaxPart()) {
                    ZbnfParser.this.report.reportln(1, " saveError: actual length of input is to less");
                }
                if (ZbnfParser.this.posRightestError < (long)(n = (int)PrescriptParser.this.input.getCurrentPosition() + PrescriptParser.this.posInputbase)) {
                    ZbnfParser.this.posRightestError = n;
                    int[] nArray = new int[1];
                    ZbnfParser.this.lineError = PrescriptParser.this.input.getLineAndColumn(nArray);
                    ZbnfParser.this.columnError = nArray[0];
                    ZbnfParser.this.sRightestError = PrescriptParser.this.input.getCurrentPart(80);
                    ZbnfParser.this.sExpectedSyntax = "";
                    if (ZbnfParser.this.listParseResultOnError != null) {
                        int n2 = PrescriptParser.this.parserStoreInPrescript.items.size();
                        int n3 = n2 - ZbnfParser.this.maxParseResultEntriesOnError;
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        ZbnfParser.this.listParseResultOnError.clear();
                        while (n3 < n2) {
                            ZbnfParser.this.listParseResultOnError.add(PrescriptParser.this.parserStoreInPrescript.items.get(n3));
                            ++n3;
                        }
                    }
                }
                if (ZbnfParser.this.posRightestError <= PrescriptParser.this.input.getCurrentPosition()) {
                    ZbnfParser.this.sExpectedSyntax = ZbnfParser.this.sExpectedSyntax + "\n " + string + " in " + this.getSemanticTreeForErrorMsg();
                }
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parse-saveError;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseError");
                }
            }

            private String getSemanticTreeForErrorMsg() {
                StringBuilder stringBuilder = new StringBuilder(200);
                PrescriptParser prescriptParser = PrescriptParser.this;
                String string = "";
                while (prescriptParser != null) {
                    stringBuilder.append(string);
                    stringBuilder.append(prescriptParser.sSemanticIdent);
                    prescriptParser = prescriptParser.parentPrescriptParser;
                    string = " <- ";
                }
                SubParser subParser = null;
                if (this.sSemanticForError.startsWith("stringvalue")) {
                    ZbnfParser.this.stop();
                }
                while (subParser != null) {
                    if (subParser.sSemanticForError != null) {
                        stringBuilder.append('+');
                        stringBuilder.append(subParser.sSemanticForError);
                    }
                    subParser = subParser.parentParser;
                }
                return stringBuilder.toString();
            }

            public ZbnfParserStore xxxgetParserStore() {
                return PrescriptParser.this.parserStoreInPrescript;
            }

            public String getDefinitionIdent() {
                return this.syntaxPrescript.getDefinitionIdent();
            }
        }
    }
}

