/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.DataAccess;
import org.vishia.util.SetLineColumn_ifc;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParser;

public class ZbnfJavaOutput {
    public static final String sVersion = "2014-04-27";
    private final MainCmdLogging_ifc report;
    private boolean bOnlyMethods;
    private boolean bOnlyFields;
    private boolean bExceptionIfnotFound;
    private StringBuffer errors;
    private Class[] outputClasses;

    public ZbnfJavaOutput() {
        this.report = MainCmd.getLogging_ifc();
        this.init();
    }

    public ZbnfJavaOutput(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.report = mainCmdLogging_ifc;
        this.init();
    }

    private ZbnfJavaOutput(MainCmdLogging_ifc mainCmdLogging_ifc, boolean bl, boolean bl2) {
        this.report = mainCmdLogging_ifc;
        this.init();
        this.bOnlyMethods = bl2;
    }

    public void setMethodsOnly(boolean bl) {
        this.bOnlyMethods = bl;
    }

    public void setFieldsOnly(boolean bl) {
        this.bOnlyFields = bl;
    }

    public void setWeakErrors(boolean bl) {
        this.bExceptionIfnotFound = !bl;
    }

    public void init() {
        this.errors = null;
        this.bOnlyFields = false;
        this.bOnlyMethods = false;
        this.bExceptionIfnotFound = true;
    }

    public String setContent(Class clazz, Object object, ZbnfParseResultItem zbnfParseResultItem) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        this.errors = null;
        Iterator<ZbnfParseResultItem> iterator = zbnfParseResultItem.iteratorChildren();
        while (iterator.hasNext()) {
            ZbnfParseResultItem zbnfParseResultItem2 = iterator.next();
            this.writeZbnfResult(new Component(null, clazz, object), zbnfParseResultItem2, 1);
        }
        return this.errors == null ? null : this.errors.toString();
    }

    public static void setOutputStrict(Object object, ZbnfParseResultItem zbnfParseResultItem, MainCmdLogging_ifc mainCmdLogging_ifc) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ZbnfJavaOutput.setOutput(object, zbnfParseResultItem, mainCmdLogging_ifc, true, true);
    }

    public static void setOutputFields(Object object, ZbnfParseResultItem zbnfParseResultItem, MainCmdLogging_ifc mainCmdLogging_ifc) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ZbnfJavaOutput.setOutput(object, zbnfParseResultItem, mainCmdLogging_ifc, true, false);
    }

    public static void setOutput(Object object, ZbnfParseResultItem zbnfParseResultItem, MainCmdLogging_ifc mainCmdLogging_ifc, boolean bl, boolean bl2) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ZbnfJavaOutput zbnfJavaOutput = new ZbnfJavaOutput(mainCmdLogging_ifc, bl, bl2);
        zbnfJavaOutput.outputClasses = object.getClass().getClasses();
        Iterator<ZbnfParseResultItem> iterator = zbnfParseResultItem.iteratorChildren();
        while (iterator.hasNext()) {
            ZbnfParseResultItem zbnfParseResultItem2 = iterator.next();
            zbnfJavaOutput.writeZbnfResult(new Component(null, object.getClass(), object), zbnfParseResultItem2, 1);
        }
    }

    public static void setOutput(Object object, ZbnfParseResultItem zbnfParseResultItem, MainCmdLogging_ifc mainCmdLogging_ifc) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ZbnfJavaOutput zbnfJavaOutput = new ZbnfJavaOutput(mainCmdLogging_ifc, false, false);
        zbnfJavaOutput.outputClasses = object.getClass().getClasses();
        for (ZbnfParseResultItem zbnfParseResultItem2 = zbnfParseResultItem.nextSkipIntoComponent(null); zbnfParseResultItem2 != null; zbnfParseResultItem2 = zbnfParseResultItem2.next(zbnfParseResultItem)) {
            zbnfJavaOutput.writeZbnfResult(new Component(null, object.getClass(), object), zbnfParseResultItem2, 1);
        }
    }

    private void writeZbnfResult(Component component, ZbnfParseResultItem zbnfParseResultItem, int n) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        String string;
        String string2 = zbnfParseResultItem.getSemantic();
        String string3 = string = string2.startsWith("@") ? string2.substring(1) : string2;
        if (string.length() > 0) {
            if (string.equals("operator")) {
                this.stop();
            }
            this.report.reportln(6, n, "ZbnfJavaOutput: " + string + ":");
            if (zbnfParseResultItem.isComponent()) {
                ChildInstanceAndClass childInstanceAndClass;
                if (zbnfParseResultItem.isOption() && zbnfParseResultItem.getParsedString() != null) {
                    this.searchDestinationAndWriteResult(string, component, zbnfParseResultItem);
                }
                if ((childInstanceAndClass = this.searchComponentsDestination(string, component)) != null) {
                    Object object;
                    Component component2 = new Component(component, childInstanceAndClass.clazz, childInstanceAndClass.instance);
                    if (component2.instance instanceof SetLineColumn_ifc) {
                        object = (SetLineColumn_ifc)component2.instance;
                        int n2 = object.setLineColumnFileMode();
                        int n3 = (n2 & 2) != 0 ? zbnfParseResultItem.getInputColumn() : -1;
                        int n4 = (n2 & 1) != 0 ? zbnfParseResultItem.getInputLine() : -1;
                        String string4 = (n2 & 4) != 0 ? zbnfParseResultItem.getInputFile() : null;
                        object.setLineColumnFile(n4, n3, string4);
                    }
                    object = zbnfParseResultItem.iteratorChildren();
                    while (object.hasNext()) {
                        ZbnfParseResultItem zbnfParseResultItem2 = (ZbnfParseResultItem)object.next();
                        this.writeZbnfResult(new Component(component, childInstanceAndClass.clazz, childInstanceAndClass.instance), zbnfParseResultItem2, n + 1);
                    }
                    if (childInstanceAndClass.shouldAdd) {
                        this.searchAddMethodAndInvoke(string, component, childInstanceAndClass);
                    }
                }
            } else {
                this.searchDestinationAndWriteResult(string, component, zbnfParseResultItem);
            }
        }
    }

    private Method searchMethod(Class clazz, String string, Class[][] classArray) {
        Method method;
        do {
            int n = 0;
            do {
                Class[] classArray2 = classArray[n];
                try {
                    method = clazz.getDeclaredMethod(string, classArray2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = null;
                }
            } while (method == null && ++n < classArray.length);
            if (method != null || (clazz = clazz.getSuperclass()) != Object.class) continue;
            clazz = null;
        } while (method == null && clazz != null);
        return method;
    }

    ChildInstanceAndClass searchCreateMethod(Component component, String string) throws IllegalArgumentException, IllegalAccessException {
        Method method = this.searchMethod(component.clazz, "new_" + string, new Class[1][0]);
        if (method != null) {
            Object object;
            Class<?> clazz = method.getReturnType();
            Object[] objectArray = null;
            try {
                object = method.invoke(component.instance, objectArray);
            }
            catch (Exception exception) {
                throw new IllegalAccessException("exception inside: " + method.toString());
            }
            return new ChildInstanceAndClass(object, clazz, true);
        }
        return null;
    }

    private void searchAddMethodAndInvoke(String string, Component component, ChildInstanceAndClass childInstanceAndClass) throws IllegalArgumentException, IllegalAccessException {
        Class[][] classArray = new Class[1][1];
        classArray[0][0] = childInstanceAndClass.clazz;
        Method method = this.searchMethod(component.clazz, "set_" + string, classArray);
        if (method == null) {
            method = this.searchMethod(component.clazz, "add_" + string, classArray);
        }
        if (method != null) {
            Object[] objectArray = new Object[]{childInstanceAndClass.instance};
            try {
                method.invoke(component.instance, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string2 = "The called method " + method.toGenericString() + " throws an Exception: " + invocationTargetException.getTargetException();
                if (this.report != null) {
                    this.report.writeWarning(string2);
                }
                throw new IllegalAccessException(string2);
            }
            catch (Exception exception) {
                throw new IllegalAccessException("can not access: " + component.clazz.getCanonicalName() + ".add_" + string + "(...) or .set...");
            }
        } else {
            String string3 = "method set_- or add_" + string + "(" + childInstanceAndClass.clazz.getCanonicalName() + ") not found";
            this.problem(component, string3);
        }
    }

    private ChildInstanceAndClass searchComponentsDestination(String string, Component component) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ChildInstanceAndClass childInstanceAndClass = null;
        int n = string.indexOf(47);
        if (n > 0) {
            String string2 = string.substring(0, n);
            childInstanceAndClass = this.searchComponentsDestination(string2, component);
            String string3 = string.substring(n + 1);
            return this.searchComponentsDestination(string3, new Component(component, childInstanceAndClass.clazz, childInstanceAndClass.instance));
        }
        childInstanceAndClass = this.searchCreateMethod(component, string);
        if (childInstanceAndClass == null) {
            String string4;
            Class clazz = component.clazz.getSuperclass();
            char c = string.charAt(0);
            String string5 = string4 = c >= 'a' && c <= 'z' ? string : Character.toLowerCase(c) + string.substring(1);
            if (string4.equals("operator")) {
                this.stop();
            }
            Field field = null;
            try {
                field = component.clazz.getDeclaredField(string4);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    field = clazz.getField(string4);
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    field = null;
                }
            }
            if (field != null) {
                this.report.report(6, string4);
                childInstanceAndClass = this.getComponentsOutputField(field, component.instance);
            } else {
                String string6 = "cannot found method new_" + string + "() or field " + string4;
                this.problem(component, string6);
            }
        }
        return childInstanceAndClass;
    }

    private ChildInstanceAndClass getComponentsOutputField(Field field, Object object) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ChildInstanceAndClass childInstanceAndClass;
        Object object2;
        try {
            object2 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessException("ZbnfJavaOutput: cannot access " + field.getName() + " in " + object.getClass().getCanonicalName());
        }
        Class<Object> clazz = field.getType();
        String string = clazz.getName();
        if (string.equals("java.util.List") || string.equals("java.util.LinkedList")) {
            ParameterizedType parameterizedType;
            List list = (List)object2;
            Class clazz2 = null;
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                clazz2 = (Class)typeArray[0];
            }
            if (list == null) {
                if (string.equals("java.util.List")) {
                    clazz = LinkedList.class;
                }
                list = (List)clazz.newInstance();
                field.set(object, list);
            }
            parameterizedType = clazz2.newInstance();
            list.add(parameterizedType);
            childInstanceAndClass = new ChildInstanceAndClass(parameterizedType, clazz2, false);
        } else {
            if (object2 == null) {
                try {
                    object2 = clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new InstantiationException(exception.getMessage());
                }
                field.set(object, object2);
            }
            childInstanceAndClass = new ChildInstanceAndClass(object2, clazz, false);
        }
        return childInstanceAndClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChildInstanceAndClass searchDestinationAndWriteResult(String string, Component component, ZbnfParseResultItem zbnfParseResultItem) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        int n;
        String string2;
        ChildInstanceAndClass childInstanceAndClass = null;
        String string3 = string2 = string.startsWith("@") ? string.substring(1) : string;
        if (string2.equals("posIndent")) {
            this.stop();
        }
        if ((n = string2.lastIndexOf(47)) > 0) {
            String string4 = string2.substring(0, n);
            childInstanceAndClass = this.searchComponentsDestination(string4, component);
            String string5 = string2.substring(n + 1);
            return this.searchDestinationAndWriteResult(string5, new Component(component, childInstanceAndClass.clazz, childInstanceAndClass.instance), zbnfParseResultItem);
        }
        if (zbnfParseResultItem == null) {
            childInstanceAndClass = this.searchComponentsDestination(string2, component);
        } else if (component.instance instanceof Map) {
            childInstanceAndClass = this.writeInMap(string2, component, zbnfParseResultItem);
        } else {
            Class[][] classArray;
            if (zbnfParseResultItem.isInteger() || zbnfParseResultItem.isFloat()) {
                classArray = new Class[4][1];
                classArray[0][0] = Integer.TYPE;
                classArray[1][0] = Long.TYPE;
                classArray[2][0] = Float.TYPE;
                classArray[3][0] = Double.TYPE;
            } else if (zbnfParseResultItem.isFloat()) {
                classArray = new Class[2][1];
                classArray[0][0] = Float.TYPE;
                classArray[1][0] = Double.TYPE;
            } else if (zbnfParseResultItem.isString() || zbnfParseResultItem.isIdentifier() || zbnfParseResultItem.isTerminalSymbol() || zbnfParseResultItem.isOption() && zbnfParseResultItem.getParsedString() != null) {
                classArray = new Class[1][1];
                classArray[0][0] = String.class;
            } else {
                classArray = new Class[1][0];
            }
            String string6 = component.clazz.getCanonicalName() + ".set_" + string2 + "(" + (classArray[0].length > 0 ? classArray[0][0].getName() : "void") + ")";
            Method method = this.searchMethod(component.clazz, "set_" + string2, classArray);
            if (method == null) {
                method = this.searchMethod(component.clazz, "add_" + string2, classArray);
            }
            if (method != null) {
                Object[] objectArray;
                Class<?>[] classArray2 = method.getParameterTypes();
                if (classArray2.length >= 1) {
                    objectArray = new Object[1];
                    Class<?> clazz = classArray2[0];
                    boolean bl = zbnfParseResultItem.isFloat();
                    double d = bl ? zbnfParseResultItem.getParsedFloat() : (double)zbnfParseResultItem.getParsedInteger();
                    long l = bl ? (long)zbnfParseResultItem.getParsedFloat() : zbnfParseResultItem.getParsedInteger();
                    String string7 = clazz.getName();
                    if (string7.equals("long")) {
                        objectArray[0] = new Long(bl ? (long)((int)d) : l);
                    } else if (string7.equals("int")) {
                        objectArray[0] = new Integer((int)(bl ? d : (double)l));
                    } else if (string7.equals("double")) {
                        objectArray[0] = new Double(bl ? d : (double)l);
                    } else if (string7.equals("float")) {
                        objectArray[0] = new Float((float)(bl ? d : (double)l));
                    } else {
                        if (clazz != String.class) throw new IllegalAccessException("unexpected argument type: " + string6 + " / " + clazz.getName());
                        objectArray[0] = new String(zbnfParseResultItem.getParsedString());
                        if (objectArray[0] == null) {
                            objectArray[0] = new String(zbnfParseResultItem.getParsedText());
                        }
                    }
                } else {
                    objectArray = null;
                }
                try {
                    method.invoke(component.instance, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new IllegalAccessException("cannot access: " + string6 + " / " + invocationTargetException.getMessage());
                }
                catch (Exception exception) {
                    throw new IllegalAccessException("error calling: " + string6 + " / " + exception.getMessage());
                }
            } else {
                char c = string2.charAt(0);
                String string8 = c >= 'a' && c <= 'z' ? string2 : Character.toLowerCase(c) + string2.substring(1);
                Field field = null;
                Class clazz = component.clazz;
                if (string8.equals("cssHtml")) {
                    this.stop();
                }
                do {
                    try {
                        field = clazz.getDeclaredField(string8);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        field = null;
                    }
                } while (field == null && (clazz = clazz.getSuperclass()) != null && clazz != Object.class);
                if (field != null) {
                    this.report.report(6, string8);
                    this.writeInField(field, component.instance, zbnfParseResultItem);
                } else {
                    String string9 = "cannot found method " + string6 + " or field " + string8;
                    this.problem(component, string9);
                }
            }
        }
        this.trySetInputColumn(string2, component, zbnfParseResultItem.getInputColumn());
        return childInstanceAndClass;
    }

    private void writeInField(Field field, Object object, ZbnfParseResultItem zbnfParseResultItem) throws IllegalAccessException {
        String string;
        String string2;
        block22: {
            string2 = field.getType().getName();
            string = "???";
            boolean bl = this.report.getReportLevel() >= 6;
            boolean bl2 = zbnfParseResultItem.isFloat();
            double d = bl2 ? zbnfParseResultItem.getParsedFloat() : (double)zbnfParseResultItem.getParsedInteger();
            long l = bl2 ? (long)zbnfParseResultItem.getParsedFloat() : zbnfParseResultItem.getParsedInteger();
            try {
                if (string2.equals("int")) {
                    int n = (int)(bl2 ? d : (double)l);
                    field.setInt(object, n);
                    if (bl) {
                        string = "" + n;
                    }
                    break block22;
                }
                if (string2.equals("long")) {
                    long l2 = bl2 ? (long)d : l;
                    field.setLong(object, l2);
                    if (bl) {
                        string = "" + l2;
                    }
                    break block22;
                }
                if (string2.equals("float")) {
                    float f = (float)(bl2 ? d : (double)l);
                    field.setFloat(object, f);
                    if (bl) {
                        string = "" + f;
                    }
                    break block22;
                }
                if (string2.equals("double")) {
                    double d2 = bl2 ? d : (double)l;
                    field.setDouble(object, d2);
                    if (bl) {
                        string = "" + d2;
                    }
                    break block22;
                }
                if (string2.equals("boolean")) {
                    field.setBoolean(object, true);
                    if (bl) {
                        string = "true";
                    }
                    break block22;
                }
                if (string2.equals("java.lang.String")) {
                    String string3 = zbnfParseResultItem.getParsedString();
                    if (string3 == null) {
                        string3 = zbnfParseResultItem.getParsedText();
                    }
                    field.set(object, string3);
                    if (bl) {
                        string = string3;
                    }
                    break block22;
                }
                if (string2.equals("char")) {
                    String string4 = zbnfParseResultItem.getParsedString();
                    if (string4 == null) {
                        string4 = zbnfParseResultItem.getParsedText();
                    }
                    char c = string4 != null && string4.length() >= 1 ? string4.charAt(0) : (char)zbnfParseResultItem.getParsedInteger();
                    field.setChar(object, c);
                    if (bl) {
                        string = string4;
                    }
                    break block22;
                }
                if (string2.equals("java.util.List")) {
                    LinkedList<String> linkedList;
                    String string5 = zbnfParseResultItem.getParsedString();
                    if (string5 == null) {
                        string5 = zbnfParseResultItem.getParsedText();
                    }
                    if ((linkedList = (LinkedList<String>)field.get(object)) == null) {
                        linkedList = new LinkedList<String>();
                        field.set(object, linkedList);
                    }
                    linkedList.add(string5);
                    if (bl) {
                        string = string5;
                    }
                    break block22;
                }
                throw new IllegalArgumentException("Unexpected type of field: " + string2 + " " + field.getName() + " in " + object.getClass().getName() + " Hint: An access to a public element can only be done for types int, long, float, double, boolean, String and List<String>.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessException("access to field is denied: " + object.getClass().getName() + "." + field.getName() + " /Type: " + string2);
            }
        }
        this.report.report(6, " \"" + string + "\" written in Element Type " + string2);
    }

    private boolean trySetInputInfo(Component component, int n, int n2, String string) throws IllegalAccessException {
        boolean bl = false;
        if (n >= 0) {
            DataAccess.DatapathElement datapathElement = new DataAccess.DatapathElement("inputLine_");
            try {
                Field field = component.clazz.getField("inputLine_");
                field.setInt(component.instance, n);
                bl = true;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    datapathElement.set("set_inputInfo_()");
                    datapathElement.setActualArguments(new Integer(n), new Integer(n2), string);
                    Object object = DataAccess.invokeMethod(datapathElement, component.clazz, component.instance, false, true);
                    bl = object != null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (Exception exception) {
                    throw new IllegalAccessException(exception.getMessage());
                }
            }
        }
        return bl;
    }

    private void trySetInputColumn(String string, Component component, int n) throws IllegalAccessException {
        if (n >= 0) {
            try {
                Field field = component.clazz.getField("inputColumn_" + string);
                field.setInt(component.instance, n);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Class[] classArray = new Class[]{Integer.TYPE};
                try {
                    Method method = component.clazz.getDeclaredMethod("set_inputColumn_" + string, classArray);
                    Object[] objectArray = new Object[]{new Integer(n)};
                    method.invoke(component.instance, objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new IllegalAccessException(invocationTargetException.getMessage());
                }
            }
        }
    }

    private void problem(Component component, String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("\n");
        Component component2 = component;
        while (component2 != null) {
            stringBuilder.append(" in class ").append(component2.clazz.getCanonicalName()).append(" = " + component2.instance.toString()).append("\n");
            component2 = component2.parent;
        }
        if (this.bExceptionIfnotFound) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.noteError(stringBuilder);
    }

    ChildInstanceAndClass writeInMap(String string, Component component, ZbnfParseResultItem zbnfParseResultItem) {
        Map map = (Map)component.instance;
        String string2 = zbnfParseResultItem.getParsedText();
        map.put(string, string2);
        return null;
    }

    void stop() {
    }

    public static String parseFileAndFillJavaObject(Class clazz, Object object, File file, File file2, MainCmdLogging_ifc mainCmdLogging_ifc, int n) {
        ZbnfJavaOutput zbnfJavaOutput = new ZbnfJavaOutput(mainCmdLogging_ifc);
        return zbnfJavaOutput.parseFileAndFillJavaObject(clazz, object, file, file2);
    }

    public String parseFileAndFillJavaObject(Object object, File file, File file2) {
        return this.parseFileAndFillJavaObject(object.getClass(), object, file, file2);
    }

    public String parseFileAndFillJavaObject(Class clazz, Object object, File file, File file2) {
        String string = null;
        int n = (int)file2.length();
        StringPartScan stringPartScan = null;
        try {
            stringPartScan = new StringPartScan(new StringPartFromFileLines(file2, n, null, null));
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "ZbnfJavaOutput - Syntax file not found; " + file2.getAbsolutePath();
        }
        catch (IOException iOException) {
            string = "ZbnfJavaOutput - Syntax file read problems; " + file2.getAbsolutePath() + " msg = " + iOException.getMessage();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "ZbnfJavaOutput - Syntax file charset problems; " + file2.getAbsolutePath() + " msg = " + illegalArgumentException.getMessage();
        }
        if (string == null && (string = this.parseFileAndFillJavaObject(clazz, object, file, stringPartScan)) != null && string.startsWith("ERROR in syntax")) {
            string = string + " in file " + file2.getAbsolutePath();
        }
        return string;
    }

    public String parseFileAndFillJavaObject(Class clazz, Object object, File file, String string) {
        StringPartScan stringPartScan = new StringPartScan(string);
        return this.parseFileAndFillJavaObject(clazz, object, file, stringPartScan);
    }

    public String parseFileAndFillJavaObject(Object object, File file, String string) {
        StringPartScan stringPartScan = new StringPartScan(string);
        return this.parseFileAndFillJavaObject(object.getClass(), object, file, stringPartScan);
    }

    public String parseFileAndFillJavaObject(Class clazz, Object object, File file, StringPartScan stringPartScan) {
        String string = null;
        StringPartFromFileLines stringPartFromFileLines = null;
        ZbnfParser zbnfParser = null;
        if (string == null) {
            zbnfParser = new ZbnfParser(this.report);
            try {
                zbnfParser.setSyntax(stringPartScan);
            }
            catch (ParseException parseException) {
                string = "ZbnfJavaOutput - ERROR in syntax prescript; " + parseException.getMessage();
            }
        }
        if (string == null) {
            zbnfParser.setReportIdents(1, 3, 6, 6);
            int n = (int)file.length();
            try {
                stringPartFromFileLines = new StringPartFromFileLines(file, n, null, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                string = "ZbnfJavaOutput - Input file not found, " + file.getAbsolutePath();
            }
            catch (IOException iOException) {
                string = "ZbnfJavaOutput - Input file read problems; " + file.getAbsolutePath() + " msg = " + iOException.getMessage();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = "ZbnfJavaOutput - Input file charset problems; " + file.getAbsolutePath() + " msg = " + illegalArgumentException.getMessage();
            }
        }
        if (string == null && stringPartFromFileLines != null) {
            boolean bl = zbnfParser.parse(stringPartFromFileLines);
            if (!bl) {
                String string2 = zbnfParser.getSyntaxErrorReport();
                string = "ZbnfJavaOutput - ERROR syntax in input file; " + file.getAbsolutePath() + "\n" + string2;
            }
            stringPartFromFileLines.close();
            zbnfParser.reportStore(this.report, 5);
        }
        if (string == null) {
            System.out.println("ZbnfJavaOutput - fillin;" + clazz.getCanonicalName());
            try {
                this.setContent(clazz, object, zbnfParser.getFirstParseResult());
            }
            catch (IllegalAccessException illegalAccessException) {
                string = "ZbnfJavaOutput - ERROR access to elements;. Hint: The elements should be public!: " + illegalAccessException.getMessage();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = "ZbnfJavaOutput - ERROR access to elements, IllegalArgumentException;: " + illegalArgumentException.getMessage();
            }
            catch (InstantiationException instantiationException) {
                string = "ZbnfJavaOutput - ERROR access to elements, InstantiationException; Hint: Any sub-classes for parse results should be static; " + instantiationException.getMessage();
            }
        }
        return string;
    }

    private void noteError(CharSequence charSequence) {
        if (this.errors == null) {
            this.errors = new StringBuffer();
        }
        this.errors.append('\n').append(charSequence).append('\n');
    }

    private static class ChildInstanceAndClass {
        final Class clazz;
        final Object instance;
        final boolean shouldAdd;

        ChildInstanceAndClass(Object object, Class clazz, boolean bl) {
            this.instance = object;
            this.clazz = clazz;
            this.shouldAdd = bl;
        }
    }

    private static class Component {
        final Object instance;
        final Class clazz;
        final Component parent;

        public Component(Component component, Class clazz, Object object) {
            assert (object != null);
            this.instance = object;
            this.clazz = object.getClass();
            this.parent = component;
        }
    }
}

