/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlSimple;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.mainCmd.Report;
import org.vishia.util.SpecialCharStrings;
import org.vishia.xmlSimple.XmlException;
import org.vishia.xmlSimple.XmlNode;

public class WikistyleTextToSimpleXml {
    final Report report;
    int end = -1;
    int start = 0;
    XmlNode[] xmlNesting = new XmlNode[20];
    ListIterator iterBaseElement;
    XmlNode dstElement;
    String dstNamespace;
    XmlNode xmlChild = null;
    int idxNesting = -1;
    String sClassNesting;
    XmlNode xmlPre = null;
    int preEmptylines = 0;
    TreeMap elementsWithAttrib;

    public WikistyleTextToSimpleXml() {
        this.report = null;
    }

    public WikistyleTextToSimpleXml(Report report) {
        this.report = report;
    }

    public void testXmlTreeAndConvert(XmlNode xmlNode) throws XmlException {
        List list = xmlNode.listChildren();
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            int n = 0;
            while (listIterator.hasNext()) {
                String string;
                Map<String, String> map;
                String string2;
                String string3;
                String string4;
                XmlNode xmlNode2 = (XmlNode)listIterator.next();
                if (xmlNode2.getName().equals("p") && (string4 = xmlNode2.getAttribute("expandWikistyle")) != null) {
                    string3 = xmlNode2.text();
                    string2 = xmlNode2.getAttribute("expandLabelOwn");
                    if (this.report != null) {
                        int n2 = string3.length();
                        if (n2 > 30) {
                            n2 = 30;
                        }
                        this.report.reportln(4, 0, "ConverterWikiStyle:" + string3.substring(0, n2));
                    }
                    xmlNode2.removeAttribute("expandWikistyle");
                    map = xmlNode2.getAttributes();
                    map = null;
                    string = xmlNode2.getAttribute("class");
                    listIterator.remove();
                    this.insertAndConvertText(string3, listIterator, null, map, string, string2);
                } else if (xmlNode2.getAttribute("expandWikistyle") != null) {
                    string3 = xmlNode2.text();
                    string2 = xmlNode2.getAttribute("expandLabelOwn");
                    if (this.report != null) {
                        int n3 = string3.length();
                        if (n3 > 30) {
                            n3 = 30;
                        }
                        this.report.reportln(4, 0, "ConverterWikiStyle:" + string3.substring(0, n3));
                    }
                    xmlNode2.removeAttribute("expandWikistyle");
                    map = xmlNode2.getAttributes();
                    map = null;
                    xmlNode2.removeChildren();
                    string = xmlNode2.getAttribute("class");
                    this.insertAndConvertText(string3, null, xmlNode2, map, string, string2);
                } else {
                    this.testXmlTreeAndConvert(xmlNode2);
                }
                ++n;
            }
        }
    }

    public void setWikistyleFormat(String string, XmlNode xmlNode, Map map, String string2) throws XmlException {
        this.insertAndConvertText(string, null, xmlNode, map, string2, null);
    }

    private void insertAndConvertText(String string, ListIterator listIterator, XmlNode xmlNode, Map map, String string2, String string3) throws XmlException {
        this.iterBaseElement = listIterator;
        this.dstElement = xmlNode;
        this.sClassNesting = string2;
        this.start = 0;
        this.end = -1;
        this.idxNesting = -1;
        this.xmlChild = this.initNesting();
        this.elementsWithAttrib = null;
        this.xmlPre = null;
        this.dstNamespace = xmlNode != null ? xmlNode.getNamespaceKey() : null;
        this.xmlChild = this.initNesting();
        block4: while (this.start < string.length()) {
            String string4;
            String string5;
            char c = string.charAt(this.start);
            if (this.xmlPre != null && c == '\n' || c == '\r') {
                ++this.preEmptylines;
                this.end = string.indexOf("\n", this.start);
                this.start = this.end + 1;
                continue;
            }
            if (c == ' ' || c == '\t' || c == ',') {
                this.end = string.indexOf("\n", this.start);
                if (this.end < 0) {
                    this.end = string.length();
                }
                if (this.start >= this.end) continue;
                string5 = string.substring(this.start, this.end);
                string4 = this.replaceTabs(string5);
                this.start = this.end + 1;
                this.xmlChild = this.initNesting();
                if (this.xmlPre == null) {
                    TreeMap treeMap;
                    this.xmlPre = xmlNode.createNode("pre", this.dstNamespace);
                    if (listIterator != null) {
                        listIterator.add(this.xmlPre);
                    }
                    if (this.xmlChild != null) {
                        this.xmlChild.addContent(this.xmlPre);
                    }
                    if (this.elementsWithAttrib != null && (treeMap = (TreeMap)this.elementsWithAttrib.get("pre")) != null) {
                        for (String string6 : treeMap.keySet()) {
                            String string7 = (String)treeMap.get(string6);
                            this.xmlPre.setAttribute(string6, string7);
                        }
                    }
                } else {
                    while (this.preEmptylines > 0) {
                        this.xmlPre.addContent("\n");
                        --this.preEmptylines;
                    }
                }
                this.xmlPre.addContent(string4.substring(1) + "\n");
                continue;
            }
            string5 = this.getLineSpecial(string);
            if (string5.length() <= 0) continue;
            string4 = this.replaceTabs(string5);
            c = string4.charAt(0);
            switch (c) {
                case '!': 
                case '#': 
                case '*': 
                case ':': 
                case ';': 
                case '>': 
                case '{': 
                case '|': {
                    if ((string4 = this.nestingLevel(string4, this.idxNesting + 1, listIterator, xmlNode, this.dstNamespace, string2)).length() <= 0) continue block4;
                    if (this.xmlChild.getName().equals("dt")) {
                        this.convertLine(string4, this.xmlChild, this.dstNamespace, string3);
                        continue block4;
                    }
                    this.writeParagraphInElement(string4, this.xmlChild, this.dstNamespace, map, this.sClassNesting == null ? null : this.sClassNesting, string3);
                    continue block4;
                }
                case '@': {
                    this.readAttributes(string4);
                    continue block4;
                }
            }
            this.xmlChild = this.initNesting();
            this.xmlPre = null;
            this.preEmptylines = 0;
            this.writeParagraphInIter(string4, listIterator, this.xmlChild, this.dstNamespace, map, string2, string3);
        }
        this.idxNesting = -1;
        this.initNesting();
        this.xmlChild = null;
        this.elementsWithAttrib = null;
        this.iterBaseElement = null;
        xmlNode = null;
        this.xmlPre = null;
    }

    private final String replaceTabs(String string) {
        int n = 0;
        int n2 = string.indexOf(9);
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder(2 * string.length());
            while (n2 >= 0) {
                stringBuilder.append(string.substring(n, n2)).append("  ");
                n = n2 + 1;
                n2 = string.indexOf(9, n);
            }
            stringBuilder.append(string.substring(n));
            return stringBuilder.toString();
        }
        return string;
    }

    private void convertLine(String string, XmlNode xmlNode, String string2, String string3) throws XmlException {
        int n = 0;
        int n2 = -1;
        if (string.startsWith(",,%%%,,code")) {
            this.stop();
        }
        while (n < string.length()) {
            Object object;
            Object object2;
            int n3 = 0;
            int n4 = string.length();
            int n5 = string.indexOf("'''''", n);
            if (n5 >= 0) {
                n3 = 3;
                n4 = n5;
                n2 = n4 + 5;
            }
            if ((n5 = string.substring(n, n4).indexOf("'''")) >= 0) {
                n3 = 1;
                n4 = n + n5;
                n2 = n4 + 3;
            }
            if ((n5 = string.substring(n, n4).indexOf("''")) >= 0) {
                n3 = 2;
                n4 = n + n5;
                n2 = n4 + 2;
            }
            if ((n5 = string.substring(n, n4).indexOf(",,")) >= 0) {
                n3 = 10;
                n4 = n + n5;
                n2 = n4 + 2;
            }
            if ((n5 = string.substring(n, n4).indexOf("[[")) >= 0) {
                n4 = n + n5;
                if (string.substring(n4).startsWith("[[Inset:")) {
                    n3 = 9;
                    n2 = n4 + 8;
                } else if (string.substring(n4).startsWith("[[Image:")) {
                    n3 = 8;
                    n2 = n4 + 8;
                } else if (string.substring(n4).startsWith("[[http:")) {
                    n3 = 5;
                    n2 = n4 + 2;
                } else if (string.substring(n4).startsWith("[[!")) {
                    n3 = 5;
                    n2 = n4 + 3;
                } else if (string.substring(n4).startsWith("[[&")) {
                    n3 = 6;
                    n2 = n4 + 3;
                } else {
                    n3 = 4;
                    n2 = n4 + 2;
                }
            }
            if (n4 > n) {
                object2 = string.substring(n, n4);
                object = SpecialCharStrings.resolveCircumScription((CharSequence)object2);
                xmlNode.addContent(object.toString());
            }
            switch (n3) {
                case 3: {
                    n4 = string.indexOf("'''''", n2);
                    n5 = n4 >= 0 ? n4 + 5 : (n4 = string.length());
                    if (n4 <= n2) break;
                    object2 = xmlNode.addNewNode("stroke", string2);
                    object = object2.addNewNode("em", string2);
                    this.convertLine(string.substring(n2, n4), (XmlNode)object, string2, string3);
                    break;
                }
                case 1: {
                    n4 = string.indexOf("'''", n2);
                    n5 = n4 >= 0 ? n4 + 3 : (n4 = string.length());
                    if (n4 <= n2) break;
                    object2 = xmlNode.addNewNode("stroke", string2);
                    this.convertLine(string.substring(n2, n4), (XmlNode)object2, string2, string3);
                    break;
                }
                case 2: {
                    n4 = string.indexOf("''", n2);
                    n5 = n4 >= 0 ? n4 + 2 : (n4 = string.length());
                    if (n4 <= n2) break;
                    object2 = xmlNode.createNode("em", string2);
                    xmlNode.addContent((XmlNode)object2);
                    this.convertLine(string.substring(n2, n4), (XmlNode)object2, string2, string3);
                    break;
                }
                case 10: {
                    n4 = string.indexOf(",,", n2);
                    while (n4 >= 3 && string.substring(n4 - 3, n4).equals("%%%")) {
                        n4 = string.indexOf(",,", n4 + 2);
                    }
                    n5 = n4 >= 0 ? n4 + 2 : (n4 = string.length());
                    if (n4 <= n2) break;
                    object2 = xmlNode.createNode("code", string2);
                    xmlNode.addContent((XmlNode)object2);
                    this.convertLine(string.substring(n2, n4), (XmlNode)object2, string2, string3);
                    break;
                }
                case 4: 
                case 5: {
                    int n6;
                    int n7;
                    int n8 = string.indexOf("|", n2);
                    n4 = string.indexOf("]]", n2);
                    n5 = n4 >= 0 ? n4 + 2 : (n4 = string.length());
                    if (n8 < 0 || n8 > n4) {
                        n7 = n2;
                        n8 = n4;
                    } else {
                        n7 = n8 + 1;
                    }
                    if (n4 <= n2) break;
                    XmlNode xmlNode2 = xmlNode.createNode("a", string2);
                    xmlNode.addContent(xmlNode2);
                    String string4 = string.substring(n2, n8);
                    if (string3 != null && (n6 = string4.indexOf(126)) >= 0) {
                        string4 = string4.substring(0, n6) + string3 + string4.substring(n6 + 1);
                    }
                    if (n3 == 5) {
                        xmlNode2.setAttribute("href", string4);
                    } else {
                        xmlNode2.setAttribute("href", "#" + string4);
                    }
                    this.convertLine(string.substring(n7, n4), xmlNode2, string2, string3);
                    break;
                }
                case 6: {
                    int n9;
                    int n6;
                    int n10 = string.indexOf("|", n2);
                    n4 = string.indexOf("]]", n2);
                    n5 = n4 >= 0 ? n4 + 2 : (n4 = string.length());
                    if (n10 < 0 || n10 > n4) {
                        n9 = n2;
                        n10 = n4;
                    } else {
                        n9 = n10 + 1;
                    }
                    if (n4 <= n2) break;
                    XmlNode xmlNode2 = xmlNode.createNode("span", string2);
                    xmlNode.addContent(xmlNode2);
                    String string5 = string.substring(n2, n10);
                    if (string3 != null && (n6 = string5.indexOf(126)) >= 0) {
                        string5 = string5.substring(0, n6) + string3 + string5.substring(n6 + 1);
                    }
                    xmlNode2.setAttribute("class", "anchor");
                    xmlNode2.setAttribute("id", string5);
                    this.convertLine(string.substring(n9, n4), xmlNode2, string2, string3);
                    break;
                }
                case 8: {
                    n4 = string.indexOf("]]", n2);
                    n5 = n4 >= 0 ? n4 + 2 : (n4 = string.length());
                    object2 = string.substring(n2, n4);
                    object = ((String)object2).split("\\|");
                    XmlNode xmlNode2 = xmlNode.createNode("img", string2);
                    xmlNode.addContent(xmlNode2);
                    xmlNode2.setAttribute("src", object[0]);
                    if (((String[])object).length > 1) {
                        xmlNode2.setAttribute("title", object[((String[])object).length - 1]);
                    }
                    for (int i = 1; i < ((String[])object).length - 1; ++i) {
                        String string6 = object[i];
                        if (string6.equals("left") || string6.equals("right") || string6.equals("center")) {
                            xmlNode2.setAttribute("align", string6);
                            continue;
                        }
                        int n11 = string6.indexOf("px");
                        if (n11 <= 0) continue;
                        int n12 = string6.indexOf(120);
                        int n13 = -1;
                        int n14 = -1;
                        if (n12 > 0 && n12 < n11) {
                            xmlNode2.setAttribute("width", string6.substring(0, n12));
                        } else if (n12 >= n11) {
                            xmlNode2.setAttribute("width", string6.substring(0, n11));
                        }
                        if (n12 < 0 || n12 >= n11) continue;
                        xmlNode2.setAttribute("height", string6.substring(n12 + 1, n11));
                    }
                    break;
                }
                case 9: {
                    n5 = this.setInset(string, n2, xmlNode, "span");
                    break;
                }
                case 0: {
                    n5 = string.length();
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected case on switch");
                }
            }
            n = n5;
        }
    }

    private String getLineSpecial(String string) {
        String string2 = "";
        boolean bl = true;
        boolean bl2 = false;
        while (!bl2 && bl) {
            int n;
            this.end = string.indexOf("\n", this.start);
            int n2 = string.indexOf("!!", this.start);
            int n3 = string.indexOf("||", this.start);
            if (this.end < 0) {
                this.end = string.length();
                bl = false;
            }
            if (n2 >= 0 && n2 < this.end) {
                this.end = n2;
                bl2 = true;
            }
            if (n3 >= 0 && n3 < this.end) {
                this.end = n3;
                bl2 = true;
            }
            for (n = this.end; n > 0 && " \t\r".indexOf(string.charAt(n - 1)) >= 0; --n) {
            }
            if (string2.length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + string.substring(this.start, n);
            this.start = bl2 ? ++this.end : this.end + 1;
            bl = this.start < string.length() && " \t,>+*#;:@{!|\r\n".indexOf(string.charAt(this.start)) < 0;
        }
        return string2;
    }

    private String nestingLevel(String string, int n, ListIterator listIterator, XmlNode xmlNode, String string2, String string3) throws XmlException {
        boolean bl;
        char c = string.charAt(0);
        int n2 = string.length() >= 2 ? (int)string.charAt(1) : 32;
        int n3 = 1;
        String string4 = null;
        String string5 = null;
        Object var12_13 = null;
        switch (c) {
            case '*': {
                string4 = "ul";
                string5 = "li";
                break;
            }
            case '#': {
                string4 = "ol";
                string5 = "li";
                break;
            }
            case ';': {
                string4 = "dl";
                string5 = "dt";
                break;
            }
            case ':': {
                string4 = "dl";
                string5 = "dd";
                break;
            }
            case '>': {
                string4 = null;
                string5 = null;
                n3 = this.checkInsertNesting_div(string, n, string3);
                break;
            }
            case '{': {
                if (n2 == 124) {
                    this.idxNesting = n;
                    n3 = 2;
                    this.newChild("table");
                    break;
                }
                string5 = null;
                break;
            }
            case '!': 
            case '|': {
                if (n2 == 45) {
                    string5 = null;
                    n3 = 2;
                    if (this.getTagNesting(this.idxNesting - 1).equals("tr")) {
                        --this.idxNesting;
                    } else if (this.getTagNesting(this.idxNesting).equals("table")) {
                        ++this.idxNesting;
                    }
                    this.newChild("tr");
                    break;
                }
                if (n2 == 125) {
                    string5 = null;
                    n3 = 2;
                    bl = true;
                    for (int i = this.idxNesting; bl && i >= this.idxNesting - 2; --i) {
                        if (!this.getTagNesting(i).equals("table")) continue;
                        this.idxNesting = i - 1;
                        bl = false;
                        this.xmlChild = this.initNesting();
                    }
                    n = this.idxNesting;
                    break;
                }
                if (this.getTagNesting(this.idxNesting).equals("table")) {
                    ++this.idxNesting;
                    this.newChild("tr");
                    ++this.idxNesting;
                } else if (this.getTagNesting(this.idxNesting).equals("tr")) {
                    ++this.idxNesting;
                }
                if (this.idxNesting < 0) break;
                this.newChild(c == '!' ? "th" : "td");
                break;
            }
            default: {
                string5 = "xdiv";
            }
        }
        if (string4 != null) {
            bl = this.checkInsertNestingTag(string4, n, string3);
            if (string5 != null) {
                if (bl || this.xmlNesting[++n] == null || "*#;:+>".indexOf(n2) < 0) {
                    TreeMap treeMap;
                    this.xmlChild = this.xmlNesting[n] = xmlNode.createNode(string5, string2);
                    this.addToParentList(n - 1, this.xmlNesting[n]);
                    if (string3 != null) {
                        this.sClassNesting = string3;
                        this.xmlChild.setAttribute("class", this.sClassNesting);
                    }
                    if (this.elementsWithAttrib != null && (treeMap = (TreeMap)this.elementsWithAttrib.get(string5)) != null) {
                        for (String string6 : treeMap.keySet()) {
                            String string7 = (String)treeMap.get(string6);
                            this.xmlChild.setAttribute(string6, string7);
                            if (!string6.equals("class")) continue;
                            this.sClassNesting = string7;
                        }
                    }
                }
                this.xmlChild = this.xmlNesting[n];
            }
        }
        if ("*#;:".indexOf(n2) >= 0 && n < 6) {
            return this.nestingLevel(string.substring(1), n + 1, listIterator, xmlNode, string2, this.sClassNesting);
        }
        for (int i = n + 1; i < this.xmlNesting.length; ++i) {
            this.xmlNesting[i] = null;
            this.xmlPre = null;
        }
        if (n2 == 43) {
            ++n3;
        }
        while (string.length() > n3 && string.charAt(n3) == ' ') {
            ++n3;
        }
        return string.substring(n3);
    }

    boolean checkInsertNestingTag(String string, int n, String string2) throws XmlException {
        boolean bl;
        boolean bl2 = bl = this.xmlNesting[n] == null || !this.xmlNesting[n].getName().equals(string);
        if (bl) {
            XmlNode xmlNode = this.dstElement.createNode(string, this.dstNamespace);
            this.addToParentList(n - 1, xmlNode);
            if (string2 != null) {
                this.sClassNesting = string2;
                xmlNode.setAttribute("class", this.sClassNesting);
            }
            this.xmlNesting[n] = xmlNode;
        }
        return bl;
    }

    int checkInsertNesting_div(String string, int n, String string2) throws XmlException {
        this.checkInsertNestingTag("div", n, string2);
        XmlNode xmlNode = this.xmlNesting[n];
        int n2 = 1;
        int n3 = string.length();
        if (string.startsWith(">@")) {
            // empty if block
        }
        if (n3 > n2 + 2 && string.substring(n2, n3).startsWith("[[inset:")) {
            n2 = this.setInset(string, n2 + 8, xmlNode, "p");
        }
        return n2;
    }

    private String getTagNesting(int n) {
        XmlNode xmlNode;
        String string = n < 0 ? "" : ((xmlNode = this.xmlNesting[n]) != null ? xmlNode.getName() : "");
        return string;
    }

    private void newChild(String string) throws XmlException {
        this.xmlNesting[this.idxNesting] = this.xmlChild = this.dstElement.createNode(string, this.dstNamespace);
        this.addToParentList(this.idxNesting - 1, this.xmlChild);
        this.initNesting();
    }

    private void addToParentList(int n, XmlNode xmlNode) throws XmlException {
        if (n < 0) {
            if (this.iterBaseElement != null) {
                this.iterBaseElement.add(xmlNode);
            }
            if (this.dstElement != null) {
                this.dstElement.addContent(xmlNode);
            }
        } else {
            this.xmlNesting[n].addContent(xmlNode);
        }
    }

    int setInset(String string, int n, XmlNode xmlNode, String string2) throws XmlException {
        int n2 = string.indexOf("]]", n);
        int n3 = n2 >= 0 ? n2 + 2 : (n2 = string.length());
        String string3 = string.substring(n, n2);
        String[] stringArray = string3.split("\\|");
        XmlNode xmlNode2 = xmlNode.createNode(string2, this.dstNamespace);
        xmlNode.addContent(xmlNode2);
        xmlNode2.setAttribute("class", "inset");
        xmlNode2.setAttribute("title", stringArray[0]);
        if (stringArray.length > 1) {
            xmlNode2.addContent(stringArray[stringArray.length - 1]);
        }
        return n3;
    }

    String readAttributeSetting(String string, int n) {
        return null;
    }

    String getAttributeName(String string) {
        return null;
    }

    String getAttributeValue(String string) {
        return null;
    }

    void readAttributes(String string) {
        int n = 0;
        while (n >= 0 && string.length() > n && string.charAt(n) == '@') {
            int n2 = string.indexOf(46, n);
            if (n2 > 0) {
                String string2 = string.substring(n + 1, n2);
                int n3 = string.indexOf(61, n2);
                if (n3 > 0) {
                    TreeMap<String, String> treeMap;
                    String string3;
                    String string4 = string.substring(n2 + 1, n3);
                    int n4 = string.indexOf(34, n3 + 2);
                    int n5 = string.indexOf(64, n3 + 1);
                    String string5 = string3 = n4 > 0 && (n5 < 0 || n4 < n5) ? string.substring(n3 + 2, n4) : null;
                    if (this.elementsWithAttrib == null) {
                        this.elementsWithAttrib = new TreeMap();
                    }
                    if ((treeMap = (TreeMap<String, String>)this.elementsWithAttrib.get(string2)) == null) {
                        treeMap = new TreeMap<String, String>();
                        this.elementsWithAttrib.put(string2, treeMap);
                    }
                    if (string3 == null) {
                        treeMap.remove(string4);
                    } else {
                        treeMap.put(string4, string3);
                    }
                }
            }
            n = string.indexOf(64, n + 1);
        }
    }

    private XmlNode initNesting() {
        for (int i = this.idxNesting + 1; i < this.xmlNesting.length; ++i) {
            this.xmlNesting[i] = null;
        }
        return this.idxNesting < 0 ? this.dstElement : this.xmlNesting[this.idxNesting];
    }

    private void writeParagraphInIter(String string, ListIterator listIterator, XmlNode xmlNode, String string2, Map map, String string3, String string4) throws XmlException {
        String string5;
        Object object;
        XmlNode xmlNode2 = xmlNode.createNode("p", string2);
        if (listIterator != null) {
            listIterator.add(xmlNode2);
        }
        if (xmlNode != null) {
            xmlNode.addContent(xmlNode2);
        }
        if (map != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String string6 = (String)entry.getKey();
                string5 = (String)entry.getValue();
                if (string6.equals("expandWikistyle")) continue;
                xmlNode2.setAttribute(string6, string5);
            }
        }
        if (string3 != null) {
            xmlNode2.setAttribute("class", string3);
        }
        if (this.elementsWithAttrib != null && (object = (TreeMap)this.elementsWithAttrib.get("p")) != null) {
            for (String string6 : ((TreeMap)object).keySet()) {
                string5 = (String)((TreeMap)object).get(string6);
                xmlNode2.setAttribute(string6, string5);
            }
        }
        this.convertLine(string, xmlNode2, string2, string4);
    }

    private void writeParagraphInElement(String string, XmlNode xmlNode, String string2, Map map, String string3, String string4) throws XmlException {
        XmlNode xmlNode2 = xmlNode.addNewNode("p", string2);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string5 = (String)entry.getKey();
                String string6 = (String)entry.getValue();
                if (string5.equals("expandWikistyle")) continue;
                xmlNode2.setAttribute(string5, string6);
            }
        }
        if (string3 != null) {
            xmlNode2.setAttribute("class", string3);
        }
        this.convertLine(string, xmlNode2, string2, string4);
    }

    private void stop() {
    }
}

