/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlSimple;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.vishia.util.Assert;
import org.vishia.xmlSimple.XmlNode;

public class SimpleXmlOutputter {
    public static final int version = 20121130;
    String newline = "\r\n";
    String sIdent = "\r\n                                                                                            ";

    public void write(OutputStreamWriter outputStreamWriter, XmlNode xmlNode) throws IOException {
        String string = outputStreamWriter.getEncoding();
        Charset charset = Charset.forName(string);
        String string2 = charset.displayName();
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>" + this.newline);
        outputStreamWriter.write("<!-- written with org.vishia.xmlSimple.SimpleXmlOutputter -->");
        this.writeNode(bufferedWriter, xmlNode, 0);
        bufferedWriter.close();
    }

    protected void writeNode(Writer writer, XmlNode xmlNode, int n) throws IOException {
        String string;
        Object object;
        String string2;
        if (n >= 0 && n < this.sIdent.length() / 2) {
            writer.write(this.sIdent.substring(0, 2 + n * 2));
        }
        if ((string2 = xmlNode.getName()).equals("em")) {
            Assert.stop();
        }
        String string3 = xmlNode.getNamespaceKey() != null ? xmlNode.getNamespaceKey() + ":" + string2 : string2;
        assert (!string3.startsWith("@"));
        writer.write(SimpleXmlOutputter.elementStart(string3));
        if (xmlNode.getAttributes() != null) {
            for (Map.Entry<String, String> entry : xmlNode.getAttributes().entrySet()) {
                object = entry.getKey();
                string = entry.getValue();
                writer.write(SimpleXmlOutputter.attribute((String)object, string));
            }
        }
        if (xmlNode.getNamespaces() != null) {
            for (Map.Entry<String, String> entry : xmlNode.getNamespaces().entrySet()) {
                object = entry.getKey();
                string = entry.getValue();
                writer.write(SimpleXmlOutputter.attribute("xmlns:" + (String)object, string));
            }
        }
        Iterator<Map.Entry<String, String>> iterator = xmlNode.iterChildren();
        boolean bl = false;
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (XmlNode)((Object)iterator.next());
                if (object.isTextNode()) {
                    if (!bl) {
                        writer.write(SimpleXmlOutputter.elementTagEnd());
                        bl = true;
                    }
                    writer.write(SimpleXmlOutputter.convertString(object.text()).toString());
                    n = -1;
                    continue;
                }
                if (object.getName().startsWith("@")) continue;
                if (!bl) {
                    writer.write(SimpleXmlOutputter.elementTagEnd());
                    bl = true;
                }
                this.writeNode(writer, (XmlNode)object, n >= 0 ? n + 1 : -1);
            }
        } else {
            object = xmlNode.text();
            if (object != null) {
                writer.write(SimpleXmlOutputter.elementTagEnd());
                bl = true;
                writer.write(SimpleXmlOutputter.convertString((String)object).toString());
            }
        }
        if (bl) {
            writer.write(SimpleXmlOutputter.elementEnd(string3));
        } else {
            writer.write(SimpleXmlOutputter.elementShortEnd());
        }
    }

    public static String elementStart(String string) {
        return "<" + string + " ";
    }

    public static String elementTagEnd() {
        return ">";
    }

    public static String elementShortEnd() {
        return "/>";
    }

    public static String elementEnd(String string) {
        return "</" + string + ">";
    }

    public static String attribute(String string, String string2) {
        return string + "=\"" + SimpleXmlOutputter.convertString(string2) + "\" ";
    }

    public static CharSequence convertString(String string) {
        StringBuilder[] stringBuilderArray = new StringBuilder[1];
        String[] stringArray = new String[]{string};
        int n = stringArray[0].indexOf(38);
        if (n >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '&', "&amp;");
        }
        if ((n = stringArray[0].indexOf(60)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '<', "&lt;");
        }
        if ((n = stringArray[0].indexOf(62)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '>', "&gt;");
        }
        if ((n = stringArray[0].indexOf(34)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\"', "&quot;");
        }
        if ((n = stringArray[0].indexOf(39)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\'', "&apos;");
        }
        if ((n = stringArray[0].indexOf(10)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\n', "&#x0a;");
        }
        if ((n = stringArray[0].indexOf(13)) >= 0) {
            SimpleXmlOutputter.convert(stringBuilderArray, stringArray, n, '\n', "&#x0d;");
        }
        if (stringBuilderArray[0] == null) {
            return string;
        }
        return stringBuilderArray[0];
    }

    private static void convert(StringBuilder[] stringBuilderArray, String[] stringArray, int n, char c, String string) {
        if (stringBuilderArray[0] == null) {
            stringBuilderArray[0] = new StringBuilder(stringArray[0]);
        }
        do {
            stringBuilderArray[0].replace(n, n + 1, string);
            stringArray[0] = stringBuilderArray[0].toString();
        } while ((n = stringArray[0].indexOf(c, n + string.length())) >= 0);
    }
}

