/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.Closeable;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;

public class ThreadRun
implements Closeable {
    public static final int version = 538120721;
    private final Thread thread;
    private final String name;
    protected boolean stopThread;
    private boolean runThread;
    private boolean bThreadWaits;
    private boolean bIsNotified;
    private int waitMillisec = 100;
    protected int ctTimeoverflow;
    protected int stepTimeMeasure;
    protected float stepTimeMeasureMid;
    private final int cycletime;
    private int nextCycle;
    private final Step step;
    private final Runnable run = new Runnable(){

        @Override
        public void run() {
            ThreadRun.this.run();
        }
    };

    public ThreadRun(String string, Step step, int n) {
        this.thread = new Thread(this.run, string);
        this.name = string;
        this.step = step;
        this.cycletime = n;
    }

    public void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStep(boolean bl) {
        ThreadRun threadRun = this;
        synchronized (threadRun) {
            if (this.bThreadWaits) {
                this.bIsNotified = true;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.runThread = false;
        ThreadRun threadRun = this;
        synchronized (threadRun) {
            if (this.bThreadWaits) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        int n;
        this.runThread = true;
        this.nextCycle = n = (int)System.currentTimeMillis();
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.step.start(this.cycletime);
        while (this.runThread) {
            int n8;
            n = (int)System.currentTimeMillis();
            int n9 = n - n2;
            if (n7 < 0) {
                this.waitMillisec = this.nextCycle - n;
                if (this.waitMillisec > 5 * this.cycletime || this.waitMillisec < -this.cycletime) {
                    System.out.printf("ThreadRun name=" + this.name + " - new time synchronization; %d; ctOk=%d; ctless0=%d; ctNowait=%d;\n", new Integer(this.waitMillisec), new Integer(n5), new Integer(n4), new Integer(n6));
                    n6 = 0;
                    n4 = 0;
                    n5 = 0;
                    ++n3;
                    this.waitMillisec = this.cycletime;
                    this.nextCycle = n + this.cycletime;
                    Debugutil.stop();
                } else if (this.waitMillisec <= 0) {
                    this.waitMillisec = this.cycletime / 16 + 1;
                    ++this.ctTimeoverflow;
                    this.waitMillisec = this.cycletime;
                    if (this.waitMillisec < 50) {
                        System.out.printf("ThreadRun name=" + this.name + "- less 50 ms;\n", new Integer(this.waitMillisec));
                        this.waitMillisec = 50;
                    }
                    n5 = 0;
                    ++n4;
                    this.nextCycle = n;
                } else {
                    ++n5;
                    this.stepTimeMeasure = this.cycletime - this.waitMillisec;
                    this.stepTimeMeasureMid += 0.01f * ((float)this.stepTimeMeasure - this.stepTimeMeasureMid);
                }
            } else {
                this.nextCycle = n + n7;
                this.waitMillisec = n7;
            }
            this.nextCycle += this.cycletime;
            ThreadRun threadRun = this;
            synchronized (threadRun) {
                if (this.waitMillisec > 0) {
                    this.bIsNotified = false;
                    this.bThreadWaits = true;
                    try {
                        this.wait(this.waitMillisec);
                    }
                    catch (InterruptedException interruptedException) {
                        ++n6;
                    }
                    this.bThreadWaits = false;
                } else {
                    Assert.stop();
                }
            }
            if (!this.runThread) continue;
            long l = System.currentTimeMillis();
            int n10 = (int)l - n;
            if (n10 < this.cycletime / 2) {
                Debugutil.stop();
            }
            n = (int)l;
            if (this.bIsNotified) {
                this.nextCycle = n + this.cycletime;
            }
            if ((n8 = n - n2) < this.cycletime / 2) {
                Debugutil.stop();
            }
            try {
                n2 = n;
                n7 = this.step.step(this.cycletime, n8, n9, l);
            }
            catch (Throwable throwable) {
                System.err.println(Assert.exceptionInfo("ThreadRun name=" + this.thread.getName() + " - unexpected Exception; ", throwable, 0, 7));
                throwable.printStackTrace(System.err);
            }
        }
    }

    public static interface Step {
        public int start(int var1);

        public int step(int var1, int var2, int var3, long var4);
    }
}

