/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.text.ParseException;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;

public class StringPartScan
extends StringPart {
    public static final int version = 20131027;
    protected int beginScan;
    protected final long[] nLastIntegerNumber = new long[5];
    private int idxLastIntegerNumber = -1;
    protected final double[] nLastFloatNumber = new double[5];
    private int idxLastFloatNumber = -1;
    protected CharSequence sLastString;

    public StringPartScan(CharSequence charSequence, int n, int n2) {
        super(charSequence, n, n2);
    }

    public StringPartScan(CharSequence charSequence) {
        super(charSequence);
    }

    public StringPartScan() {
    }

    public final StringPartScan scanSkipSpace() {
        this.seekNoWhitespace();
        return this;
    }

    public final StringPartScan scanSkipComment() {
        this.seekNoWhitespaceOrComments();
        return this;
    }

    public final StringPartScan scanStart() {
        this.bCurrentOk = true;
        this.scanOk();
        return this;
    }

    private final boolean scanEntry() {
        if (this.bCurrentOk) {
            this.seekNoWhitespaceOrComments();
            if (this.bStartScan) {
                this.idxLastIntegerNumber = -1;
                this.bStartScan = false;
            }
            if (this.begin == this.end) {
                this.bCurrentOk = false;
            }
        }
        return this.bCurrentOk;
    }

    public final boolean scanOk() {
        if (this.bCurrentOk) {
            this.beginScan = this.beginLast = this.begin;
            this.bStartScan = true;
        } else {
            this.begin = this.beginLast = this.beginScan;
        }
        boolean bl = this.bCurrentOk;
        this.bCurrentOk = true;
        return bl;
    }

    public final StringPartScan scan(CharSequence charSequence) {
        if (this.bCurrentOk) {
            CharSequence charSequence2;
            boolean bl;
            this.seekNoWhitespaceOrComments();
            int n = StringFunctions.indexOf(charSequence, '\u0003', 0);
            boolean bl2 = bl = n >= 0;
            if (bl) {
                charSequence2 = charSequence.subSequence(0, n);
            } else {
                n = charSequence.length();
                charSequence2 = charSequence;
            }
            if (this.begin + n <= this.endMax && StringFunctions.equals(this.content, this.begin, this.begin + n, charSequence2) && (!bl || this.begin + n == this.end)) {
                this.begin += n;
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    public final StringPartScan scanQuotion(CharSequence charSequence, String string, String[] stringArray) {
        return this.scanQuotion(charSequence, string, stringArray, Integer.MAX_VALUE);
    }

    public final StringPartScan scanQuotion(CharSequence charSequence, String string, String[] stringArray, int n) {
        if (this.scanEntry()) {
            this.scan(charSequence).lentoNonEscapedString(string, n);
            if (this.bCurrentOk) {
                if (stringArray != null) {
                    stringArray[0] = this.getCurrentPart().toString();
                }
                this.fromEnd().seek(string.length());
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    private final long scanDigits(boolean bl, int n) {
        if (this.bCurrentOk) {
            int n2;
            long l = 0L;
            boolean bl2 = true;
            int n3 = this.begin;
            int n4 = n2 = this.end - n3 < n ? this.end : n3 + n;
            do {
                if (n3 < n2) {
                    char c = this.content.charAt(n3);
                    if (c >= '0' && c <= '9') {
                        l = l * (long)(bl ? 16 : 10) + (long)(c - 48);
                    } else if (bl && c >= 'a' && c <= 'f') {
                        l = l * 16L + (long)(c - 97 + 10);
                    } else if (bl && c >= 'A' && c <= 'F') {
                        l = l * 16L + (long)(c - 65 + 10);
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    ++n3;
                    continue;
                }
                bl2 = false;
            } while (bl2);
            if (n3 > this.begin) {
                this.begin = n3;
                return l;
            }
            this.bCurrentOk = false;
        }
        return -1L;
    }

    public final StringPartScan scanPositivInteger() throws ParseException {
        if (this.scanEntry()) {
            long l = this.scanDigits(false, Integer.MAX_VALUE);
            if (this.bCurrentOk) {
                if (this.idxLastIntegerNumber < this.nLastIntegerNumber.length - 2) {
                    this.nLastIntegerNumber[++this.idxLastIntegerNumber] = l;
                } else {
                    throw new ParseException("to much scanned integers", 0);
                }
            }
        }
        return this;
    }

    public final StringPartScan scanInteger() throws ParseException {
        if (this.scanEntry()) {
            boolean bl = false;
            if (this.content.charAt(this.begin) == '-') {
                bl = true;
                this.seek(1);
            }
            long l = this.scanDigits(false, Integer.MAX_VALUE);
            if (bl) {
                l = -l;
            }
            if (this.bCurrentOk) {
                if (this.idxLastIntegerNumber < this.nLastIntegerNumber.length - 2) {
                    this.nLastIntegerNumber[++this.idxLastIntegerNumber] = l;
                } else {
                    throw new ParseException("to much scanned integers", 0);
                }
            }
        }
        return this;
    }

    public final StringPartScan scanFloatNumber(boolean bl) throws ParseException {
        if (bl) {
            this.idxLastFloatNumber = -1;
        }
        this.scanFloatNumber();
        return this;
    }

    public final StringPartScan scanFloatNumber() throws ParseException {
        if (this.scanEntry()) {
            boolean bl = false;
            char c = this.content.charAt(this.begin);
            if (c == '-') {
                bl = true;
                this.seek(1);
            }
            long l = this.scanDigits(false, Integer.MAX_VALUE);
            if (this.bCurrentOk) {
                if (bl) {
                    l = -l;
                }
                this.scanFractionalNumber(l);
                if (!this.bCurrentOk) {
                    this.bCurrentOk = true;
                    if (this.idxLastFloatNumber < this.nLastFloatNumber.length - 2) {
                        this.nLastFloatNumber[++this.idxLastFloatNumber] = l;
                    } else {
                        throw new ParseException("to much scanned floats", 0);
                    }
                }
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final StringPartScan scanFractionalNumber(long l) throws ParseException {
        char c;
        if (!this.scanEntry()) return this;
        long l2 = 0L;
        int n = 1;
        int n2 = 0;
        boolean bl = false;
        int n3 = this.begin;
        if (this.begin < this.endMax && this.content.charAt(this.begin) == '.') {
            this.seek(1);
            while (this.begin < this.endMax && this.getCurrentChar() == '0') {
                this.seek(1);
                n *= 10;
            }
            l2 = this.scanDigits(false, Integer.MAX_VALUE);
            if (!this.bCurrentOk && n >= 10) {
                this.bCurrentOk = true;
                l2 = 0L;
            }
        }
        int n4 = this.begin;
        if (this.bCurrentOk && n4 < this.endMax && ((c = this.content.charAt(this.begin)) == 'e' || c == 'E')) {
            this.seek(1);
            c = this.content.charAt(this.begin);
            if (c == '-') {
                bl = true;
                this.seek(1);
                c = this.content.charAt(this.begin);
            }
            if (c >= '0' && c <= '9') {
                n2 = (int)this.scanDigits(false, Integer.MAX_VALUE);
                if (!this.bCurrentOk) {
                    n2 = 0;
                    assert (false);
                }
            } else {
                this.begin = n4;
                n2 = 0;
            }
        }
        if (this.begin > n3) {
            double d = l;
            if (l2 > 0L) {
                for (double d2 = (double)l2; d2 >= 1.0; d2 /= 10.0) {
                }
                d += (d2 /= (double)n);
            }
            if (n2 != 0) {
                if (bl) {
                    n2 = -n2;
                }
                d *= Math.pow(10.0, n2);
            }
            if (this.idxLastFloatNumber >= this.nLastFloatNumber.length - 2) throw new ParseException("to much scanned floats", 0);
            this.nLastFloatNumber[++this.idxLastFloatNumber] = d;
            return this;
        } else {
            this.bCurrentOk = false;
        }
        return this;
    }

    public final StringPartScan scanHex(int n) throws ParseException {
        if (this.scanEntry()) {
            long l = this.scanDigits(true, n);
            if (this.bCurrentOk) {
                if (this.idxLastIntegerNumber < this.nLastIntegerNumber.length - 2) {
                    this.nLastIntegerNumber[++this.idxLastIntegerNumber] = l;
                } else {
                    throw new ParseException("to much scanned integers", 0);
                }
            }
        }
        return this;
    }

    public final StringPartScan scanHexOrDecimal(int n) throws ParseException {
        if (this.scanEntry()) {
            long l;
            if (StringFunctions.equals(this.content, this.begin, this.begin + 2, "0x")) {
                this.seek(2);
                l = this.scanDigits(true, n);
            } else {
                l = this.scanDigits(false, n);
            }
            if (this.bCurrentOk) {
                if (this.idxLastIntegerNumber < this.nLastIntegerNumber.length - 2) {
                    this.nLastIntegerNumber[++this.idxLastIntegerNumber] = l;
                } else {
                    throw new ParseException("to much scanned integers", 0);
                }
            }
        }
        return this;
    }

    public final StringPartScan scanIdentifier() {
        return this.scanIdentifier(null, null);
    }

    public final StringPartScan scanIdentifier(String string, String string2) {
        if (this.scanEntry()) {
            this.lentoIdentifier(string, string2);
            if (this.bFound) {
                this.sLastString = this.getCurrentPart();
                this.begin = this.end;
            } else {
                this.bCurrentOk = false;
            }
            this.end = this.endLast;
        }
        return this;
    }

    public final long getLastScannedIntegerNumber() throws ParseException {
        if (this.idxLastIntegerNumber >= 0) {
            return this.nLastIntegerNumber[this.idxLastIntegerNumber--];
        }
        throw new ParseException("no integer number scanned.", 0);
    }

    public final double getLastScannedFloatNumber() throws ParseException {
        if (this.idxLastFloatNumber >= 0) {
            return this.nLastFloatNumber[this.idxLastFloatNumber--];
        }
        throw new ParseException("no float number scanned.", 0);
    }

    public final CharSequence getLastScannedString() {
        return this.sLastString;
    }

    public final CharSequence getCircumScriptionToAnyChar(String string) {
        return this.getCircumScriptionToAnyChar_p(string, false);
    }

    public final CharSequence getCircumScriptionToAnyCharOutsideQuotion(String string) {
        return this.getCircumScriptionToAnyChar_p(string, true);
    }

    private final CharSequence getCircumScriptionToAnyChar_p(String string, boolean bl) {
        char c = bl ? (char)'\"' : '\u0000';
        int n = this.indexOfAnyChar(string, 0, this.end - this.begin, '\\', c, c);
        if (n >= 0) {
            this.lento(n);
            CharSequence charSequence = StringFunctions.convertTransliteration(this.getCurrentPart(), '\\');
            this.fromEnd();
            return charSequence;
        }
        return "";
    }

    public final StringPartScan scanToAnyChar(CharSequence[] charSequenceArray, String string, char c, char c2, char c3) {
        if (this.scanEntry()) {
            int n = this.indexOfAnyChar(string, 0, this.end - this.begin, c, c2, c3);
            if (n >= 0) {
                this.lento(n);
                if (charSequenceArray != null) {
                    charSequenceArray[0] = StringFunctions.convertTransliteration(this.getCurrentPart(), c);
                }
                this.fromEnd();
            } else {
                this.bCurrentOk = false;
            }
        }
        return this;
    }

    @Override
    public void close() {
        super.close();
        this.sLastString = null;
        this.beginScan = 0;
        this.bFound = false;
        this.bCurrentOk = false;
    }
}

