/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.vishia.util.FileSystem;
import org.vishia.util.IntegerBlockArray;
import org.vishia.util.StringPartScan;

public class StringPartFromFileLines
extends StringPartScan {
    public static final int version = 20121222;
    final StringBuilder buffer;
    String sLine = null;
    int nLine = 0;
    int nLineCt = 0;
    boolean bEof;
    final BufferedReader readIn;
    IntegerBlockArray linePositions = new IntegerBlockArray(1000);
    int maxIxLinePosition;

    public StringPartFromFileLines(File file) throws FileNotFoundException, IOException, IllegalCharsetNameException, UnsupportedCharsetException {
        this(file, 0, null, null);
    }

    public StringPartFromFileLines(File file, int n, String string, Charset charset) throws FileNotFoundException, IOException, IllegalCharsetNameException, UnsupportedCharsetException {
        this.setInputfile(FileSystem.normalizePath(file).toString());
        this.bEof = false;
        long l = file.length();
        this.buffer = n <= 0 || l < (long)(n - 10) ? new StringBuilder((int)l) : new StringBuilder(n);
        this.linePositions.set(++this.maxIxLinePosition, 0);
        if (string != null) {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[256];
            int n2 = fileInputStream.read(byArray);
            fileInputStream.close();
            String string2 = new String(byArray, 0, n2);
            int n3 = string2.indexOf(10);
            if (n3 >= 0 && n3 < n2) {
                n3 = string2.indexOf(10, n3 + 1);
            }
            if (n3 < 0) {
                n3 = n2;
            }
            StringPartScan stringPartScan = new StringPartScan(string2.substring(0, n3));
            stringPartScan.setIgnoreWhitespaces(true);
            if (stringPartScan.seek(string, 1).found() && stringPartScan.scan("=").scanOk()) {
                String string3;
                stringPartScan.seekNoWhitespace();
                if (stringPartScan.getCurrentChar() == '\"') {
                    string3 = stringPartScan.seek(1).lentoQuotionEnd('\"', 100).getCurrentPart().toString();
                    if (string3.length() > 0) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                } else {
                    string3 = stringPartScan.lentoIdentifier(null, "-").getCurrentPart().toString();
                }
                if (string3.length() > 0) {
                    charset = Charset.forName(string3);
                }
            }
        }
        this.readIn = charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)) : new BufferedReader(new FileReader(file));
        boolean bl = this.readnextContentFromFile();
        if (this.buffer.length() > 0 && this.buffer.charAt(0) == '\ufeff') {
            this.assign(this.buffer.substring(1));
        } else {
            this.assign(this.buffer);
        }
        if (!bl) {
            this.readIn.close();
        }
    }

    @Override
    public int XXXgetLineCt() {
        int n = this.linePositions.binarySearch(this.begin, this.maxIxLinePosition);
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    @Override
    public int getLineAndColumn(int[] nArray) {
        int n = this.linePositions.binarySearch(this.begin, this.maxIxLinePosition);
        if (n < 0) {
            n = -n - 2;
        }
        if (nArray != null) {
            int n2 = this.linePositions.get(n);
            nArray[0] = this.begin - n2;
        }
        return n;
    }

    boolean readnextContentFromFile() throws IOException {
        boolean bl = false;
        while (!this.bEof && !bl) {
            int n = this.buffer.length();
            int n2 = this.buffer.capacity() - n;
            if (n2 >= this.nLine) {
                int n3;
                if (this.sLine != null) {
                    if (this.nLine > 0) {
                        this.buffer.append(this.sLine.substring(0, this.nLine));
                    }
                    this.buffer.append('\n');
                    this.linePositions.set(++this.maxIxLinePosition, this.buffer.length());
                }
                this.sLine = this.readIn.readLine();
                if (this.sLine == null) {
                    this.bEof = true;
                    this.nLine = 0;
                    continue;
                }
                for (n3 = this.sLine.length() - 1; n3 >= 0 && this.sLine.charAt(n3) == ' '; --n3) {
                }
                this.nLine = n3 + 1;
                continue;
            }
            bl = true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.readIn != null) {
            try {
                this.readIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.nLineCt = 0;
        super.close();
    }
}

