/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.Closeable;
import org.vishia.util.Java4C;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartScan;

public class StringPart
implements CharSequence,
Comparable<CharSequence>,
Closeable {
    public static final String sVersion = "2014-01-12";
    protected int begin;
    protected int end;
    protected int begiMin;
    protected int endMax;
    protected CharSequence content;
    protected boolean bCurrentOk = true;
    protected boolean bStartScan = true;
    protected int beginLast;
    protected int endLast;
    boolean bFound = true;
    public static final int seekEnd = 1;
    private static final int mSeekBackward_ = 16;
    private static final int mSeekToLeft_ = 64;
    public static final int seekToLeft = 80;
    public static final int seekBack = 48;
    public static final int seekNormal = 0;
    protected int bitMode = 0;
    protected static final int mSkipOverWhitespace_mode = 1;
    protected static final int mSkipOverCommentInsideText_mode = 2;
    protected static final int mSkipOverCommentToEol_mode = 4;
    String sFile;
    String sCommentStart = "/*";
    String sCommentEnd = "*/";
    String sCommentToEol = "//";
    public static final char cStartOfText = '\u0002';
    public static final char cEndOfText = '\u0003';

    public StringPart() {
        this.content = null;
        this.beginLast = 0;
        this.begin = 0;
        this.begiMin = 0;
        this.end = 0;
        this.endMax = 0;
        this.endLast = 0;
    }

    public StringPart(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public StringPart(CharSequence charSequence, int n, int n2) {
        this.begiMin = this.begin = n;
        this.endMax = this.end = n2;
        this.content = charSequence;
    }

    public final void setInputfile(String string) {
        this.sFile = string;
    }

    public final StringPart assign(CharSequence charSequence) {
        this.content = charSequence;
        this.setParttoMax();
        return this;
    }

    public final StringPart assignReplaceEnv(StringBuilder stringBuilder) {
        int n = 0;
        int n2 = stringBuilder.length();
        while ((n = stringBuilder.indexOf("$", n)) >= 0) {
            int n3;
            int n4;
            int n5;
            if (stringBuilder.charAt(n + 1) == '(') {
                n5 = n + 2;
                n4 = stringBuilder.indexOf(")", n5);
                n3 = n4 + 1;
            } else {
                n5 = n + 1;
                n4 = n3 = StringFunctions.posAfterIdentifier(stringBuilder, n5, n2);
            }
            String string = System.getenv(stringBuilder.substring(n5, n4));
            if (string == null) {
                string = "";
            }
            stringBuilder.replace(n, n3, string);
            n2 = stringBuilder.length();
        }
        this.content = stringBuilder;
        this.begin = 0;
        this.beginLast = 0;
        this.begiMin = 0;
        this.end = this.endLast = this.content.length();
        this.endMax = this.endLast;
        this.bCurrentOk = true;
        this.bStartScan = true;
        return this;
    }

    public final StringPart assign(StringPart stringPart) {
        if (stringPart == this) {
            this.begiMin = this.beginLast = this.begin;
            this.endMax = this.endLast = this.end;
        } else {
            this.content = stringPart.content;
            this.beginLast = this.begin = stringPart.begin;
            this.begiMin = this.begin;
            this.end = this.endLast = stringPart.end;
            this.endMax = this.endLast;
        }
        return this;
    }

    public final StringPart assignFromEnd(StringPart stringPart) {
        this.content = stringPart.content;
        this.beginLast = this.begin;
        this.begiMin = this.begin = stringPart.end;
        this.endMax = this.end = stringPart.endMax;
        this.endLast = this.end;
        return this;
    }

    public final boolean setIgnoreComment(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.bitMode & 2) != 0;
        this.bitMode = bl ? (this.bitMode |= 2) : (this.bitMode &= 0xFFFFFFFD);
        return bl2;
    }

    public final boolean setIgnoreComment(String string, String string2) {
        boolean bl = (this.bitMode & 2) != 0;
        this.bitMode |= 2;
        this.sCommentStart = string;
        this.sCommentEnd = string2;
        return bl;
    }

    public final boolean setIgnoreEndlineComment(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.bitMode & 4) != 0;
        this.bitMode = bl ? (this.bitMode |= 4) : (this.bitMode &= 0xFFFFFFFB);
        return bl2;
    }

    public final boolean setIgnoreEndlineComment(String string) {
        boolean bl = (this.bitMode & 4) != 0;
        this.bitMode |= 4;
        this.sCommentToEol = string;
        return bl;
    }

    public final boolean setIgnoreWhitespaces(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.bitMode & 1) != 0;
        this.bitMode = bl ? (this.bitMode |= 1) : (this.bitMode &= 0xFFFFFFFE);
        return bl2;
    }

    public final StringPart setBeginMaxPart() {
        this.begiMin = this.begin;
        return this;
    }

    @Java4C.Inline
    public void setParttoMax() {
        this.begin = 0;
        this.beginLast = 0;
        this.begiMin = 0;
        this.end = this.endLast = this.content.length();
        this.endMax = this.endLast;
        this.bCurrentOk = true;
        this.bStartScan = true;
    }

    public final StringPart fromEnd() {
        this.beginLast = this.begin;
        this.endLast = this.end;
        this.begin = this.end;
        this.end = this.endMax;
        return this;
    }

    @Override
    public final char charAt(int n) {
        return this.absCharAt(this.begin + n);
    }

    @Override
    public final Part subSequence(int n, int n2) {
        if (n < 0 || n2 > this.end - this.begin) {
            throw new IllegalArgumentException("StringPartBase.subString - faulty;" + n);
        }
        return new Part(this.begin + n, this.begin + n2);
    }

    @Override
    public final int length() {
        return this.end - this.begin;
    }

    public final int lengthMaxPart() {
        if (this.endMax > this.begin) {
            return this.endMax - this.begin;
        }
        return 0;
    }

    public final StringPart lento(int n) throws IndexOutOfBoundsException {
        this.endLast = this.end;
        int n2 = this.begin + n;
        if (n2 < this.begin) {
            this.throwIndexOutOfBoundsException("lento(int) negative:" + (n2 - this.begin));
        }
        if (n2 > this.endMax) {
            this.throwIndexOutOfBoundsException("lento(int) after endMax:" + (n2 - this.endMax));
        }
        this.end = n2;
        return this;
    }

    public final StringPart lento(char c) {
        this.endLast = this.end;
        this.end = this.begin - 1;
        while (++this.end < this.endLast) {
            if (this.content.charAt(this.end) != c) continue;
            this.bFound = true;
            return this;
        }
        this.end = this.begin;
        this.bFound = false;
        return this;
    }

    public final StringPart lento(String string) {
        return this.lento(string, 0);
    }

    public final StringPart lento(CharSequence charSequence, int n) {
        this.endLast = this.end;
        int n2 = StringFunctions.indexOf(this.content, this.begin, this.end, charSequence);
        boolean bl = this.bFound = n2 >= 0;
        if (n2 >= 0) {
            this.end = n2;
            if ((n & 1) != 0) {
                this.end += charSequence.length();
            }
        } else {
            this.end = this.begin;
        }
        return this;
    }

    public final StringPart lentoIdentifier() {
        return this.lentoIdentifier(null, null);
    }

    public final StringPart lentoIdentifier(String string, String string2) {
        this.endLast = this.end;
        this.end = this.begin;
        if (this.end >= this.endMax) {
            this.bFound = false;
        } else {
            char c = this.content.charAt(this.end);
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || string != null && string.indexOf(c) >= 0) {
                ++this.end;
                while (this.end < this.endMax && ((c = this.content.charAt(this.end)) == '_' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || string2 != null && string2.indexOf(c) >= 0)) {
                    ++this.end;
                }
            }
            this.bFound = this.end > this.begin;
        }
        return this;
    }

    public final StringPart lentoAnyNonEscapedChar(String string, int n) {
        if (this.bCurrentOk) {
            this.endLast = this.end;
            int n2 = this.indexOfAnyChar(string, 0, n);
            while (n2 > this.begin + 1 && this.content.charAt(n2 - 1) == '\\') {
                n2 = this.indexOfAnyChar(string, n2 + 1 - this.begin, n);
            }
            if (n2 < 0) {
                this.end = this.begin;
                this.bFound = false;
            } else {
                this.end = this.begin + n2;
                this.bFound = true;
            }
        }
        return this;
    }

    public final StringPart lentoNonEscapedString(String string, int n) {
        if (this.bCurrentOk) {
            this.endLast = this.end;
            int n2 = this.indexOf(string, 0, n);
            while (n2 > this.begin + 1 && this.content.charAt(n2 - 1) == '\\') {
                n2 = this.indexOf(string, n2 + 1 - this.begin, n);
            }
            if (n2 < 0) {
                this.end = this.begin;
                this.bFound = false;
            } else {
                this.end = this.begin + n2;
                this.bFound = true;
            }
        }
        return this;
    }

    public StringPart line() {
        int n;
        int n2 = StringFunctions.lastIndexOfAnyChar(this.content, this.begiMin, this.begin, "\r\n");
        if (n2 < 0) {
            n2 = this.begiMin;
        }
        if ((n = StringFunctions.indexOfAnyChar(this.content, this.begin, this.endMax, "\r\n")) < 0) {
            n = this.endMax;
        }
        this.begin = n2;
        this.end = n;
        return this;
    }

    public final StringPart seek(int n) {
        this.beginLast = this.begin;
        this.begin += n;
        if (this.begin > this.end) {
            this.throwIndexOutOfBoundsException("seek=" + n + " begin=" + (this.begin - n) + " end=" + this.end);
        } else if (this.begin < this.begiMin) {
            this.throwIndexOutOfBoundsException("seek=" + n + " begin=" + (this.begin - n) + " begin-min=" + this.begiMin);
        }
        this.bFound = true;
        return this;
    }

    public final StringPart seekNoWhitespace() {
        this.beginLast = this.begin;
        while (this.begin < this.end && " \t\r\n\f".indexOf(this.content.charAt(this.begin)) >= 0) {
            ++this.begin;
        }
        this.bFound = this.begin > this.beginLast;
        return this;
    }

    @Deprecated
    protected final StringPart skipWhitespaceAndComment() {
        return this.seekNoWhitespaceOrComments();
    }

    public final StringPart seekNoWhitespaceOrComments() {
        int n;
        int n2 = this.begin;
        do {
            n = this.begin;
            if ((this.bitMode & 1) != 0) {
                this.seekNoWhitespace();
            }
            if ((this.bitMode & 2) != 0 && StringFunctions.compare(this.content, this.begin, this.sCommentStart, 0, this.sCommentStart.length()) == 0) {
                this.seek(this.sCommentEnd, 1);
            }
            if ((this.bitMode & 4) == 0 || StringFunctions.compare(this.content, this.begin, this.sCommentToEol, 0, this.sCommentToEol.length()) != 0) continue;
            this.seek('\n', 1);
        } while (this.begin != n);
        this.bFound = this.begin > n2;
        return this;
    }

    public final boolean found() {
        return this.bFound;
    }

    protected final StringPart seekBegin() {
        this.begin = this.beginLast = this.begiMin;
        return this;
    }

    public final StringPart seek(String string, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.beginLast = this.begin;
        if ((n & 0x40) == 64) {
            n5 = this.begin + string.length() - 1;
            if (n5 > this.endMax) {
                n5 = this.endMax;
            }
            n4 = this.begiMin;
            n3 = n5;
            n2 = this.begin;
        } else {
            n4 = this.begin;
            n3 = this.end;
            n2 = this.end;
        }
        n5 = (n & 0x10) == 16 ? StringFunctions.lastIndexOf(this.content, n4, n3, string) : StringFunctions.indexOf(this.content, n4, n3, string);
        if (n5 < 0) {
            this.begin = n2;
            this.bFound = false;
        } else {
            this.bFound = true;
            this.begin = n5;
            if ((n & 1) == 1) {
                this.begin += string.length();
            }
        }
        return this;
    }

    @Java4C.Inline
    public StringPart seek(String string) {
        return this.seek(string, 0);
    }

    @Java4C.Inline
    public StringPart seekEnd(String string) {
        return this.seek(string, 1);
    }

    public final StringPart seekAnyString(String[] stringArray, int[] nArray) {
        this.beginLast = this.begin;
        int n = this.indexOfAnyString(stringArray, 0, Integer.MAX_VALUE, nArray, null);
        if (n < 0) {
            this.bFound = false;
            this.begin = this.end;
        } else {
            this.bFound = true;
            this.begin += n;
        }
        return this;
    }

    public final StringPart seek(char c, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.beginLast = this.begin;
        if ((n & 0x40) == 64) {
            n5 = this.begin;
            if (n5 > this.endMax) {
                n5 = this.endMax;
            }
            n4 = this.begiMin;
            n3 = n5;
            n2 = this.begin;
        } else {
            n4 = this.begin;
            n3 = this.end;
            n2 = this.end;
        }
        n5 = (n & 0x10) == 16 ? StringFunctions.lastIndexOf(this.content, n4, n3, c) : StringFunctions.indexOf(this.content, n4, n3, c);
        if (n5 < 0) {
            this.begin = n2;
            this.bFound = false;
        } else {
            this.bFound = true;
            this.begin = n5;
            if ((n & 1) == 1) {
                ++this.begin;
            }
        }
        return this;
    }

    public final StringPart seekNoChar(String string) {
        this.beginLast = this.begin;
        while (this.begin < this.end && string.indexOf(this.content.charAt(this.begin)) >= 0) {
            ++this.begin;
        }
        this.bFound = this.begin < this.end;
        return this;
    }

    public final int indexOfAnyChar(String string, int n, int n2) {
        int n3;
        int n4 = this.end - (n3 = this.begin + n) < n2 ? this.end : n3 + n2;
        int n5 = StringFunctions.indexOfAnyChar(this.content, n3, n4, string);
        if (n5 < 0) {
            return n5;
        }
        return n5 - this.begin;
    }

    public final int indexOfAnyChar(String string, int n, int n2, char c, char c2, char c3) {
        int n3 = this.begin + n;
        int n4 = this.end - n3 < n2 ? this.end : this.begin + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c4 = this.content.charAt(n3);
            if (c4 == c2 && c4 != '\u0000') {
                int n5 = this.indexEndOfQuotation(c3, c, n3 - this.begin, n4 - this.begin);
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                n3 = n5 + this.begin;
                continue;
            }
            if (c4 == c && c4 != '\u0000' && n3 < n4 - 1) {
                n3 += 2;
                continue;
            }
            if (string.indexOf(c4) >= 0) {
                bl = false;
                continue;
            }
            ++n3;
        }
        if (bl) {
            if (string.indexOf(3) >= 0) {
                return n3 - this.begin;
            }
            return -1;
        }
        return n3 - this.begin;
    }

    public final int lastIndexOfAnyChar(String string, int n, int n2) {
        int n3;
        int n4 = this.begin + n;
        for (n3 = this.end - this.begin < n2 ? this.end - 1 : this.begin + n2 - 1; n3 >= n4 && string.indexOf(this.content.charAt(n3)) < 0; --n3) {
        }
        int n5 = n3 >= n4 ? n3 - this.begin : -1;
        return n5;
    }

    public final int indexOfAnyString(CharSequence[] charSequenceArray, int n, int n2, int[] nArray, String[] stringArray) {
        int n3;
        int n4;
        int n5 = this.begin + n;
        int n6 = n4 = this.end - n5 < n2 ? this.end : n5 + n2;
        assert (charSequenceArray.length < 100);
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = false;
        int n7 = -1;
        while (++n7 < charSequenceArray.length) {
            CharSequence charSequence = charSequenceArray[n7];
            if (charSequence.charAt(0) == '\u0003') {
                bl = true;
                continue;
            }
            stringBuffer.append(charSequence.charAt(0));
        }
        String string = stringBuffer.toString();
        boolean bl2 = false;
        while (!bl2 && n5 < n4) {
            n3 = -1;
            while (n5 < n4 && (n3 = string.indexOf(this.content.charAt(n5))) < 0) {
                ++n5;
            }
            if (n5 >= n4) continue;
            int n8 = -1;
            while (!bl2 && ++n8 < charSequenceArray.length) {
                CharSequence charSequence = charSequenceArray[n8];
                int n9 = charSequence.length();
                if (n4 - n5 < n9 || !StringFunctions.equals(this.content, n5, n5 + n9, charSequence)) continue;
                bl2 = true;
                if (stringArray != null) {
                    stringArray[0] = charSequence.toString();
                }
                if (nArray == null) continue;
                nArray[0] = n8;
            }
            if (bl2) continue;
            ++n5;
        }
        if (n5 < n4 || n5 == n4 && bl) {
            n3 = n5 - this.begin;
        } else {
            n3 = -1;
            if (stringArray != null) {
                stringArray[0] = null;
            }
            if (nArray != null) {
                nArray[0] = -1;
            }
        }
        return n3;
    }

    public final int indexOfAnyCharOutsideQuotion(String string, int n, int n2) {
        int n3 = this.begin + n;
        int n4 = this.end - n3 < n2 ? this.end : this.begin + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c = this.content.charAt(n3);
            if (c == '\"') {
                int n5 = this.indexEndOfQuotion('\"', n3 - this.begin, n4 - this.begin);
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                n3 = n5 + this.begin;
                continue;
            }
            if (string.indexOf(c) >= 0) {
                bl = false;
                continue;
            }
            ++n3;
        }
        return bl ? -1 : n3 - this.begin;
    }

    public final int indexEndOfQuotion(char c, int n, int n2) {
        int n3 = this.begin + n + 1;
        int n4 = this.end - n3 < n2 ? this.end : n3 + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c2;
            if ((c2 = this.content.charAt(n3++)) == '\\' && n3 + 1 < n4) {
                ++n3;
                continue;
            }
            if (c2 != c) continue;
            bl = false;
        }
        return bl ? -1 : n3 - this.begin;
    }

    public final int indexEndOfQuotation(char c, char c2, int n, int n2) {
        int n3 = this.begin + n + 1;
        int n4 = this.end - n3 < n2 ? this.end : n3 + n2;
        boolean bl = true;
        while (n3 < n4 && bl) {
            char c3;
            if ((c3 = this.content.charAt(n3++)) == c2 && c3 != '\u0000' && n3 + 1 < n4) {
                ++n3;
                continue;
            }
            if (c3 != c) continue;
            bl = false;
        }
        return bl ? -1 : n3 - this.begin;
    }

    public final int indexOfAnyChar(String string) {
        return this.indexOfAnyChar(string, 0, Integer.MAX_VALUE);
    }

    public final int indexOfNoChar(String string, int n) {
        int n2;
        for (n2 = this.begin + n; n2 < this.end && string.indexOf(this.content.charAt(n2)) >= 0; ++n2) {
        }
        return n2 >= this.end ? -1 : n2 - this.begin;
    }

    public final int indexOfNoChar(String string) {
        return this.indexOfNoChar(string, 0);
    }

    public final StringPart lentoAnyChar(String string, int n) {
        return this.lentoAnyChar(string, n, 0);
    }

    public final StringPart lentoAnyChar(String string, int n, int n2) {
        this.endLast = this.end;
        int n3 = (n2 & 0x10) != 0 ? this.lastIndexOfAnyChar(string, 0, n) : this.indexOfAnyChar(string, 0, n);
        if (n3 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.end = this.begin + n3;
            this.bFound = true;
        }
        return this;
    }

    public final StringPart lentoAnyString(String[] stringArray, int n) {
        return this.lentoAnyString(stringArray, n, 0);
    }

    public final StringPart lentoAnyString(String[] stringArray, int n, int n2) {
        this.endLast = this.end;
        String[] stringArray2 = new String[1];
        int n3 = this.indexOfAnyString(stringArray, 0, n, null, stringArray2);
        if (n3 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            if ((n2 & 1) != 0) {
                n3 += stringArray2[0].length();
            }
            this.end = this.begin + n3;
            this.bFound = true;
        }
        return this;
    }

    public final void lentoAnyStringWithIndent(String[] stringArray, String string, int n, StringBuilder stringBuilder) {
        this.endLast = this.end;
        stringBuilder.setLength(0);
        int n2 = this.getCurrentColumn();
        int n3 = this.begin;
        boolean bl = string.charAt(string.length() - 1) == ' ';
        int n4 = this.indexOfAnyString(stringArray, 0, n, null, null);
        if (n4 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.bFound = true;
            this.end = this.begin + n4;
            boolean bl2 = false;
            while (!bl2) {
                n4 = StringFunctions.indexOf(this.content, '\n', n3);
                if (n4 < 0) {
                    n4 = this.end;
                }
                if (n4 > this.end) {
                    n4 = this.end;
                    bl2 = true;
                } else {
                    ++n4;
                }
                stringBuilder.append(this.content.subSequence(n3, n4));
                if (bl2) continue;
                n3 = n4;
                int n5 = n3 + n2;
                if (n5 > this.end) {
                    n5 = this.end;
                }
                while (n3 < n5 && string.indexOf(this.content.charAt(n3)) >= 0) {
                    ++n3;
                }
                if (!bl) continue;
                while (" \t".indexOf(this.content.charAt(n3)) >= 0) {
                    ++n3;
                }
            }
        }
    }

    public final StringPart lentoAnyCharOutsideQuotion(String string, int n) {
        this.endLast = this.end;
        int n2 = this.indexOfAnyCharOutsideQuotion(string, 0, n);
        if (n2 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.end = this.begin + n2;
            this.bFound = true;
        }
        return this;
    }

    public final StringPart lentoQuotionEnd(char c, int n) {
        this.endLast = this.end;
        int n2 = this.indexEndOfQuotion(c, 0, n);
        if (n2 < 0) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.end = this.begin + n2;
            this.bFound = true;
        }
        return this;
    }

    public final StringPart lentoAnyChar(String string) {
        this.lentoAnyChar(string, Integer.MAX_VALUE);
        return this;
    }

    public final StringPart len0end() {
        if (this.end <= this.begin) {
            this.end = this.endMax;
        }
        return this;
    }

    public final StringPart setLengthMax() {
        this.end = this.endMax;
        return this;
    }

    public final StringPart lenBacktoNoChar(String string) {
        this.endLast = this.end;
        while (--this.end >= this.begin && string.indexOf(this.content.charAt(this.end)) >= 0) {
        }
        if (this.end < this.begin) {
            this.end = this.begin;
            this.bFound = false;
        } else {
            this.bFound = true;
        }
        return this;
    }

    public final StringPart trim() {
        return this.seekNoChar(" \t\n\r").lenBacktoNoChar(" \t\n\r");
    }

    final StringPart trimComment() {
        this.beginLast = this.begin;
        this.endLast = this.end;
        int n = this.indexOf("//");
        if (n >= 0) {
            this.end = this.begin + n;
        }
        this.bFound = this.begin > this.beginLast;
        return this.trim();
    }

    @Override
    public final int compareTo(CharSequence charSequence) {
        return StringFunctions.compare(this, 0, charSequence, 0, Integer.MAX_VALUE);
    }

    public final int indexOf(char c) {
        int n = StringFunctions.indexOf(this.content, this.begin, this.end, c);
        if (n < 0) {
            return -1;
        }
        return n - this.begin;
    }

    public final int indexOf(char c, int n) {
        if (n >= this.end - this.begin || n < 0) {
            return -1;
        }
        int n2 = StringFunctions.indexOf(this.content, this.begin + n, this.end, c);
        if (n2 < 0) {
            return -1;
        }
        return n2 - this.begin + n;
    }

    public final int indexOf(String string) {
        int n = StringFunctions.indexOf(this.content, this.begin, this.end, string);
        if (n < 0) {
            return -1;
        }
        return n - this.begin;
    }

    public final int indexOf(CharSequence charSequence) {
        int n = StringFunctions.indexOf(this.content, this.begin, this.end, charSequence);
        if (n < 0) {
            return -1;
        }
        return n - this.begin;
    }

    public final int indexOf(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4 = n3 = this.end - this.begin < n2 ? this.end : this.begin + n2;
        if (n >= n3 - this.begin || n < 0) {
            return -1;
        }
        int n5 = StringFunctions.indexOf(this.content, this.begin + n, n3, charSequence);
        if (n5 < 0) {
            return -1;
        }
        return n5 - this.begin + n;
    }

    public final boolean equals(CharSequence charSequence) {
        return StringFunctions.equals(this.content, this.begin, this.end, charSequence);
    }

    public final boolean startsWith(CharSequence charSequence) {
        int n = StringFunctions.indexOf(charSequence, '\u0003', 0);
        if (n >= 0) {
            if (n == 0) {
                return this.begin == this.end;
            }
            return StringFunctions.equals(this.content, this.begin, this.end, charSequence);
        }
        return StringFunctions.startsWith(this.content, this.begin, this.end, charSequence);
    }

    public final StringPartScan scan() {
        return (StringPartScan)this;
    }

    public final long getCurrentPosition() {
        return this.begin;
    }

    public final void setCurrentPosition(long l) {
        this.begin = (int)l;
    }

    public final Part substring(int n, int n2) {
        int n3 = n2 <= 0 ? this.endMax - n2 : n2;
        return new Part(n + this.begiMin, n3);
    }

    public final CharSequence getCurrent(int n) {
        int n2;
        int n3 = n2 = this.content.length() - this.begin < n ? this.content.length() - this.begin : n;
        if (n2 == 0) {
            return "";
        }
        return new Part(this.begin, this.begin + n2);
    }

    public final char getCurrentChar() {
        if (this.begin < this.content.length()) {
            return this.content.charAt(this.begin);
        }
        return '\u0000';
    }

    public int XXXgetLineCt() {
        return 0;
    }

    public int getLineAndColumn(int[] nArray) {
        return 0;
    }

    public final int getCurrentColumn() {
        int n = StringFunctions.lastIndexOf(this.content, 0, this.begin, '\n');
        if (n < 0) {
            return this.begin;
        }
        return this.begin - n - 1;
    }

    public final String getInputfile() {
        return this.sFile;
    }

    public final Part getCurrentPart() {
        if (this.end > this.begin) {
            return new Part(this.begin, this.end);
        }
        return new Part(this.begin, this.begin);
    }

    public final CharSequence getLastPart() {
        if (this.begin > this.beginLast) {
            return new Part(this.beginLast, this.begin);
        }
        return "";
    }

    public final CharSequence getCurrentPart(int n) {
        int n2;
        int n3 = n2 = this.end - this.begin < n ? this.end : this.begin + n;
        if (this.end > this.begin) {
            return new Part(this.begin, n2);
        }
        return "";
    }

    public final Part getPart(int n, int n2) {
        if (n + n2 > this.content.length()) {
            n2 = this.content.length() - n;
        }
        return new Part(n, n + n2);
    }

    protected final char absCharAt(int n) {
        int n2 = n;
        if (n2 >= 0 && n2 < this.content.length()) {
            return this.content.charAt(n2);
        }
        throw new IllegalArgumentException("StringPartBase.charAt - faulty; " + n);
    }

    protected final String absSubString(int n, int n2) {
        int n3 = n;
        int n4 = n2 - n;
        int n5 = n3 + n4;
        if (this.content == null) {
            return " ??null?? ";
        }
        if (n3 >= 0 && n5 <= this.content.length()) {
            return this.content.subSequence(n3, n3 + n4).toString();
        }
        throw new IllegalArgumentException("StringPartBase.subSequence - faulty; " + n);
    }

    @Override
    public String toString() {
        return this.getCurrentPart().toString();
    }

    public final String debugString() {
        int n = this.content.length();
        String string = this.content.subSequence(0, n > 20 ? 20 : n) + "<<<" + this.begin + "," + this.end + ">>>";
        if (this.begin < n) {
            string = string + this.content.subSequence(this.begin, n > this.begin + 20 ? this.begin + 20 : n);
        }
        string = string + "<<<";
        return string;
    }

    private final void throwIndexOutOfBoundsException(String string) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(string);
    }

    @Override
    public void close() {
        this.content = null;
        this.begin = 0;
        this.beginLast = 0;
        this.begiMin = 0;
        this.endLast = 0;
        this.end = 0;
        this.endMax = 0;
        this.bFound = false;
        this.bCurrentOk = false;
    }

    public static String replace(CharSequence charSequence, CharSequence[] charSequenceArray, String[] stringArray, StringBuilder stringBuilder) {
        int n = charSequence.length();
        boolean bl = false;
        int n2 = charSequenceArray.length;
        if (n2 != stringArray.length) {
            throw new IllegalArgumentException("token and value should have same size, lesser 20");
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(n + 100);
        }
        StringPart stringPart = new StringPart(charSequence);
        int n3 = 0;
        do {
            int[] nArray = new int[1];
            int n4 = stringPart.indexOfAnyString(charSequenceArray, n3, stringPart.length(), nArray, null);
            if (n4 >= 0) {
                stringBuilder.append(charSequence.subSequence(n3, n4));
                int n5 = nArray[0];
                stringBuilder.append(stringArray[n5]);
                n3 = n4 + charSequenceArray[n5].length();
                continue;
            }
            stringBuilder.append(charSequence.subSequence(n3, n));
            n3 = -1;
        } while (n3 >= 0);
        return stringBuilder.toString();
    }

    public final class Part
    implements CharSequence {
        int b1;
        int e1;

        protected Part(int n, int n2) {
            assert (n >= 0 && n <= StringPart.this.content.length());
            assert (n2 >= 0 && n2 <= StringPart.this.content.length());
            assert (n <= n2);
            this.b1 = n;
            this.e1 = n2;
        }

        @Override
        public final char charAt(int n) {
            return StringPart.this.absCharAt(this.b1 + n);
        }

        @Override
        public final int length() {
            return this.e1 - this.b1;
        }

        @Override
        public final CharSequence subSequence(int n, int n2) {
            return new Part(this.b1 + n, this.b1 + n2);
        }

        @Override
        public String toString() {
            return StringPart.this.absSubString(this.b1, this.e1);
        }

        public final Part trim() {
            int n;
            int n2 = this.e1;
            for (n = this.b1; n < n2 && " \r\n\t".indexOf(StringPart.this.content.charAt(n)) >= 0; ++n) {
            }
            while (n2 > n && " \r\n".indexOf(StringPart.this.content.charAt(n2 - 1)) >= 0) {
                --n2;
            }
            Part part = new Part(n, n2);
            return part;
        }
    }
}

