/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.vishia.mainCmd.Report;

public abstract class SortedList
implements List {
    private static final long serialVersionUID = 1L;
    private int ix = -2;
    private final List list;
    protected final Comparator stringComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return SortedList.this.getKey(object).compareTo((String)object2);
        }
    };
    protected final Comparator objectComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return SortedList.this.getKey(object).compareTo(SortedList.this.getKey(object2));
        }
    };

    public SortedList() {
        this.list = new LinkedList();
    }

    public SortedList(List list) {
        this.list = list;
    }

    public abstract String getKey(Object var1);

    public int compare(Object object, Object object2) {
        String string = this.getKey(object);
        String string2 = this.getKey(object2);
        return string.compareTo(string2);
    }

    public int getIx() {
        return this.ix;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public boolean addNew(Object object) {
        this.ix = Collections.binarySearch(this.list, object, this.objectComparator);
        if (this.ix >= 0) {
            return false;
        }
        this.list.add(-this.ix - 1, object);
        return true;
    }

    @Override
    public boolean add(Object object) {
        this.ix = Collections.binarySearch(this.list, object, this.objectComparator);
        if (this.ix >= 0) {
            this.list.add(this.ix, object);
        } else {
            this.list.add(-this.ix - 1, object);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                this.addNew(iterator.next());
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public Object get(String string) {
        this.ix = Collections.binarySearch(this.list, string, this.stringComparator);
        if (this.ix < 0) {
            return null;
        }
        return this.list.get(this.ix);
    }

    public int search(String string) {
        this.ix = Collections.binarySearch(this.list, string, this.stringComparator);
        return this.ix;
    }

    public Object get(int n) {
        if (n < 0) {
            n = -n - 2;
        }
        if (n < 0) {
            return null;
        }
        return this.list.get(n);
    }

    public void report(Report report, String string) {
        report.reportln(1, "--------------------- SortedList: " + string + "---------------------------------------");
        for (Object e : this.list) {
            report.reportln(1, e.toString());
        }
        report.reportln(1, "-------------------------------------------------------------------------");
    }

    public void writeTextFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        for (Object e : this.list) {
            String string = e.toString();
            fileOutputStream.write((string + "\n").getBytes());
        }
    }

    public void addTextFile(File file, Class clazz) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        boolean bl = true;
        while (bl) {
            String string = bufferedReader.readLine();
            if (string == null) {
                bl = false;
                continue;
            }
            Object var6_6 = null;
            try {
                var6_6 = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("addTextFile: InstantiationException");
            }
            this.addNew(var6_6);
        }
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    public void add(int n, Object object) {
        throw new RuntimeException("SortedList.add(int index, Object) is not supported");
    }

    public boolean addAll(int n, Collection collection) {
        throw new RuntimeException("SortedList.addAll(int index, Collection) is not supported");
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.list.listIterator(n);
    }

    public Object remove(int n) {
        return this.list.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.list.remove(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.list.retainAll(collection);
    }

    public Object set(int n, Object object) {
        throw new RuntimeException("SortedList.set(int index, Object) is not supported");
    }

    public List subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.list.toArray(objectArray);
    }
}

