/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

public class KeyCode {
    public static final int version = 537987376;
    public static final int alt = 0xA00000;
    public static final int ctrl = 0xC000000;
    public static final int shift = 0x50000000;
    public static final int ctrlAlt = 0xCA00000;
    public static final int shiftAlt = 0x50A00000;
    public static final int shiftCtrl = 0x5C000000;
    public static final int shiftCtrlAlt = 1553989632;
    public static final int mSpecialKeys = 983040;
    public static final int mAddKeys = -1048576;
    public static final int mCtrlAlt = 0xFF00000;
    public static final int function = 983040;
    public static final int nonAlphanum = 917504;
    public static final int alphanum = 0;
    public static final int F1 = 983089;
    public static final int F2 = 983090;
    public static final int F3 = 983091;
    public static final int F4 = 983092;
    public static final int F5 = 983093;
    public static final int F6 = 983094;
    public static final int F7 = 983095;
    public static final int F8 = 983096;
    public static final int F9 = 983097;
    public static final int F10 = 983105;
    public static final int F11 = 983106;
    public static final int F12 = 983107;
    public static final int left = 655468;
    public static final int right = 655474;
    public static final int up = 655477;
    public static final int dn = 655460;
    public static final int pgup = 655445;
    public static final int pgdn = 655428;
    public static final int home = 655464;
    public static final int end = 655461;
    public static final int back = 917512;
    public static final int enter = 917517;
    public static final int ins = 917609;
    public static final int del = 917604;
    public static final int esc = 917531;
    public static final int mouse1Down = 720964;
    public static final int mouse1Up = 720981;
    public static final int mouse1UpMoved = 720978;
    public static final int mouse1Double = 720963;
    public static final int mouse2Down = 720996;
    public static final int mouse2Up = 721013;
    public static final int mouse2UpMoved = 721010;
    public static final int mouse2Double = 720995;
    public static final int mouseBothDown = 720994;
    public static final int mouseWheelUp = 721012;
    public static final int mouseWheelDn = 720997;
    public static final int mouse3Down = 720947;
    public static final int mouse3Up = 720948;
    public static final int menuEntered = 720973;
    public static final int Entered = 720973;
    public static final int userSelect = 720979;
    public static final int defaultSelect = 721011;
    public static final int focusGained = 720966;
    public static final int focusLost = 720998;
    public static final int valueChanged = 721014;
    public static final int activated = 720993;
    public static final int removed = 721016;
    public static final int dropFiles = 852038;
    public static final int dropText = 852052;
    public static final int dragFiles = 852070;
    public static final int dragText = 852084;
    public final int code;
    public final String str;

    public KeyCode(String string) {
        this.code = KeyCode.convert(string);
        this.str = string;
    }

    public KeyCode(int n) {
        this.code = n;
        StringBuilder stringBuilder = new StringBuilder(20);
        if ((n & 0xF0000000) == 0x50000000) {
            stringBuilder.append("shift-");
        }
        if ((n & 0xF000000) == 0xA00000) {
            stringBuilder.append("alt-");
        }
        if ((n & 0xF00000) == 0xC000000) {
            stringBuilder.append("ctrl-");
        }
        if ((n & 0xF0000) == 983040) {
            stringBuilder.append("F");
        }
        stringBuilder.append((char)(n & 0xFF));
        this.str = stringBuilder.toString();
    }

    public String toString() {
        return this.str;
    }

    public static int convert(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        if (string.contains("sh-")) {
            n2 |= 0x50000000;
        }
        if (string.contains("alt-")) {
            n2 |= 0xA00000;
        }
        if (string.contains("ctrl-")) {
            n2 |= 0xC000000;
        }
        if (string.contains("ctr-")) {
            n2 |= 0xC000000;
        }
        if (n2 == 0 && (n = string.indexOf(45)) > 0) {
            for (int i = 0; i < n; ++i) {
                switch (string.charAt(i)) {
                    case 'a': {
                        n2 |= 0xA00000;
                    }
                    case 'A': {
                        n2 |= 0x50A00000;
                    }
                    case 'c': {
                        n2 |= 0xC000000;
                    }
                    case 'C': {
                        n2 |= 0x5C000000;
                    }
                }
            }
        }
        if (n3 >= 2 && string.charAt(n3 - 2) == 'F' && (n = "0123456789abcABC".indexOf(string.charAt(n3 - 1))) >= 0) {
            if (n == 0) {
                n = 10;
            } else if (n >= 13) {
                n -= 3;
            }
            n2 |= 0xF0000;
            n2 |= 48 + n;
        } else {
            n2 |= string.charAt(n3 - 1);
        }
        return n2;
    }

    public static boolean isWritingKey(int n) {
        if ((n & 0xFFFF0000) == 0) {
            return true;
        }
        if (n == 917604) {
            return true;
        }
        return n == 917512;
    }

    public static boolean isAsciiTextKey(int n) {
        return n >= 32 && n <= 126;
    }

    public static boolean isTextKey(int n) {
        return (n & 0xFFFF0000) == 0 && n >= 32;
    }

    public static boolean isControlOrFunction(int n) {
        int n2 = n & 0xF0000;
        return n2 == 983040 || n2 == 0 && (n & 0xC000000) != 0;
    }

    public static boolean isControlFunctionMouseUpOrMenu(int n) {
        int n2 = n & 0xF0000;
        return n == 720973 || n == 720981 || n2 == 983040 || n2 == 917504 || (n & 0xFF00000) != 0;
    }

    public static boolean isWritingOrTextNavigationKey(int n) {
        if ((n & 0xFFFF0000) == 0) {
            return true;
        }
        if ((n & 0xF0000) == 655360) {
            return true;
        }
        if (n == 917512) {
            return true;
        }
        if (n == 917517) {
            return true;
        }
        return n == 917604;
    }
}

