/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.vishia.bridgeC.AllocInBlock;
import org.vishia.util.Assert;
import org.vishia.util.StringFunctions;

public class IndexMultiTable<Key extends Comparable<Key>, Type>
implements Map<Key, Type>,
Iterable<Type> {
    public static final String sVersion = "2014-12-24";
    static int identParent_ = 100;
    final Key minKey__;
    final Key maxKey__;
    final Provide<Key> provider;
    private boolean shouldCheck = false;
    protected static final int maxBlock = AllocInBlock.restSizeBlock(IndexMultiTable.class, 160) / 8;
    final Table<Key, Type> root;
    protected int modcount;
    public static final Provide<String> providerString = new Provide<String>(){

        public String[] createSortKeyArray(int n) {
            return new String[n];
        }

        @Override
        public String getMaxSortKey() {
            return "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff";
        }

        @Override
        public String getMinSortKey() {
            return "";
        }
    };
    Set<Map.Entry<Key, Type>> entrySet = new Set<Map.Entry<Key, Type>>(){

        @Override
        public boolean add(Map.Entry<Key, Type> entry) {
            IndexMultiTable.this.put((Comparable)entry.getKey(), entry.getValue());
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Key, Type>> collection) {
            for (Map.Entry entry : collection) {
                IndexMultiTable.this.put((Comparable)entry.getKey(), entry.getValue());
            }
            return true;
        }

        @Override
        public void clear() {
            IndexMultiTable.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return IndexMultiTable.this.containsValue(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            boolean bl = true;
            for (Object obj : collection) {
                if (IndexMultiTable.this.containsValue(obj)) continue;
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Map.Entry<Key, Type>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public boolean remove(Object object) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return null;
        }
    };

    public IndexMultiTable(Provide<Key> provide) {
        this.provider = provide;
        this.minKey__ = (Comparable)provide.getMinSortKey();
        this.maxKey__ = (Comparable)provide.getMaxSortKey();
        this.root = new Table(this);
    }

    @Override
    public void clear() {
        ++this.modcount;
        this.root.clear();
    }

    @Override
    public Type put(Key Key2, Type Type2) {
        ++this.modcount;
        return (Type)((Table)this.root).putOrAdd(Key2, Type2, null, KindofAdd.replace);
    }

    public void add(Key Key2, Type Type2) {
        ++this.modcount;
        ((Table)this.root).putOrAdd(Key2, Type2, null, KindofAdd.addOptimized);
    }

    @Override
    public boolean containsKey(Object object) {
        boolean[] blArray = new boolean[1];
        return this.search((Comparable)object, true, blArray) != null || blArray[0];
    }

    public void shouldCheck(boolean bl) {
        this.shouldCheck = bl;
    }

    public void append(Key Key2, Type Type2) {
        if (Key2.equals("ckgro") && ((Table)this.root).sizeAll == 19) {
            Assert.stop();
        }
        ++this.modcount;
        ((Table)this.root).putOrAdd(Key2, Type2, null, KindofAdd.addLast);
    }

    public void addBefore(Key Key2, Type Type2, Type Type3) {
        ++this.modcount;
        ((Table)this.root).putOrAdd(Key2, Type2, Type3, KindofAdd.addBefore);
    }

    @Override
    public boolean containsValue(Object object) {
        return false;
    }

    @Override
    public Set<Map.Entry<Key, Type>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Type get(Object object) {
        assert (object instanceof Comparable);
        IndexBox indexBox = new IndexBox();
        Table table = ((Table)this.root).searchInTables((Comparable)object, true, indexBox);
        if (table != null) {
            return (Type)table.aValues[indexBox.ix];
        }
        return null;
    }

    public Type search(Key Key2) {
        return this.search(Key2, false, null);
    }

    public Type search(Key Key2, boolean bl, boolean[] blArray) {
        IndexBox indexBox = new IndexBox();
        Table table = ((Table)this.root).searchInTables(Key2, bl, indexBox);
        if (table != null) {
            if (blArray != null) {
                blArray[0] = indexBox.found;
            }
            Object object = table.aValues[indexBox.ix];
            return (Type)object;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<Key> keySet() {
        return null;
    }

    @Override
    public int size() {
        return ((Table)this.root).sizeAll;
    }

    @Override
    public Collection<Type> values() {
        return null;
    }

    @Override
    public ListIterator<Type> iterator() {
        return new IteratorImpl();
    }

    public ListIterator<Type> iterator(Key Key2) {
        return new IteratorImpl(this, Key2);
    }

    @Override
    public Type remove(Object object) {
        assert (object instanceof Comparable);
        IndexBox indexBox = new IndexBox();
        Table table = ((Table)this.root).searchInTables((Comparable)object, true, indexBox);
        if (table != null) {
            Object object2 = table.aValues[indexBox.ix];
            table.delete(indexBox.ix);
            return (Type)object2;
        }
        return null;
    }

    void stop() {
    }

    public void checkTable() {
        ((Table)this.root).checkTable(null, null, -1, (Comparable)this.provider.getMinSortKey());
    }

    void assert1(boolean bl) {
        if (!bl) {
            this.stop();
            throw new RuntimeException("IndexMultiTable - is corrupted;");
        }
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Type> map) {
        for (Map.Entry<Key, Type> entry : map.entrySet()) {
            this.put((Key)((Comparable)entry.getKey()), entry.getValue());
        }
    }

    private void splitTopLevel(int n, Key Key2, Object object) {
        Table table = new Table(this);
        Table table2 = new Table(this);
        table.parent = (table2.parent = (Table)this.root);
        table.isHyperBlock = table2.isHyperBlock = this.root.isHyperBlock;
        table.ixInParent = 0;
        table2.ixInParent = 1;
        this.root.isHyperBlock = true;
        int n2 = ((Table)this.root).sizeBlock / 2;
        if (n > n2) {
            table.sizeAll = ((Table)this.root).movein((Table)this.root, table, 0, 0, n2);
            table.sizeBlock = n2;
            table2.sizeAll = ((Table)this.root).movein((Table)this.root, table2, n2, 0, n - n2);
            int n3 = n - n2;
            table2.aKeys[n3] = Key2;
            table2.aValues[n3] = object;
            if (object instanceof IndexMultiTable) {
                Table table3 = (Table)object;
                table3.ixInParent = n3;
                table3.parent = table2;
            }
            table2.sizeAll += ((Table)this.root).movein((Table)this.root, table2, n, n3 + 1, ((Table)this.root).sizeBlock - n);
            table2.sizeBlock = ((Table)this.root).sizeBlock - n2 + 1;
            this.root.aValues[0] = table;
            this.root.aValues[1] = table2;
            table.check();
            table2.check();
        } else {
            if (n >= 0) {
                table.sizeAll = ((Table)this.root).movein((Table)this.root, table, 0, 0, n);
                table.aKeys[n] = Key2;
                table.aValues[n] = object;
                if (object instanceof IndexMultiTable) {
                    Table table4 = (Table)object;
                    table4.ixInParent = n;
                    table4.parent = table;
                }
                table.sizeAll += 1;
                table.sizeAll += ((Table)this.root).movein((Table)this.root, table, n, n + 1, n2 - n);
                table.sizeBlock = n2 + 1;
            } else {
                table.sizeAll = ((Table)this.root).movein((Table)this.root, table, 0, 0, n2);
                table.sizeBlock = n2;
            }
            table2.sizeAll = ((Table)this.root).movein((Table)this.root, table2, n2, 0, ((Table)this.root).sizeBlock - n2);
            table2.sizeBlock = ((Table)this.root).sizeBlock - n2;
            this.root.aValues[0] = table;
            this.root.aValues[1] = table2;
            table.check();
            table2.check();
        }
        this.root.aKeys[0] = table.aKeys[0];
        this.root.aKeys[1] = table2.aKeys[0];
        ((Table)this.root).sizeBlock = 2;
        ((Table)this.root).clearRestArray((Table)this.root);
        this.root.check();
    }

    public String toString() {
        return this.root.toString();
    }

    class IndexBox {
        int ix;
        boolean found;

        IndexBox() {
        }
    }

    protected static class Entry
    implements Map.Entry<Key, Type> {
        final Type value;
        final Key key;
        final /* synthetic */ IndexMultiTable this$0;

        Entry(Key Key2, Type Type2) {
            this.this$0 = var1_1;
            this.key = Key2;
            this.value = Type2;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Type getValue() {
            return this.value;
        }

        @Override
        public Type setValue(Type Type2) {
            throw new IllegalArgumentException("IndexMultiTable.Entry does not support setValue()");
        }

        public String toString() {
            return "[ " + this.key + ", " + this.value + " ]";
        }
    }

    protected class EntrySetIterator
    implements Iterator<Map.Entry<Key, Type>> {
        private final IteratorImpl tableIter;

        protected EntrySetIterator() {
            this.tableIter = (IteratorImpl)IndexMultiTable.this.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.tableIter.hasNext();
        }

        @Override
        public Map.Entry<Key, Type> next() {
            Object Type2 = this.tableIter.next();
            Object Key2 = this.tableIter.lastKey();
            return new Entry(IndexMultiTable.this, Key2, Type2);
        }

        @Override
        public void remove() {
            this.tableIter.remove();
        }

        public String toString() {
            return this.tableIter.toString();
        }
    }

    public static interface Provide<Key> {
        public Key[] createSortKeyArray(int var1);

        public Key getMinSortKey();

        public Key getMaxSortKey();
    }

    static class Table<Key extends Comparable<Key>, Type> {
        protected final Key[] aKeys;
        protected final Object[] aValues = new Object[maxBlock];
        private int sizeBlock;
        private int sizeAll;
        protected boolean isHyperBlock;
        final int identParent = ++identParent_;
        private int ixInParent;
        private Table<Key, Type> parent;
        final IndexMultiTable<Key, Type> rootIdxTable;

        Table(IndexMultiTable<Key, Type> indexMultiTable) {
            this.rootIdxTable = indexMultiTable;
            this.aKeys = (Comparable[])indexMultiTable.provider.createSortKeyArray(maxBlock);
            for (int i = 0; i < maxBlock; ++i) {
                this.aKeys[i] = indexMultiTable.maxKey__;
            }
            this.sizeBlock = 0;
            this.ixInParent = -1;
        }

        int binarySearchFirstKey(Comparable<Key>[] comparableArray, int n, int n2, Key Key2) {
            int n3 = n;
            int n4 = n2 - 1;
            int n5 = 0;
            boolean bl = false;
            while (n3 <= n4) {
                n5 = n3 + n4 >> 1;
                Comparable<Key> comparable = comparableArray[n5];
                int n6 = this.compare(comparable, Key2);
                if (n6 < 0) {
                    n3 = n5 + 1;
                    continue;
                }
                n4 = n5 - 1;
                bl = bl || n6 == 0;
            }
            if (bl) {
                return n3 > n5 ? n3 : n5;
            }
            return -(n3 + 1);
        }

        protected int compare(Comparable<Key> comparable, Key Key2) {
            int n;
            if (comparable instanceof CharSequence) {
                CharSequence charSequence = Key2 instanceof CharSequence ? (CharSequence)Key2 : Key2.toString();
                n = StringFunctions.compare((CharSequence)((Object)comparable), charSequence);
            } else {
                n = comparable.compareTo(Key2);
            }
            return n;
        }

        private Type putOrAdd(Key Key2, Type Type2, Type Type3, KindofAdd kindofAdd) {
            this.check();
            Object object = null;
            if (this.isHyperBlock && this.sizeBlock == maxBlock) {
                if (this.parent != null) {
                    Table<Object, Type> table = this.splitIntoSibling(-1, null, null);
                    if (this.compare((Comparable<Object>)table.aKeys[0], Key2) <= 0) {
                        return super.putOrAdd(Key2, Type2, Type3, kindofAdd);
                    }
                } else {
                    ((IndexMultiTable)this.rootIdxTable).splitTopLevel(-1, null, null);
                }
            }
            this.check();
            int n = Arrays.binarySearch(this.aKeys, Key2);
            if (n < 0) {
                n = -n - 1;
                if (this.isHyperBlock) {
                    Table<Object, Type> table;
                    if (--n < 0) {
                        n = 0;
                        table = this;
                        while (table != null) {
                            if (this.compare((Comparable<Object>)Key2, this.aKeys[0]) < 0) {
                                this.aKeys[0] = Key2;
                            }
                            table = table.parent;
                        }
                    }
                    table = (Table)this.aValues[n];
                    object = table.putOrAdd(Key2, Type2, Type3, kindofAdd);
                } else if (n < 0) {
                    n = -n - 1;
                    this.sortin(n, Key2, Type2);
                    this.check();
                } else {
                    this.sortin(n, Key2, Type2);
                    this.check();
                }
                this.check();
            } else {
                switch (kindofAdd) {
                    case replace: {
                        Object object2;
                        if (this.isHyperBlock) {
                            Table table = (Table)this.aValues[n];
                            object = table.putOrAdd(Key2, Type2, Type3, kindofAdd);
                            break;
                        }
                        object = object2 = this.aValues[n];
                        this.aValues[n] = Type2;
                        break;
                    }
                    case addBefore: {
                        boolean bl = this.searchAndSortin(Key2, Type2, n, Type3);
                        if (bl) break;
                        this.searchbackAndSortin(Key2, Type2, n, Type3);
                        break;
                    }
                    case addLast: {
                        assert (Type3 == null);
                        this.searchLastAndSortin(Key2, Type2, n);
                        break;
                    }
                    case addOptimized: {
                        if (this.isHyperBlock) {
                            Table table = (Table)this.aValues[n];
                            table.putOrAdd(Key2, Type2, Type3, kindofAdd);
                            break;
                        }
                        this.sortin(n, Key2, Type2);
                    }
                }
            }
            return (Type)object;
        }

        private boolean searchLastAndSortin(Key Key2, Type Type2, int n) {
            boolean bl = true;
            int n2 = n;
            Table<Key, Type> table = this.parent;
            Table<Key, Type> table2 = this;
            while (table != null) {
                if (table2.ixInParent + 1 < table.sizeBlock && this.compare((Comparable<Key>)table.aKeys[table2.ixInParent + 1], Key2) == 0) {
                    return super.searchLastAndSortin(Key2, Type2, this.ixInParent + 1);
                }
                if (table2.ixInParent == table.sizeBlock) {
                    table2 = table;
                    table = table.parent;
                    continue;
                }
                table = null;
            }
            while (bl && n2 < this.sizeBlock) {
                if (++n2 != this.sizeBlock && this.compare((Comparable<Key>)this.aKeys[n2], Key2) == 0) continue;
                if (this.isHyperBlock) {
                    Table table3 = (Table)this.aValues[--n2];
                    table3.searchLastAndSortin(Key2, Type2, 0);
                    bl = false;
                    continue;
                }
                bl = false;
                super.sortin(n2, Key2, Type2);
            }
            return !bl;
        }

        private boolean searchAndSortin(Key Key2, Type Type2, int n, Type Type3) {
            boolean bl = true;
            boolean bl2 = false;
            int n2 = n;
            while (bl && n2 < this.sizeBlock) {
                if (this.isHyperBlock) {
                    Table table = (Table)this.aValues[n2];
                    bl2 = table.searchAndSortin(Key2, Type2, n2, Type3);
                    bl = !bl2;
                    if (!bl) continue;
                    ++n2;
                    continue;
                }
                if (n2 < this.sizeBlock - 1 || this.aValues[n2 + 1] == Type3) {
                    this.sortin(n2, Key2, Type2);
                    bl2 = true;
                    bl = false;
                    continue;
                }
                if (++n2 >= this.sizeBlock || this.compare((Comparable<Key>)this.aKeys[n2], Key2) == 0) continue;
                bl = false;
            }
            return bl2;
        }

        private boolean searchbackAndSortin(Key Key2, Type Type2, int n, Type Type3) {
            return false;
        }

        private void sortin(int n, Key Key2, Object object) {
            this.check();
            if (this.sizeBlock == maxBlock) {
                if (this.isHyperBlock) {
                    this.rootIdxTable.stop();
                }
                if (this.parent != null) {
                    this.splitIntoSibling(n, Key2, object);
                    this.check();
                } else {
                    ((IndexMultiTable)this.rootIdxTable).splitTopLevel(n, Key2, object);
                    this.check();
                }
            } else {
                if (n < this.sizeBlock) {
                    this.movein(this, this, n, n + 1, this.sizeBlock - n);
                }
                ++this.sizeBlock;
                this.aKeys[n] = Key2;
                this.aValues[n] = object;
                if (object instanceof IndexMultiTable) {
                    Table table = (Table)object;
                    table.ixInParent = n;
                    table.parent = this;
                }
            }
            this.check();
            ++this.sizeAll;
        }

        private Table<Key, Type> splitIntoSibling(int n, Key Key2, Object object) {
            Table<Key, Type> table = new Table<Key, Type>(this.rootIdxTable);
            table.parent = this.parent;
            table.isHyperBlock = this.isHyperBlock;
            table.ixInParent = this.ixInParent + 1;
            int n2 = this.sizeBlock / 2;
            if (n > n2) {
                int n3 = n - n2;
                table.sizeAll = this.movein(this, table, n2, 0, n - n2);
                table.aKeys[n3] = Key2;
                table.aValues[n3] = object;
                if (object instanceof IndexMultiTable) {
                    Table table2 = (Table)object;
                    table2.ixInParent = n3;
                    table2.parent = table;
                }
                ++table.sizeAll;
                table.sizeAll += this.movein(this, table, n, n3 + 1, this.sizeBlock - n);
                table.sizeBlock = this.sizeBlock - n2 + 1;
                this.sizeBlock = n2;
                this.sizeAll -= table.sizeAll;
                this.clearRestArray(this);
                super.sortin(table.ixInParent, table.aKeys[0], table);
                this.check();
                table.check();
                this.parent.check();
            } else {
                table.sizeAll = this.movein(this, table, n2, 0, this.sizeBlock - n2);
                table.sizeBlock = this.sizeBlock - n2;
                if (n >= 0) {
                    if (n < n2) {
                        this.movein(this, this, n, n + 1, n2 - n);
                    }
                    this.aKeys[n] = Key2;
                    this.aValues[n] = object;
                    if (object instanceof IndexMultiTable) {
                        Table table3 = (Table)object;
                        table3.ixInParent = n;
                        table3.parent = this;
                    }
                    this.sizeBlock = n2 + 1;
                    this.sizeAll = this.sizeAll - table.sizeAll + 1;
                } else {
                    this.sizeBlock = n2;
                    this.sizeAll -= table.sizeAll;
                }
                this.clearRestArray(this);
                super.sortin(table.ixInParent, table.aKeys[0], table);
                this.check();
                table.check();
                this.parent.check();
            }
            return table;
        }

        private int movein(Table<Key, Type> table, Table<Key, Type> table2, int n, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7 = n3;
            int n8 = n3;
            if (table == table2 && n < n2) {
                n6 = -1;
                n5 = n + n3 - 1;
                n4 = n2 + n3 - 1;
            } else {
                n6 = 1;
                n5 = n;
                n4 = n2;
            }
            while (--n8 >= 0) {
                Object object = table.aValues[n5];
                if (object instanceof Table) {
                    Table table3 = (Table)object;
                    table3.ixInParent = n4;
                    table3.parent = table2;
                    n7 += table3.sizeAll - 1;
                }
                table2.aValues[n4] = object;
                table2.aKeys[n4] = table.aKeys[n5];
                n5 += n6;
                n4 += n6;
            }
            return n7;
        }

        private void clearRestArray(Table<Key, Type> table) {
            for (int i = table.sizeBlock; i < maxBlock; ++i) {
                table.aKeys[i] = this.rootIdxTable.maxKey__;
                table.aValues[i] = null;
            }
        }

        protected void delete(int n) {
            --this.sizeBlock;
            Table<Key, Type> table = this;
            do {
                if (table.sizeAll <= 0) continue;
                --table.sizeAll;
            } while ((table = table.parent) != null);
            if (n < this.sizeBlock) {
                super.movein(this, this, n + 1, n, this.sizeBlock - n);
            }
            this.aKeys[this.sizeBlock] = this.rootIdxTable.maxKey__;
            this.aValues[this.sizeBlock] = null;
            if (this.sizeBlock == 0) {
                if (this.parent != null) {
                    this.parent.delete(this.ixInParent);
                } else {
                    this.isHyperBlock = false;
                }
            }
        }

        public void clear() {
            for (int i = 0; i < this.sizeBlock; ++i) {
                if (this.isHyperBlock) {
                    Table table = (Table)this.aValues[i];
                    table.clear();
                }
                this.aValues[i] = null;
                this.aKeys[i] = this.rootIdxTable.maxKey__;
            }
            this.sizeBlock = 0;
            this.isHyperBlock = false;
        }

        private Table<Key, Type> searchInTables(Key Key2, boolean bl, IndexBox indexBox) {
            int n;
            Table table = this;
            while (table.isHyperBlock) {
                n = this.binarySearchFirstKey((Comparable<Key>[])table.aKeys, 0, table.sizeBlock, Key2);
                if (n < 0) {
                    n = -n - 2;
                }
                if (n < 0) {
                    return null;
                }
                assert (n < table.sizeBlock);
                table = (Table)table.aValues[n];
            }
            n = this.binarySearchFirstKey((Comparable<Key>[])table.aKeys, 0, table.sizeBlock, Key2);
            if (n < 0) {
                if (bl) {
                    return null;
                }
                n = -n - 2;
            } else {
                indexBox.found = true;
            }
            if (n >= 0) {
                indexBox.ix = n;
                return table;
            }
            return null;
        }

        Table<Key, Type> nextSibling() {
            Table table = null;
            if (this.parent != null) {
                if (this.ixInParent < this.sizeBlock - 1) {
                    Table table2;
                    table = table2 = (Table)this.parent.aValues[this.ixInParent + 1];
                } else {
                    Assert.check(false);
                }
            } else {
                Assert.check(false);
            }
            return table;
        }

        void check() {
            if (((IndexMultiTable)this.rootIdxTable).shouldCheck) {
                int n;
                if (this.parent != null) {
                    this.rootIdxTable.assert1(this.parent.aValues[this.ixInParent] == this);
                }
                if (this.sizeBlock >= 1) {
                    this.rootIdxTable.assert1(this.aValues[0] != null);
                }
                for (n = 1; n < this.sizeBlock; ++n) {
                    this.rootIdxTable.assert1(this.compare((Comparable<Key>)this.aKeys[n - 1], this.aKeys[n]) <= 0);
                    this.rootIdxTable.assert1(this.aValues[n] != null);
                    if (this.aValues[n] != null) continue;
                    this.rootIdxTable.stop();
                }
                if (this.isHyperBlock) {
                    for (n = 0; n < this.sizeBlock; ++n) {
                        this.rootIdxTable.assert1(this.aValues[n] instanceof IndexMultiTable);
                        Table table = (Table)this.aValues[n];
                        this.rootIdxTable.assert1(this.aKeys[n].equals(table.aKeys[0]));
                        this.rootIdxTable.assert1(table.ixInParent == n);
                    }
                }
                for (n = this.sizeBlock; n < maxBlock; ++n) {
                    this.rootIdxTable.assert1(this.aKeys[n] == this.rootIdxTable.maxKey__);
                    this.rootIdxTable.assert1(this.aValues[n] == null);
                }
            }
        }

        private Key checkTable(Table<Key, Type> table, Key Key2, int n, Key Key3) {
            int n2;
            Key Key4 = Key3;
            this.rootIdxTable.assert1(table == null || Key2.equals(this.aKeys[0]));
            this.rootIdxTable.assert1(this.parent == table);
            this.rootIdxTable.assert1(this.ixInParent == n);
            for (n2 = 0; n2 < this.sizeBlock; ++n2) {
                this.rootIdxTable.assert1(this.compare((Comparable<Key>)this.aKeys[n2], Key4) >= 0);
                if (this.isHyperBlock) {
                    this.rootIdxTable.assert1(this.aValues[n2] instanceof IndexMultiTable);
                    Table table2 = (Table)this.aValues[n2];
                    Key4 = table2.checkTable(this, this.aKeys[n2], n2, Key4);
                    continue;
                }
                this.rootIdxTable.assert1(!(this.aValues[n2] instanceof IndexMultiTable));
                Key4 = this.aKeys[n2];
            }
            for (n2 = this.sizeBlock; n2 < maxBlock; ++n2) {
                this.rootIdxTable.assert1(this.aKeys[n2] == this.rootIdxTable.maxKey__);
                this.rootIdxTable.assert1(this.aValues[n2] == null);
            }
            return Key4;
        }

        private void toString(StringBuilder stringBuilder) {
            if (this.sizeBlock == 0) {
                stringBuilder.append("..emptyIndexMultiTable...");
            } else if (this.isHyperBlock) {
                for (int i = 0; i < this.sizeBlock; ++i) {
                    Table table = (Table)this.aValues[i];
                    table.toString(stringBuilder);
                }
            } else {
                for (int i = 0; i < this.sizeBlock; ++i) {
                    stringBuilder.append(this.aKeys[i]).append(", ");
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.parent != null) {
                stringBuilder.append("#").append(this.parent.identParent);
            }
            if (this.isHyperBlock) {
                stringBuilder.append(':');
            } else {
                stringBuilder.append('=');
            }
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }
    }

    private static class IteratorHelper<Key extends Comparable<Key>, Type> {
        private final boolean bPrev;
        protected int idx;
        Table<Key, Type> table;
        Key currKey;
        Type currValue;

        IteratorHelper(boolean bl) {
            this.bPrev = bl;
            this.table = null;
            this.idx = -1;
        }

        void copy(IteratorHelper<Key, Type> iteratorHelper) {
            this.idx = iteratorHelper.idx;
            this.table = iteratorHelper.table;
            this.currKey = iteratorHelper.currKey;
            this.currValue = iteratorHelper.currValue;
        }

        private boolean checkHyperTable() {
            Object object;
            while (this.idx >= ((Table)this.table).sizeBlock && ((Table)this.table).parent != null) {
                this.idx = ((Table)this.table).ixInParent + 1;
                this.table = ((Table)this.table).parent;
            }
            while (this.idx < 0 && ((Table)this.table).parent != null) {
                this.idx = ((Table)this.table).ixInParent - 1;
                this.table = ((Table)this.table).parent;
            }
            while (this.table.isHyperBlock && this.idx >= 0 && this.idx < ((Table)this.table).sizeBlock) {
                object = (Table)this.table.aValues[this.idx];
                this.table = object;
                if (this.bPrev) {
                    this.idx = ((Table)object).sizeBlock - 1;
                    continue;
                }
                this.idx = 0;
            }
            if (this.idx >= 0 && this.idx < ((Table)this.table).sizeBlock) {
                this.currKey = this.table.aKeys[this.idx];
                object = this.table.aValues[this.idx];
                this.currValue = object;
                return true;
            }
            this.currKey = null;
            this.currValue = null;
            return false;
        }

        public String toString() {
            return this.table == null ? "null" : (this.idx < 0 ? "--no-previous--" : (this.idx >= ((Table)this.table).sizeBlock ? "--no-next--" : this.table.aKeys[this.idx].toString()));
        }
    }

    protected final class IteratorImpl
    implements ListIterator<Type> {
        IteratorHelper<Key, Type> helperPrev;
        IteratorHelper<Key, Type> helperNext;
        private final int modcount;
        private boolean bLastWasNext;
        Key lastKey;
        Type lastValue;

        IteratorImpl() {
            this.bLastWasNext = false;
            this.modcount = IndexMultiTable.this.modcount;
            this.helperNext = new IteratorHelper(false);
            this.helperNext.table = IndexMultiTable.this.root;
            this.helperNext.idx = 0;
            this.helperNext.checkHyperTable();
            this.helperPrev = new IteratorHelper(true);
            this.helperPrev.table = IndexMultiTable.this.root;
            this.helperPrev.idx = -1;
            this.helperPrev.currKey = null;
            this.helperPrev.currValue = null;
        }

        IteratorImpl(Key Key2) {
            int n;
            this.bLastWasNext = false;
            this.modcount = IndexMultiTable.this.modcount;
            Table table = IndexMultiTable.this.root;
            while (table.isHyperBlock) {
                Table table2;
                n = table.binarySearchFirstKey((Comparable<Key>[])table.aKeys, 0, table.sizeBlock, Key2);
                if (n < 0) {
                    n = -n - 1;
                }
                assert (table.aValues[n] instanceof Table);
                table = table2 = (Table)table.aValues[n];
            }
            this.helperPrev = new IteratorHelper(true);
            this.helperNext = new IteratorHelper(false);
            this.helperPrev.table = this.helperNext.table = table;
            n = table.binarySearchFirstKey((Comparable<Key>[])table.aKeys, 0, table.sizeBlock, Key2);
            if (n < 0) {
                n = -n - 1;
                this.helperPrev.idx = n - 1;
                this.helperPrev.checkHyperTable();
                this.helperNext.idx = n;
                this.helperNext.checkHyperTable();
            } else {
                this.helperPrev.idx = n;
                this.helperPrev.currKey = this.helperPrev.table.aKeys[n];
                this.helperPrev.checkHyperTable();
                this.helperNext.idx = n + 1;
                this.helperNext.checkHyperTable();
            }
        }

        @Override
        public boolean hasNext() {
            return this.helperNext.currKey != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.helperPrev.currKey != null;
        }

        @Override
        public Type next() {
            this.checkForModification();
            this.bLastWasNext = true;
            this.lastKey = this.helperNext.currKey;
            this.lastValue = this.helperNext.currValue;
            if (this.lastKey != null) {
                this.next_i();
            }
            return this.lastValue;
        }

        @Override
        public Type previous() {
            this.checkForModification();
            this.bLastWasNext = false;
            this.lastKey = this.helperPrev.currKey;
            this.lastValue = this.helperPrev.currValue;
            if (this.lastKey != null) {
                this.prev_i();
            }
            return this.lastValue;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void add(Type Type2) {
            throw new IllegalStateException("not implemented");
        }

        @Override
        public void set(Type Type2) {
            throw new IllegalStateException("not implemented");
        }

        Key lastKey() {
            return this.lastKey;
        }

        private void checkForModification() {
            if (this.modcount != IndexMultiTable.this.modcount) {
                throw new ConcurrentModificationException();
            }
        }

        private void next_i() {
            this.checkForModification();
            this.helperPrev.copy(this.helperNext);
            if (++this.helperNext.idx >= this.helperNext.table.sizeBlock) {
                this.helperNext.checkHyperTable();
            } else {
                this.helperNext.currKey = this.helperNext.table.aKeys[this.helperNext.idx];
                Object object = this.helperNext.table.aValues[this.helperNext.idx];
                this.helperNext.currValue = object;
            }
        }

        private void prev_i() {
            this.checkForModification();
            this.helperNext.copy(this.helperPrev);
            if (--this.helperPrev.idx < 0) {
                this.helperPrev.checkHyperTable();
            } else {
                this.helperPrev.currKey = this.helperPrev.table.aKeys[this.helperPrev.idx];
                Object object = this.helperPrev.table.aValues[this.helperPrev.idx];
                this.helperPrev.currValue = object;
            }
        }

        @Override
        public void remove() {
            this.checkForModification();
            if (this.bLastWasNext) {
                this.helperPrev.table.delete(this.helperPrev.idx);
                --this.helperPrev.idx;
                this.helperPrev.checkHyperTable();
                this.helperNext.table = this.helperPrev.table;
                this.helperNext.idx = this.helperPrev.idx + 1;
                this.helperNext.checkHyperTable();
            } else {
                this.helperNext.table.delete(this.helperNext.idx);
                this.helperNext.checkHyperTable();
            }
        }

        public String toString() {
            return this.helperPrev.toString() + " ... " + this.helperNext.toString();
        }
    }

    private static enum KindofAdd {
        addOptimized,
        addLast,
        addBefore,
        replace;

    }
}

