/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.LinkedList;
import java.util.List;
import org.vishia.util.Assert;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFunctions;

public class FilePath {
    public static final String sVersion = "2014-06-22";
    private String scriptVariable;
    private String drive;
    private boolean absPath;
    private String basepath;
    private String localdir = "";
    private String name = "";
    private String ext = "";
    private boolean allTree;
    private boolean someFiles;
    private static FilePath emptyParent = new FilePath();

    @Deprecated
    public FilePath() {
    }

    public FilePath(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        String string2 = string.replace('\\', '/');
        int n5 = string2.length();
        int n6 = string2.indexOf(58);
        int n7 = string2.indexOf(47);
        if (n5 >= 1 && string2.charAt(0) == '&') {
            n4 = n6 > 0 && (n6 < n7 || n7 < 0) ? n6 : (n7 > 0 ? n7 : n5);
            this.scriptVariable = string2.substring(1, n4);
            this.absPath = false;
            n3 = n4 == n7 ? n4 + 1 : n4;
        } else if (n6 == 1) {
            this.drive = string2.substring(0, 1);
            n6 = string2.indexOf(58, 2);
            this.absPath = n7 == 2;
            n3 = this.absPath ? 3 : 2;
        } else {
            this.absPath = n7 == 0;
            int n8 = n3 = this.absPath ? 1 : 0;
        }
        if (n6 > 0) {
            n2 = n3;
            n = n6 + 1;
        } else {
            n2 = -1;
            n = n3;
        }
        this.basepath = n2 >= 0 ? string2.substring(n2, n - 1) : null;
        n4 = string2.lastIndexOf(47) + 1;
        if (n4 < n) {
            n4 = n;
        }
        if (n4 > n) {
            this.localdir = string2.substring(n, n4 - 1);
            this.allTree = this.localdir.indexOf("/**/") >= 0;
            this.someFiles = this.localdir.indexOf(42) >= 0;
        } else {
            this.localdir = "";
        }
        int n9 = string2.lastIndexOf(46);
        if (n9 <= n4) {
            n9 = n5;
        }
        this.name = string2.substring(n4, n9);
        this.someFiles |= this.name.indexOf(42) >= 0;
        this.ext = string2.substring(n9);
        this.someFiles |= this.ext.indexOf(42) >= 0;
        if (n4 + 1 == n9 && n4 + 2 == n5 && string2.charAt(n4) == '.') {
            this.name = "..";
            this.ext = "";
        }
    }

    public FilePath(FilePath filePath, FilePath filePath2, FilePath filePath3, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        FilePath filePath4 = filePath2 != null ? filePath2 : null;
        FilePath filePath5 = filePath3 != null ? filePath3 : null;
        CharSequence charSequence = filePath.basepath(null, filePath4, filePath5, filePathEnvAccess);
        CharSequence charSequence2 = filePath.localdir(null, filePath4, filePath5, filePathEnvAccess);
        int n = FilePath.isRootpath(charSequence);
        this.drive = n >= 2 ? Character.toString(charSequence.charAt(0)) : null;
        this.absPath = n == 1 || n == 3;
        this.basepath = charSequence.subSequence(n, charSequence.length()).toString();
        this.localdir = charSequence2.toString();
        if (!this.localdir.endsWith("/")) {
            Assert.stop();
        } else {
            Assert.stop();
        }
        this.name = filePath.name;
        this.ext = filePath.ext;
        this.allTree = this.localdir.indexOf(42) >= 0;
        this.someFiles = filePath.someFiles;
    }

    public boolean isNotEmpty() {
        return this.basepath != null || this.localdir.length() > 0 || this.name.length() > 0 || this.drive != null || this.scriptVariable != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scriptVariable != null) {
            stringBuilder.append('&').append(this.scriptVariable);
        }
        if (this.drive != null) {
            stringBuilder.append(this.drive).append(':');
        }
        if (this.absPath) {
            stringBuilder.append("/");
        }
        if (this.basepath != null) {
            stringBuilder.append(this.basepath).append(":");
        }
        if (this.localdir.length() > 0) {
            stringBuilder.append(this.localdir).append("/");
        }
        stringBuilder.append(this.name).append(this.ext);
        return stringBuilder.toString();
    }

    public CharSequence localdir(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.localdir(null, null, null, filePathEnvAccess);
        if (charSequence.length() == 0) {
            return ".";
        }
        return charSequence;
    }

    public CharSequence localdirW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.localdir(filePathEnvAccess));
    }

    public CharSequence localname(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        StringBuilder stringBuilder = new StringBuilder();
        return this.addLocalName(stringBuilder, filePathEnvAccess);
    }

    public CharSequence localnameW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.localname(filePathEnvAccess));
    }

    public CharSequence localfile(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        StringBuilder stringBuilder = new StringBuilder();
        this.addLocalName(stringBuilder, filePathEnvAccess);
        stringBuilder.append(this.ext);
        return stringBuilder;
    }

    public CharSequence localfileW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.localfile(filePathEnvAccess));
    }

    public CharSequence name() {
        return this.name;
    }

    public CharSequence namext() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(this.ext);
        return stringBuilder;
    }

    public String ext() {
        return this.ext;
    }

    public boolean someFiles() {
        return this.someFiles;
    }

    public boolean allTree() {
        return this.allTree;
    }

    public CharSequence absbasepath(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.basepath(null, emptyParent, null, filePathEnvAccess);
        return this.absbasepath(charSequence, filePathEnvAccess);
    }

    public CharSequence absbasepathW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.absbasepath(filePathEnvAccess));
    }

    public CharSequence absdir(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.absbasepath(filePathEnvAccess);
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        return this.localdir(stringBuilder, null, null, filePathEnvAccess);
    }

    public CharSequence absdirW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.absdir(filePathEnvAccess));
    }

    public CharSequence absname(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.absbasepath(filePathEnvAccess);
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        int n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.localdir);
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.name);
        return stringBuilder;
    }

    public CharSequence absnameW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.absname(filePathEnvAccess));
    }

    public CharSequence absfile(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.absbasepath(filePathEnvAccess);
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        this.addLocalName(stringBuilder);
        stringBuilder.append(this.ext);
        return stringBuilder;
    }

    public CharSequence absfileW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.absfile(filePathEnvAccess));
    }

    public CharSequence absfileReplwildcard(FilePath filePath, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.absbasepath(filePathEnvAccess);
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        this.localfileReplwildcard(stringBuilder, filePath);
        return stringBuilder;
    }

    public CharSequence basepath(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return this.basepath(null, emptyParent, null, filePathEnvAccess);
    }

    public CharSequence basepathW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.basepath(filePathEnvAccess));
    }

    public CharSequence dir(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        int n;
        CharSequence charSequence = this.basepath(filePathEnvAccess);
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        int n2 = n = this.localdir == null ? 0 : this.localdir.length();
        if (n > 0) {
            int n3 = stringBuilder.length();
            if (n3 > 0 && stringBuilder.charAt(n3 - 1) != '/') {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.localdir);
        }
        return stringBuilder;
    }

    public CharSequence dirW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.dir(filePathEnvAccess));
    }

    public CharSequence pathname(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.basepath(filePathEnvAccess);
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        int n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.localdir);
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.name);
        return stringBuilder;
    }

    public CharSequence pathnameW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.pathname(filePathEnvAccess));
    }

    public CharSequence file(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.basepath(filePathEnvAccess);
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        this.addLocalName(stringBuilder);
        return stringBuilder.append(this.ext);
    }

    public CharSequence fileW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.file(filePathEnvAccess));
    }

    public CharSequence base_localdir(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        StringBuilder stringBuilder;
        CharSequence charSequence = this.basepath(filePathEnvAccess);
        StringBuilder stringBuilder2 = stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(":");
        }
        stringBuilder.append(this.localdir);
        return stringBuilder;
    }

    public CharSequence base_localdirW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.base_localdir(filePathEnvAccess));
    }

    public CharSequence base_localfile(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        StringBuilder stringBuilder;
        CharSequence charSequence = this.basepath(filePathEnvAccess);
        StringBuilder stringBuilder2 = stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(":");
        }
        stringBuilder.append(this.localdir);
        int n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.name);
        stringBuilder.append(this.ext);
        return stringBuilder;
    }

    public CharSequence base_localfileW(FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return FilePath.toWindows(this.base_localfile(filePathEnvAccess));
    }

    public static CharSequence toWindows(CharSequence charSequence) {
        if (charSequence instanceof StringBuilder) {
            StringBuilder stringBuilder = (StringBuilder)charSequence;
            for (int i = 0; i < charSequence.length(); ++i) {
                if (stringBuilder.charAt(i) != '/') continue;
                stringBuilder.setCharAt(i, '\\');
            }
            return stringBuilder;
        }
        return ((String)charSequence).replace('/', '\\');
    }

    public void expandFiles(List<FilePath> list, FilePath filePath, FilePath filePath2, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        String string;
        String string2;
        CharSequence charSequence = this.basepath(new StringBuilder(), filePath, filePath2, filePathEnvAccess);
        CharSequence charSequence2 = this.absbasepath(charSequence, filePathEnvAccess);
        if (charSequence2.charAt(1) == ':') {
            string2 = String.valueOf(charSequence2.charAt(0));
            string = charSequence2.subSequence(3, charSequence2.length()).toString();
        } else {
            string2 = null;
            string = charSequence2.subSequence(1, charSequence2.length()).toString();
        }
        LinkedList<FileSystem.FileAndBasePath> linkedList = new LinkedList<FileSystem.FileAndBasePath>();
        CharSequence charSequence3 = this.localfile(null, filePath, filePath2, filePathEnvAccess);
        String string3 = charSequence2 + ":" + charSequence3;
        try {
            FileSystem.addFilesWithBasePath(null, string3, linkedList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (FileSystem.FileAndBasePath fileAndBasePath : linkedList) {
            String string4;
            String string5;
            String string6;
            FilePath filePath3 = new FilePath();
            filePath3.absPath = true;
            filePath3.drive = string2;
            filePath3.basepath = string;
            int n = fileAndBasePath.localPath.lastIndexOf(47) + 1;
            int n2 = fileAndBasePath.localPath.lastIndexOf(46);
            if (n2 < n) {
                n2 = -1;
            }
            String string7 = string6 = n > 0 ? fileAndBasePath.localPath.substring(0, n - 1) : "";
            if (n2 < 0) {
                string5 = "";
                string4 = fileAndBasePath.localPath.substring(n);
            } else {
                string5 = fileAndBasePath.localPath.substring(n2);
                string4 = fileAndBasePath.localPath.substring(n, n2);
            }
            filePath3.localdir = string6;
            assert (!string6.endsWith("/"));
            filePath3.name = string4;
            filePath3.ext = string5;
            list.add(filePath3);
        }
    }

    public static int isRootpath(CharSequence charSequence) {
        int n = charSequence.length() >= 1 && "\\/".indexOf(charSequence.charAt(0)) >= 0 ? 1 : (charSequence.length() >= 2 && charSequence.charAt(1) == ':' ? (charSequence.length() >= 3 && "\\/".indexOf(charSequence.charAt(2)) >= 0 ? 3 : 2) : 0);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence basepath(StringBuilder stringBuilder, FilePath filePath, FilePath filePath2, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        StringBuilder stringBuilder2;
        CharSequence charSequence;
        FilePath filePath3;
        Object object;
        if (this.scriptVariable != null) {
            object = filePathEnvAccess.getValue(this.scriptVariable);
            if (object == null) {
                throw new NoSuchFieldException("FilePath.basepath - scriptVariable not found; " + this.scriptVariable);
            }
            if (object instanceof FilePath) {
                filePath3 = (FilePath)object;
                charSequence = null;
            } else {
                if (!(object instanceof CharSequence)) throw new NoSuchFieldException("FilePath.basepath - scriptVariable faulty type; " + this.scriptVariable + ";" + object.getClass().getSimpleName());
                charSequence = (CharSequence)object;
                filePath3 = null;
            }
        } else {
            filePath3 = null;
            charSequence = null;
        }
        if (this.absPath) {
            if (this.drive != null || this.basepath != null || stringBuilder != null || filePath3 != null) {
                object = stringBuilder != null ? stringBuilder : new StringBuilder();
                ((StringBuilder)object).setLength(0);
                if (this.drive != null) {
                    ((StringBuilder)object).append(this.drive).append(":");
                }
                ((StringBuilder)object).append("/");
                if (this.basepath == null) return object;
                ((StringBuilder)object).append(this.basepath);
                return object;
            }
            if ($assertionsDisabled) return "/";
            if (stringBuilder != null) throw new AssertionError();
            if (this.basepath != null) throw new AssertionError();
            if (this.drive == null) return "/";
            throw new AssertionError();
        }
        if (this.basepath != null) {
            int n;
            String string;
            StringBuilder stringBuilder3;
            if (filePath == null && filePath2 == null && filePath3 == null) {
                if (charSequence == null) return this.basepath;
            }
            StringBuilder stringBuilder4 = stringBuilder3 = stringBuilder != null ? stringBuilder : new StringBuilder();
            object = filePath3 != null ? filePath3.file(stringBuilder3, filePath, filePath2, filePathEnvAccess) : (filePath != null ? filePath.file(stringBuilder3, filePath2, filePathEnvAccess) : (filePath2 != null ? filePath2.file(stringBuilder3, null, filePathEnvAccess) : stringBuilder3));
            if (this.basepath.length() > 0 || filePath3 != null && filePath3 == null || charSequence != null) {
                if (object instanceof StringBuilder) {
                    stringBuilder3 = (StringBuilder)object;
                } else {
                    assert (stringBuilder3 == null);
                    stringBuilder3 = object != null ? new StringBuilder((CharSequence)object) : new StringBuilder();
                }
            }
            if ((string = charSequence != null && filePath3 == null ? charSequence.toString() : null) != null && string.length() > 0) {
                n = stringBuilder3.length();
                if (n > 0 && FilePath.isRootpath(string) > 0) {
                    stringBuilder3.setLength(0);
                } else if (n > 0 && stringBuilder3.charAt(n - 1) != '/') {
                    stringBuilder3.append("/");
                }
                stringBuilder3.append((CharSequence)string);
            }
            if (this.basepath.length() == 0) {
                return stringBuilder3 != null ? stringBuilder3 : object;
            }
            n = stringBuilder3.length();
            if (n > 0 && stringBuilder3.charAt(n - 1) != '/') {
                stringBuilder3.append("/");
            }
            stringBuilder3.append(this.basepath);
            return stringBuilder3;
        }
        assert (this.basepath == null);
        boolean[] blArray = new boolean[]{true};
        StringBuilder stringBuilder5 = stringBuilder2 = stringBuilder != null ? stringBuilder : new StringBuilder();
        if (filePath3 != null && filePath3.basepath != null) {
            return filePath3.basepath(stringBuilder2, filePath, filePath2, filePathEnvAccess);
        }
        if (filePath != null) {
            return filePath.basepath(stringBuilder2, null, filePath2, filePathEnvAccess);
        }
        if (filePath2 != null) {
            return filePath2.basepath(stringBuilder2, null, null, filePathEnvAccess);
        }
        if (stringBuilder2 == null) return "";
        return stringBuilder2;
    }

    public CharSequence localdir(StringBuilder stringBuilder, FilePath filePath, FilePath filePath2, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        int n;
        StringBuilder stringBuilder2;
        if (this.basepath != null || this.scriptVariable == null && filePath == null && filePath2 == null) {
            int n2;
            if (stringBuilder == null) {
                return this.localdir;
            }
            if (this.localdir.length() > 0 && (n2 = stringBuilder.length()) > 0 && stringBuilder.charAt(n2 - 1) != '/') {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.localdir);
            return stringBuilder;
        }
        assert (this.basepath == null);
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder == null ? new StringBuilder() : stringBuilder;
        if (this.scriptVariable != null) {
            Object object = filePathEnvAccess.getValue(this.scriptVariable);
            if (object instanceof FilePath) {
                FilePath filePath3 = (FilePath)object;
                if (filePath3.someFiles) {
                    filePath3.localdir(stringBuilder2, filePath, filePath2, filePathEnvAccess);
                } else {
                    filePath3.localfile(stringBuilder2, filePath, filePath2, filePathEnvAccess);
                }
            } else if (object instanceof CharSequence) {
                stringBuilder2.append((CharSequence)object);
            } else {
                stringBuilder2.append(object);
            }
        } else if (filePath != null) {
            filePath.localfile(stringBuilder2, null, filePath2, filePathEnvAccess);
        } else if (filePath2 != null) {
            if (filePath2.someFiles) {
                filePath2.localdir(stringBuilder2, null, null, filePathEnvAccess);
            } else {
                filePath2.localfile(stringBuilder2, null, null, filePathEnvAccess);
            }
        }
        if (this.localdir.length() > 0 && (n = stringBuilder2.length()) > 0 && stringBuilder2.charAt(n - 1) != '/') {
            stringBuilder2.append("/");
        }
        stringBuilder2.append(this.localdir);
        return stringBuilder2;
    }

    public CharSequence localfile(StringBuilder stringBuilder, FilePath filePath, FilePath filePath2, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        if (this.localdir.length() == 0 && this.ext.length() == 0 && filePath == null && filePath2 == null && this.scriptVariable == null) {
            if (stringBuilder == null) {
                return this.name;
            }
            stringBuilder.append(this.name);
            return stringBuilder;
        }
        CharSequence charSequence = this.localdir(stringBuilder, filePath, filePath2, filePathEnvAccess);
        StringBuilder stringBuilder2 = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        int n = stringBuilder2.length();
        if (n > 0 && stringBuilder2.charAt(n - 1) != '/') {
            stringBuilder2.append("/");
        }
        stringBuilder2.append(this.name).append(this.ext);
        return stringBuilder2;
    }

    public CharSequence file(StringBuilder stringBuilder, FilePath filePath, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        return this.file(stringBuilder, null, filePath, filePathEnvAccess);
    }

    public CharSequence file(StringBuilder stringBuilder, FilePath filePath, FilePath filePath2, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        CharSequence charSequence = this.basepath(stringBuilder, filePath, filePath2, filePathEnvAccess);
        StringBuilder stringBuilder2 = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
        this.localdir(stringBuilder2, emptyParent, filePath2, filePathEnvAccess);
        int n = stringBuilder2.length();
        if (n > 0 && stringBuilder2.charAt(n - 1) != '/') {
            stringBuilder2.append("/");
        }
        stringBuilder2.append(this.name).append(this.ext);
        return stringBuilder2.append(this.ext);
    }

    private CharSequence addLocalName(StringBuilder stringBuilder) {
        int n;
        if (this.localdir.length() > 0 && (n = stringBuilder.length()) > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.localdir);
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.name);
        return stringBuilder;
    }

    private CharSequence addLocalName(StringBuilder stringBuilder, FilePathEnvAccess filePathEnvAccess) throws NoSuchFieldException {
        int n;
        CharSequence charSequence = this.localdir(filePathEnvAccess);
        if (!StringFunctions.equals(charSequence, ".")) {
            if (this.localdir.length() > 0 && (n = stringBuilder.length()) > 0 && stringBuilder.charAt(n - 1) != '/') {
                stringBuilder.append("/");
            }
            stringBuilder.append(charSequence);
        }
        if ((n = stringBuilder.length()) > 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append("/");
        }
        stringBuilder.append(this.name);
        return stringBuilder;
    }

    public CharSequence localfileReplwildcard(StringBuilder stringBuilder, FilePath filePath) {
        int n;
        int n2;
        if (this.localdir.length() > 0 && (n2 = stringBuilder.length()) > 0 && stringBuilder.charAt(n2 - 1) != '/') {
            stringBuilder.append("/");
        }
        int n3 = this.localdir.indexOf(42);
        int n4 = n = this.localdir.length() > n3 + 1 && this.localdir.charAt(n3 + 1) == '*' ? n3 + 2 : n3 + 1;
        if (n3 >= 0) {
            stringBuilder.append(this.localdir.substring(0, n3));
            stringBuilder.append(filePath.localdir);
            stringBuilder.append(this.localdir.substring(n));
        } else {
            stringBuilder.append(this.localdir);
        }
        n2 = stringBuilder.length();
        if (n2 > 0 && stringBuilder.charAt(n2 - 1) != '/') {
            stringBuilder.append("/");
        }
        n3 = this.name.indexOf(42);
        n = this.name.indexOf(42, n3 + 1);
        if (n3 >= 0) {
            stringBuilder.append(this.name.substring(0, n3));
            stringBuilder.append(filePath.name);
            if (n >= 0) {
                stringBuilder.append(this.name.substring(n3 + 1, n));
                if (filePath.ext.length() > 1) {
                    stringBuilder.append(filePath.ext.substring(1));
                }
                stringBuilder.append(this.name.substring(n + 1));
            } else {
                stringBuilder.append(this.name.substring(n3 + 1));
            }
        } else {
            stringBuilder.append(this.name);
        }
        return stringBuilder;
    }

    private CharSequence absbasepath(CharSequence charSequence, FilePathEnvAccess filePathEnvAccess) {
        CharSequence charSequence2 = charSequence;
        if (FilePath.isRootpath(charSequence2) == 0) {
            if (charSequence2.length() > 0) {
                StringBuilder stringBuilder;
                if (charSequence2 instanceof StringBuilder) {
                    stringBuilder = (StringBuilder)charSequence2;
                } else {
                    stringBuilder = new StringBuilder(charSequence2);
                    charSequence2 = stringBuilder;
                }
                CharSequence charSequence3 = filePathEnvAccess.getCurrentDir();
                if (stringBuilder.length() >= 2 && stringBuilder.charAt(1) == ':') {
                    if (charSequence3.length() >= 2 && charSequence3.charAt(1) == ':' && stringBuilder.charAt(0) == charSequence3.charAt(0)) {
                        stringBuilder.insert(2, '/');
                        stringBuilder.replace(0, 2, charSequence3.toString());
                    }
                } else {
                    stringBuilder.insert(0, '/');
                    stringBuilder.insert(0, charSequence3);
                }
            } else {
                charSequence2 = filePathEnvAccess.getCurrentDir();
            }
        }
        charSequence2 = FileSystem.normalizePath(charSequence2);
        return charSequence2;
    }

    @Deprecated
    public static class ZbnfFilepath {
        public final FilePath filepath = new FilePath();

        public void set_drive(String string) {
            this.filepath.drive = string;
        }

        public void set_absPath() {
            this.filepath.absPath = true;
        }

        public void set_scriptVariable(String string) {
            this.filepath.scriptVariable = string;
        }

        public void set_pathbase(String string) {
            this.filepath.basepath = string.replace('\\', '/');
            this.filepath.allTree = string.indexOf(42) >= 0;
        }

        public void set_path(String string) {
            this.filepath.localdir = string.replace('\\', '/');
            this.filepath.allTree = string.indexOf(42) >= 0;
        }

        public void set_name(String string) {
            this.filepath.name = string;
            this.filepath.someFiles = (byte)(this.filepath.someFiles | (string.indexOf(42) >= 0 ? 1 : 0));
        }

        public void set_ext(String string) {
            if (string.equals(".") && this.filepath.name.equals(".")) {
                this.filepath.name = "..";
            } else if (string.length() > 0 && string.charAt(0) == '.' || this.filepath.name.length() > 0) {
                this.filepath.ext = string;
            } else {
                this.filepath.name = string;
            }
            this.filepath.someFiles = (byte)(this.filepath.someFiles | (string.indexOf(42) >= 0 ? 1 : 0));
        }
    }

    public static interface FilePathEnvAccess {
        public Object getValue(String var1) throws NoSuchFieldException;

        public CharSequence getCurrentDir();
    }
}

